/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.development.form.IUploadEvents;
import com.sdjxd.pms.platform.base.Context;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.FileItemExt;
import com.sdjxd.pms.platform.form.service.CellEvent;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.Dom;
import com.sdjxd.pms.platform.form.service.cell.DynamicCell;
import com.sdjxd.pms.platform.form.service.cell.Upload;
import com.sdjxd.pms.platform.form.service.cell.ins.UploadImgIns;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import javax.imageio.ImageIO;
import net.sf.json.JSONArray;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;

public class UploadImg
extends DynamicCell {
    private static final long serialVersionUID = 1L;
    private Boolean hasBtnClick = false;
    int maxFileCount = 1;
    String allowFileType = "BMP,JPG,JPEG,GIF,PNG,PCX,TIFF,WMF,ICO,TGA";
    int showType = 0;
    int ftpType = 0;
    long maxSizeAllowed = 0xA00000L;
    String initImg;
    protected static PatternDao dao;
    protected Dom addDiv;
    protected Dom delDiv;
    static long maxSize;
    static long Threshold;
    protected String btnLabel;
    protected int btnHeight = 15;
    protected int btnWidth = 75;
    protected String btnTextStyle = "uploadBtnTextStyle";
    protected String btnReadOnlyStyle = "uploadBtnReadStyle";
    protected String btnBkStyle = "uploadBtnBkStyle";
    protected String btnFontStyle = "uploadBtnFontStyle";
    protected String filePath = "";

    static {
        maxSize = -1L;
        Threshold = -1L;
        if (maxSize < 0L) {
            String config = Global.getConfig("upload.sizeMax");
            if (config.endsWith("M")) {
                config = config.substring(0, config.length() - 1);
            }
            maxSize = Integer.parseInt(config);
            maxSize = maxSize * 1024L * 1024L;
        }
        if (Threshold < 0L) {
            String Thresholdconfig = Global.getConfig("upload.sizeThreadshold");
            if (Thresholdconfig.endsWith("M")) {
                Thresholdconfig = Thresholdconfig.substring(0, Thresholdconfig.length() - 1);
                Threshold = Integer.parseInt(Thresholdconfig);
                Threshold = Threshold * 1024L * 1024L;
            } else if (Thresholdconfig.endsWith("k") || Thresholdconfig.endsWith("K")) {
                Thresholdconfig = Thresholdconfig.substring(0, Thresholdconfig.length() - 1);
                Threshold = Integer.parseInt(Thresholdconfig);
                Threshold *= 1024L;
            } else {
                Threshold = 4196L;
            }
        }
    }

    public UploadImg(Form pattern) {
        super(pattern);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        block11: {
            super.setData(model);
            this.tagName = "div";
            this.attributes.put("MaxFileCount", String.valueOf(this.maxFileCount));
            this.attributes.put("FtpType", String.valueOf(this.ftpType));
            String assitInfo = model.assitInfo;
            this.initImg = model.cellLabel;
            if (model.extAttrs != null) {
                String path = model.extAttrs.get("DF29DBD3-40D0-48E1-9C1A-928C5DC65A55");
                if (path != null) {
                    this.filePath = path = path.replaceAll("\"", "");
                }
            } else {
                this.filePath = "";
            }
            try {
                JSONArray assitInfoArray = JSONArray.fromObject((Object)assitInfo);
                if (assitInfoArray.size() < 4) break block11;
                try {
                    Double d = Double.parseDouble(assitInfoArray.get(0).toString()) * 1024.0 * 1024.0;
                    this.maxSizeAllowed = d.longValue();
                }
                catch (Exception e) {
                    this.maxSizeAllowed = maxSize;
                }
                if (assitInfoArray.get(1).toString().trim().length() > 0) {
                    this.allowFileType = assitInfoArray.get(1).toString().toUpperCase();
                }
                this.showType = Integer.parseInt(assitInfoArray.get(2).toString());
                JSONArray btArray = JSONArray.fromObject((Object)assitInfoArray.get(3));
                if (btArray.size() >= 6) {
                    this.btnHeight = btArray.getInt(1);
                    this.btnWidth = btArray.getInt(2);
                    this.btnReadOnlyStyle = btArray.getString(3);
                    this.btnTextStyle = btArray.getString(4);
                    this.btnFontStyle = btArray.getString(5);
                }
            }
            catch (Exception assitInfoArray) {
                // empty catch block
            }
        }
        this.addDiv = new Dom("div");
        this.addDiv.setId(String.valueOf(this.cellId) + "_upbtn");
        this.addDiv.setCellBody("\u4e0a\u4f20");
        this.addDiv.setHeight(String.valueOf(this.btnHeight) + "px");
        this.addDiv.setWidth(String.valueOf(this.btnWidth) + "px");
        this.addDiv.addStyle("position", "absolute");
        this.addDiv.addStyle("zIndex", "1");
        this.addDiv.addStyle("left", "20px");
        this.addDiv.addStyle("bottom", "80px");
        this.addDiv.addStyle("cursor", "pointer");
        this.addDiv.addStyle("overflow", "hidden");
        this.addDiv.addStyle("line-height", String.valueOf(this.btnHeight) + "px");
        this.addDiv.addStyle("text-align", "center");
        Dom formDom = new Dom("FORM");
        formDom.add("method", "post");
        formDom.setId("UPLOADIMG_FORM_" + this.id);
        formDom.add("target", "upload_iframe");
        formDom.add("enctype", "multipart/form-data");
        formDom.addStyle("margin", "0px");
        formDom.addStyle("font-size", "0px");
        formDom.addStyle("border-width", "0px");
        Dom file = new Dom("input");
        file.add("type", "file");
        file.add("name", "upLoadFile" + this.id);
        file.add("id", "upLoadFile" + this.id);
        file.addStyle("position", "absolute");
        file.addStyle("right", "0");
        file.addStyle("top", "0");
        file.addStyle("filter", "Alpha(opacity=0)");
        file.addStyle("-moz-opacity", "0");
        file.addStyle("-khtml-opacity", "0");
        file.addStyle("opacity", "0");
        file.addStyle("cursor", "pointer");
        file.on("change", "defaultForm.getCellById(" + this.getId() + ").onFileChange()");
        file.on("click", "defaultForm.getCellById(" + this.getId() + ").onFileClick(event)");
        formDom.appendChild(file);
        this.addDiv.appendChild(formDom);
        this.delDiv = new Dom("div");
        this.delDiv.setCellBody("\u5220\u9664");
        this.delDiv.setId("UPLOADIMG_DEL_" + this.id);
        this.delDiv.setHeight(String.valueOf(this.btnHeight) + "px");
        this.delDiv.setWidth(String.valueOf(this.btnWidth) + "px");
        this.delDiv.addStyle("position", "absolute");
        this.delDiv.addStyle("zIndex", "1");
        this.delDiv.addStyle("left", "120px");
        this.delDiv.addStyle("bottom", "80px");
        this.delDiv.addStyle("cursor", "pointer");
        this.delDiv.addStyle("overflow", "hidden");
        this.delDiv.addStyle("line-height", String.valueOf(this.btnHeight) + "px");
        this.delDiv.addStyle("text-align", "center");
        if (!StringTool.isEmpty(this.btnFontStyle)) {
            this.addDiv.addClass("fontStyle", this.btnFontStyle);
            this.delDiv.addClass("fontStyle", this.btnFontStyle);
        }
        if (!StringTool.isEmpty(this.btnTextStyle)) {
            this.addDiv.addClass("textStyle", this.btnTextStyle);
            this.delDiv.addClass("textStyle", this.btnTextStyle);
        }
        this.addDiv.setTabindex(model.dtextNum);
        this.addDiv.add("MaxFileCount", String.valueOf(this.maxFileCount));
        this.addDiv.add("FtpType", String.valueOf(this.ftpType));
    }

    @Override
    public void renderChild(FormInstance form) throws Exception {
        PrintWriter renderHtml = Global.getContext().getWriter();
        if (this.ftpType == 0) {
            this.addDiv.on("mouseover", "return false;");
        }
        String fileNames = null;
        String fileIds = null;
        FormCell[] formCell = form.getCell();
        if (this.id < formCell.length && formCell[this.id] != null) {
            fileNames = formCell[this.id].getText();
            fileIds = formCell[this.id].getValue();
        }
        Dom divDom = new Dom("DIV");
        divDom.setId("UPLOADIMG_DIV_" + this.id);
        divDom.addStyle("width", "100%");
        divDom.addStyle("hight", "100%");
        Dom imgDom = new Dom("IMG");
        imgDom.addStyle("border", "0px");
        imgDom.setId("UPLOADIMG_IMG_" + this.id);
        StringBuffer DivImgHtml = new StringBuffer(128);
        divDom.appendChild(imgDom);
        CellEvent[] events = this.events;
        int i = 0;
        while (i < events.length) {
            if (events[i] != null && "onclick".equals(events[i].getEventCode())) {
                this.hasBtnClick = true;
            }
            ++i;
        }
        if (!this.hasBtnClick.booleanValue()) {
            divDom.on("click", "com.sdjxd.pms.platform.form.cell.UploadImg.showBigPicture(" + this.id + ")");
        } else {
            divDom.on("click", "defaultForm.getCellById(" + this.id + ").invokeEvent('onclick')");
        }
        if (formCell[this.id].isEnabled()) {
            divDom.on("mouseover", "com.sdjxd.pms.platform.form.cell.UploadImg.showButton(" + this.id + ", true)");
            divDom.on("mouseout", "com.sdjxd.pms.platform.form.cell.UploadImg.showButton(" + this.id + ", false)");
            this.addDiv.on("click", "defaultForm.getCellById(" + this.id + ").noReturn()");
            this.delDiv.on("click", "defaultForm.getCellById(" + this.id + ").del()");
            if (!StringTool.isEmpty(this.btnBkStyle)) {
                this.addDiv.addClass("bkStyle", this.btnBkStyle);
                this.delDiv.addClass("bkStyle", this.btnBkStyle);
            }
        } else {
            if (!StringTool.isEmpty(this.btnReadOnlyStyle)) {
                this.addDiv.addClass("bkStyle", this.btnReadOnlyStyle);
                this.delDiv.addClass("bkStyle", this.btnReadOnlyStyle);
            }
            this.addDiv.addStyle("display", "none");
            this.delDiv.addStyle("display", "none");
        }
        if (this.addDiv != null) {
            divDom.appendChild(this.addDiv);
            divDom.appendChild(this.delDiv);
        }
        divDom.render(DivImgHtml);
        ((Writer)renderHtml).write(DivImgHtml.toString());
        super.renderChild(form);
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        if (dao == null) {
            dao = (PatternDao)BeanFactory.getClass("PatternDao");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.cell.UploadImg({id:");
        sb.append(this.id);
        sb.append(",typeName:'UploadImg'");
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        sb.append(",type:").append(this.ftpType);
        sb.append(",bgColorStyle:'").append(this.data.bkColorStyle).append("'");
        sb.append(",readOnlyBgColorStyle:'").append(this.data.readBkColorStyle).append("'");
        sb.append(",showType:").append(this.showType);
        sb.append(",initImg:'").append(this.initImg).append("'");
        String fileNames = null;
        String fileIds = null;
        FormCell[] formCell = form.getCell();
        if (this.id < formCell.length && formCell[this.id] != null) {
            fileNames = formCell[this.id].getText();
            fileIds = formCell[this.id].getValue();
            if (fileNames == null || fileNames.length() == 0) {
                fileNames = "";
            }
            if (fileIds != null && fileIds.length() != 0) {
                sb.append(",fileNames:").append(BeanTool.toJson(fileNames.split(",")));
                sb.append(",fileIds:").append(BeanTool.toJson(fileIds.split(",")));
                String sizes = dao.getImgWidAndHeight(fileIds);
                String[] sizeArr = sizes.split(",");
                if (sizeArr.length == 2) {
                    if (sizeArr[0] != null && !"".equals(sizeArr[0])) {
                        sb.append(",imgWidth:").append(sizeArr[0]);
                    }
                    if (sizeArr[1] != null && !"".equals(sizeArr[1])) {
                        sb.append(",imgHeight:").append(sizeArr[1]);
                    }
                }
            }
        }
        sb.append(",maxFileCount:").append(this.maxFileCount);
        sb.append(",maxSize:").append(this.maxSizeAllowed);
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",needSave:").append(this.isNeedSave());
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append("}));");
        sb.append("defaultForm.getCellById(" + this.id + ").showImg();");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    public static String getImgPath(String fileId) {
        String savepath;
        if (!Upload.IS_SAVE_DB) {
            savepath = Global.getConfig("upload.tempDir");
            if (!savepath.endsWith("/")) {
                savepath = String.valueOf(savepath) + "/";
            }
        } else {
            savepath = "/servlet/com.sdjxd.pms.platform.serviceBreak.Invoke?_c=com.sdjxd.pms.platform.form.service.cell.Upload&_m=show&_nr=1&_p0=";
        }
        savepath = String.valueOf(savepath) + fileId;
        return savepath.substring(1);
    }

    private String saves(String formInstanceId, String path) {
        if (dao == null) {
            dao = (PatternDao)BeanFactory.getClass("PatternDao");
        }
        Context context = Global.getContext();
        User user = User.getCurrentUser();
        String fileId = "";
        String bSuccess = "true";
        String sheetid = formInstanceId;
        StringBuffer successInfo = new StringBuffer();
        try {
            DiskFileUpload fu = new DiskFileUpload();
            fu.setHeaderEncoding("GBK");
            fu.setSizeMax(this.maxSizeAllowed);
            fu.setSizeThreshold((int)Threshold);
            String repositoryPath = Global.getConfig("upload.catchPath");
            File file = (File)BeanFactory.getClass("File", new String[]{repositoryPath});
            if (!(file.exists() || file.mkdir() || (file = (File)BeanFactory.getClass("File", new String[]{repositoryPath = System.getProperty("java.io.tmpdir")})).exists())) {
                throw new Exception("\u4e34\u65f6\u76ee\u5f55\u8bbe\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01");
            }
            fu.setRepositoryPath(repositoryPath);
            List fileItems = context.getDiskFileUploadFile(fu);
            for (FileItem fi : fileItems) {
                IUploadEvents ies;
                if (fi.isFormField()) continue;
                String fileName = fi.getFieldName();
                if (fi.getName().length() == 0) continue;
                if (fi.getName().lastIndexOf(".") == -1) {
                    throw new Exception("\u6240\u9009\u62e9\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u660e\u786e\uff0c\u4e0d\u5141\u8bb8\u4e0a\u4f20\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\uff01");
                }
                String fileType = fi.getName().substring(fi.getName().lastIndexOf(".") + 1, fi.getName().length());
                if (this.allowFileType.indexOf(fileType = fileType.toUpperCase()) == -1) {
                    throw new Exception("\u5fc5\u987b\u8981\u4e0a\u4f20\u6307\u5b9a\u7c7b\u578b\u56fe\u7247\u6587\u4ef6\uff01");
                }
                fileId = Guid.create();
                InputStream io = fi.getInputStream();
                BufferedImage sourceImg = ImageIO.read(io);
                String width = String.valueOf(sourceImg.getWidth());
                String height = String.valueOf(sourceImg.getHeight());
                FileItemExt fiext = new FileItemExt(fi, path);
                String beforSaveClass = PatternDao.getExtAttribute("C8837219-92F1-4D52-A171-6442394DBBFD", context.getParameter("_formId"));
                if (beforSaveClass.length() > 0 && (ies = (IUploadEvents)BeanTool.getInstance(beforSaveClass)) != null) {
                    ies.onBeforeSave(fiext);
                }
                if (dao.saveCommonsFile(fileId, "", user.getId(), fiext.getFileItem(), sheetid, fiext.getPath(), "1")) {
                    dao.updateImgWidAndHeight(fileId, width, height);
                    successInfo.append(String.valueOf(fileName) + "@" + fileId + "@" + width + "@" + height + "@");
                    continue;
                }
                successInfo.append(String.valueOf(fileName) + "@" + "@");
                bSuccess = "false";
            }
        }
        catch (Exception e) {
            String expMsg = e.getMessage();
            System.out.println("\u52a8\u6001\u56fe\u7247\u5143\u4ef6\u51fa\u9519:" + expMsg);
            if (expMsg.indexOf("size exceeds") != -1) {
                expMsg = "\u52a8\u6001\u56fe\u7247\u957f\u5ea6\u8d85\u51fa\u9650\u5236\u3002";
            } else if (expMsg.indexOf("extension of the file") != -1) {
                expMsg = "\u6240\u9009\u62e9\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e0a\u4f20\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\uff01";
            }
            return "<script>parent.defaultForm.getCellById(" + this.id + ").UploadImgFileBack(false,\"" + StringTool.toJson(expMsg) + "\");</script>";
        }
        return "<script>parent.defaultForm.getCellById(" + this.id + ").UploadImgFileBack(" + bSuccess + ",\"" + StringTool.toJson(successInfo.toString()) + "\");</script>";
    }

    public static String save(String formInstanceId, String cellId) {
        FormInstance formInstance = FormInstance.loadFromCache(formInstanceId);
        int cellIdInt = Integer.parseInt(cellId);
        UploadImgIns formCell = (UploadImgIns)formInstance.getCell(cellIdInt);
        String path = formCell.getPath();
        UploadImg uploadImgCell = (UploadImg)formInstance.getPattern().getCells()[Integer.parseInt(cellId)];
        return uploadImgCell.saves(formInstanceId, path);
    }

    @Override
    public void save(FormInstance form, List list) {
        super.save(form, list);
    }

    @Override
    public void saveCell(FormInstance form, List list, int cellid) {
        Form pattern = form.getPattern();
        int patternType = pattern.getPatternType();
        if (patternType != 6) {
            Upload.delFile(form, list, this.id);
        }
    }

    public static int del(String fileIds) {
        if (dao == null) {
            dao = (PatternDao)BeanFactory.getClass("PatternDao");
        }
        String[] fieldArr = fileIds.split(",");
        int i = 0;
        while (i < fieldArr.length) {
            if (!StringTool.isEmpty(fieldArr[i])) {
                String path = Upload.getFilePath(fieldArr[i]);
                File file = new File(path);
                if (file.exists() && file.isFile()) {
                    file.delete();
                }
                file = null;
            }
            if (!dao.delCommonsFile(fieldArr[i])) {
                return 0;
            }
            ++i;
        }
        return 1;
    }

    @Override
    public FormCell createCellInstance() {
        return new UploadImgIns();
    }

    @Override
    public void renderInstanceValue(FormInstance form) {
        UploadImgIns formCell = (UploadImgIns)form.getCell(this.id);
        String path = Upload.replaceUrl(this.filePath);
        path = StringTool.replaceKeyWord(path);
        formCell.setPath(path);
    }
}

