/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.development.form.IUploadEvents;
import com.sdjxd.pms.platform.base.Context;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.base.PlatformLogger;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.Css;
import com.sdjxd.pms.platform.form.model.FileBean;
import com.sdjxd.pms.platform.form.model.FileItemExt;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.Dom;
import com.sdjxd.pms.platform.form.service.cell.DynamicCell;
import com.sdjxd.pms.platform.form.service.cell.UploadProperties;
import com.sdjxd.pms.platform.form.service.cell.ins.UploadIns;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.RowSet;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.log4j.Logger;

public class Upload
extends DynamicCell {
    private static final long serialVersionUID = 1L;
    private Dom button;
    static long maxSize;
    static long Threshold;
    public static boolean IS_SAVE_DB;
    private static Logger log;
    protected String btnLabel = "\u6dfb\u52a0";
    protected int btnHeight = 15;
    protected int btnWidth = 75;
    protected String btnTextStyle = "uploadBtnTextStyle";
    protected String btnReadOnlyStyle = "uploadBtnReadStyle";
    protected String btnBkStyle = "uploadBtnBkStyle";
    protected String btnFontStyle = "uploadBtnFontStyle";
    protected static String DENIED_EXTENSIONS;
    protected String allowedExtensions;
    protected String swfAllowedType = "*.*";
    protected boolean oppositeExten = false;
    protected int maxFileCount = 3;
    protected int ftpType = 0;
    protected long maxSizeAllowed = 0x100000L;
    protected String filePath = "";
    private static PatternDao dao;

    static {
        String saveToDb;
        maxSize = -1L;
        Threshold = -1L;
        IS_SAVE_DB = false;
        if (maxSize < 0L) {
            String config = Global.getConfig("upload.sizeMax");
            if (config.endsWith("M")) {
                config = config.substring(0, config.length() - 1);
            }
            maxSize = Integer.parseInt(config);
            maxSize = maxSize * 1024L * 1024L;
        }
        if (Threshold < 0L) {
            String Thresholdconfig = Global.getConfig("upload.sizeThreadshold");
            if (Thresholdconfig.endsWith("M")) {
                Thresholdconfig = Thresholdconfig.substring(0, Thresholdconfig.length() - 1);
                Threshold = Integer.parseInt(Thresholdconfig);
                Threshold = Threshold * 1024L * 1024L;
            } else if (Thresholdconfig.endsWith("k") || Thresholdconfig.endsWith("K")) {
                Thresholdconfig = Thresholdconfig.substring(0, Thresholdconfig.length() - 1);
                Threshold = Integer.parseInt(Thresholdconfig);
                Threshold *= 1024L;
            } else {
                Threshold = 4196L;
            }
        }
        if ((saveToDb = Global.getConfig("upload.saveToDB")) != null && ("true".equalsIgnoreCase(saveToDb) || "1".equalsIgnoreCase(saveToDb))) {
            IS_SAVE_DB = true;
        }
        log = Logger.getLogger(Upload.class);
        DENIED_EXTENSIONS = "com,exe,bat,cmd,vbs";
    }

    public Upload(Form pattern) {
        super(pattern);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        this.tagName = "div";
        this.attributes.put("MaxFileCount", String.valueOf(this.maxFileCount));
        this.attributes.put("FtpType", String.valueOf(this.ftpType));
        this.style.put("overflow-y", "auto");
        String assitInfo = model.assitInfo;
        boolean isAllowed = false;
        if (assitInfo != null && assitInfo.length() != 0) {
            try {
                Object[] tmp = StringTool.strToArray(assitInfo);
                if (tmp.length > 1) {
                    this.ftpType = Integer.parseInt((String)tmp[0]);
                    this.maxFileCount = Integer.parseInt((String)tmp[1]);
                }
                if (tmp.length > 3) {
                    isAllowed = true;
                    try {
                        this.maxSizeAllowed = Integer.parseInt((String)tmp[3]) * 1024 * 1024;
                    }
                    catch (Exception e) {
                        this.maxSizeAllowed = 0x100000L;
                    }
                }
                if (tmp.length > 4) {
                    String[] btnInfo = (String[])tmp[4];
                    this.btnLabel = btnInfo[0];
                    this.btnHeight = Integer.parseInt(btnInfo[1]);
                    this.btnWidth = Integer.parseInt(btnInfo[2]);
                    this.btnReadOnlyStyle = btnInfo[3];
                    this.btnTextStyle = btnInfo[4];
                    this.btnBkStyle = btnInfo[5];
                    this.btnFontStyle = btnInfo[6];
                }
                if (tmp.length > 5) {
                    this.allowedExtensions = (String)tmp[5];
                    if (!StringTool.isEmpty(this.allowedExtensions)) {
                        String str = "";
                        String[] swfTypes = this.allowedExtensions.split(",");
                        int i = 0;
                        while (i < swfTypes.length) {
                            str = String.valueOf(str) + ";*." + swfTypes[i];
                            ++i;
                        }
                        this.swfAllowedType = str = str.substring(1, str.length());
                    }
                }
                if (tmp.length > 6) {
                    String path = (String)tmp[6];
                    this.filePath = path.replaceAll("\"", "");
                }
                if (tmp.length > 7) {
                    this.oppositeExten = "1".equals(tmp[7]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!isAllowed) {
            this.maxSizeAllowed = maxSize;
        }
        if (this.ftpType == 0) {
            this.button = new Dom("input");
            this.button.add("type", "button");
            this.button.setId(String.valueOf(this.cellId) + "_upbtn");
            this.button.add("value", this.btnLabel);
            this.button.setHeight("" + this.btnHeight);
            this.button.setWidth("" + this.btnWidth);
            if (!StringTool.isEmpty(this.btnFontStyle)) {
                this.button.addClass("fontStyle", this.btnFontStyle);
            }
            if (!StringTool.isEmpty(this.btnTextStyle)) {
                this.button.addClass("textStyle", this.btnTextStyle);
            }
            this.button.setTabindex(model.dtextNum);
            this.button.on("mouseover", "defaultForm.getCellById(" + this.id + ").createFileEl()");
            this.button.add("MaxFileCount", String.valueOf(this.maxFileCount));
            this.button.add("FtpType", String.valueOf(this.ftpType));
        }
    }

    @Override
    public String getValueAttribute() {
        return "cv";
    }

    private String outButtonDiv(String fileNames, String fileIds, boolean enabled) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<div id='div_" + this.cellId + "_btn' style='width:100%;height:10px;text-align:right'  cv='" + fileIds + "' value='" + fileNames + "'>");
        buffer.append("<input type='button' class='" + this.btnFontStyle + " " + this.btnTextStyle + " ");
        if (enabled) {
            buffer.append(this.btnBkStyle);
        } else {
            buffer.append(this.btnReadOnlyStyle);
        }
        buffer.append("'");
        buffer.append(" style='width:" + this.btnWidth + "px;height:" + this.btnHeight + "px' id='" + this.cellId + "_upbtn' MaxFileCount='" + this.maxFileCount + "' FtpType='" + this.ftpType + "' ");
        if (enabled) {
            buffer.append(" onmouseover=defaultForm.getCellById(" + this.id + ").createFileEl() ");
        }
        buffer.append(" value='" + this.btnLabel + "'></input></div>");
        return buffer.toString();
    }

    private String outTableDiv(String fileNames, String fileIds, boolean enabled) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n<div id='div_" + this.cellId + "_table' style='position:absolute;top:0px;border:0px solid #cccccc;overflow-y:auto;width:" + (this.width - 85) + "px;height:" + this.height + "px;'>");
        buffer.append("\n<table width='100%' style='table-Layout:fixed;padding:0' border=0 cellPadding=0 cellSpacing=0 id='" + this.cellId + "_table'>");
        String[] fileName = fileNames.split(",");
        String[] fileId = fileIds.split(",");
        int index = 0;
        index = 0;
        while (index < fileName.length && index < fileId.length) {
            if (fileName[index].length() != 0) {
                buffer.append("\n<tr>");
                buffer.append("<td width=20 align='center' class='link ");
                buffer.append(this.data.fontStyle).append(" ").append(this.data.textColorStyle).append("'>").append(index + 1).append("</td>");
                buffer.append("<td onclick='defaultForm.getCellById(").append(this.id).append(").showFile()' id='");
                buffer.append(this.cellId).append("_").append(fileId[index]).append("_2' class='link ");
                buffer.append(this.data.textColorStyle).append(" ").append(this.data.fontStyle).append("' >");
                buffer.append(fileName[index]);
                buffer.append("</td>");
                if (enabled) {
                    buffer.append("<td width=20 align='center'><span class='uploadok' </span></td>");
                    buffer.append("<td width=20 align='center'><span class='link del' id='" + this.cellId + "_" + fileId[index] + "_3' onclick='defaultForm.getCellById(" + this.id + ").delFileII()' style='height:12px;'></span></td>");
                }
                buffer.append("</tr>");
            }
            ++index;
        }
        buffer.append("\n</table>");
        buffer.append("\n</div>");
        return buffer.toString();
    }

    private String outTopDiv(String fileNames, String fileIds, boolean enabled) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.outButtonDiv(fileNames, fileIds, enabled));
        buffer.append(this.outTableDiv(fileNames, fileIds, enabled));
        return buffer.toString();
    }

    @Override
    public void renderChild(FormInstance form) throws Exception {
        PrintWriter renderHtml = Global.getContext().getWriter();
        if (this.ftpType == 0) {
            this.button.on("mouseover", "return false;");
        }
        String fileNames = null;
        String fileIds = null;
        FormCell[] formCell = form.getCell();
        if (this.id < formCell.length && formCell[this.id] != null) {
            fileNames = formCell[this.id].getText();
            fileIds = formCell[this.id].getValue();
        }
        if (this.ftpType == 0) {
            if (formCell[this.id].isEnabled()) {
                this.button.on("mouseover", "defaultForm.getCellById(" + this.id + ").createFileEl()");
                if (!StringTool.isEmpty(this.btnBkStyle)) {
                    this.button.addClass("bkStyle", this.btnBkStyle);
                }
            } else if (!StringTool.isEmpty(this.btnReadOnlyStyle)) {
                this.button.addClass("bkStyle", this.btnReadOnlyStyle);
            }
            if (this.button != null) {
                StringBuffer buttonHtml = new StringBuffer(128);
                this.button.render(buttonHtml);
                ((Writer)renderHtml).write(buttonHtml.toString());
            }
            if (fileNames != null && fileNames.length() != 0 && fileIds != null && fileIds.length() != 0) {
                String[] fileName = fileNames.split(",");
                String[] fileId = fileIds.split(",");
                int index = 0;
                StringBuffer html = new StringBuffer(128);
                index = 0;
                while (index < fileName.length && index < fileId.length) {
                    Dom fileIconAndLink = new Dom("span");
                    Dom fileIcon = new Dom("span");
                    Dom fileNameLink = new Dom("span");
                    Dom fileDel = new Dom("span");
                    fileIconAndLink.appendChild(fileIcon);
                    fileIconAndLink.appendChild(fileNameLink);
                    fileIconAndLink.appendChild(fileDel);
                    if (fileId[index].length() != 0) {
                        fileIconAndLink.addClass("r", "link");
                        fileIconAndLink.addStyle("border-width", "0");
                        fileIconAndLink.setId(String.valueOf(this.cellId) + "_" + fileId[index]);
                        fileIconAndLink.add("nowarp", "true");
                        fileIcon.addClass("r", "attch");
                        fileIcon.addStyle("border-width", "0");
                        fileIcon.setId(String.valueOf(this.cellId) + "_" + fileId[index] + "_1");
                        fileNameLink.addClass("r", this.data.textColorStyle);
                        fileNameLink.addClass("r1", this.data.fontStyle);
                        fileNameLink.addStyle("border-width", "0");
                        fileNameLink.setId(String.valueOf(this.cellId) + "_" + fileId[index] + "_2");
                        fileNameLink.setCellBody(fileName[index]);
                        fileNameLink.on("click", "defaultForm.getCellById(" + this.id + ").showFile();");
                        fileDel.addClass("r", "link del");
                        fileDel.addStyle("border-width", "0");
                        fileDel.setId(String.valueOf(this.cellId) + "_" + fileId[index] + "_3");
                        if (formCell[this.id].isEnabled()) {
                            fileDel.on("click", "defaultForm.getCellById(" + this.id + ").delFile();");
                        } else {
                            fileDel.on("click", "alert('\u53ea\u8bfb\u72b6\u6001\u4e0b\u65e0\u6cd5\u5220\u9664\uff01');");
                            fileDel.addStyle("display", "none");
                        }
                        fileDel.add("title", "\u5220\u9664\u6587\u4ef6");
                        fileIconAndLink.render(html);
                    }
                    ++index;
                }
                ((Writer)renderHtml).write(html.toString());
            }
        } else {
            if (fileNames == null || fileIds == null) {
                fileNames = "";
                fileIds = "";
            }
            ((Writer)renderHtml).write(this.outTopDiv(fileNames, fileIds, formCell[this.id].isEnabled()));
            if (this.button != null) {
                StringBuffer buttonHtml = new StringBuffer(128);
                this.button.render(buttonHtml);
                ((Writer)renderHtml).write(buttonHtml.toString());
            }
        }
        super.renderChild(form);
    }

    @Override
    protected void renderAttribute(FormInstance form) throws Exception {
        super.renderAttribute(form);
    }

    @Override
    protected void renderEvent(FormInstance form) {
        if (this.id < form.getCell().length) {
            FormCell formCell = form.getCell()[this.id];
            if (formCell == null) {
                return;
            }
            StringBuffer sb = new StringBuffer(128);
            int i = 0;
            while (i < MAXEVENT) {
                if (this.events[i] != null) {
                    String sender = "defaultForm.getCellById(" + this.id + ")";
                    sb.append(this.events[i].toString(sender));
                }
                ++i;
            }
            form.addScript("form_obj_cell_" + this.id + "_event", sb.toString());
        }
    }

    @Override
    protected void renderEnable(FormInstance form) throws Exception {
        PrintWriter renderHtml = Global.getContext().getWriter();
        ((Writer)renderHtml).write(" d=1");
    }

    @Override
    public FormCell createCellInstance() {
        return new UploadIns();
    }

    @Override
    public void renderInstanceValue(FormInstance form) {
        UploadIns formCell = (UploadIns)form.getCell(this.id);
        String path = Upload.replaceUrl(this.filePath);
        path = StringTool.replaceKeyWord(path);
        formCell.setPath(path);
    }

    public static String replaceUrl(String sstr) {
        if (sstr == null || sstr.length() == 0) {
            return sstr;
        }
        String ostr = sstr;
        String regex = "\\[(\\w+)\\.([^\\]]*)\\]";
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(ostr);
        String matchValue = "";
        Context context = Global.getContext();
        HashMap<String, String> replacement = new HashMap<String, String>();
        while (m.find()) {
            String matchStr = m.group();
            String matchName = m.group(1);
            String matchArg = m.group(2);
            matchValue = matchStr;
            if (replacement.containsKey(matchStr) || !matchName.equals("url") || context == null) continue;
            matchValue = context.getParameter(matchArg);
            matchValue = UploadProperties.getConfig(matchValue);
            replacement.put(matchStr, matchValue);
        }
        for (Map.Entry entry : replacement.entrySet()) {
            String oldStr = (String)entry.getKey();
            String newStr = (String)entry.getValue();
            ostr = ostr.replace(oldStr, newStr);
        }
        return ostr;
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        StringBuffer sb = new StringBuffer();
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.cell.Upload({id:");
        sb.append(this.id);
        sb.append(",typeName:'Upload'");
        sb.append(",tagId:").append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",fileNameLen:").append(this.data.maxSize);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        sb.append(",type:").append(this.ftpType);
        sb.append(",bgColorStyle:'").append(this.data.bkColorStyle).append("'");
        sb.append(",readOnlyBgColorStyle:'").append(this.data.readBkColorStyle).append("'");
        String fileNames = null;
        String fileIds = null;
        FormCell[] formCell = form.getCell();
        if (this.id < formCell.length && formCell[this.id] != null) {
            fileNames = formCell[this.id].getText();
            fileIds = formCell[this.id].getValue();
            if (fileNames != null && fileNames.length() != 0 && fileIds != null && fileIds.length() != 0) {
                sb.append(",fileNames:").append(BeanTool.toJson(fileNames.split(",")));
                sb.append(",fileIds:").append(BeanTool.toJson(fileIds.split(",")));
            }
        }
        sb.append(",maxFileCount:").append(this.maxFileCount);
        sb.append(",maxSize:").append(this.maxSizeAllowed);
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",needSave:").append(this.isNeedSave());
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append(",settings : {");
        sb.append("flash_url : $appRoot+\"/pms/platform/form/cell/swfupload/swfupload.swf\",");
        String jsessionid = Global.getContext().getSessionId();
        if (StringTool.isEmpty(form.getId())) {
            sb.append("upload_url: $appRoot+\"/servlet/com.sdjxd.pms.platform.serviceBreak.Invoke;jsessionid=" + jsessionid + "\"+window.location.search+\"&_sender=page&_c=com.sdjxd.pms.platform.form.service.cell.Upload&_m=save&_formid=" + form.getPatternId() + "&_p0=\\\"" + form.getId() + "\\\"&_p1=\\\"" + form.getPatternId() + "\\\"&_p2=\\\"" + this.id + "\\\"\",");
        } else {
            sb.append("upload_url: $appRoot+\"/servlet/com.sdjxd.pms.platform.serviceBreak.Invoke;jsessionid=" + jsessionid + "?_sender=page&_c=com.sdjxd.pms.platform.form.service.cell.Upload&_m=save&_formid=" + form.getPatternId() + "&_p0=\\\"" + form.getId() + "\\\"&_p1=\\\"" + this.id + "\\\"\",");
        }
        sb.append("file_size_limit : \"").append(this.maxSizeAllowed / 0x100000L).append(" MB\",");
        sb.append("file_types : \"").append(this.swfAllowedType).append("\",");
        sb.append("file_types_description : \"").append(this.swfAllowedType).append("\",");
        sb.append("file_upload_limit : ").append(this.maxFileCount).append(",");
        sb.append("file_queue_limit : ").append(this.maxFileCount).append(",");
        sb.append("debug: false,");
        sb.append("\tbutton_window_mode : \"transparent\",");
        sb.append("\tbutton_placeholder_id: \"" + this.cellId + "_upbtn\",");
        sb.append("\tbutton_width: ").append(this.btnWidth).append(",");
        sb.append("\tbutton_height: ").append(this.btnHeight).append(",");
        sb.append("\tbutton_text: '<span class=\"button\">").append(this.btnLabel).append("</span>',");
        Css css1 = (Css)Form.getCss().get(this.btnFontStyle);
        Css css2 = (Css)Form.getCss().get(this.btnTextStyle);
        String cssText1 = "";
        String cssText2 = "";
        if (css1 != null) {
            cssText1 = css1.getStyletext();
        }
        if (css2 != null) {
            cssText2 = css2.getStyletext();
        }
        sb.append("\tbutton_text_style: '.button {" + cssText1 + " " + cssText2 + " }',");
        sb.append("\tbutton_text_top_padding: 1,");
        sb.append("\tbutton_text_left_padding: 5");
        sb.append("}");
        sb.append("}));");
        sb.append("defaultForm.getCellById(" + this.id + ").loadFlashButton()");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    public static String save(String formInstanceId, String cellId) {
        FormInstance formInstance = FormInstance.loadFromCache(formInstanceId);
        int cellIdInt = Integer.parseInt(cellId);
        UploadIns formCell = (UploadIns)formInstance.getCell(cellIdInt);
        String path = formCell.getPath();
        Upload uploadCell = (Upload)formInstance.getPattern().getCells()[Integer.parseInt(cellId)];
        return uploadCell.saves(formInstanceId, path);
    }

    public static String save(String formInstanceId, String patternId, String cellId) throws Exception {
        if (StringTool.isEmpty(formInstanceId)) {
            formInstanceId = Guid.create();
        }
        Form form = Form.getPattern(patternId);
        Upload uploadCell = (Upload)form.getCells()[Integer.parseInt(cellId)];
        String path = uploadCell.filePath;
        path = Upload.replaceUrl(path);
        path = StringTool.replaceKeyWord(path);
        return uploadCell.saves(formInstanceId, path);
    }

    private String saves(String formInstanceId, String path) {
        if (dao == null) {
            dao = (PatternDao)BeanFactory.getClass("PatternDao");
        }
        Context context = Global.getContext();
        User user = User.getCurrentUser();
        String fileId = "";
        String bSuccess = "true";
        String sheetid = formInstanceId;
        StringBuffer successInfo = new StringBuffer();
        try {
            DiskFileUpload fu = new DiskFileUpload();
            fu.setHeaderEncoding("UTF-8");
            fu.setSizeMax(this.maxSizeAllowed);
            fu.setSizeThreshold((int)Threshold);
            fu.setRepositoryPath(Global.getConfig("upload.catchPath"));
            String repositoryPath = Global.getConfig("upload.catchPath");
            File file = (File)BeanFactory.getClass("File", new String[]{repositoryPath});
            if (!(file.exists() || file.mkdir() || (file = (File)BeanFactory.getClass("File", new String[]{repositoryPath = System.getProperty("java.io.tmpdir")})).exists())) {
                throw new Exception("\u4e34\u65f6\u76ee\u5f55\u8bbe\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01");
            }
            fu.setRepositoryPath(repositoryPath);
            List fileItems = context.getDiskFileUploadFile(fu);
            for (FileItem fi : fileItems) {
                IUploadEvents ies;
                if (fi.isFormField()) continue;
                String fileName = fi.getFieldName();
                if (fi.getName().length() == 0) continue;
                if (fi.getName().lastIndexOf(".") == -1) {
                    throw new Exception("\u6240\u9009\u62e9\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u660e\u786e\uff0c\u4e0d\u5141\u8bb8\u4e0a\u4f20\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\uff01");
                }
                String fileType = fi.getName().substring(fi.getName().lastIndexOf(".") + 1, fi.getName().length());
                FileItemExt fiext = new FileItemExt(fi, path);
                String formid = context.getParameter("_formid");
                String beforSaveClass = PatternDao.getExtAttribute("C8837219-92F1-4D52-A171-6442394DBBFD", formid);
                if (beforSaveClass.length() > 0 && (ies = (IUploadEvents)BeanTool.getInstance(beforSaveClass)) != null) {
                    ies.onBeforeSave(fiext);
                }
                if (StringTool.isEmpty(this.allowedExtensions) ? DENIED_EXTENSIONS.indexOf(fileType.toLowerCase()) >= 0 : !this.oppositeExten && this.allowedExtensions.toLowerCase().indexOf(fileType.toLowerCase()) < 0 || this.oppositeExten && this.allowedExtensions.toLowerCase().indexOf(fileType.toLowerCase()) >= 0) {
                    throw new Exception("\u6240\u9009\u62e9\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e0a\u4f20\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\uff01");
                }
                fileId = Guid.create();
                if (dao.saveCommonsFile(fileId, "", user.getId(), fiext.getFileItem(), sheetid, fiext.getPath())) {
                    successInfo.append(String.valueOf(fileName) + "@" + fileId + "@");
                    continue;
                }
                successInfo.append(String.valueOf(fileName) + "@" + "@");
                bSuccess = "false";
            }
        }
        catch (Exception e) {
            String expMsg = e.getMessage();
            System.out.println("\u4e0a\u4f20\u5143\u4ef6\u51fa\u9519:" + expMsg);
            if (expMsg.indexOf("size exceeds") != -1) {
                expMsg = "\u4e0a\u4f20\u7684\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u9650\u5236\u3002";
            } else if (expMsg.indexOf("extension of the file") != -1) {
                expMsg = "\u6240\u9009\u62e9\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e0a\u4f20\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\uff01";
            }
            String reStr = "";
            try {
                reStr = URLEncoder.encode(StringTool.toJson(expMsg), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return "false:a:" + this.getId() + ":a:" + reStr;
        }
        String reStr = "";
        try {
            reStr = URLEncoder.encode(StringTool.toJson(successInfo.toString()), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return String.valueOf(bSuccess) + ":a:" + this.getId() + ":a:" + reStr;
    }

    public static void show(String fileId) throws Exception {
        if (fileId == null || fileId.indexOf("'") >= 0 || fileId.indexOf("(") >= 0 || fileId.indexOf(")") >= 0) {
            PlatformLogger.log(User.getCurrentUser() == null ? "" : User.getCurrentUser().getId(), "", fileId, "\u6587\u4ef6\u4e0b\u8f7dsql\u6ce8\u5165", 9);
            throw new Exception("\u60a8\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u6b64\u9875\u9762\uff01");
        }
        if (dao == null) {
            dao = (PatternDao)BeanFactory.getClass("PatternDao");
        }
        FileBean fileInfo = null;
        if (IS_SAVE_DB) {
            fileInfo = dao.getDbFile(fileId);
        } else {
            String savepath = Upload.getFilePath(fileId);
            File file = (File)BeanFactory.getClass("File", new String[]{savepath});
            if (file.exists() && file.isFile()) {
                fileInfo = dao.getFile(fileId);
                FileInputStream in = (FileInputStream)BeanFactory.getClass("FileInputStream", new File[]{file});
                fileInfo.setFileStream(new BufferedInputStream(in));
            } else {
                log.error((Object)("\u6587\u4ef6\u4e0d\u5b58\u5728\uff08fileid='" + fileId + "'\uff09\uff1a" + savepath));
                fileInfo = new FileBean();
            }
        }
        Global.getContext().writeFileToResponse(fileInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFileExists(String fileId) throws Exception {
        if (dao == null) {
            dao = (PatternDao)BeanFactory.getClass("PatternDao");
        }
        FileBean fileInfo = null;
        if (IS_SAVE_DB) {
            fileInfo = dao.getDbFile(fileId);
            if (fileInfo.getFileStream() != null) return true;
            String savepath = Upload.getFilePath(fileId);
            if (StringTool.isEmpty(savepath)) {
                return false;
            }
            File file = (File)BeanFactory.getClass("File", new String[]{savepath});
            if (!file.exists() || !file.isFile()) return false;
            fileInfo = dao.getFile(fileId);
            FileInputStream in = (FileInputStream)BeanFactory.getClass("FileInputStream", new File[]{file});
            fileInfo.setFileStream(in);
            return true;
        } else {
            String savepath = Upload.getFilePath(fileId);
            File file = (File)BeanFactory.getClass("File", new String[]{savepath});
            if (file.exists() && file.isFile()) {
                fileInfo = dao.getFile(fileId);
                FileInputStream in = (FileInputStream)BeanFactory.getClass("FileInputStream", new File[]{file});
                fileInfo.setFileStream(in);
                return true;
            } else {
                fileInfo = dao.getDbFile(fileId);
                if (fileInfo.getFileStream() != null) return true;
                return false;
            }
        }
    }

    public static String getFilePath(String fileId) {
        String sql2 = "SELECT PATH,REALFILENAME FROM [SFILE].JXD7_PM_FILE WHERE ID= '" + fileId + "'";
        String filePath = "";
        String fileName = "";
        try {
            RowSet rs = DbOper.executeQuery(sql2);
            if (rs.next()) {
                filePath = rs.getString("PATH");
                fileName = rs.getString("REALFILENAME");
                if (filePath != null && !filePath.endsWith("/")) {
                    filePath = String.valueOf(filePath) + "/";
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        if (filePath == null || filePath.equals("")) {
            String savepath = Global.getConfig("upload.tempDir");
            if (savepath.startsWith("/")) {
                savepath = String.valueOf(Global.getPath()) + savepath;
            }
            if (!savepath.endsWith("/")) {
                savepath = String.valueOf(savepath) + "/";
            }
            filePath = savepath = savepath.replaceAll("(\\\\)|(//)", "/");
        }
        filePath = !StringTool.isEmpty(fileName) ? String.valueOf(filePath) + fileName : String.valueOf(filePath) + fileId;
        return filePath;
    }

    public static void delFile(FormInstance form, List list, int id) {
        FormCell[] formCell = form.getCell();
        if (formCell[id] == null) {
            return;
        }
        String cellValue = formCell[id].getValue();
        String lastValue = formCell[id].getLastValue();
        if (!StringTool.isEmpty(lastValue)) {
            List<String> lastFiles = Arrays.asList(lastValue.split(","));
            List<String> curFiles = Arrays.asList(cellValue.split(","));
            StringBuffer sql2 = new StringBuffer("DELETE FROM [SFILE].JXD7_PM_FILE WHERE SHEETID='");
            sql2.append(form.getId()).append("'");
            if (!StringTool.isEmpty(cellValue)) {
                ArrayList<String> delFiles = new ArrayList<String>();
                int i = 0;
                while (i < lastFiles.size()) {
                    if (!curFiles.contains(lastFiles.get(i))) {
                        boolean flag;
                        delFiles.add(lastFiles.get(i));
                        String savepath = Upload.getFilePath(lastFiles.get(i));
                        File file = (File)BeanFactory.getClass("File", new String[]{savepath});
                        if (file.exists() && file.isFile() && !(flag = file.delete())) {
                            log.error((Object)"Upload.java\u4e2ddelFile\u65b9\u6cd5\uff1a\u670d\u52a1\u5668\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff01");
                        }
                        file = null;
                    }
                    ++i;
                }
                if (delFiles.size() > 0) {
                    sql2.append(" AND ").append(DbOper.toIn1000Sql("ID", delFiles));
                    list.add(sql2.toString());
                }
            } else {
                int i = 0;
                while (i < lastFiles.size()) {
                    boolean flag;
                    String savepath = Upload.getFilePath(lastFiles.get(i));
                    File file = (File)BeanFactory.getClass("File", new String[]{savepath});
                    if (file.exists() && file.isFile() && !(flag = file.delete())) {
                        log.error((Object)"Upload.java\u4e2ddelFile\u65b9\u6cd5\uff1a\u670d\u52a1\u5668\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff01");
                    }
                    file = null;
                    ++i;
                }
                sql2.append(" AND ").append(DbOper.toIn1000Sql("ID", lastFiles));
                list.add(sql2.toString());
            }
        }
    }

    @Override
    public void save(FormInstance form, List list) {
        super.save(form, list);
    }

    @Override
    public void saveCell(FormInstance form, List list, int cellid) {
        Form pattern = form.getPattern();
        int patternType = pattern.getPatternType();
        if (patternType != 6) {
            Upload.delFile(form, list, this.id);
        }
    }

    public static void deleteFile(String formInstanceId) {
        if (dao == null) {
            dao = (PatternDao)BeanFactory.getClass("PatternDao");
        }
        try {
            dao.deleteFile(formInstanceId);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static String getCellValueByPatternField(String patternId, String sheetId, String field) {
        if (dao == null) {
            dao = (PatternDao)BeanFactory.getClass("PatternDao");
        }
        String strValue = dao.getCellValueByPatternField(patternId, field, sheetId);
        return strValue;
    }

    public static String saveFile(String jsCallBackHandle) {
        if (dao == null) {
            dao = (PatternDao)BeanFactory.getClass("PatternDao");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Context context = Global.getContext();
        try {
            FileBean fileBean = Upload.saveRequestFile("");
            if (fileBean != null) {
                result.put("fileName", fileBean.getFileName());
                result.put("fileId", fileBean.getFileId());
                result.put("success", Boolean.TRUE);
                result.put("msg", null);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            log.error((Object)exp);
            result.put("msg", exp.getMessage());
            result.put("success", Boolean.FALSE);
        }
        return "<script>" + jsCallBackHandle + "(\"" + StringTool.toJson(BeanTool.toJson(result)) + "\");</script>";
    }

    public static FileBean saveRequestFile(String folderPath) throws Exception {
        String fileName;
        FileItem fi;
        FileBean fileBean = null;
        boolean oppositeExten = false;
        String allowedExtensions = "".toLowerCase();
        if (dao == null) {
            dao = (PatternDao)BeanFactory.getClass("PatternDao");
        }
        DiskFileUpload fu = new DiskFileUpload();
        fu.setHeaderEncoding("GBK");
        fu.setSizeMax(maxSize);
        fu.setSizeThreshold((int)Threshold);
        String repositoryPath = Global.getConfig("upload.catchPath");
        File file = (File)BeanFactory.getClass("File", new String[]{repositoryPath});
        if (!(file.exists() || file.mkdir() || (file = (File)BeanFactory.getClass("File", new String[]{repositoryPath = System.getProperty("java.io.tmpdir")})).exists())) {
            throw new Exception("\u4e34\u65f6\u76ee\u5f55\u8bbe\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01");
        }
        fu.setRepositoryPath(repositoryPath);
        List fileItems = Global.getContext().getDiskFileUploadFile(fu);
        Iterator i = fileItems.iterator();
        if (i.hasNext() && !(fi = (FileItem)i.next()).isFormField() && (fileName = fi.getName()).length() > 0) {
            int extStartIndex = fileName.lastIndexOf(".");
            if (extStartIndex < 0) {
                throw new Exception("\u6240\u9009\u62e9\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u660e\u786e\uff0c\u4e0d\u5141\u8bb8\u4e0a\u4f20\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\uff01");
            }
            String extendFileName = fileName.substring(extStartIndex + 1, fileName.length()).toLowerCase();
            if (StringTool.isEmpty(allowedExtensions) ? DENIED_EXTENSIONS.indexOf(extendFileName) >= 0 : !oppositeExten && allowedExtensions.indexOf(extendFileName) < 0 || oppositeExten && allowedExtensions.indexOf(extendFileName) >= 0) {
                throw new Exception("\u6240\u9009\u62e9\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e0a\u4f20\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\uff01");
            }
            fileBean = Upload.saveFileItem(fi, folderPath);
        }
        return fileBean;
    }

    private static FileBean saveFileItem(FileItem fileItem, String folderPath) throws Exception {
        String extendFileName;
        String mainFileName;
        FileBean fileBean = null;
        String contentType = fileItem.getContentType();
        String createUserId = User.getCurrentUser().getId();
        long streamSize = fileItem.getSize();
        InputStream fileStream = fileItem.getInputStream();
        String localFileName = fileItem.getName();
        int extStartIndex = (localFileName = localFileName.substring(localFileName.lastIndexOf("\\") + 1, localFileName.length())).lastIndexOf(".");
        if (extStartIndex >= 0) {
            mainFileName = localFileName.substring(0, extStartIndex);
            extendFileName = localFileName.substring(extStartIndex + 1, localFileName.length());
        } else {
            mainFileName = localFileName;
            extendFileName = "";
        }
        if (IS_SAVE_DB) {
            String fileId = Guid.create();
            fileBean = new FileBean();
            fileBean.setFileId(fileId);
            fileBean.setFileName(localFileName);
            fileBean.setContentType(contentType);
            fileBean.setCreater(createUserId);
            fileBean.setCreateDate(DateTool.getNow());
            fileBean.setFileLength(streamSize);
            fileBean.setFileStream(fileStream);
            dao.saveDbFile(fileBean);
        } else {
            File file;
            String renamedFileName;
            String fileId;
            String finalPath;
            if (!folderPath.equals("") && !folderPath.startsWith("/")) {
                finalPath = folderPath;
            } else {
                String rootPath = Global.getConfig("upload.tempDir");
                finalPath = rootPath.startsWith("/") ? String.valueOf(Global.getPath()) + rootPath : rootPath;
                if (!finalPath.endsWith("/") || !finalPath.endsWith("\\")) {
                    finalPath = String.valueOf(finalPath) + "/";
                }
                finalPath = String.valueOf(finalPath) + folderPath;
                finalPath = finalPath.replaceAll("(\\\\)|(//)", "/");
            }
            File fileFolds = (File)BeanFactory.getClass("File", new String[]{finalPath});
            if (!fileFolds.isAbsolute()) {
                throw new Exception("\u521b\u5efa\u76ee\u5f55 \uff1a " + finalPath + " \u5931\u8d25 \uff01");
            }
            if (!fileFolds.isDirectory()) {
                fileFolds.mkdirs();
            }
            if ("1".equals(Global.getConfig("isSaveByName"))) {
                fileId = Guid.create();
                renamedFileName = localFileName;
                String fullFileName = String.valueOf(finalPath) + renamedFileName;
                file = (File)BeanFactory.getClass("File", new String[]{fullFileName});
                int m = 1;
                while (file.exists() && file.isFile()) {
                    renamedFileName = String.valueOf(mainFileName) + "(" + m + ")." + extendFileName;
                    fullFileName = String.valueOf(finalPath) + renamedFileName;
                    ++m;
                    file = (File)BeanFactory.getClass("File", new String[]{fullFileName});
                }
            } else {
                String fullFileName;
                do {
                    fileId = Guid.create();
                    renamedFileName = String.valueOf(fileId) + "." + extendFileName;
                } while ((file = (File)BeanFactory.getClass("File", new String[]{fullFileName = String.valueOf(finalPath) + renamedFileName})).exists() && file.isFile());
            }
            fileBean = new FileBean();
            fileBean.setFileId(fileId);
            fileBean.setFileName(localFileName);
            fileBean.setContentType(contentType);
            fileBean.setCreater(createUserId);
            fileBean.setCreateDate(DateTool.getNow());
            fileBean.setFileLength(streamSize);
            fileBean.setFileStream(fileStream);
            fileBean.setSavedFilePath(finalPath);
            fileBean.setSavedFileName(renamedFileName);
            dao.saveDiskFile(fileBean);
            fileItem.write(file);
        }
        return fileBean;
    }

    public static void deleteFileNew(String fileIds) {
        String[] fileIdArr;
        PatternDao fileDao = (PatternDao)BeanFactory.getClass("PatternDao");
        if (StringTool.isEmpty(fileIds)) {
            return;
        }
        String[] stringArray = fileIdArr = fileIds.split(",");
        int n = fileIdArr.length;
        int n2 = 0;
        while (n2 < n) {
            String fileId = stringArray[n2];
            if (!StringTool.isEmpty(fileId)) {
                String path = Upload.getFilePath(fileId);
                File file = new File(path);
                if (file.exists() && file.isFile()) {
                    file.delete();
                }
                file = null;
            }
            fileDao.delCommonsFile(fileId);
            ++n2;
        }
    }

    public static boolean updateNeedDel(String[] fileIds) {
        PatternDao fileDao = (PatternDao)BeanFactory.getClass("PatternDao");
        boolean flag = false;
        if (fileIds.length > 0 && fileDao != null) {
            flag = PatternDao.updateNeedDel(fileIds);
        }
        return flag;
    }
}

