/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.dao.TreeDao;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.LinkApp;
import com.sdjxd.pms.platform.form.model.TreeNodeBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.CommonCell;
import com.sdjxd.pms.platform.form.service.cell.ins.TreeIns;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.StringTool;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;

public class Tree
extends CommonCell {
    private static final long serialVersionUID = 1L;
    private LinkApp linkApp;
    private String jsLinkName;
    private String clickText;
    private String dblClickText;
    private String openLevelCount;
    private boolean showCheckBox;
    private boolean createAllNode;
    private boolean checkedParent = false;
    private boolean checkedChild = true;
    private boolean addRootNode = false;
    private String addRootNodeName;
    private TreeDao treeDao = null;
    private String appId;

    public Tree(Form pattern) {
        super(pattern);
        pattern.setOldPattern(true);
        this.tagName = "div";
    }

    public static TreeNodeBean[] getChildNodeArray(String appId, String tableId, String linkId, String sheetId, String nodeGuid, int cellId, String isGroup, String gId) {
        TreeDao dao = new TreeDao(appId);
        LinkApp linkApp = dao.getLinkApp();
        StringBuffer script = new StringBuffer();
        return dao.getLinkAppTableNodeArray(appId, linkApp.getDataSourceName(), tableId, linkId, sheetId, cellId, isGroup, gId, null, script, nodeGuid, false);
    }

    public static TreeNodeBean[] getRootNodeArray(String appId, boolean createAllNode) {
        TreeDao dao = new TreeDao(appId);
        LinkApp lkapp = dao.getLinkApp();
        if (lkapp == null) {
            return null;
        }
        StringBuffer script = new StringBuffer();
        return dao.getLinkAppRootNodeArray(lkapp, createAllNode, script, false);
    }

    public static List getChildTableInTabPage(String appId, String tableId) {
        return TreeDao.getLinkAppTableNodeInfo(appId, tableId);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        if (model == null) {
            return;
        }
        super.setData(model);
        this.id = this.data.cellId;
        this.setCellId(String.valueOf(this.cellPrefix) + this.id);
        String oWidth = String.valueOf(this.width) + "px";
        if (model.widthScale != null && model.widthScale.length() != 0 && !model.widthScale.equals("0")) {
            oWidth = model.widthScale;
        }
        this.style.put("width", oWidth);
        String oHeight = String.valueOf(this.height) + "px";
        if (model.heightScale != null && model.heightScale.length() != 0 && !model.heightScale.equals("0")) {
            oHeight = model.heightScale;
        }
        this.style.put("height", oHeight);
        this.setStyle();
        this.setClassName();
        if (this.data.createDate != null && this.data.createDate.length() != 0) {
            this.modifyTime = DateTool.parseDate(this.data.createDate);
        }
        String[] tmp = (String[])StringTool.strToArray(this.data.assitInfo);
        int color = Integer.parseInt(tmp[7]);
        StringBuffer sbColor = new StringBuffer(7);
        sbColor.append("#");
        sbColor.append(color % 256 == 0 ? "00" : Integer.toHexString(color % 256));
        sbColor.append((color >> 8) % 256 == 0 ? "00" : Integer.toHexString((color >> 8) % 256));
        sbColor.append(color >> 16 == 0 ? "00" : Integer.toHexString(color >> 16));
        this.showCheckBox = tmp[0].equals("1");
        this.createAllNode = tmp[2].equals("1");
        int tag = tmp[5].indexOf(":");
        this.jsLinkName = "Tree_" + this.id;
        this.appId = tmp[5].substring(tag + 1, tmp[5].length());
        this.clickText = tmp[6];
        this.dblClickText = tmp.length > 9 ? tmp[9] : "";
        String string = this.openLevelCount = tmp.length > 8 ? tmp[8] : "0";
        if (tmp.length > 10 && tmp[10].equals("1")) {
            this.checkedParent = true;
        }
        if (tmp.length > 11 && tmp[11].equals("0")) {
            this.checkedChild = false;
        }
        if (tmp[1].equals("1")) {
            this.addRootNode = true;
            this.addRootNodeName = tmp[4].length() != 0 ? tmp[4] : "\u589e\u52a0\u6839\u8282\u70b9";
        }
    }

    @Override
    public void render(FormInstance form) throws Exception {
        super.render(form);
        String assitInfo = this.data.assitInfo;
        if (assitInfo != null) {
            String[] tmp = (String[])StringTool.strToArray(assitInfo);
            String sql2 = tmp[5];
            String bgColor = tmp[7];
            int color = Integer.parseInt(bgColor);
            StringBuffer sbColor = new StringBuffer(7);
            sbColor.append("#");
            sbColor.append(color % 256 == 0 ? "00" : Integer.toHexString(color % 256));
            sbColor.append((color >> 8) % 256 == 0 ? "00" : Integer.toHexString((color >> 8) % 256));
            sbColor.append(color >> 16 == 0 ? "00" : Integer.toHexString(color >> 16));
            try {
                StringBuffer script = new StringBuffer();
                script.append("var nodeInfo={};");
                PrintWriter renderHtml = form.getRenderHtml();
                ((Writer)renderHtml).write(this.outContainer(script));
                this.renderScriptObject(form);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.renderEvent(form);
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        StringBuffer sb = new StringBuffer();
        StringBuffer script = new StringBuffer();
        script.append("var nodeInfo={};");
        sb.append(this.outScript(script, form));
        sb.append("defaultForm.addChild(").append(this.jsLinkName).append(");");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    private String outContainer(StringBuffer script) {
        String oWidth = String.valueOf(this.width) + "px";
        String oHeight = String.valueOf(this.height) + "px";
        StringBuffer sb = new StringBuffer();
        sb.append("<div id='treeDiv_" + this.id + "'");
        if (this.heightScale != null && this.heightScale.length() != 0 && !this.heightScale.equals("0")) {
            sb.append(" heightScale=").append(this.heightScale);
            oHeight = this.heightScale;
        }
        sb.append(" style='width:");
        if (this.widthScale != null && this.widthScale.length() != 0 && !this.widthScale.equals("0")) {
            sb.append(this.widthScale);
        } else {
            sb.append(oWidth);
        }
        sb.append(";height:" + oHeight + ";left:" + this.left + "px;top:" + this.top + "px;overflow:auto;position:" + this.position + ";border-width: " + this.data.lineWidth + "px; border-style: solid;box-sizing:content-box'");
        sb.append(" class='" + this.data.borderStyle + " ");
        sb.append(this.data.bkColorStyle).append("'");
        sb.append(">");
        sb.append("</div>");
        return sb.toString();
    }

    private String outContent(StringBuffer script) {
        if (this.linkApp == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        this.linkApp.setJsName(this.jsLinkName);
        this.linkApp.setCellId(this.id);
        String content = "";
        this.treeDao.getLinkAppRootNodeArray(this.linkApp, this.createAllNode, script, true);
        sb.append(content);
        return sb.toString();
    }

    private String outScript(StringBuffer script, FormInstance form) {
        TreeIns formCell = (TreeIns)form.getCell(this.id);
        String openLevelCount = formCell.getOpenLevelCount();
        boolean showCheckBox = formCell.isShowCheckBox();
        LinkApp linkApp = formCell.getLinkApp();
        if (linkApp != null) {
            this.treeDao.getLinkAppRootNodeArray(linkApp, this.createAllNode, script, true);
        }
        String appID = linkApp == null ? "" : linkApp.getAppId();
        StringBuffer sb = new StringBuffer();
        sb.append("\n var " + this.jsLinkName + " = new com.sdjxd.pms.platform.form.cell.Tree({id:");
        sb.append(this.id);
        sb.append(",tagId:treeDiv_").append(this.id);
        sb.append(",typeName:'Tree'");
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        sb.append(",needSave:false");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append(",showCheckBox:").append(showCheckBox);
        sb.append(",openLevel:'").append(StringTool.replaceHTML(openLevelCount));
        sb.append("',createAllNode:").append(this.createAllNode);
        sb.append(",checkedParent:").append(this.checkedParent);
        sb.append(",checkedChild:").append(this.checkedChild);
        sb.append(",textColorStyle:'").append(this.data.textColorStyle).append("'");
        sb.append(",bgColorStyle:'").append(this.data.bkColorStyle).append("'");
        sb.append(",readOnlyBgColorStyle:'").append(this.data.readBkColorStyle).append("'");
        if (this.addRootNode) {
            sb.append(",addRootNode:").append(this.addRootNode);
            sb.append(",addRootNodeName:\"").append(this.addRootNodeName).append("\"");
            if (linkApp != null && linkApp.getTableId() != null) {
                sb.append(",linkAppTableId:\"").append(linkApp.getTableId()).append("\"");
            } else {
                sb.append(",linkAppTableId:\"").append("\"");
            }
            sb.append(",addRootNodeId:\"").append(Guid.create()).append("\"");
        }
        sb.append("});");
        sb.append("\n " + this.jsLinkName + ".init('" + appID + "',\"").append(script).append("\");");
        if (this.clickText != null && this.clickText.length() != 0) {
            sb.append("\n " + this.jsLinkName + ".clickText = " + this.clickText);
        }
        if (this.dblClickText != null && this.dblClickText.length() != 0) {
            sb.append("\n " + this.jsLinkName + ".dblClickText = " + this.dblClickText);
        }
        if (openLevelCount != null && !openLevelCount.equals("0")) {
            sb.append("\n" + this.jsLinkName + ".openNode('" + StringTool.replaceHTML(openLevelCount) + "');");
        }
        return sb.toString();
    }

    private String nodeToHtml(TreeNodeBean[] node) {
        if (node == null || node.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < node.length) {
            sb.append(this.nodeToHtml(node[i]));
            ++i;
        }
        return sb.toString();
    }

    private String nodeToHtml(TreeNodeBean node) {
        if (node == null) {
            return "";
        }
        TreeNodeBean[] childNodes = node.getChilds();
        StringBuffer str = new StringBuffer();
        str.append("<TABLE id=\"");
        str.append(node.getId());
        str.append("\" cellSpacing=\"0\" cellPadding=\"0\">");
        str.append("<TR>");
        str.append("<TD class=\"tree_item_cell\">");
        str.append("<DIV  class=\"");
        if (childNodes == null) {
            str.append("tree_item_nonexpandable");
        } else {
            str.append("tree_item_collapsed");
        }
        str.append("\" id=\"expander\" onclick=");
        str.append("window.COMPcreateEvent();Tree_" + this.id + ".getChildNodes();");
        str.append(">");
        str.append("</DIV>");
        str.append("<DIV  class=\"tree_item_icon\" id=\"icon\" onclick=\"");
        str.append("Tree_" + this.id + ".MouseClick(this);");
        str.append("\">");
        str.append("<IMG height=\"16\" src=\"");
        str.append(node.getIconSrc());
        str.append("\" width=\"16\" />");
        str.append("</DIV>");
        str.append("<DIV  class=\"tree_item_text\" id=\"text\" ondblclick=\"");
        str.append("Tree_" + this.id + ".MouseDBlClick(this);");
        str.append("\" onclick=\"");
        str.append("Tree_" + this.id + ".MouseClick(this);");
        str.append("\">");
        if (this.showCheckBox) {
            str.append("<INPUT id=\"tree_item_checkbox_");
            str.append(node.getId());
            str.append("\" style=\"MARGIN-TOP: -4px; MARGIN-LEFT: -4px\" onclick=\"Tree_");
            str.append(this.id);
            str.append(".checkBoxClick(this)\" type=\"checkbox\" nodeId=\"");
            str.append(node.getId());
            str.append("\" value=\"on\" ");
            if (node.isChecked()) {
                str.append(" checked ");
            }
            if (node.isDisabled()) {
                str.append(" disabled ");
            }
            str.append(" />");
        }
        str.append("<SPAN>");
        str.append(node.getText());
        str.append("</SPAN>");
        str.append("</DIV>");
        str.append("</TD>");
        str.append("</TR>");
        if (childNodes != null && childNodes.length > 0) {
            str.append("<TR style=\"display:none;\">");
            str.append("<TD class=\"tree_childNodes\">");
            int i = 0;
            while (i < childNodes.length) {
                str.append(this.nodeToHtml(childNodes[i]));
                ++i;
            }
            str.append("</TD>");
            str.append("</TR>");
        }
        str.append("</TABLE>");
        return str.toString();
    }

    @Override
    protected void setBorder(int lineWidth) {
        this.border = lineWidth;
        if (this.border > 0) {
            this.style.put("border-width", String.valueOf(this.border) + "px");
            this.style.put("border-style", "solid");
            this.style.put("border-color", SheetConstants.CELL.LINECOLOR);
            this.style.remove("border");
            this.setWidth(this.width - 2 * lineWidth);
            this.setHeight(this.height - 2 * lineWidth);
        } else if (this.border == 0) {
            this.style.put("border", "0px");
            this.style.remove("border-width");
            this.style.remove("border-style");
            this.style.remove("border-color");
        }
    }

    @Override
    public FormCell createCellInstance() {
        return new TreeIns();
    }

    @Override
    public void renderInstanceValue(FormInstance form) {
        TreeIns formCell = (TreeIns)form.getCell(this.id);
        String appId_Real = this.appId;
        if (appId_Real.length() == 0) {
            appId_Real = Global.getContext().getParameter("appID");
        }
        if (appId_Real != null && appId_Real.length() != 0) {
            this.treeDao = new TreeDao(appId_Real);
            LinkApp linkApp = this.treeDao.getLinkApp();
            if (linkApp != null) {
                linkApp.setJsName(this.jsLinkName);
                linkApp.setCellId(this.id);
                String filter = linkApp.getFilter();
                if (filter == null) {
                    filter = "";
                }
                if (Global.getContext().getParameter("treeRootNodeFilter") != null && Global.getContext().getParameter("treeRootNodeFilter").length() != 0) {
                    if (filter != null && filter.length() != 0) {
                        filter = String.valueOf(filter) + " and ";
                    }
                    filter = String.valueOf(filter) + " (";
                    filter = String.valueOf(filter) + Global.getContext().getParameter("treeRootNodeFilter");
                    filter = String.valueOf(filter) + ")";
                }
                linkApp.setFilter(StringTool.replaceKeyWord(filter));
                formCell.setLinkApp(linkApp);
            }
        }
        String openLevelCount_Real = this.openLevelCount;
        if (Global.getContext().getParameter("h_treeNodeOpenLevel") != null && Global.getContext().getParameter("h_treeNodeOpenLevel").length() != 0) {
            openLevelCount_Real = Global.getContext().getParameter("h_treeNodeOpenLevel");
        }
        formCell.setOpenLevelCount(openLevelCount_Real);
        boolean showCheckBox_Real = this.showCheckBox;
        if (Global.getContext().getParameter("h_treeShowCheckBox") != null && Global.getContext().getParameter("h_treeShowCheckBox").length() != 0) {
            showCheckBox_Real = Global.getContext().getParameter("h_treeShowCheckBox").equals("1");
        }
        formCell.setShowCheckBox(showCheckBox_Real);
    }
}

