/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.model.CellActionBean;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.cell.Cell;
import com.sdjxd.pms.platform.form.service.cell.DynamicCell;
import com.sdjxd.pms.platform.form.service.cell.HtmlSelectorBtn;
import com.sdjxd.pms.platform.table.model.FieldMeanBean;
import com.sdjxd.pms.platform.table.service.mean.FieldMean;
import com.sdjxd.pms.platform.table.service.mean.ID_Selector;
import com.sdjxd.pms.platform.table.service.mean.IFieldMean;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Text
extends DynamicCell {
    private static final long serialVersionUID = 1L;
    protected HtmlSelectorBtn selectorBtn;
    protected String fieldMeanType;
    protected String fieldMeanValue;
    protected IFieldMean fieldMean;
    private String inputType = "text";
    private boolean manuscript;
    private String expression;

    public Text(Form pattern) {
        super(pattern);
        this.setOldPatternAuto(pattern);
        this.setPattern(pattern);
        this.selectorBtn = (HtmlSelectorBtn)BeanFactory.getClass("HtmlSelectorBtn", new Object[]{pattern});
        this.tagName = "input";
        this.attributes.put("type", this.inputType);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        Object[] temp;
        boolean bl = this.manuscript = model.readonly == 1;
        if (model.fieldMeanType != null) {
            this.fieldMeanType = model.fieldMeanType;
            if (!StringTool.isEmpty(model.fieldMeanValue)) {
                FieldMeanBean fieldMeanBean;
                this.fieldMeanValue = model.fieldMeanValue;
                if (model.fieldMeanType.equals("IDStringPicker")) {
                    fieldMeanBean = new FieldMeanBean();
                    fieldMeanBean.setType(model.fieldMeanType);
                    fieldMeanBean.setDataSourceName(model.meanDataSourceName);
                    fieldMeanBean.setAssitinfo(model.fieldMeanValue);
                    this.fieldMean = FieldMean.getInstance(fieldMeanBean);
                } else if (model.fieldMeanType.equals("DropDown")) {
                    fieldMeanBean = new FieldMeanBean();
                    fieldMeanBean.setType(model.fieldMeanType);
                    fieldMeanBean.setDataSourceName(model.meanDataSourceName);
                    fieldMeanBean.setAssitinfo(model.fieldMeanValue);
                    this.fieldMean = FieldMean.getInstance(fieldMeanBean);
                } else if (model.fieldMeanType.equals("Name_Selector") || model.fieldMeanType.equals("ID_Selector")) {
                    Object[] temp2;
                    fieldMeanBean = new FieldMeanBean();
                    fieldMeanBean.setType(model.fieldMeanType);
                    fieldMeanBean.setDataSourceName(model.meanDataSourceName);
                    fieldMeanBean.setAssitinfo(model.fieldMeanValue);
                    this.fieldMean = FieldMean.getInstance(fieldMeanBean);
                    if (model.assitInfo != null && !model.assitInfo.equals("") && (temp2 = StringTool.strToArray(model.assitInfo)).length > 0) {
                        String[] btnInfo = null;
                        if (temp2[0] != null && temp2[0] instanceof String) {
                            btnInfo = (String[])temp2;
                        } else if (temp2[0] != null && temp2[0] instanceof String[]) {
                            btnInfo = (String[])temp2[0];
                        }
                        try {
                            if (btnInfo != null && btnInfo.length > 6) {
                                this.selectorBtn.btnLabel = btnInfo[0];
                                this.selectorBtn.btnHeight = Integer.parseInt(btnInfo[1]);
                                this.selectorBtn.btnWidth = Integer.parseInt(btnInfo[2]);
                                this.selectorBtn.btnReadOnlyStyle = btnInfo[3];
                                this.selectorBtn.btnTextStyle = btnInfo[4];
                                this.selectorBtn.btnBkStyle = btnInfo[5];
                                this.selectorBtn.btnFontStyle = btnInfo[6];
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.selectorBtn.setParentControls(this);
                    this.selectorBtn.setData(model);
                }
            }
        }
        super.setData(model);
        if (model.assitInfo != null && !model.assitInfo.equals("") && (temp = StringTool.strToArray(model.assitInfo)).length > 1 && temp[0] != null && temp[0].getClass().isArray()) {
            this.expression = (String)temp[1];
        }
    }

    private void parseExpression() {
        if (this.expression == null || this.expression.length() == 0) {
            return;
        }
        ICell[] cells = this.pattern.getCells();
        String jscontent = this.expression;
        String cellRegex = "\\\"\\[([0-9]+)\\.(text|value)\\]\\\"";
        Pattern matcherPattern = Pattern.compile(cellRegex);
        Matcher m = matcherPattern.matcher(this.expression);
        HashMap<String, String> replacement = new HashMap<String, String>();
        int[] relatedCellId = new int[20];
        int index = 0;
        while (m.find()) {
            String matcherValue = m.group(1);
            relatedCellId[index++] = Integer.parseInt(matcherValue);
            if ("value".equals(m.group(2))) {
                replacement.put(m.group(0), "defaultForm.getCellById(" + matcherValue + ").getValue()");
                continue;
            }
            replacement.put(m.group(0), "defaultForm.getCellById(" + matcherValue + ").getText()");
        }
        jscontent = StringTool.replace(jscontent, replacement);
        jscontent = "defaultForm.getCellById(" + this.id + ").setText(" + jscontent + ")";
        this.addEvent("onload", jscontent);
        --index;
        while (index >= 0) {
            if (relatedCellId[index] >= 0 && relatedCellId[index] < cells.length && cells[relatedCellId[index]] != null) {
                cells[relatedCellId[index]].addEvent("onchange", jscontent);
            }
            --index;
        }
    }

    public static void main(String[] ars) {
        String ostr = "[1.value]*[1.text]*$ds1.data[0][\"userNumber\"]*sum($ds1.row[\"userNumber\"])*max($ds1.column[\"userNumber\"])";
        String cellRegex = "\\[([0-9]+)\\.(text|value)\\]";
        String cellTextRegex = "\\[([0-9]+)\\.text\\]";
        String cellValueRegex = "\\[([0-9]+)\\.value\\]";
        String datasetDataRegex = "(\\$[\\w_0-9]*)\\.data";
        String datasetRowRegex = "(\\$[\\w_0-9]*)\\.row";
        String datasetColumnRegex = "(\\$[\\w_0-9]*)\\.column";
        Pattern pattern = Pattern.compile(cellRegex);
        Matcher m = pattern.matcher(ostr);
        while (m.find()) {
            System.out.println("cellRegex.groupCount():" + m.groupCount());
            System.out.println(" cellRegex.group():" + m.group());
            System.out.println(" cellRegex.group(1)---:" + m.group(1));
        }
        pattern = Pattern.compile(cellTextRegex);
        m = pattern.matcher(ostr);
        while (m.find()) {
            System.out.println("cellTextRegex.groupCount():" + m.groupCount());
            System.out.println(" cellTextRegex.group():" + m.group());
            System.out.println(" cellTextRegex.group(1):" + m.group(1));
        }
        pattern = Pattern.compile(cellValueRegex);
        m = pattern.matcher(ostr);
        while (m.find()) {
            System.out.println("cellValueRegex.groupCount():" + m.groupCount());
            System.out.println(" cellValueRegex.group():" + m.group());
            System.out.println(" cellValueRegex.group(1):" + m.group(1));
        }
        pattern = Pattern.compile(datasetDataRegex);
        m = pattern.matcher(ostr);
        while (m.find()) {
            System.out.println("datasetRegex.groupCount():" + m.groupCount());
            System.out.println(" datasetRegex.group():" + m.group());
            System.out.println(" datasetRegex.group(1):" + m.group(1));
        }
    }

    @Override
    public String getValueAttribute() {
        return "cv";
    }

    @Override
    public void setDefault(FormInstance form) {
        if (this.fieldMeanType != null && this.fieldMeanType.equals("IDStringPicker")) {
            return;
        }
        if (this.fieldMeanType != null && this.fieldMeanType.equals("ID_Selector")) {
            String defaultValue = this.label;
            defaultValue = StringTool.replaceKeyWord(defaultValue, form);
            if (!StringTool.isEmpty(defaultValue = FormInstance.replaceParaValue(defaultValue, form))) {
                form.getCell()[this.id].setValue(defaultValue);
                form.getCell()[this.id].setText(this.fieldMean.getText(defaultValue));
            }
        } else {
            String defaultValue = this.label;
            defaultValue = StringTool.replaceKeyWord(defaultValue, form);
            defaultValue = FormInstance.replaceParaValue(defaultValue, form);
            int i = 0;
            while (i < this.controls.size()) {
                ((Cell)this.controls.get(i)).setDefault(form);
                ++i;
            }
            if (!StringTool.isEmpty(defaultValue)) {
                form.getCell()[this.id].setText(defaultValue);
            }
        }
    }

    @Override
    protected void setWidth(int width) {
        super.setWidth(width);
        if (this.fieldMeanType != null && (this.fieldMeanType.equals("ID_Selector") || this.fieldMeanType.equals("Name_Selector"))) {
            this.width = width - this.selectorBtn.btnWidth - 2;
            this.style.put("width", String.valueOf(String.valueOf(this.width)) + "px");
        } else {
            this.width = width;
            this.style.put("width", String.valueOf(String.valueOf(width)) + "px");
        }
    }

    @Override
    protected void setHeight(int height) {
        super.setHeight(height);
        this.style.put("padding-top", "1px");
        this.style.put("line-height", String.valueOf(String.valueOf(height - 2 - this.border * 2)) + "px");
    }

    @Override
    protected void setBorder(int lineWidth) {
        super.setBorder(lineWidth);
    }

    @Override
    protected void renderEnable(FormInstance form) throws Exception {
        FormCell[] cells = form.getCell();
        if (this.id < cells.length && cells[this.id] != null && (!cells[this.id].isEnabled() || this.readonly)) {
            PrintWriter renderHtml1 = form.getRenderHtml();
            ((Writer)renderHtml1).write(" d=1 readonly=\"");
            ((Writer)renderHtml1).write(SheetConstants.HTML.ATTTRUE);
            ((Writer)renderHtml1).write("\"");
        } else if (this.fieldMean instanceof ID_Selector && !((ID_Selector)this.fieldMean).isAllowEdit()) {
            PrintWriter renderHtml1 = form.getRenderHtml();
            ((Writer)renderHtml1).write(" d=1 readonly=\"");
            ((Writer)renderHtml1).write(SheetConstants.HTML.ATTTRUE);
            ((Writer)renderHtml1).write("\"");
        }
    }

    @Override
    protected void renderAttribute(FormInstance form) throws Exception {
        FormCell[] formCell;
        super.renderAttribute(form);
        if (this.fieldMean != null && !this.pattern.isHasText() && StringTool.isEmpty(this.textField) && this.id < (formCell = form.getCell()).length && formCell[this.id] != null) {
            String value = formCell[this.id].getValue();
            String text = formCell[this.id].getText();
            if (!StringTool.isEmpty(value) && StringTool.isEmpty(text)) {
                formCell[this.id].setText(this.fieldMean.getText(value));
            }
        }
        this.renderValue(form);
    }

    @Override
    protected void renderClass(FormInstance form) throws Exception {
        PrintWriter renderHtml1 = form.getRenderHtml();
        ((Writer)renderHtml1).write(" class=\"");
        this.renderCommonClass(form);
        boolean isReadOnly = false;
        if (this.cellType == 10) {
            if (this.id < form.getCell().length && form.getCell()[this.id] != null && form.getCell()[this.id].isEnabled()) {
                if (this.fieldMean instanceof ID_Selector && !((ID_Selector)this.fieldMean).isAllowEdit()) {
                    isReadOnly = true;
                }
            } else {
                isReadOnly = true;
            }
        } else if (this.id >= form.getCell().length || form.getCell()[this.id] == null || !form.getCell()[this.id].isEnabled()) {
            isReadOnly = true;
        }
        if (isReadOnly) {
            this.renderReadClass(form);
        } else {
            this.renderEditClass(form);
        }
        ((Writer)renderHtml1).write("\"");
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        FormCell[] formCell;
        StringBuffer sb = new StringBuffer();
        if (this.fieldMeanType != null && (this.fieldMeanType.equals("Name_Selector") || this.fieldMeanType.equals("ID_Selector")) && this.fieldMeanValue != null && this.fieldMeanValue.length() != 0) {
            sb.append("var selColMean").append(this.id);
            sb.append(" = new com.sdjxd.pms.platform.form.cell.SelectorColumnMean({");
            if (this.selectorBtn.colMeanNameField != null) {
                sb.append("nameField:\"").append(this.selectorBtn.colMeanNameField).append("\"");
            }
            if (this.selectorBtn.colMeanIdField != null) {
                sb.append(",idField:\"").append(this.selectorBtn.colMeanIdField).append("\"");
            }
            if (this.selectorBtn.colMeanTableName != null) {
                sb.append(",tableName:\"").append(this.selectorBtn.colMeanTableName).append("\"");
            }
            if (this.selectorBtn.colMeanTableName != null) {
                sb.append(",dataSourceName:\"").append(this.selectorBtn.getMeanDataSourceName()).append("\"");
            }
            if (this.selectorBtn.colMeanDialogArg != null) {
                sb.append(",dialogArg:\"").append(this.selectorBtn.colMeanDialogArg).append("\"");
            }
            if (this.fieldMeanValue != null) {
                sb.append(",assistInfo:").append(this.fieldMeanValue).append("");
            }
            if (this.selectorBtn.colMeanUrl != null) {
                sb.append(",url:\"").append(StringTool.replaceKeyWord(this.selectorBtn.colMeanUrl));
                if (this.selectorBtn.colMeanActArg != null) {
                    sb.append("?").append(StringTool.replaceKeyWord(this.selectorBtn.colMeanActArg));
                }
                sb.append("\"");
            }
            sb.append("});\r\n");
        } else if (this.fieldMeanType != null && this.fieldMeanType.equals("IDStringPicker")) {
            sb.append("var selColMean").append(this.id);
            sb.append(" = new com.sdjxd.pms.platform.form.cell.ComboBoxColumnMean({assistInfo:");
            sb.append(this.fieldMeanValue);
            sb.append(",dataSourceName:\"").append(this.meanDataSourceName).append("\"});\r\n");
        } else if (this.fieldMeanType != null && this.fieldMeanType.equals("Text")) {
            sb.append("var selColMean").append(this.id);
            sb.append(" = new com.sdjxd.pms.platform.form.cell.TextMean({assistInfo:");
            sb.append(this.fieldMeanValue);
            sb.append("});\r\n");
        } else if (this.fieldMeanType != null && this.fieldMeanType.equals("DropDown")) {
            sb.append("var selColMean").append(this.id);
            sb.append(" = new com.sdjxd.pms.platform.form.cell.DropDownMean({assistInfo:");
            sb.append(this.fieldMeanValue);
            sb.append("});\r\n");
        }
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.cell.Text({id:");
        sb.append(this.id);
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        sb.append(",isPrint:");
        sb.append(this.data.isPrint);
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",label:\"" + StringTool.toJson(this.label) + "\"");
        sb.append(",expression:\"" + StringTool.toJson(this.expression) + "\"");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append(",bgColorStyle:'").append(this.data.bkColorStyle).append("'");
        sb.append(",readOnlyBgColorStyle:'").append(this.data.readBkColorStyle).append("'");
        sb.append(",isMultiLine:false,needSave:");
        sb.append(this.isNeedSave());
        sb.append(",allowEdit:").append(!this.readonly);
        if (this.data.checkCondition != -1) {
            sb.append(",conditionId:" + this.data.checkCondition);
        }
        if (this.fieldMeanType != null && this.fieldMeanValue != null && this.fieldMeanValue.length() != 0) {
            sb.append(",fieldMean:selColMean").append(this.id);
        }
        if (this.fieldMeanType != null && (this.fieldMeanType.equals("Name_Selector") || this.fieldMeanType.equals("ID_Selector")) && this.fieldMeanValue != null && this.fieldMeanValue.length() != 0) {
            sb.append(",selectorBtnStyle:{btnLabel:'").append(this.selectorBtn.btnLabel).append("'");
            sb.append(",btnHeight:").append(this.selectorBtn.btnHeight);
            sb.append(",btnWidth:").append(this.selectorBtn.btnWidth);
            sb.append(",btnTextStyle:'").append(this.selectorBtn.btnTextStyle).append("'");
            sb.append(",btnReadOnlyStyle:'").append(this.selectorBtn.btnReadOnlyStyle).append("'");
            sb.append(",btnBkStyle:'").append(this.selectorBtn.btnBkStyle).append("'");
            sb.append(",btnFontStyle:'").append(this.selectorBtn.btnFontStyle).append("'");
            sb.append("}");
        }
        if (this.verifyMeans != null && this.verifyMeans.length > 0) {
            sb.append(",verifyMeans:[");
            StringBuffer meanBuffer = new StringBuffer(512);
            int i = 0;
            while (i < this.verifyMeans.length) {
                meanBuffer.append("var ").append(this.verifyMeans[i].getJsName());
                meanBuffer.append(" = new com.sdjxd.pms.platform.form.cell.TextMean({assistInfo:");
                meanBuffer.append(this.verifyMeans[i].getRegex());
                meanBuffer.append("});\r\n");
                form.addScript("form_obj_cell_0_means" + this.verifyMeans[i].getJsName(), meanBuffer.toString());
                sb.append(this.verifyMeans[i].getJsName());
                sb.append(",");
                ++i;
            }
            sb.setLength(sb.length() - 1);
            sb.append("]");
        }
        sb.append("}));\r\n");
        if (this.fieldMeanType != null && (this.fieldMeanType.equals("Name_Selector") || this.fieldMeanType.equals("ID_Selector")) && this.fieldMeanValue != null && this.fieldMeanValue.length() != 0) {
            sb.append("cellId").append(this.id).append("selectorBtn").append(".onclick = function(){");
            sb.append("com.sdjxd.pms.platform.form.cell.Text.selectorObject(");
            sb.append("defaultForm.getCellById(").append(this.id).append(")");
            sb.append(");}\r\n");
        } else if ("DropDown".equals(this.fieldMeanType)) {
            formCell = form.getCell();
            if (formCell != null && this.id < formCell.length && formCell[this.id] != null && formCell[this.id].isEnabled()) {
                sb.append("cellId").append(this.id).append(".onclick = function(){");
                sb.append("com.sdjxd.pms.platform.form.cell.Text.showDropDown(");
                sb.append("defaultForm.getCellById(").append(this.id).append(")");
                sb.append(");}\r\n");
            }
        } else if (this.fieldMeanType != null && this.fieldMeanType.equals("IDStringPicker")) {
            formCell = form.getCell();
            if (formCell != null && this.id < formCell.length && formCell[this.id] != null && formCell[this.id].isEnabled()) {
                sb.append("cellId").append(this.id).append(".onclick = function(){");
                sb.append("com.sdjxd.pms.platform.form.cell.Text.showMultiListBox(");
                sb.append("defaultForm.getCellById(").append(this.id).append(")");
                sb.append(");}\r\n");
            }
            if (formCell != null && this.id < formCell.length && formCell[this.id] != null) {
                if (form.getPattern().getCells()[this.id].getDefaultValueTime() == 1) {
                    if (formCell[this.id].isEnabled() && StringTool.isEmpty(formCell[this.id].getValue())) {
                        sb.append("defaultForm.getCellById(").append(this.id).append(").setDefault(").append(StringTool.replaceKeyWord(this.label)).append(");");
                    }
                } else if (form.getId() == "" || form.getModify().is(DataModify.NEW)) {
                    sb.append("defaultForm.getCellById(").append(this.id).append(").setDefault(").append(StringTool.replaceKeyWord(this.label)).append(");");
                }
            }
        }
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    @Override
    public void addEvent(CellActionBean cellAction) {
        if (cellAction == null) {
            this.parseExpression();
            if (this.fieldMeanType != null && this.fieldMeanType.equals("Password")) {
                this.attributes.put("type", "password");
                this.style.put("ime-mode", "Disabled");
            }
            this.addEvent("onchange", "sender.textChanged();");
            this.addEvent("onkeydown", "if(event.keyCode==13){event.keyCode=9;}");
        }
        super.addEvent(cellAction);
    }

    @Override
    protected void renderEvent(FormInstance form) {
        FormCell formCell;
        if (this.id < form.getCell().length && (formCell = form.getCell()[this.id]) != null) {
            StringBuffer sb = new StringBuffer(128);
            int i = 0;
            while (i < MAXEVENT) {
                if (this.events[i] != null && (this.events[i].getEventCode().equals("onmouseover") || formCell.isEnabled())) {
                    String sender = "onload".equals(this.events[i].getEventCode()) ? "window" : "defaultForm.getCellById(" + this.id + ")";
                    sb.append(this.events[i].toString(sender));
                }
                ++i;
            }
            form.addScript("form_obj_cell_" + this.id + "_event", sb.toString());
        }
    }

    protected void setOldPatternAuto(Form pattern) {
        pattern.setOldPattern(true);
    }
}

