/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.model.CellActionBean;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.TabPage;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.CommonCell;
import com.sdjxd.pms.platform.tool.StringTool;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;

public class TabPageCell
extends CommonCell {
    private static final long serialVersionUID = 1L;
    private String assitInfo;
    private String cssStyle;
    private ArrayList tabPages;
    private String jsName;
    private int defaultPageIndex;
    private boolean isTitleHorizontal;
    private int startPos;

    public TabPageCell(Form pattern) {
        super(pattern);
        pattern.setOldPattern(true);
        this.tagName = "TabPage";
        this.defaultPageIndex = 0;
        this.isTitleHorizontal = true;
        this.startPos = 0;
    }

    @Override
    public void setData(CellBean model) throws Exception {
        if (model == null) {
            return;
        }
        super.setData(model);
        this.id = model.cellId;
        this.width = model.width;
        this.height = model.height;
        this.assitInfo = model.assitInfo;
        this.cssStyle = "overflow:no;position:absolute;top:" + model.y1 + "px;left:" + model.x1 + "px;";
        Object[] infos = StringTool.strToArray(StringTool.replaceKeyWord(model.assitInfo));
        this.tabPages = new ArrayList();
        if (infos != null) {
            int i = 0;
            while (i < infos.length) {
                String[] tmp = (String[])infos[i];
                if (tmp != null && tmp.length > 0 && tmp.length < 3) {
                    if (tmp.length > 0 && tmp[0].equals("1")) {
                        this.isTitleHorizontal = false;
                    }
                    if (tmp.length > 1 && !tmp[1].equals("")) {
                        this.startPos = Integer.parseInt(tmp[1]);
                    }
                }
                if (tmp != null && tmp.length > 4) {
                    TabPage tabPage = new TabPage();
                    tabPage.setTitle(tmp[2]);
                    String url = tmp[4];
                    tabPage.setUrl(url);
                    tabPage.setEnableScroll(tmp[1].equals("1"));
                    tabPage.setLoadNow(tmp[0].equals("1"));
                    tabPage.setDefault(tmp[3].equals("1"));
                    if (tmp[3].equals("1")) {
                        this.defaultPageIndex = i;
                    }
                    this.tabPages.add(tabPage);
                }
                ++i;
            }
        }
        this.jsName = "TabPage_" + this.id;
    }

    @Override
    public void render(FormInstance form) throws IOException {
        this.renderVisible(form);
        try {
            PrintWriter renderHtml1 = form.getRenderHtml();
            ((Writer)renderHtml1).write(this.outTabContainer());
            ((Writer)renderHtml1).write(this.outScript(form));
            this.renderEvent(form);
            this.renderScriptObject(form);
        }
        catch (Exception e) {
            System.out.println("\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
        }
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        StringBuffer sb = new StringBuffer();
        sb.append("defaultForm.addChild(").append(this.jsName).append(")");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    @Override
    protected void renderVisible(FormInstance form) throws IOException {
        FormCell formCell;
        if (this.id < form.getCell().length && (formCell = form.getCell()[this.id]) != null && !formCell.isVisible()) {
            this.cssStyle = "display:none;" + this.cssStyle;
        }
    }

    public String outTabContainer() {
        String oWidth = String.valueOf(this.width) + "px";
        if (this.widthScale != null && this.widthScale.length() != 0) {
            oWidth = this.widthScale;
        }
        String oHeight = String.valueOf(this.height) + "px";
        if (this.heightScale != null && this.heightScale.length() != 0 && !this.heightScale.equals("0")) {
            oHeight = this.heightScale;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<div id=\"TabPageDiv_" + this.id + "\"\n");
        String aStyle = "width:" + oWidth + "; height:" + oHeight + ";align:left;" + this.cssStyle;
        buffer.append(" style=\"" + aStyle + "\">\n");
        buffer.append("<table cellpadding=0 cellspacing=0 width=100% height=100%>");
        if (this.isTitleHorizontal) {
            buffer.append("<tr style='width:100%;height:25px;' >");
            buffer.append("<td style='width:100%;height:25px;padding:0' >");
            buffer.append("<div id=\"" + this.jsName + "_tabContainer\" style=\"padding-left:30px;width:100%;height:25;\">\n");
            buffer.append("<table style=\"width:25px;height:" + this.startPos + "px;table-layout:fixed;position:absolute;top:0;left:0\"></table>");
            buffer.append("<table border=0 cellspacing=0 style='width:100%;height:25px;table-layout:fixed;position:absolute;top:0;left:" + this.startPos + "' cellpadding=0>\n");
            buffer.append("<TR id=\"" + this.jsName + "_tabList\" class='tab_head' >\n");
        } else {
            buffer.append("<tr style='width:25px;height:100%;' >");
            buffer.append("<td style='width:25px;height:100%;padding:0' >");
            buffer.append("<div id=\"" + this.jsName + "_tabContainer\" style=\"height:25;\">\n");
            buffer.append("<table style=\"width:25px;height:" + this.startPos + "px;table-layout:fixed;position:absolute;top:0;left:0\"></table>");
            buffer.append("<table id=\"" + this.jsName + "_tabList\" border=0 cellspacing=0 style='width:25px;table-layout:fixed;position:absolute;top:" + this.startPos + ";left:0' cellpadding=0>\n");
            buffer.append("<TR class='tab_head' >\n");
        }
        buffer.append("<td >&nbsp;</td></TR>\n");
        buffer.append("</table>\n");
        buffer.append("</div>\n");
        if (this.isTitleHorizontal) {
            buffer.append("</td>");
            buffer.append("</tr>");
            buffer.append("<tr>");
            buffer.append("<td style='padding:0' height=100%>");
        } else {
            buffer.append("</td>");
            buffer.append("<td style='padding:0'>");
        }
        buffer.append("<TABLE");
        String borderStyle = (String)this.classNames.get("border");
        if (!StringTool.isEmpty(borderStyle)) {
            buffer.append(" class=").append(borderStyle);
            buffer.append(" style=\"border-width:");
            buffer.append(this.border).append("px;border-style:solid;\"");
        } else {
            buffer.append(" style=\"border:");
            buffer.append(this.border).append("px");
            buffer.append(" solid ").append(SheetConstants.CELL.LINECOLOR).append("\"");
        }
        buffer.append(" width=\"100%\" height=\"100%\" cellpadding=\"0\" cellspacing=\"0\">\n");
        buffer.append("<TBODY id=\"" + this.jsName + "_workPanel\"></TBODY>\n");
        buffer.append("</TABLE>\n");
        if (this.isTitleHorizontal) {
            buffer.append("</td>");
            buffer.append("</tr>");
            buffer.append("</table>");
        } else {
            buffer.append("</td>");
            buffer.append("</tr>");
            buffer.append("</table>");
        }
        buffer.append("<input type=hidden id='TabCellId' value='TabPageDiv_" + this.id + "'/>");
        buffer.append("</div>");
        return buffer.toString();
    }

    public String outScript(FormInstance form) {
        StringBuffer buffer = new StringBuffer();
        String height1 = this.heightScale != null && !this.heightScale.equals("") ? this.heightScale : String.valueOf(this.height);
        buffer.append("<input type='hidden' id='" + this.jsName + "_HEIGHT' value='" + height1 + "'>\n");
        buffer.append("<script>\n");
        buffer.append("var " + this.jsName + " = new com.sdjxd.pms.platform.form.cell.TabControl({");
        buffer.append("id:").append(this.id);
        buffer.append(",typeName:'TabControl'");
        buffer.append(",showName:\"" + this.cellName + "\"");
        buffer.append(",isTitleHorizontal:").append(this.isTitleHorizontal);
        buffer.append(",tagId:document.getElementById(\"TabPageDiv_").append(this.id).append("\")");
        buffer.append(",divId:").append(this.data.areaId);
        buffer.append(",userDefinfo:").append("'" + StringTool.toJson(this.userDefinfo) + "'");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            buffer.append(",limit:").append(form.getCell()[this.id].getLimit());
        }
        buffer.append(",needSave:false");
        buffer.append(",defaultPageIndex:").append(this.defaultPageIndex);
        buffer.append("});\n");
        buffer.append(String.valueOf(this.jsName) + ".init(document.getElementById(\"TabPageDiv_" + this.id + "\"),document.getElementById(\"" + this.jsName + "_tabContainer\"), document.getElementById(\"" + this.jsName + "_tabList\"), document.getElementById(\"" + this.jsName + "_workPanel\"),\"" + this.jsName + "\");\n");
        buffer.append("setTimeout(function(){");
        int topTab = 0;
        int i = 0;
        while (i < this.tabPages.size()) {
            TabPage tabPage = (TabPage)this.tabPages.get(i);
            String title = tabPage.getTitle();
            String scroll = "auto";
            if (!tabPage.isEnableScroll()) {
                scroll = "no";
            }
            String url = tabPage.getUrl();
            if (tabPage.isDefault()) {
                topTab = i;
                url = tabPage.getUrl();
            }
            url = url.indexOf("?") != -1 ? String.valueOf(url) + "&TABID=" + i : String.valueOf(url) + "?TABID=" + i;
            url = StringTool.replaceKeyWord(url, form);
            buffer.append(String.valueOf(this.jsName) + ".addTab(\"" + title + "\",\"" + Global.getName() + "/pms/platform/image/Tab_header1.gif\",\"" + url + "\",\"" + (tabPage.isLoadNow() ? "1" : "0") + "\",\"" + scroll + "\");\n");
            ++i;
        }
        buffer.append(String.valueOf(this.jsName) + ".setPanelsHidden();\n");
        if (this.tabPages.size() > 0) {
            buffer.append(String.valueOf(this.jsName) + ".setSelectedIndex(" + topTab + ", null, true)");
        }
        this.tabPages.size();
        buffer.append("},100);");
        buffer.append("</script>\n");
        return buffer.toString();
    }

    @Override
    public void addEvent(CellActionBean cellAction) {
        super.addEvent(cellAction);
    }

    @Override
    protected void renderEvent(FormInstance form) {
        super.renderEvent(form);
    }

    public String getCssStyle() {
        return this.cssStyle;
    }

    public void setCssStyle(String cssStyle) {
        this.cssStyle = cssStyle;
    }
}

