/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.CommonCell;
import com.sdjxd.pms.platform.tool.StringTool;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;

public class Spliter
extends CommonCell {
    private static final long serialVersionUID = 1L;
    private Form pattern = null;
    private String splitType = "1";
    private String splitDivI;
    private String splitDivII;

    public Spliter(Form pattern) {
        super(pattern);
        pattern.setOldPattern(true);
        this.tagName = "div";
        this.cellPrefix = SheetConstants.CELL.AREA_PREFIX;
        this.pattern = pattern;
        this.controls = new ArrayList();
    }

    @Override
    public Form getPattern() {
        return this.pattern;
    }

    @Override
    protected void setStyle() {
        this.setPosition(this.data.position);
        this.setTop(this.data.y1);
        this.setLeft(this.data.x1);
        this.setWidth(this.data.width);
        this.setHeight(this.data.height);
        this.setScroll("no");
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        String assitInfo = model.assitInfo;
        if (assitInfo != null && assitInfo.split("@").length > 1) {
            this.splitType = assitInfo.split("@")[0];
            this.splitDivI = assitInfo.split("@")[1];
            this.splitDivII = assitInfo.split("@")[2];
        }
        if (this.splitType.equals("1")) {
            if (model.heightScale != null && model.heightScale.length() != 0 && !model.heightScale.equals("0")) {
                this.style.put("height", model.heightScale);
            } else {
                this.style.put("height", String.valueOf(model.height));
            }
            this.style.put("width", "5px");
            this.style.put("background-image", "url(" + Global.getName() + "/pms/platform/image/Spliter_Horizonal_bk.gif);");
        } else {
            if (model.widthScale != null && model.widthScale.length() != 0 && !model.widthScale.equals("0")) {
                this.style.put("width", model.widthScale);
            } else {
                this.style.put("width", String.valueOf(model.width));
            }
            this.style.put("height", "5px");
            this.style.put("background-image", "url(" + Global.getName() + "/pms/platform/image/Spliter_Vertical_bk.gif);");
        }
        this.attributes.put("top", String.valueOf(this.top) + "px");
        this.attributes.put("left", String.valueOf(this.left) + "px");
    }

    @Override
    public void renderBody(FormInstance form) throws Exception {
        super.renderBody(form);
        PrintWriter renderHtml = form.getRenderHtml();
        ((Writer)renderHtml).write(this.outTable());
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        StringBuffer sb = new StringBuffer();
        sb.append("var Spliter_").append(this.id).append(" = new com.sdjxd.pms.platform.form.cell.Spliter({id:");
        sb.append(this.id);
        sb.append(",typeName:'Spliter'");
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",needSave:false");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append("});");
        sb.append("Spliter_").append(this.id).append(".init('");
        sb.append(this.cellId).append("','");
        sb.append(this.splitDivI).append("','");
        sb.append(this.splitDivII).append("','");
        sb.append(this.splitType).append("');");
        sb.append("defaultForm.addChild(Spliter_").append(this.id).append(")");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    private String outTable() {
        StringBuffer sb = new StringBuffer();
        if (this.splitType.equals("1")) {
            sb.append("\n<table cellspacing=0 cellpadding=0 style='width:100%;background-image: url(" + Global.getName() + "/pms/platform/image/Spliter_Horizonal_bk.gif);'>");
            sb.append("\n<tr height='16'><td onclick='Spliter_" + this.id + ".toLeft();' style='cursor:hand;background-image: url(" + Global.getName() + "/pms/platform/image/Spliter_Horizonal_first.gif);'></td></tr>");
            sb.append("\n<tr height='16'><td onclick='Spliter_" + this.id + ".toRight();' style='cursor:hand;background-image: url(" + Global.getName() + "/pms/platform/image/Spliter_Horizonal_third.gif);'></td></tr>");
        } else {
            sb.append("\n<table cellspacing=0 cellpadding=0 style='height:100%;background-image: url(" + Global.getName() + "/pms/platform/image/Spliter_Vertical_bk.gif);'>");
            sb.append("\n<tr height=6><td width='16' onclick='Spliter_" + this.id + ".toLeft();' style='cursor:hand;background-image: url(" + Global.getName() + "/pms/platform/image/Spliter_Vertical_first.gif);'></td>");
            sb.append("\n<td width='16' onclick='Spliter_" + this.id + ".toRight();' style='cursor:hand;background-image: url(" + Global.getName() + "/pms/platform/image/Spliter_Vertical_third.gif);'></td></tr>");
        }
        sb.append("\n</table>");
        return sb.toString();
    }
}

