/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.CellActionBean;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.Text;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import net.sf.json.JSONArray;

public class Sign
extends Text {
    private static final long serialVersionUID = 1L;
    private boolean signByImg = false;

    public Sign(Form pattern) {
        super(pattern);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        JSONArray jsonArray;
        super.setData(model);
        if (this.data.slaveSignCells != null && this.data.slaveSignCells.length() != 0) {
            this.attributes.put("s", this.data.slaveSignCells);
        }
        this.attributes.put("readonly", SheetConstants.HTML.ATTTRUE);
        if (!StringTool.isEmpty(model.assitInfo) && (jsonArray = JSONArray.fromObject((Object)model.assitInfo)) != null && jsonArray.size() != 0) {
            try {
                this.signByImg = jsonArray.getInt(0) == 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void addEvent(CellActionBean action) {
        if (!this.hasEvent("onclick")) {
            this.addEvent("onclick", "Sign_" + this.id + ".onSign();");
        }
        this.addEvent("onchange", "if(!arguments.callee.caller.caller)");
        super.addEvent(action);
    }

    public String getRoleIds() {
        int lastChar;
        String assistInfo = this.data.assitInfo;
        if (assistInfo == null || assistInfo.length() == 0) {
            return "";
        }
        int firstChar = assistInfo.indexOf("@") + 1;
        if (firstChar > (lastChar = assistInfo.indexOf("&"))) {
            return "";
        }
        return assistInfo.substring(firstChar, lastChar);
    }

    @Override
    protected void renderEnable(FormInstance form) throws IOException {
        if (this.id < form.getCell().length && form.getCell()[this.id] != null && !form.getCell()[this.id].isEnabled()) {
            PrintWriter renderHtml1 = form.getRenderHtml();
            ((Writer)renderHtml1).write(" d=1");
        }
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        StringBuffer sb = new StringBuffer();
        sb.append("var Sign_").append(this.id);
        sb.append(" = new com.sdjxd.pms.platform.form.cell.Sign({id:");
        sb.append(this.id);
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",isPrint:");
        sb.append(this.data.isPrint);
        sb.append(",bgColorStyle:'").append(this.data.bkColorStyle).append("'");
        sb.append(",readOnlyBgColorStyle:'").append(this.data.readBkColorStyle).append("'");
        sb.append(",signByImg:" + this.signByImg);
        sb.append(",showName:\"" + this.cellName + "\"");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        if (this.data.checkCondition != -1) {
            sb.append(",conditionId:" + this.data.checkCondition);
        }
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        sb.append(",needSave:").append(this.isNeedSave());
        sb.append("});\r\n");
        sb.append("defaultForm.addChild(Sign_").append(this.id).append(");");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    @Override
    protected void renderAttribute(FormInstance form) throws Exception {
        User user;
        String value;
        super.renderAttribute(form);
        FormCell[] formCell = form.getCell();
        if (!this.pattern.isHasText() && StringTool.isEmpty(this.textField) && this.id < formCell.length && formCell[this.id] != null && !StringTool.isEmpty(value = formCell[this.id].getValue()) && (user = User.getUser(value)) != null) {
            formCell[this.id].setText(user.getName());
        }
        this.renderValue(form);
        if (this.id < formCell.length && formCell[this.id] != null && 1 == formCell[this.id].getLimit()) {
            PrintWriter renderHtml1 = form.getRenderHtml();
            ((Writer)renderHtml1).write(" unselectable=\"on\" ");
        }
    }

    @Override
    public String getValue(FormCell formCell) {
        return formCell.getValue();
    }

    public static String getSignImgUrl(String userId) throws Exception {
        String url = null;
        PatternDao dao = (PatternDao)BeanFactory.getSingleInstance("PatternDao");
        url = dao.getUserSignImgUrl(userId);
        return url;
    }

    @Override
    protected void setOldPatternAuto(Form pattern) {
    }

    @Override
    public void setDefault(FormInstance form) {
        String defaultValue = this.label;
        defaultValue = StringTool.replaceKeyWord(defaultValue, form);
        if (!StringTool.isEmpty(defaultValue = FormInstance.replaceParaValue(defaultValue, form))) {
            User user = User.getUser(defaultValue);
            form.getCell()[this.id].setValue(defaultValue);
            form.getCell()[this.id].setText(user.getName());
        }
    }
}

