/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.ComboBoxColumnMeanBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.DynamicCell;
import com.sdjxd.pms.platform.tool.StringTool;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;

public class SelectList
extends DynamicCell {
    private static final long serialVersionUID = 1L;
    protected String fieldMeanValue;
    protected int isMulti;

    public SelectList(Form pattern) {
        super(pattern);
        pattern.setOldPattern(true);
        this.tagName = "div";
        this.controls = new ArrayList();
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        this.fieldMeanValue = model.fieldMeanValue;
        this.data = model;
        this.attributes.put("id", this.cellId);
        this.cellBody = this.label;
        Object[] temp = StringTool.strToArray(model.assitInfo);
        if (temp != null && temp.length > 0) {
            try {
                this.isMulti = Integer.parseInt((String)temp[0]);
            }
            catch (NumberFormatException e) {
                this.isMulti = 0;
            }
        } else {
            this.isMulti = 0;
        }
        this.style.remove("position");
        this.style.remove("top");
        this.style.remove("left");
        this.style.remove("width");
        this.style.remove("height");
        this.style.remove("border");
    }

    @Override
    public void render(FormInstance form) throws Exception {
        super.render(form);
        PrintWriter renderHtml = form.getRenderHtml();
        ComboBoxColumnMeanBean bean = new ComboBoxColumnMeanBean(this.meanDataSourceName, this.fieldMeanValue, this.getLimitInfoArray());
        String classStyle = String.valueOf(this.data.bkColorStyle) + " " + this.data.fontStyle + " " + this.data.textColorStyle;
        ArrayList[] result = new ArrayList[2];
        ArrayList text = new ArrayList();
        ArrayList value = new ArrayList();
        result = bean.refresh();
        text = result[0];
        value = result[1];
        ((Writer)renderHtml).write("<select size=3 type=\"select\"");
        if (1 == this.isMulti) {
            ((Writer)renderHtml).write(" multiple");
        }
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            if (form.getCell()[this.id].getLimit() == 1) {
                ((Writer)renderHtml).write(" disabled = true");
            } else if (form.getCell()[this.id].getLimit() == 0) {
                ((Writer)renderHtml).write(" style=\"display:none\" ");
            }
        }
        ((Writer)renderHtml).write(" class=\"" + classStyle + "\"");
        ((Writer)renderHtml).write(" tabindex=\"" + this.tabindex + "\"");
        ((Writer)renderHtml).write(" name=\"cellId" + this.id + "select\"");
        ((Writer)renderHtml).write(" id=\"cellId" + this.id + "select\"");
        ((Writer)renderHtml).write(" style=\"top:" + this.top);
        ((Writer)renderHtml).write("px;left:" + this.left);
        ((Writer)renderHtml).write("px;height:" + this.height);
        ((Writer)renderHtml).write("px;width:" + this.width);
        ((Writer)renderHtml).write("px;position:absolute");
        ((Writer)renderHtml).write(";border-width:" + this.border + "px");
        ((Writer)renderHtml).write(";border-style:solid;");
        if (this.attributes.get("strokecolor") == null) {
            ((Writer)renderHtml).write("border-color:#A5ACB5;");
        } else {
            ((Writer)renderHtml).write("border-color:" + this.attributes.get("strokecolor") + ";");
        }
        ((Writer)renderHtml).write("\">");
        if (text != null) {
            int i = 0;
            while (i < text.size()) {
                ((Writer)renderHtml).write("<option value=\"" + value.toArray()[i] + "\">" + text.toArray()[i] + "</option>");
                ++i;
            }
        }
        ((Writer)renderHtml).write("</select>");
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        StringBuffer sb = new StringBuffer();
        if (this.fieldMeanValue != null && this.fieldMeanValue.length() != 0) {
            ComboBoxColumnMeanBean bean = new ComboBoxColumnMeanBean(this.meanDataSourceName, this.fieldMeanValue, null);
            sb.append("var cmbMean" + this.id);
            sb.append(" = new com.sdjxd.pms.platform.form.cell.ComboBoxColumnMean({");
            if (!"".equals(bean.assistInfo)) {
                sb.append("assistInfo:").append(bean.assistInfo);
            }
            if (!"".equals(bean.dataSourceName)) {
                sb.append(",dataSourceName:\"").append(bean.dataSourceName).append("\"");
            }
            if (bean.fillMode != 0) {
                sb.append(",fillMode:").append(bean.fillMode);
            }
            if (!"".equals(bean.id)) {
                sb.append(",id:\"").append(bean.id).append("\"");
            }
            if (!"".equals(bean.moduleName)) {
                sb.append(",moduleName:\"").append(bean.moduleName).append("\"");
            }
            if (!"".equals(bean.name)) {
                sb.append(",name:\"").append(bean.name).append("\"");
            }
            sb.append("});\r\n");
        }
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.cell.SelectList({id:");
        sb.append(this.id);
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",left:");
        sb.append(this.left);
        sb.append(",top:");
        sb.append(this.top);
        sb.append(",width:");
        sb.append(this.width);
        sb.append(",height:");
        sb.append(this.height);
        sb.append(",isEditable:");
        sb.append(this.isEnabled());
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",needSave:false");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append("}");
        if (this.fieldMeanValue != null && this.fieldMeanValue.length() != 0) {
            sb.append(",cmbMean");
            sb.append(this.id);
        }
        sb.append("));");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }
}

