/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.ComboBoxColumnMeanBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.CommonCell;
import com.sdjxd.pms.platform.form.service.cell.DynamicCell;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.util.ArrayList;
import java.util.TreeMap;

public class Radio
extends DynamicCell {
    private static final long serialVersionUID = 1L;
    private CommonCell htmlRadio;
    protected String fieldMeanValue;
    protected int columnCount;
    protected int nowrap;
    protected int limit;
    protected String borderStyle;

    public Radio(Form pattern) {
        super(pattern);
        pattern.setOldPattern(true);
        this.tagName = "span";
        this.controls = new ArrayList();
        this.htmlRadio = (CommonCell)BeanFactory.getClass("HtmlRadio", new Object[]{pattern});
    }

    @Override
    public void setData(CellBean model) throws Exception {
        block6: {
            super.setData(model);
            this.fieldMeanValue = model.fieldMeanValue;
            Object[] temp = StringTool.strToArray(model.assitInfo);
            if (temp != null && temp.length > 0) {
                try {
                    this.columnCount = Integer.parseInt((String)temp[0]);
                    if (temp.length >= 2) {
                        this.nowrap = ((String)temp[1]).equals("1") ? 1 : 0;
                        break block6;
                    }
                    this.nowrap = 1;
                }
                catch (NumberFormatException e) {
                    this.columnCount = 1;
                }
            } else {
                this.columnCount = 1;
            }
        }
        this.data = model;
        this.limit = model.limit;
        this.borderStyle = model.borderStyle;
        this.attributes.put("id", String.valueOf(this.cellId) + "span");
        this.cellBody = model.fieldMeanValue != null && model.fieldMeanValue.length() != 0 ? "" : this.data.cellName;
        this.htmlRadio.setData(model);
        this.htmlRadio.setParentControls(this);
        TreeMap style = this.htmlRadio.getStyle();
        style.remove("position");
        style.remove("top");
        style.remove("left");
        style.remove("width");
        style.remove("height");
        style.remove("border");
        if (this.fieldMeanValue.length() == 0 && this.data.isNeedSave == 1) {
            this.htmlRadio.attributes.put("onchange", "defaultForm.setModify();");
        }
    }

    @Override
    public String getTextAttribute() {
        return this.htmlRadio.getTextAttribute();
    }

    @Override
    public String getValueAttribute() {
        return this.htmlRadio.getValueAttribute();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.htmlRadio.enabled = enabled;
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        FormCell[] cells;
        String defaultValue;
        StringBuffer sb = new StringBuffer();
        if (this.fieldMeanValue != null && this.fieldMeanValue.length() != 0) {
            ComboBoxColumnMeanBean bean = new ComboBoxColumnMeanBean(this.meanDataSourceName, this.fieldMeanValue, this.getLimitInfoArray());
            sb.append("var cmbMean" + this.id);
            sb.append(" = new com.sdjxd.pms.platform.form.cell.ComboBoxColumnMean({");
            if (!"".equals(bean.assistInfo)) {
                sb.append("assistInfo:").append(bean.assistInfo);
            }
            if (!"".equals(bean.dataSourceName)) {
                sb.append(",dataSourceName:\"").append(bean.dataSourceName).append("\"");
            }
            if (bean.fillMode != 0) {
                sb.append(",fillMode:").append(bean.fillMode);
            }
            if (!"".equals(bean.id)) {
                sb.append(",id:\"").append(bean.id).append("\"");
            }
            if (!"".equals(bean.moduleName)) {
                sb.append(",moduleName:\"").append(bean.moduleName).append("\"");
            }
            if (!"".equals(bean.name)) {
                sb.append(",name:\"").append(bean.name).append("\"");
            }
            sb.append("});\r\n");
        }
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.cell.Radio({id:");
        sb.append(this.id);
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("span\")");
        sb.append(",left:\"");
        sb.append(String.valueOf(this.left) + "px\"");
        sb.append(",top:\"");
        sb.append(String.valueOf(this.top) + "px\"");
        sb.append(",width:\"");
        sb.append(String.valueOf(this.width) + "px\"");
        sb.append(",height:\"");
        sb.append(String.valueOf(this.height) + "px\"");
        sb.append(",nowrap:");
        sb.append(this.nowrap);
        sb.append(",showName:\"" + this.cellName + "\"");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
            defaultValue = form.getCell()[this.id].getText();
        } else {
            defaultValue = this.label != null ? StringTool.replaceKeyWord(this.label) : "";
        }
        sb.append(",label:'").append(defaultValue).append("'");
        sb.append(",bgColorStyle:'").append(this.data.bkColorStyle).append("'");
        sb.append(",readOnlyBgColorStyle:'").append(this.data.readBkColorStyle).append("'");
        sb.append(",textColorStyle:'").append(this.data.textColorStyle).append("'");
        sb.append(",needSave:");
        sb.append(this.isNeedSave());
        sb.append(",columnNum:");
        sb.append(this.columnCount);
        sb.append(",borderStyle:'" + this.borderStyle + "'");
        sb.append(",border:" + this.border);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        sb.append(",divId:").append(this.data.areaId);
        if (this.fieldMeanValue != null && this.fieldMeanValue.length() != 0 && this.id < (cells = form.getCell()).length && cells[this.id] != null) {
            sb.append(",defaultValue:'");
            sb.append(cells[this.id].getValue());
            sb.append("'");
        }
        sb.append("}");
        if (this.fieldMeanValue != null && this.fieldMeanValue.length() != 0) {
            sb.append(",cmbMean");
            sb.append(this.id);
        }
        sb.append("));");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }
}

