/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.CommonCell;
import com.sdjxd.pms.platform.tool.StringTool;

public class Picture
extends CommonCell {
    private static final long serialVersionUID = 1L;

    public Picture(Form pattern) {
        super(pattern);
        this.tagName = "image";
    }

    @Override
    public void setData(CellBean model) throws Exception {
        if (model == null) {
            return;
        }
        super.setData(model);
        this.attributes.put("src", String.valueOf(Global.getName()) + model.assitInfo);
        this.style.put("z-Index", "2");
        if (model.slaveSignCells != null && model.slaveSignCells.equals("1")) {
            this.style.remove("width");
            this.style.remove("height");
        }
    }

    @Override
    protected void renderEvent(FormInstance form) {
        FormCell formCell;
        if (this.id < form.getCell().length && (formCell = form.getCell()[this.id]) != null) {
            StringBuffer sb = new StringBuffer(128);
            int i = 0;
            while (i < MAXEVENT) {
                if (this.events[i] != null) {
                    String sender = "defaultForm.getCellById(" + this.id + ")";
                    sb.append(this.events[i].toString(sender));
                }
                ++i;
            }
            form.addScript("form_obj_cell_" + this.id + "_event", sb.toString());
        }
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        StringBuffer sb = new StringBuffer();
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.cell.Picture({id:");
        sb.append(this.id);
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        sb.append(",needSave:false");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append(",isPrint:");
        sb.append(this.data.isPrint);
        sb.append("}));");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }
}

