/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.cache.Cache;
import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.ListStyleData;
import com.sdjxd.pms.platform.table.model.TableBean;
import com.sdjxd.pms.platform.table.service.Table;
import com.sdjxd.pms.platform.table.service.mean.FieldMean;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.util.List;
import java.util.Map;

public class ListStyleBean
extends BaseClass {
    private static final long serialVersionUID = 1L;
    private static PatternDao dao = (PatternDao)BeanFactory.getSingleInstance("PatternDao");
    private ListStyleData styleData;
    private List columnData;
    private TableBean table;
    private Map listFieldMean;
    private TableBean indexTableBean;
    private String viewSql;

    public String getViewSql() {
        return this.viewSql;
    }

    public void setViewSql(String viewSql) {
        this.viewSql = viewSql;
    }

    public TableBean getIndexTableBean() {
        return this.indexTableBean;
    }

    public void setIndexTableBean(TableBean indexTableBean) {
        this.indexTableBean = indexTableBean;
    }

    public ListStyleData getStyleData() {
        return this.styleData;
    }

    public void setStyleData(ListStyleData styleData) {
        this.styleData = styleData;
    }

    public List getColumnData() {
        return this.columnData;
    }

    public void setColumnData(List columnData) {
        this.columnData = columnData;
    }

    public TableBean getTable() {
        return this.table;
    }

    public void setTable(TableBean table) {
        this.table = table;
    }

    public Map getListFieldMean() {
        return this.listFieldMean;
    }

    public void setListFieldMean(Map listFieldMean) {
        this.listFieldMean = listFieldMean;
    }

    private static ListStyleBean getListStyleBeanById(String styleId) throws Exception {
        ListStyleBean listStyleBean = new ListStyleBean();
        ListStyleData styleData = dao.getListStyle(styleId);
        listStyleBean.setStyleData(styleData);
        if (styleData == null) {
            return null;
        }
        if (styleData.getTableId() == null || "".equals(styleData.getTableId())) {
            List columnData = dao.getListStyleColumn(styleId, 0, "");
            Map listFieldMean = FieldMean.getListFieldMean(styleId);
            listStyleBean.setColumnData(columnData);
            listStyleBean.setListFieldMean(listFieldMean);
        } else {
            TableBean table = Table.getTable(styleData.getTableId());
            listStyleBean.setTable(table);
            int isView = table.getIsView();
            String pkCol = table.getPkCol();
            if (styleData.getLinkViewId() != null && !styleData.getLinkViewId().equals("")) {
                String viewSql = dao.getViewSql(styleData.getLinkViewId(), table.getTableName(), pkCol);
                isView = 1;
                TableBean indexTableBean = Table.getTable(styleData.getLinkViewId());
                listStyleBean.setIndexTableBean(indexTableBean);
                listStyleBean.setViewSql(viewSql);
            }
            List columnData = dao.getListStyleColumn(styleId, isView, styleData.getTableId());
            Map listFieldMean = FieldMean.getListFieldMean(styleId);
            listStyleBean.setColumnData(columnData);
            listStyleBean.setListFieldMean(listFieldMean);
        }
        return listStyleBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListStyleBean getListStyleBean(String styleId) throws Exception {
        ListStyleBean listStyleBean = Cache.getListStyleBeanCache(styleId);
        if (listStyleBean == null) {
            Cache cache = Cache.instance;
            synchronized (cache) {
                listStyleBean = Cache.getListStyleBeanCache(styleId);
                if (listStyleBean == null) {
                    listStyleBean = ListStyleBean.getListStyleBeanById(styleId);
                    Cache.setListStyleBeanCache(styleId, listStyleBean);
                }
            }
        }
        return listStyleBean;
    }
}

