/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.base.Constants;
import com.sdjxd.pms.platform.data.ListMap;
import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.ListStyleColumnData;
import com.sdjxd.pms.platform.form.model.ListStyleData;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.ListStyleBean;
import com.sdjxd.pms.platform.table.model.TableBean;
import com.sdjxd.pms.platform.table.service.mean.FieldMean;
import com.sdjxd.pms.platform.table.service.mean.IFieldMean;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ListStyle {
    private static Logger log = Logger.getLogger(ListStyle.class);
    private static PatternDao dao = (PatternDao)BeanFactory.getSingleInstance("PatternDao");
    private String styleId;
    private List columnData;
    private List means;
    private String tableId;
    private String tableName;
    private String dataSourceName;
    private String dataUserName;
    private int pageIndex = 1;
    private int rowsCount = -1;
    private int pageCount = -1;
    private int currentRowCount = -1;
    private ListMap order = new ListMap();
    private String query;
    private String initQuery;
    private String finalQuery;
    private String userDefinfo;
    private int pageDataSize;
    private boolean isAutoHeight;
    private boolean allowPage;
    private boolean loadData;
    private boolean headerSort;
    private List data;
    private String sql;
    private List dataDb;
    private String pkCol;
    private int isView;
    private String viewName;

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public boolean getIsAutoHeight() {
        return this.isAutoHeight;
    }

    public void setIsAutoHeight(boolean isAutoHeight) {
        this.isAutoHeight = isAutoHeight;
    }

    public ListStyle() {
    }

    public static ListStyle getInstance(String styleId) throws Exception {
        if (StringTool.isEmpty(styleId)) {
            return null;
        }
        ListStyleBean listStyleBean = ListStyleBean.getListStyleBean(styleId);
        ListStyleData styleData = listStyleBean.getStyleData();
        if (styleData == null) {
            return null;
        }
        if (styleData.getTableId() == null || "".equals(styleData.getTableId())) {
            return new ListStyle(listStyleBean, true);
        }
        return new ListStyle(listStyleBean);
    }

    public static ListStyleData getData(String styleId) throws Exception {
        return dao.getListStyle(styleId);
    }

    private ListStyle(ListStyleBean listStyleBean, boolean noTableId) throws Exception {
        this();
        ListStyleData styleData = listStyleBean.getStyleData();
        this.styleId = styleData.getStyleId();
        this.pkCol = "SHEETID";
        this.addOrderField(this.getPkCol(), "ASC");
        this.tableId = "";
        this.tableName = "(" + styleData.getFilterSql() + ") SQLTAB";
        this.headerSort = styleData.isHeaderSort();
        this.query = null;
        this.finalQuery = null;
        this.pageDataSize = styleData.getPageDataSize();
        this.allowPage = styleData.getAllowPage();
        this.loadData = styleData.isLoadData();
        this.isAutoHeight = styleData.getIsAutoHeight();
        this.columnData = listStyleBean.getColumnData();
        Map listFieldMean = listStyleBean.getListFieldMean();
        int cols = this.columnData.size();
        this.means = new ArrayList(cols);
        String meanId = "";
        int i = 0;
        while (i < cols) {
            ListStyleColumnData column = (ListStyleColumnData)this.columnData.get(i);
            meanId = column.getMeanId();
            if (meanId != null && meanId.length() != 0) {
                this.means.add(listFieldMean.get(meanId));
            } else {
                this.means.add(new FieldMean());
            }
            ++i;
        }
        Object[] orderList = styleData.getOrderField();
        if (orderList != null) {
            int orderSize = orderList.length;
            int i2 = orderSize - 1;
            while (i2 >= 0) {
                Object dataItem = orderList[i2];
                if (dataItem instanceof String[]) {
                    String[] theOrder = (String[])dataItem;
                    this.addOrderField(theOrder[0], theOrder[1]);
                }
                --i2;
            }
        }
    }

    private ListStyle(ListStyleBean listStyleBean) throws Exception {
        this();
        ListStyleData styleData = listStyleBean.getStyleData();
        this.styleId = styleData.getStyleId();
        TableBean table = listStyleBean.getTable();
        this.pkCol = table.getPkCol();
        this.tableId = table.getTableId();
        this.tableName = table.getTableName();
        this.dataSourceName = table.getDataSourceName();
        this.dataUserName = table.getDataUserName();
        this.addOrderField(this.getPkCol(), "ASC");
        this.headerSort = styleData.isHeaderSort();
        this.query = null;
        this.initQuery = styleData.getFilterSql();
        this.finalQuery = null;
        this.isView = table.getIsView();
        if (styleData.getLinkViewId() != null && !styleData.getLinkViewId().equals("")) {
            this.tableName = "(";
            this.tableName = String.valueOf(this.tableName) + listStyleBean.getViewSql();
            this.tableName = String.valueOf(this.tableName) + ") T ";
            this.isView = 1;
            TableBean indexTableBean = listStyleBean.getIndexTableBean();
            this.viewName = indexTableBean.getTableName();
        }
        this.pageDataSize = styleData.getPageDataSize();
        this.allowPage = styleData.getAllowPage();
        this.loadData = styleData.isLoadData();
        this.isAutoHeight = styleData.getIsAutoHeight();
        this.columnData = listStyleBean.getColumnData();
        Map listFieldMean = listStyleBean.getListFieldMean();
        int cols = this.columnData.size();
        this.means = new ArrayList(cols);
        String meanId = "";
        int i = 0;
        while (i < cols) {
            ListStyleColumnData column = (ListStyleColumnData)this.columnData.get(i);
            meanId = column.getMeanId();
            if (meanId != null && meanId.length() != 0) {
                this.means.add(listFieldMean.get(meanId));
            } else {
                this.means.add(new FieldMean());
            }
            ++i;
        }
        Object[] orderList = styleData.getOrderField();
        if (orderList != null) {
            int orderSize = orderList.length;
            int i2 = orderSize - 1;
            while (i2 >= 0) {
                Object dataItem = orderList[i2];
                if (dataItem instanceof String[]) {
                    String[] theOrder = (String[])dataItem;
                    this.addOrderField(theOrder[0], theOrder[1]);
                }
                --i2;
            }
        }
    }

    public int getIsView() {
        return this.isView;
    }

    public void addFilterSql(String sql2) {
        if (StringTool.isEmpty(sql2) || sql2.trim().length() == 0) {
            return;
        }
        this.finalQuery = null;
        String filterSql = sql2;
        StringBuffer sb = new StringBuffer(128);
        if (StringTool.isEmpty(this.query)) {
            sb.append(filterSql);
        } else {
            sb.append("(").append(this.query).append(") AND (").append(filterSql).append(")");
        }
        this.query = sb.toString();
    }

    public void addOrderField(String fieldName, String orderType) {
        if (fieldName != null && fieldName.length() != 0) {
            if (orderType == null || orderType.length() == 0) {
                this.order.add(0, fieldName, "ASC");
            } else {
                this.order.add(0, fieldName, orderType);
            }
        }
    }

    public String getOrderField() {
        StringBuffer sb = new StringBuffer(64);
        int orderSize = this.order.size();
        int i = 0;
        while (i < orderSize) {
            String key = (String)this.order.getKey(i);
            sb.append(",");
            sb.append(key);
            sb.append(" ");
            sb.append((String)this.order.getValue(i));
            ++i;
        }
        if (orderSize > 0) {
            return sb.substring(1);
        }
        return this.pkCol;
    }

    public ListMap getOrder() {
        return this.order;
    }

    public int getPageDataSize() {
        return this.pageDataSize;
    }

    public int getRowsCount() {
        return this.rowsCount;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex < 1 ? 1 : pageIndex;
    }

    private void setRowsCount(int rowsCount) {
        this.rowsCount = rowsCount;
        int dataSize = this.getPageDataSize();
        if (this.allowPage && dataSize > 0) {
            this.pageCount = this.rowsCount / dataSize;
            if (this.rowsCount % dataSize > 0) {
                ++this.pageCount;
            }
            if (this.pageCount <= 0) {
                if (this.rowsCount == 0) {
                    this.pageCount = 0;
                    this.pageIndex = 1;
                } else {
                    this.pageCount = 1;
                    this.pageIndex = 1;
                }
            }
        } else {
            this.pageCount = 1;
        }
    }

    public int getPageCount() {
        if (this.rowsCount < 0) {
            log.error((Object)"\u5fc5\u987b\u5148\u8c03\u7528getData()");
        }
        return this.pageCount;
    }

    public int getCurrentRowCount() {
        return this.currentRowCount;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public String getPkCol() {
        return this.pkCol;
    }

    public String getQuery() {
        return this.getQuery(null);
    }

    public String getQuery(FormInstance formInstance) {
        if (this.finalQuery == null || "null".equals(this.finalQuery)) {
            this.finalQuery = this.initQuery == null || this.initQuery.length() == 0 || "null".equals(this.initQuery) ? (this.query == null || this.query.length() == 0 || "null".equals(this.query) ? "1=1" : this.query) : (this.query == null || this.query.length() == 0 ? this.initQuery : "(" + this.initQuery + ") AND (" + this.query + ")");
            this.finalQuery = this.finalQuery.replaceAll("\\[cell.userDefinfo\\]", this.userDefinfo);
            this.finalQuery = StringTool.replace(this.finalQuery, "='" + Constants.resources_blankRootNodeId + "'", " is null");
            if (formInstance != null) {
                this.finalQuery = FormInstance.replaceParaValue(this.finalQuery, formInstance);
            }
            this.finalQuery = StringTool.replaceKeyWord(this.finalQuery, formInstance);
        }
        return this.finalQuery;
    }

    public String getQuery(FormInstance formInstance, Map param) {
        if (this.finalQuery == null || "null".equals(this.finalQuery)) {
            this.finalQuery = this.initQuery == null || this.initQuery.length() == 0 || "null".equals(this.initQuery) ? (this.query == null || this.query.length() == 0 || "null".equals(this.query) ? "1=1" : this.query) : (this.query == null || this.query.length() == 0 ? this.initQuery : "(" + this.initQuery + ") AND (" + this.query + ")");
            this.finalQuery = this.finalQuery.replaceAll("\\[cell.userDefinfo\\]", this.userDefinfo);
            this.finalQuery = StringTool.replace(this.finalQuery, "='" + Constants.resources_blankRootNodeId + "'", " is null");
            if (formInstance != null) {
                this.finalQuery = FormInstance.replaceParaValue(this.finalQuery, formInstance);
            }
            this.finalQuery = ListStyle.replaceUrl(this.finalQuery, param);
            this.finalQuery = StringTool.replaceKeyWord(this.finalQuery, formInstance);
        }
        return this.finalQuery;
    }

    private static String replaceUrl(String sstr, Map param) {
        if (sstr == null || sstr.length() == 0) {
            return sstr;
        }
        String ostr = sstr;
        String regex = "\\[(\\w+)\\.([^\\]]*)\\]";
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(ostr);
        String matchValue = "";
        HashMap<String, String> replacement = new HashMap<String, String>();
        while (m.find()) {
            String matchStr = m.group();
            String matchName = m.group(1);
            String matchArg = m.group(2);
            matchValue = matchStr;
            if (replacement.containsKey(matchStr) || !matchName.equals("url") || param == null) continue;
            matchValue = (String)param.get(matchArg);
            replacement.put(matchStr, matchValue);
        }
        for (Map.Entry entry : replacement.entrySet()) {
            String oldStr = (String)entry.getKey();
            String newStr = (String)entry.getValue();
            ostr = ostr.replace(oldStr, newStr);
        }
        return ostr;
    }

    public String getTableNoTableId(FormInstance formInstance) {
        if ("".equals(this.tableId)) {
            this.tableName = this.tableName.replaceAll("\\[cell.userDefinfo\\]", this.userDefinfo);
            this.tableName = StringTool.replace(this.tableName, "='" + Constants.resources_blankRootNodeId + "'", " is null");
            if (formInstance != null) {
                this.tableName = FormInstance.replaceParaValue(this.tableName, formInstance);
            }
            this.tableName = StringTool.replaceKeyWord(this.tableName, formInstance);
        }
        return this.tableName;
    }

    public List getData(FormInstance formInstance) throws Exception {
        this.getQuery(formInstance);
        this.getTableNoTableId(formInstance);
        this.setRowsCount(dao.getDataCount(this));
        if (this.pageIndex > this.pageCount) {
            this.pageIndex = 1;
        }
        this.data = this.allowPage || this.pageDataSize > 0 ? dao.getPageListData(this) : dao.getAllListData(this);
        this.dataDb = this.getDbData();
        int cols = this.columnData.size();
        int rows = this.data.size();
        int c = 0;
        while (c < cols) {
            String colName = ((ListStyleColumnData)this.columnData.get(c)).getAsName();
            IFieldMean mean = (IFieldMean)this.means.get(c);
            if (mean != null) {
                mean.setCacheIdValue(true);
                int r = 0;
                while (r < rows) {
                    Map dataRow = (Map)this.data.get(r);
                    if (colName != null && colName.length() != 0) {
                        String value = (String)dataRow.get(colName);
                        dataRow.put(colName, mean.getText(value));
                    }
                    ++r;
                }
            }
            ++c;
        }
        this.currentRowCount = this.pageIndex == this.pageCount ? (this.pageCount == 0 ? 0 : (this.allowPage || this.pageDataSize > 0 ? this.rowsCount % this.getPageDataSize() : this.rowsCount)) : this.getPageDataSize();
        return this.data;
    }

    public IFieldMean getMean(int index) {
        return (IFieldMean)this.means.get(index);
    }

    public List getData() throws Exception {
        FormInstance formInstance = null;
        return this.getData(formInstance);
    }

    public List emptyData() {
        this.setRowsCount(0);
        this.data = new ArrayList();
        this.dataDb = new ArrayList();
        this.currentRowCount = 0;
        return this.data;
    }

    public String getField() {
        if (this.columnData == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(128);
        int len = this.columnData.size();
        boolean hasPk = false;
        ListStyleColumnData column = null;
        int i = 0;
        while (i < len) {
            column = (ListStyleColumnData)this.columnData.get(i);
            if (2 != column.getColumnType()) {
                String columnId = column.getColumnId();
                if ((columnId = StringTool.replaceKeyWord(columnId)) != null && columnId.length() != 0) {
                    hasPk = hasPk || columnId.equals(this.pkCol);
                    sb.append(",").append(columnId);
                }
            }
            ++i;
        }
        if (this.pkCol != null && this.pkCol.length() != 0 && !hasPk) {
            sb.append(",").append(this.pkCol);
        }
        return sb.substring(1);
    }

    public List getColumnData() {
        return this.columnData;
    }

    public boolean isHeaderSort() {
        return this.headerSort;
    }

    public void setPageDataSize(int pageDataSize) {
        this.pageDataSize = pageDataSize;
    }

    private List getDbData() {
        ArrayList dbDataList = new ArrayList();
        int i = 0;
        while (i < this.data.size()) {
            TreeMap<String, String> dbData = new TreeMap<String, String>();
            Map dataTemp = (Map)this.data.get(i);
            for (Map.Entry entry : dataTemp.entrySet()) {
                String field = (String)entry.getKey();
                String fieldValue = (String)entry.getValue();
                dbData.put(field, fieldValue);
            }
            dbData.put("*", "*");
            dbDataList.add(dbData);
            ++i;
        }
        return dbDataList;
    }

    public String toJson() {
        StringBuffer sb = new StringBuffer(128);
        Class<?> classType = null;
        ListStyle obj = this;
        Class<?> parentType = obj.getClass();
        sb.insert(0, "{");
        while (parentType != null && !parentType.equals(classType)) {
            Field[] field = parentType.getDeclaredFields();
            int index = 0;
            while (index < field.length) {
                if (!Modifier.isStatic(field[index].getModifiers())) {
                    String fieldName = field[index].getName();
                    sb.append(BeanTool.toJson(fieldName));
                    sb.append(":");
                    Object fieldValue = null;
                    if ("query".equals(fieldName)) {
                        fieldValue = "";
                    } else {
                        try {
                            field[index].setAccessible(true);
                            fieldValue = field[index].get(obj);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    sb.append(BeanTool.toJson(fieldValue));
                    sb.append(",");
                }
                ++index;
            }
            classType = parentType;
            parentType = classType.getSuperclass();
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean isAllowPage() {
        return this.allowPage;
    }

    public boolean isLoadData() {
        return this.loadData;
    }

    public void setAllowPage(boolean allowPage) {
        this.allowPage = allowPage;
    }

    public void setQuery(String query) {
        this.finalQuery = null;
        this.query = query;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDataUserName() {
        return this.dataUserName == null ? "" : this.dataUserName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getUserDefinfo() {
        return this.userDefinfo;
    }

    public void setUserDefinfo(String userDefinfo) {
        this.userDefinfo = userDefinfo;
    }

    public String getSQLData() throws Exception {
        return this.getSQLData(null);
    }

    public String getSQLData(FormInstance formInstance) throws Exception {
        if (formInstance != null) {
            this.getQuery(formInstance);
            this.getTableNoTableId(formInstance);
        }
        this.sql = dao.getAllSQLData(this);
        return this.sql;
    }

    public String getSQLData(FormInstance formInstance, Map param) throws Exception {
        if (formInstance != null) {
            this.getQuery(formInstance);
            this.getTableNoTableId(formInstance);
        }
        this.sql = dao.getAllSQLData(this, param);
        return this.sql;
    }

    public HashMap<String, String> handleDataOfEveryLine(HashMap<String, String> map) throws Exception {
        int cols = this.columnData.size();
        HashMap<String, String> newMap = new HashMap<String, String>(map.size());
        int c = 0;
        while (c < cols) {
            String colName = ((ListStyleColumnData)this.columnData.get(c)).getAsName();
            IFieldMean mean = (IFieldMean)this.means.get(c);
            if (map.containsKey(colName)) {
                String colVal = map.get(colName);
                if (mean != null) {
                    mean.setCacheIdValue(true);
                    newMap.put(colName, mean.getText(colVal));
                } else {
                    newMap.put(colName, colVal);
                }
            }
            ++c;
        }
        return newMap;
    }
}

