/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.GlobalSql;
import com.sdjxd.hussar.core.permit72.service.support.PermitCtrl;
import com.sdjxd.pms.platform.Limit.service.Limit;
import com.sdjxd.pms.platform.base.Context;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.data.ListMap;
import com.sdjxd.pms.platform.form.dao.DataConst;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.EditGridData;
import com.sdjxd.pms.platform.form.model.ListStyleColumnData;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.cell.CommonCell;
import com.sdjxd.pms.platform.form.service.cell.Dom;
import com.sdjxd.pms.platform.form.service.cell.ListStyle;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.CheckClient;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.StringTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ListCell
extends CommonCell {
    private static Logger log = Logger.getLogger(ListCell.class);
    private static final long serialVersionUID = 1L;
    private String styleId;
    private String mainCss = "mainCss";
    private String headCss = "headCss";
    private String rowCss = "rowCss";
    private String alterCss = "JTrowCss";
    private String pagerCss = "pageCss";
    private int scrollBarType;

    public ListCell(Form pattern) {
        super(pattern);
        pattern.setOldPattern(true);
        this.tagName = "div";
    }

    @Override
    public void setData(CellBean model) throws Exception {
        String[] assitInfo;
        if (model == null) {
            return;
        }
        super.setData(model);
        this.id = this.data.cellId;
        this.setCellId(String.valueOf(this.cellPrefix) + this.id);
        this.setStyle();
        this.setClassName();
        if (this.data.createDate != null && this.data.createDate.length() != 0) {
            this.modifyTime = DateTool.parseDate(this.data.createDate);
        }
        if ((assitInfo = (String[])StringTool.strToArray(model.assitInfo)) != null) {
            int len = assitInfo.length;
            this.styleId = len > 0 ? assitInfo[0] : "DCFFE842-2D04-4E5F-A477-361E854D63CD";
            if (len > 1) {
                this.mainCss = assitInfo[1];
                if (this.mainCss != null && this.mainCss.toLowerCase().endsWith(" td")) {
                    this.mainCss = this.mainCss.substring(this.mainCss.length() - 3);
                }
            }
            if (len > 2) {
                this.headCss = assitInfo[2];
                if (this.headCss != null && !this.headCss.toLowerCase().endsWith(" td")) {
                    this.headCss = String.valueOf(this.headCss) + " td";
                }
            }
            if (len > 3) {
                this.rowCss = assitInfo[3];
                if (this.rowCss != null && !this.rowCss.toLowerCase().endsWith(" td")) {
                    this.rowCss = String.valueOf(this.rowCss) + " td";
                }
            }
            if (len > 4) {
                this.alterCss = assitInfo[4];
                if (this.alterCss != null && !this.alterCss.toLowerCase().endsWith(" td")) {
                    this.alterCss = String.valueOf(this.alterCss) + " td";
                }
            }
            if (len > 5) {
                this.pagerCss = assitInfo[5];
                if (this.pagerCss != null && !this.pagerCss.toLowerCase().endsWith(" td")) {
                    this.pagerCss = String.valueOf(this.pagerCss) + " td";
                }
            }
            if (len > 6) {
                this.scrollBarType = Integer.parseInt(assitInfo[6]);
            }
        }
    }

    @Override
    public void render(FormInstance formInstance) throws Exception {
        ListStyle listStyle;
        Context context = Global.getContext();
        String listStyleID = context.getParameter("listStyleID");
        if (StringTool.isEmpty(listStyleID)) {
            listStyleID = this.styleId;
        }
        if ((listStyle = ListCell.initListStyle(formInstance, this, listStyleID, null, null, 1, false, -1)) != null) {
            if (listStyle.isLoadData()) {
                listStyle.getData(formInstance);
            } else {
                listStyle.emptyData();
            }
            EditGridData editGridData = new EditGridData(this, formInstance);
            Object[] jsonLimit = StringTool.strToArray(this.getLimitInfo());
            ArrayList<String> limitOfFields = new ArrayList<String>();
            if (jsonLimit != null) {
                int i = 0;
                while (i < jsonLimit.length) {
                    String oneLimitId = (String)jsonLimit[i];
                    String limitSql = Limit.getLimitSql(oneLimitId, null);
                    if (limitSql == null) {
                        limitOfFields.add(oneLimitId);
                    }
                    ++i;
                }
            }
            List fieldsInLimit = null;
            if (limitOfFields.size() > 0) {
                String[] temp = new String[limitOfFields.size()];
                limitOfFields.toArray(temp);
                fieldsInLimit = Limit.getLimitData(temp, null);
            }
            editGridData.setFieldMeansDB(listStyle.getStyleId(), listStyle.getColumnData());
            this.listContent(listStyle, formInstance);
            this.renderScriptObject(listStyle, editGridData, fieldsInLimit, formInstance);
        } else {
            log.warn((Object)("\u5217\u8868\u663e\u793a\u65b9\u6848\u83b7\u53d6\u4e3a\u7a7a\uff1a" + listStyleID));
            this.listContent(null, formInstance);
            this.renderScriptObject(null, null, null, formInstance);
        }
    }

    protected void renderScriptObject(ListStyle h_listStyle, EditGridData h_editGridData, List fieldsInLimit, FormInstance h_form) {
        HashMap keys;
        boolean readOnly = false;
        FormCell formCell = h_form.getCell() != null && this.id < h_form.getCell().length && h_form.getCell()[this.id] != null ? h_form.getCell()[this.id] : new FormCell(this.id);
        if (!formCell.isEnabled()) {
            readOnly = true;
        }
        StringBuffer result = new StringBuffer(1024);
        String strClassName = "com.sdjxd.pms.platform.form.cell.EditGrid";
        result.append("var " + this.cellId + " = new " + strClassName + "({id:" + this.id + ",");
        result.append("needSave:").append(this.isNeedSave());
        if (h_form.getCell() != null && this.id < h_form.getCell().length && h_form.getCell()[this.id] != null) {
            result.append(",limit:");
            result.append(h_form.getCell()[this.id].getLimit());
        }
        result.append(",divId:").append(this.data.areaId);
        result.append(",isAutoHeight:").append(h_listStyle.getIsAutoHeight());
        result.append(",isAllowPage:").append(h_listStyle.isAllowPage());
        result.append(",tagId:");
        result.append("document.getElementById(\"" + this.cellId).append("_divAll\")");
        result.append(",userDefinfo:");
        result.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        result.append(",cellReadOnlyCss:\"").append(this.data.readBkColorStyle).append("\"");
        result.append("});\n");
        result.append(this.cellId).append(".setReadOnly(").append(readOnly).append(");\n");
        result.append("defaultForm.addChild(").append(this.cellId).append(");\n");
        result.append(this.getEventScript(h_form));
        result.append(this.cellId).append(".initCell('" + this.cellId + "');\n");
        ListMap config = new ListMap();
        config.put("cellName", this.data.cellName);
        config.put("mainCss", this.mainCss);
        config.put("headCss", this.headCss);
        config.put("rowCss", this.rowCss);
        config.put("alterCss", this.alterCss);
        config.put("pagerCss", this.pagerCss);
        config.put("listStyle", h_listStyle);
        result.append(this.cellId).append(".applyConfig(").append(config.toJson()).append(");\n");
        if (h_editGridData != null) {
            result.append(this.cellId).append(".setEditGridData(").append(h_editGridData.toJsonString()).append(");\n");
        }
        result.append(this.cellId).append(".show();\n");
        if (h_listStyle != null && formCell.isVisible() && formCell.isEnabled() && (keys = formCell.getKeys()) != null) {
            Iterator it = keys.entrySet().iterator();
            ArrayList<String> columnList = new ArrayList<String>();
            String currentStyleId = h_listStyle.getStyleId();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String[] info = (String[])entry.getKey();
                if (info == null || info.length <= 2) continue;
                int columnLimit = Integer.parseInt((String)entry.getValue());
                String columnOfStyleId = info[2];
                String columnId = info[3];
                if (columnLimit != 1 || columnOfStyleId != null && !columnOfStyleId.equals(currentStyleId)) continue;
                columnList.add(columnId);
            }
            if (columnList.size() > 0) {
                result.append(this.cellId).append(".setReadOnlyColByField(").append(BeanTool.toJson(columnList)).append(");\n");
            }
        }
        if (fieldsInLimit != null && fieldsInLimit.size() > 0) {
            ArrayList<String> fieldsArray = new ArrayList<String>();
            int i = 0;
            while (i < fieldsInLimit.size()) {
                String fields = (String)fieldsInLimit.get(i);
                Object[] temp2 = StringTool.strToArray(fields);
                int j = 0;
                while (j < temp2.length) {
                    String[] temp3 = (String[])temp2[j];
                    int k = 1;
                    while (k < temp3.length) {
                        fieldsArray.add(temp3[k]);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            result.append(this.cellId).append(".setReadOnlyColByField(").append(BeanTool.toJson(fieldsArray)).append(");\n");
        }
        if (h_listStyle != null) {
            List list = h_listStyle.getColumnData();
            int cols = list.size();
            int i = 0;
            while (i < cols) {
                ListStyleColumnData column = (ListStyleColumnData)list.get(i);
                int columnType = column.getColumnType();
                if (columnType == 9) {
                    result.append(this.cellId).append(".setReadOnlyColByField([").append(BeanTool.toJson(column.getAsName())).append("]);\n");
                }
                ++i;
            }
        }
        h_form.addScript("form_obj_cell_" + this.id, result.toString());
    }

    @Override
    protected String getEventScript(FormInstance form) {
        FormCell formCell;
        if (this.id < form.getCell().length && (formCell = form.getCell()[this.id]) != null) {
            StringBuffer sb = new StringBuffer(128);
            int i = 0;
            while (i < MAXEVENT) {
                if (this.events[i] != null) {
                    String sender = "defaultForm.getCellById(" + this.id + ")";
                    sb.append(this.events[i].toString(sender));
                }
                ++i;
            }
            return sb.toString();
        }
        return "";
    }

    public void listContent(ListStyle style, FormInstance form) {
        Dom all = new Dom("div");
        all.addCet(this.getClass());
        Dom headDiv = new Dom("div");
        headDiv.addCet(this.getClass());
        all.appendChild(headDiv);
        Dom headTr = new Dom("tr");
        headTr.addCet(this.getClass());
        Dom headTable = new Dom("table");
        headTable.addCet(this.getClass());
        headTable.appendChild(headTr);
        headDiv.appendChild(headTable);
        Dom dataDiv = new Dom("div");
        dataDiv.addCet(this.getClass());
        all.appendChild(dataDiv);
        Dom dataTable = new Dom("table");
        dataTable.addCet(this.getClass());
        dataDiv.appendChild(dataTable);
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null && form.getCell()[this.id].getLimit() == 0) {
            all.addStyle("display", "none");
        }
        all.add("id", String.valueOf(this.cellId) + "_divAll");
        String oHeight = this.heightScale != null && this.heightScale.length() != 0 ? this.heightScale : String.valueOf(this.height - 2) + "px";
        all.addStyle("height", oHeight);
        String oWidth = this.widthScale != null ? this.widthScale : String.valueOf(this.width) + "px";
        all.addStyle("width", oWidth);
        all.addStyle("border-style", "none");
        all.addStyle("position", this.getChildPosition());
        if (this.position.equals(DataConst.CELL.POSITION.ABSOLUTE)) {
            all.addStyle("top", String.valueOf(this.top) + "px");
            all.addStyle("left", String.valueOf(this.left) + "px");
        }
        all.addClass("", this.mainCss);
        headDiv.add("id", String.valueOf(this.cellId) + "_divHead");
        headDiv.add("align", "center");
        headDiv.addStyle("position", "absolute");
        headDiv.addStyle("z-index", "1");
        headDiv.addStyle("left", "1px");
        headDiv.addStyle("top", "1px");
        headDiv.addStyle("border-style", "none");
        oWidth = this.widthScale != null ? this.widthScale : String.valueOf(this.width - 2) + "px";
        headDiv.addStyle("width", oWidth);
        headDiv.addStyle("overflow", "hidden");
        headDiv.addClass("", this.mainCss);
        headTable.add("id", String.valueOf(this.cellId) + "_divHead_table");
        headTable.addStyle("width", "100%");
        headTable.addStyle("border-style", "none");
        headTable.addClass("", this.mainCss);
        if (this.headCss.indexOf("nohead") >= 0) {
            headDiv.addStyle("display", "none");
            headTr.addStyle("height", "24px");
        }
        headTr.addClass("", this.headCss);
        headTr.setCellBody("<td></td>");
        dataDiv.setId(String.valueOf(this.cellId) + "_divData");
        if (this.scrollBarType == 0) {
            dataDiv.addStyle("overflow", "auto");
        } else if (this.scrollBarType == 1) {
            dataDiv.addStyle("overflow", "no");
        } else if (this.scrollBarType == 2) {
            dataDiv.addStyle("overflow-x", "auto");
            dataDiv.addStyle("overflow-y", "no");
        } else if (this.scrollBarType == 3) {
            dataDiv.addStyle("overflow-x", "no");
            dataDiv.addStyle("overflow-y", "auto");
        }
        dataDiv.setWidth("100%");
        oHeight = this.heightScale != null && this.heightScale.length() != 0 ? this.heightScale : String.valueOf(this.height - 2) + "px";
        int height = 0;
        if (this.heightScale == null || this.heightScale.length() == 0) {
            height = this.height;
            if (!this.pagerCss.equals("nopage") && style != null && style.isAllowPage()) {
                height = this.height - 20;
            }
            dataDiv.setHeight(String.valueOf(height) + "px");
        } else {
            dataDiv.setHeight(this.heightScale);
        }
        dataDiv.add("align", "center");
        dataDiv.on("scroll", String.valueOf(this.cellId) + ".doScroll()");
        dataDiv.addClass("", this.mainCss);
        dataTable.setId(String.valueOf(this.cellId) + "_divData_table");
        dataTable.addStyle("border-style", "none");
        dataTable.setWidth("100%");
        dataTable.addClass("", this.mainCss);
        Dom EditContent = new Dom("div");
        EditContent.setId(String.valueOf(this.cellId) + "_divData_table_EditContent");
        EditContent.addStyle("z-Index", "100");
        EditContent.addStyle("display", "none");
        EditContent.addStyle("position", "absolute");
        EditContent.addStyle("text-align", "right");
        EditContent.add("h_author", "editList");
        dataDiv.appendChild(EditContent);
        Dom dataTr = new Dom("tr");
        dataTable.appendChild(dataTr);
        if (this.headCss.indexOf("nohead") >= 0) {
            dataTr.addStyle("height", "0px");
        }
        dataTr.addClass("", this.headCss);
        dataTr.setCellBody("<td></td>");
        dataTr.setWidth("100%");
        dataTable.setWidth("100%");
        if (!this.pagerCss.equals("nopage") && style != null && style.isAllowPage()) {
            all.appendChild(this.listPager());
        }
        StringBuffer buffer = new StringBuffer(512);
        all.render(buffer);
        form.getRenderHtml().write(buffer.toString());
    }

    public Dom listPager() {
        Dom div = new Dom("div");
        div.setId(String.valueOf(this.cellId) + "_divFooter");
        div.setPosition("absolute");
        div.addStyle("overflow", "hidden");
        div.setWidth("100%");
        Dom table = new Dom("table");
        div.appendChild(table);
        table.setWidth("100%");
        table.add("cellPadding", "0");
        table.add("CELLSPACING", "0");
        table.add("border", "0");
        table.setId(String.valueOf(this.cellId) + "_divFooter_table");
        table.addClass("", this.pagerCss);
        Dom tr = new Dom("tr");
        table.appendChild(tr);
        Dom td = new Dom("td");
        td.add("nowrap", "true");
        tr.appendChild(td);
        td.setWidth("180px");
        Dom span = new Dom("span");
        td.appendChild(span);
        span.setId(String.valueOf(this.cellId) + "first");
        span.addStyle("text-decoration", "underline");
        span.setCellBody(Global.getMessage("form.cell.list.page.home", new Object[0]));
        span = new Dom("span");
        td.appendChild(span);
        span.setId(String.valueOf(this.cellId) + "forward");
        span.addStyle("text-decoration", "underline");
        span.setCellBody(Global.getMessage("form.cell.list.page.previous", new Object[0]));
        span = new Dom("span");
        td.appendChild(span);
        span.setId(String.valueOf(this.cellId) + "next");
        span.addStyle("text-decoration", "underline");
        span.setCellBody(Global.getMessage("form.cell.list.page.next", new Object[0]));
        span = new Dom("span");
        td.appendChild(span);
        span.setId(String.valueOf(this.cellId) + "last");
        span.addStyle("text-decoration", "underline");
        span.setCellBody(Global.getMessage("form.cell.list.page.last", new Object[0]));
        td = new Dom("td");
        td.add("nowrap", "true");
        tr.appendChild(td);
        td.setWidth("70px");
        span = new Dom("span");
        td.appendChild(span);
        span.setCellBody(Global.getMessage("form.cell.list.page.turnto1", new Object[0]));
        td = new Dom("td");
        td.add("nowrap", "true");
        tr.appendChild(td);
        td.setWidth("34px");
        td.add("align", "left");
        td.add("padding-bottom", "6px");
        Dom input = new Dom("input");
        input.setId(String.valueOf(this.cellId) + "iPageIndex");
        td.appendChild(input);
        input.addStyle("border", "0px solid #7fc6bc");
        input.addStyle("border-bottom", "1px solid #7fc6bc");
        input.addStyle("ime-mode", "disabled");
        input.setWidth("30px");
        input.setHeight("16px");
        input.on("keypress", "window.COMPcreateEvent();return SetIntInput(this, false)");
        input.on("keydown", "window.COMPcreateEvent();onkeyEnter()");
        input.on("paste", "return false");
        input.on("dragenter", "return false");
        input.on("dragstart", "return false");
        input.on("contextmenu", "return false");
        input.on("change", String.valueOf(this.cellId) + ".turnTo(this.value)");
        td = new Dom("td");
        td.add("nowrap", "true");
        tr.appendChild(td);
        td.setCellBody("<span>" + Global.getMessage("form.cell.list.page.turnto2", new Object[0]) + "</span>");
        td.setWidth("36px");
        td = new Dom("td");
        td.add("nowrap", "true");
        tr.appendChild(td);
        td.setCellBody("<span align=right>" + Global.getMessage("form.cell.list.page.perpage1", new Object[0]) + "</span>");
        td.setWidth("30px");
        td = new Dom("td");
        td.add("nowrap", "true");
        tr.appendChild(td);
        td.setWidth("30px");
        td.add("align", "left");
        td.add("padding-bottom", "6px");
        input = new Dom("input");
        td.appendChild(input);
        input.setId(String.valueOf(this.cellId) + "pageDataSize");
        input.addStyle("border", "0px solid #7fc6bc");
        input.addStyle("border-bottom", "1px solid #7fc6bc");
        input.addStyle("ime-mode", "disabled");
        input.setWidth("30px");
        input.setHeight("16px");
        input.on("keypress", "window.COMPcreateEvent();return SetIntInput(this, false)");
        input.on("keydown", "window.COMPcreateEvent();onkeyEnter()");
        input.on("paste", "return false");
        input.on("dragenter", "return false");
        input.on("dragstart", "return false");
        input.on("contextmenu", "return false");
        input.on("change", String.valueOf(this.cellId) + ".turnTo('changedatasize')");
        td = new Dom("td");
        td.add("nowrap", "true");
        tr.appendChild(td);
        td.setCellBody("<span>" + Global.getMessage("form.cell.list.page.perpage2", new Object[0]) + "</span>&nbsp;");
        td = new Dom("td");
        td.add("nowrap", "true");
        tr.appendChild(td);
        td.add("align", "right");
        span = new Dom("span");
        td.appendChild(span);
        span.setCellBody(Global.getMessage("form.cell.list.page.items1", new Object[0]));
        span = new Dom("span");
        td.appendChild(span);
        span.setId(String.valueOf(this.cellId) + "pageIndex");
        span = new Dom("span");
        td.appendChild(span);
        span.setCellBody(Global.getMessage("form.cell.list.page.items2", new Object[0]));
        span = new Dom("span");
        td.appendChild(span);
        span.setId(String.valueOf(this.cellId) + "pageCount");
        span = new Dom("span");
        td.appendChild(span);
        span.setCellBody(Global.getMessage("form.cell.list.page.items3", new Object[0]));
        span = new Dom("span");
        td.appendChild(span);
        span.setId(String.valueOf(this.cellId) + "rowsCount");
        span = new Dom("span");
        td.appendChild(span);
        span.setCellBody(Global.getMessage("form.cell.list.page.items4", new Object[0]));
        return div;
    }

    public String getData(ListStyle style, Map map) {
        StringBuffer tableCell = new StringBuffer(1024);
        StringBuffer tableRow = new StringBuffer(1024);
        String value = "";
        boolean isBlank = map == null;
        TreeMap<String, CharSequence> attributes = new TreeMap<String, CharSequence>();
        TreeMap<String, String> styles = new TreeMap<String, String>();
        StringBuffer styleString = new StringBuffer(128);
        StringBuffer cellBody = new StringBuffer(128);
        int rowNum = -2;
        TreeMap<String, String> rowAttributes = new TreeMap<String, String>();
        int rowIndex = -1;
        if (!isBlank) {
            if (map.containsKey("[ROWNUM]")) {
                rowNum = Integer.parseInt((String)map.get("[ROWNUM]"));
                map.remove("[ROWNUM]");
            }
            if (rowNum % 2 == 0 && this.rowCss != null) {
                rowAttributes.put("class", this.rowCss);
            } else if (rowNum % 2 == 1 && this.alterCss != null) {
                rowAttributes.put("class", this.alterCss);
            }
            rowAttributes.put("DataFilled", "true");
            rowAttributes.put("value", (String)map.get(style.getPkCol()));
        } else {
            rowAttributes.put("DataFilled", "false");
        }
        if (!isBlank && map.containsKey("[ROWINDEX]")) {
            rowIndex = Integer.parseInt((String)map.get("[ROWINDEX]"));
            rowAttributes.put("rowIndex", String.valueOf(rowIndex));
            map.remove("[ROWINDEX]");
        }
        if (this.rowCss.indexOf("rowCss") == -1 && isBlank) {
            rowAttributes.put("height", "23");
        }
        List columnList = style.getColumnData();
        ListStyleColumnData listCol = null;
        int i = 0;
        while (i < columnList.size()) {
            String propertyName;
            Object para;
            attributes.clear();
            styles.clear();
            cellBody.setLength(0);
            listCol = (ListStyleColumnData)columnList.get(i);
            int columnType = listCol.getColumnType();
            String width = listCol.getColumnWidth();
            if (width == null || width.equals("0")) {
                styles.put("display", "none");
            }
            attributes.put("align", listCol.getHAlign());
            attributes.put("type", "" + columnType);
            attributes.put("property", listCol.getColumnId());
            attributes.put("cellIndex", String.valueOf(i));
            switch (listCol.getCellStyle()) {
                case 0: {
                    styles.put("word-break", "break-all");
                    break;
                }
                case 1: {
                    styles.put("white-space", "nowrap");
                    break;
                }
                case 2: {
                    styles.put("white-space", "nowrap");
                    styles.put("overflow", "hidden");
                    styles.put("text-overflow", "ellipsis");
                }
            }
            String event = listCol.getEventInfo();
            event = event != null ? StringTool.replaceKeyWord(event) : "";
            String eventArg = listCol.getEventArg();
            if (eventArg != null && eventArg.length() != 0) {
                String[] argField = eventArg.split(",");
                String[] argValue = new String[argField.length];
                int argIndex = 0;
                while (i < argField.length) {
                    argValue[argIndex] = (String)map.get(argField[argIndex]);
                    ++i;
                }
                event = StringTool.format(event, argValue);
            }
            attributes.put("", event);
            if (!isBlank && (para = map.get(propertyName = listCol.getColumnId())) != null) {
                value = (String)para;
                attributes.put("title", StringTool.getPureText(value));
            }
            switch (columnType) {
                case 1: {
                    styles.put("cursor", "hand");
                    break;
                }
                case 2: {
                    styles.put("padding-bottom", "1px");
                    if (rowNum < 0) break;
                    cellBody.append(rowNum);
                    break;
                }
                case 3: {
                    cellBody.append(value);
                    break;
                }
                default: {
                    cellBody.append(value);
                }
            }
            styleString.setLength(0);
            for (Map.Entry entry : styles.entrySet()) {
                styleString.append(entry.getKey());
                styleString.append(":");
                styleString.append(entry.getValue());
                styleString.append(";");
            }
            if (styleString.length() > 0) {
                attributes.put("style", styleString);
            }
            tableCell.append("<td");
            for (Map.Entry entry : attributes.entrySet()) {
                tableCell.append(" ");
                tableCell.append(entry.getKey());
                tableCell.append("=\"");
                tableCell.append(entry.getValue());
                tableCell.append("\"");
            }
            tableCell.append(">");
            String text = cellBody.toString();
            text = StringTool.replace(text, "<br/>", "\r\n");
            tableCell.append(text);
            tableCell.append("</td>\n");
            ++i;
        }
        tableRow.append("<tr");
        for (Map.Entry entry : rowAttributes.entrySet()) {
            tableRow.append(" ");
            tableRow.append(entry.getKey());
            tableRow.append("=\"");
            tableRow.append(entry.getValue());
            tableRow.append("\"");
        }
        tableRow.append(">");
        tableRow.append(tableCell.toString());
        tableRow.append("</tr>");
        return tableRow.toString();
    }

    public static ListStyle getListData(String styleId, String orderSql, String filterSql, int pageIndex) throws Exception {
        CheckClient cc = new CheckClient();
        if (!cc.checkFilter(filterSql)) {
            return null;
        }
        ListStyle listStyle = ListCell.initListStyle(null, null, styleId, orderSql, filterSql, pageIndex, true, -1);
        listStyle.getData();
        return listStyle;
    }

    public static ListStyle getListData(String formInstanceId, String styleId, String orderSql, String filterSql, int pageIndex) throws Exception {
        CheckClient cc = new CheckClient();
        if (!cc.checkFilter(filterSql)) {
            return null;
        }
        FormInstance formInstance = null;
        formInstance = FormInstance.loadFromCache(formInstanceId);
        ListStyle listStyle = ListCell.initListStyle(formInstance, null, styleId, orderSql, filterSql, pageIndex, true, -1);
        return listStyle;
    }

    public static ListStyle getListData(String formInstanceId, String formId, int cellId, String styleId, String orderSql, String filterSql, int pageIndex) throws Exception {
        ICell[] cells;
        CheckClient cc = new CheckClient();
        if (!cc.checkFilter(filterSql)) {
            return null;
        }
        Form form = Form.getPattern(formId);
        if (form != null && (cells = form.getCells()) != null && cells.length > cellId && cells[cellId] != null && cells[cellId] instanceof ListCell) {
            FormInstance formInstance = FormInstance.load(formInstanceId, form);
            ListStyle listStyle = ListCell.initListStyle(formInstance, (ListCell)cells[cellId], styleId, orderSql, filterSql, pageIndex, true, -1);
            return listStyle;
        }
        return null;
    }

    public static ListStyle getListData(String formInstanceId, String formId, int cellId, String styleId, String orderSql, String filterSql, int pageIndex, int pageDataSize) throws Exception {
        String defenseSQLInjection = com.sdjxd.hussar.core.base72.Global.getConfig((String)"defenseSQLInjection");
        if ("true".equalsIgnoreCase(defenseSQLInjection)) {
            throw new Exception("\u542f\u7528\u9632sql\u6ce8\u5165\u65f6\uff0c\u7981\u6b62\u8c03\u7528\u8be5\u65b9\u6cd5\uff01");
        }
        return ListCell.getListData1(formInstanceId, formId, cellId, styleId, orderSql, filterSql, pageIndex, pageDataSize);
    }

    private static ListStyle getListData1(String formInstanceId, String formId, int cellId, String styleId, String orderSql, String filterSql, int pageIndex, int pageDataSize) throws Exception {
        ICell[] cells;
        CheckClient cc = new CheckClient();
        if (!cc.checkFilter(filterSql)) {
            return null;
        }
        Form form = Form.getPattern(formId);
        if (form != null && (cells = form.getCells()) != null && cells.length > cellId && cells[cellId] != null && cells[cellId] instanceof ListCell) {
            FormInstance formInstance = FormInstance.load(formInstanceId, form);
            ListStyle listStyle = ListCell.initListStyle(formInstance, (ListCell)cells[cellId], styleId, orderSql, filterSql, pageIndex, true, pageDataSize);
            return listStyle;
        }
        return null;
    }

    public static ListStyle getListDataByQueryParam(String formInstanceId, String formId, int cellId, String styleId, String orderSql, HashMap<String, Object> queryParam, int pageIndex, int pageDataSize) throws Exception {
        String filterSqlStr = GlobalSql.getQuerySql(queryParam);
        if (filterSqlStr == null) {
            filterSqlStr = "";
        }
        ListStyle listStyle = ListCell.getListData1(formInstanceId, formId, cellId, styleId, orderSql, filterSqlStr.toString(), pageIndex, pageDataSize);
        return listStyle;
    }

    static ListStyle initListStyle(FormInstance formInstance, ListCell listCell, String styleId, String orderSql, String filterSql, int pageIndex, boolean loadData, int pageDataSize) throws Exception {
        Context context = Global.getContext();
        ListStyle listStyle = ListStyle.getInstance(styleId);
        if (listStyle != null) {
            listStyle.addFilterSql(filterSql);
            String defenseSQLInjection = com.sdjxd.hussar.core.base72.Global.getConfig((String)"defenseSQLInjection");
            if ("true".equalsIgnoreCase(defenseSQLInjection)) {
                String param = context.getParameter("filter");
                Object arg = BeanTool.parse(param);
                if (arg instanceof Map) {
                    Map queryParam = (Map)arg;
                    String sql2 = GlobalSql.getQuerySql((Map)queryParam);
                    if (!StringTool.isEmpty(sql2)) {
                        listStyle.addFilterSql(sql2);
                    }
                } else if (arg != null) {
                    log.info((Object)"\u4f7f\u7528\u9632sql\u6ce8\u5165\uff0c\u901a\u8fc7url\u8bbe\u7f6e\u5217\u8868\u8fc7\u6ee4\u6761\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
                }
            } else {
                listStyle.addFilterSql(context.getParameter("filter"));
            }
            if ("1".equals(Global.getConfig("isDataLimitControl"))) {
                User user = User.getCurrentUser();
                ArrayList<String> colNames = new ArrayList<String>();
                List columnDatas = listStyle.getColumnData();
                int i = 0;
                while (i < columnDatas.size()) {
                    String columnId;
                    ListStyleColumnData columnData = (ListStyleColumnData)columnDatas.get(i);
                    if (2 != columnData.getColumnType() && (columnId = columnData.getColumnId()) != null && columnId.length() != 0) {
                        colNames.add(columnId);
                    }
                    ++i;
                }
                if (user != null) {
                    String table = listStyle.getTableName();
                    PermitCtrl permit = new PermitCtrl();
                    String userId = user.getId();
                    String limitSql = permit.getLimitSql(userId, table, Const.TABLEOPER.SELECT, colNames);
                    if (!StringTool.isEmpty(limitSql)) {
                        listStyle.addFilterSql(limitSql);
                    }
                }
            }
            if (listCell != null) {
                Object[] jsonLimit;
                if (formInstance != null) {
                    EditGridData editGridData = new EditGridData(listCell, formInstance);
                    listStyle.addFilterSql(editGridData.getQueryCondition());
                }
                if ((jsonLimit = StringTool.strToArray(listCell.getLimitInfo())) != null) {
                    String filterOfLimit = "";
                    int i = 0;
                    while (i < jsonLimit.length) {
                        String oneLimitId = (String)jsonLimit[i];
                        String filterTemp = Limit.getLimitSql(oneLimitId, null);
                        if (filterTemp != null && !filterTemp.equals("")) {
                            if (!filterOfLimit.equals("")) {
                                filterOfLimit = String.valueOf(filterOfLimit) + " OR ";
                            }
                            filterOfLimit = String.valueOf(filterOfLimit) + "(";
                            filterOfLimit = String.valueOf(filterOfLimit) + filterTemp;
                            filterOfLimit = String.valueOf(filterOfLimit) + ")";
                        }
                        ++i;
                    }
                    if (!filterOfLimit.equals("")) {
                        listStyle.addFilterSql(filterOfLimit);
                    }
                }
            }
            if (listCell != null && !StringTool.isEmpty(listCell.userDefinfo)) {
                listStyle.setUserDefinfo(listCell.userDefinfo);
            }
            if (!StringTool.isEmpty(orderSql)) {
                String[] order = orderSql.split(",");
                int i = order.length - 1;
                while (i >= 0) {
                    String[] orderField = order[i].split(" ");
                    listStyle.addOrderField(orderField[0], orderField[1]);
                    --i;
                }
            }
            if (pageIndex < 0) {
                listStyle.setAllowPage(false);
                listStyle.setPageDataSize(-1);
            } else {
                listStyle.setPageIndex(pageIndex);
                if (pageDataSize > 0) {
                    listStyle.setPageDataSize(pageDataSize);
                }
            }
            if (loadData) {
                listStyle.getData(formInstance);
            }
        }
        return listStyle;
    }

    public String getStyleId() {
        return this.styleId;
    }
}

