/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.Css;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.CommonCell;
import com.sdjxd.pms.platform.tool.StringTool;

public class Line
extends CommonCell {
    private static final long serialVersionUID = 1L;
    private int strokeweight;
    private String tempPosition;
    private String strokecolor;
    private String lineType = "line";

    public Line(Form pattern) {
        super(pattern);
        this.tagName = "div";
    }

    @Override
    protected void setBorder(int lineWidth) {
        String cssText;
        Css css;
        this.border = lineWidth;
        if (this.border <= 0) {
            this.border = 1;
        }
        if (this.data.borderStyle == null) {
            this.data.borderStyle = "";
        }
        this.strokecolor = this.data.borderStyle.length() == 0 ? SheetConstants.CELL.LINECOLOR : ((css = (Css)Form.getCss().get(this.data.borderStyle)) != null ? ((cssText = css.getValue("border-color")) != null ? cssText : SheetConstants.CELL.LINECOLOR) : SheetConstants.CELL.LINECOLOR);
        this.style.put("background-color", this.strokecolor);
    }

    @Override
    protected void setWidth(int width) {
        this.noRender();
        this.width = width;
        if (StringTool.isEmpty(this.widthScale)) {
            this.setTo();
        }
    }

    @Override
    protected void setHeight(int height) {
        this.noRender();
        this.height = height;
        if (StringTool.isEmpty(this.heightScale)) {
            this.setTo();
        }
    }

    @Override
    public void setWidthScale(String widthScale) {
        if (StringTool.isEmpty(widthScale)) {
            this.widthScale = null;
        } else {
            this.widthScale = widthScale;
            this.setTo();
        }
    }

    @Override
    public void setHeightScale(String heightScale) {
        if (StringTool.isEmpty(heightScale)) {
            this.heightScale = null;
        } else {
            this.heightScale = heightScale;
            this.setTo();
        }
    }

    private void setTo() {
        String styleWidth = null;
        String styleHeight = null;
        if (StringTool.isEmpty(this.widthScale)) {
            if (this.width > 0) {
                styleWidth = String.valueOf(String.valueOf(this.width)) + "px";
            }
        } else {
            styleWidth = this.widthScale;
        }
        if (StringTool.isEmpty(this.heightScale)) {
            if (this.height > 0) {
                styleHeight = String.valueOf(String.valueOf(this.height)) + "px";
            }
        } else {
            styleHeight = this.heightScale;
        }
        this.style.put("overflow", "hidden");
        if (StringTool.isEmpty(styleWidth)) {
            this.style.put("width", String.valueOf(String.valueOf(this.border)) + "px");
            this.style.put("left", String.valueOf(String.valueOf(this.left - this.border / 2)) + "px");
        } else {
            this.style.put("width", styleWidth);
        }
        if (StringTool.isEmpty(styleHeight)) {
            this.style.put("height", String.valueOf(String.valueOf(this.border)) + "px");
            this.style.put("top", String.valueOf(String.valueOf(this.top - this.border / 2)) + "px");
        } else {
            this.style.put("height", styleHeight);
        }
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        StringBuffer sb = new StringBuffer();
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.cell.Line({id:");
        sb.append(this.id);
        sb.append(",typeName:'Line'");
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        sb.append(",isDashType:false");
        sb.append(",needSave:false");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append(",isPrint:");
        sb.append(this.data.isPrint);
        sb.append("}));");
        if (this.width > 1 && this.height > 1) {
            this.tempPosition = String.valueOf(this.tempPosition) + this.strokecolor + ";" + this.border;
            sb.append("defaultForm.getCellById(" + this.getId() + ").drawSlash('" + this.tempPosition + "')");
        }
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    @Override
    public void setData(CellBean model) throws Exception {
        int top;
        int height;
        int left;
        int width;
        if (model == null) {
            return;
        }
        super.setData(model);
        this.setAreaId(this.data.areaId);
        this.setPosition(this.data.position);
        this.tempPosition = String.valueOf(this.data.x1) + ";" + this.data.y1 + ";" + (this.data.x1 + this.data.width) + ";" + (this.data.y1 + this.data.height) + ";";
        if (this.data.width < 0) {
            width = Math.abs(this.data.width);
            left = this.data.x1 + this.data.width;
        } else {
            width = this.data.width;
            left = this.data.x1;
        }
        if (this.data.height < 0) {
            height = Math.abs(this.data.height);
            top = this.data.y1 + this.data.height;
        } else {
            height = this.data.height;
            top = this.data.y1;
        }
        this.setTop(top);
        this.setLeft(left);
        this.setBorder(this.data.lineWidth);
        this.setWidth(width);
        this.setHeight(height);
        this.setWidthScale(this.data.widthScale);
        this.setHeightScale(this.data.heightScale);
    }

    @Override
    public void render(FormInstance form) throws Exception {
        if (this.width > 1 && this.height > 1) {
            this.style.put("display", "none");
        }
        super.render(form);
    }

    public String getLineType() {
        return this.lineType;
    }

    public void setLineType(String lineType) {
        this.lineType = lineType;
    }
}

