/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.InfoShowColumn;
import com.sdjxd.pms.platform.form.model.InfoShowStyle;
import com.sdjxd.pms.platform.form.model.InfoShowTable;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.CommonCell;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;

public class InfoShow
extends CommonCell {
    private static final long serialVersionUID = 1L;

    public InfoShow(Form pattern) {
        super(pattern);
        pattern.setOldPattern(true);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        if (model == null) {
            return;
        }
        this.data = model;
        this.id = this.data.cellId;
        this.setCellId(String.valueOf(this.cellPrefix) + this.id);
        this.setAreaId(this.data.areaId);
        this.setStyle();
        this.setLimit(model.limit);
        this.setClassName();
        if (this.data.createDate != null && this.data.createDate.length() != 0) {
            this.modifyTime = DateTool.parseDate(this.data.createDate);
        }
    }

    @Override
    public void render(FormInstance form) throws IOException {
        InfoShowTable attTable;
        PatternDao dao = (PatternDao)BeanFactory.getClass("PatternDao");
        PrintWriter out = form.getRenderHtml();
        InfoShowTable infoTable = (InfoShowTable)Global.getContext().getAttribute("infoShowTableDIY");
        if (infoTable != null) {
            infoTable.setWidth(String.valueOf(this.width));
            String height1 = String.valueOf(this.height);
            if (this.heightScale != null && this.heightScale.length() != 0 && !this.heightScale.equals("0")) {
                height1 = this.heightScale;
            }
            infoTable.setHeight(height1);
            infoTable.setName("cellId" + this.id);
            infoTable.setCellId(this.id);
            infoTable.setStyleLeft(this.left);
            infoTable.setStyleTop(this.top);
            infoTable.setPosition(this.position);
            String showType = "";
            showType = Global.getContext().getParameter("SHOWTYPE") != null ? Global.getContext().getParameter("SHOWTYPE") : "NEW";
            if (showType.equals("NEW")) {
                infoTable.setEditType(0);
                String sheetId = Guid.create();
                infoTable.setKeyValue(sheetId);
                this.setColumnDefaultValues(infoTable.getColumns(), dao);
            } else {
                if (showType.equals("EDIT")) {
                    infoTable.setEditType(1);
                } else {
                    infoTable.setEditType(2);
                }
                String sheetId = infoTable.getKeyValue();
                StringTool.isEmpty(sheetId);
            }
            ((Writer)out).write(infoTable.outContent());
            return;
        }
        String tableId = this.getData().assitInfo;
        if (tableId == null || tableId.length() == 0) {
            tableId = Global.getContext().getParameter("TABLEID");
        }
        if (tableId == null || tableId.length() == 0) {
            try {
                ((Writer)out).write("<font color=red>\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570[\u8868ID TABLEID]\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5!</font>");
            }
            catch (Exception showType) {
                // empty catch block
            }
            return;
        }
        String tableName = Global.getContext().getParameter("TABLENAME");
        if (tableName != null && tableName.length() == 0) {
            try {
                ((Writer)out).write("<font color=red>\u8868ID[" + tableId + "]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u8868\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5!</font>");
            }
            catch (Exception sheetId) {
                // empty catch block
            }
            return;
        }
        InfoShowTable table = null;
        try {
            table = new InfoShowTable(tableId);
        }
        catch (Exception exp) {
            ((Writer)out).write("<font color=red>\u53c2\u6570\u9519\u8bef[\u8868ID TABLEID]\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5!</font>");
            exp.printStackTrace();
            return;
        }
        table.setWidth(String.valueOf(this.width));
        String height1 = String.valueOf(this.height);
        if (this.heightScale != null && this.heightScale.length() != 0 && !this.heightScale.equals("0")) {
            height1 = this.heightScale;
        }
        table.setHeight(height1);
        table.setName("cellId" + this.id);
        table.setCellId(this.id);
        table.setStyleLeft(this.left);
        table.setStyleTop(this.top);
        table.setPosition(this.position);
        if (tableName != null && tableName.length() != 0) {
            table.setTableName(tableName);
        }
        String styleId = "";
        styleId = Global.getContext().getParameter("infoShowStyleID");
        InfoShowStyle style1 = null;
        if (styleId != null && styleId.length() != 0) {
            style1 = dao.getInfoShowStyle(styleId);
        }
        if (style1 == null) {
            style1 = dao.getInfoShowStyleDefault(tableId);
        }
        if (style1 == null) {
            try {
                ((Writer)out).write("<font color=red>\u8868ID[" + tableId + "]\u5bf9\u5e94\u8868[" + tableName + "]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u663e\u793a\u65b9\u6848\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5!</font>");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        table.setInfoShowStyle(style1);
        List columns = dao.getInfoShowColumn(tableId, style1.getStyleId());
        int editType = 0;
        String keyValue = "";
        String showType = "";
        showType = Global.getContext().getParameter("SHOWTYPE") != null ? Global.getContext().getParameter("SHOWTYPE") : "NEW";
        if (showType.equals("NEW")) {
            keyValue = Guid.create();
            this.setColumnDefaultValues(columns, dao);
        } else {
            editType = showType.equals("EDIT") ? 1 : 2;
            String sheetId = Global.getContext().getParameter("infoShowSheetID");
            if (sheetId == null) {
                sheetId = Global.getContext().getParameter("INFOSHOWSHEETID");
            }
            if (sheetId == null) {
                try {
                    ((Writer)out).write("<font color=red>\u7f16\u8f91\u64cd\u4f5c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570[infoShowSheetID]\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5!</font>");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            keyValue = sheetId;
            TreeMap columnValues = null;
            try {
                columnValues = dao.getColumnValueByTableId(tableId, sheetId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (columnValues == null) {
                try {
                    ((Writer)out).write("<font color=red>\u8868[ID=" + tableId + "]\u4e2d\u6ca1\u6709\u627e\u5230[SHEETID=" + sheetId + "]\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5!</font>");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            columns = InfoShow.setColumnValues(columns, columnValues, dao);
        }
        if (style1.getAttStyleId() != null && style1.getAttStyleId().length() != 0 && (attTable = dao.getInfoShowTableByStyleId(style1.getAttStyleId())) != null) {
            table.setAttTableName(attTable.getTableName());
            table.setAttTableId(attTable.getTableId());
            String attSId = "";
            if (Global.getContext().getParameter("ATTSID") != null) {
                attSId = Global.getContext().getParameter("ATTSID");
            } else {
                int i = 0;
                while (i < columns.size()) {
                    InfoShowColumn column = (InfoShowColumn)columns.get(i);
                    if (column.getColumnId().equals(style1.getColId())) {
                        attSId = column.getColumnValue();
                        break;
                    }
                    ++i;
                }
            }
            if (attSId != null && attSId.length() != 0) {
                TreeMap columnValues = null;
                try {
                    columnValues = dao.getAttachColumnValueByTableId(attTable.getTableId(), attSId, table.getInfoShowStyle().getAttachCol());
                }
                catch (Exception column) {
                    // empty catch block
                }
                if (columnValues != null) {
                    table.setAttSheetId(columnValues.get("SHEETID").toString());
                } else {
                    try {
                        ((Writer)out).write("<font color=red>\u8868[ID=" + attTable.getTableId() + "]\u4e2d\u6ca1\u6709\u627e\u5230[SHEETID=" + attSId + "]\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5!</font>");
                    }
                    catch (Exception column) {
                        // empty catch block
                    }
                }
                List attColumns = InfoShow.setColumnValues(attTable.getColumns(), columnValues, dao);
                attTable.setColumns(attColumns);
            } else {
                table.setAttSheetId(Guid.create());
            }
            table.setAttColumns(attTable.getColumns());
            columns = InfoShow.attachColumns(columns, attTable.getColumns());
        }
        table.setColumns(columns);
        table.setEditType(editType);
        table.setKeyValue(keyValue);
        try {
            ((Writer)out).write(table.outContent());
        }
        catch (IOException exp) {
            exp.printStackTrace();
        }
    }

    private List setColumnDefaultValues(List columns, PatternDao dao) {
        ArrayList<InfoShowColumn> nColumns = new ArrayList<InfoShowColumn>();
        String text = "";
        String value = "";
        int i = 0;
        while (i < columns.size()) {
            InfoShowColumn column = (InfoShowColumn)columns.get(i);
            if (column.getDefaultValue() == null || column.getDefaultValue().length() == 0) {
                nColumns.add(column);
            } else {
                value = column.getDefaultValue();
                value = StringTool.replaceKeyWord(value);
                column.setColumnValue(value);
                text = value.trim();
                if (column.getInfoShowProperty() != null) {
                    Date date;
                    if (column.getInfoShowProperty().getPropertyType() != null && (column.getInfoShowProperty().getPropertyType().equals("IDStringPicker") || column.getInfoShowProperty().getPropertyType().equals("ID_Selector"))) {
                        if (column.getInfoShowProperty().getPropertyType().equals("IDStringPicker")) {
                            String assitInfo = column.getInfoShowProperty().getAssitInfo();
                            assitInfo = StringTool.replaceKeyWord(assitInfo);
                            text = dao.getdropDownOptionValue(column.getInfoShowProperty().getDataSourceName(), assitInfo, value);
                        } else {
                            String[] params = column.getInfoShowProperty().getAssitInfo().split("@");
                            if (params.length < 4) {
                                System.out.println("\u67e5\u8be2\u5b57\u6bb5\u542b\u4e49\u4fe1\u606f\u65f6\u51fa\u73b0\u9519\u8bef\uff1a\u5b57\u6bb5\u542b\u4e49[" + column.getInfoShowProperty().getPropertyName() + "]\u53c2\u6570[" + column.getInfoShowProperty().getAssitInfo() + "]\u8bbe\u7f6e\u9519\u8bef\u3002");
                            } else {
                                String tableName = params[3];
                                String nameCol = params[2];
                                String idCol = params[1];
                                text = dao.getNameById(column.getInfoShowProperty().getDataSourceName(), "", tableName, nameCol, idCol, value);
                            }
                        }
                    } else if (column.getInfoShowProperty().getPropertyType() != null && column.getInfoShowProperty().getPropertyType().equals("DateTime") && (date = DateTool.parseDate(value)) != null) {
                        text = DateTool.dateToStr(date, column.getInfoShowProperty().getAssitInfo());
                    }
                }
                column.setColumnText(text);
                nColumns.add(column);
            }
            ++i;
        }
        return nColumns;
    }

    public static List setColumnValues(List columns, TreeMap columnValues, PatternDao dao) {
        if (columnValues == null || columnValues.size() == 0) {
            return null;
        }
        ArrayList<InfoShowColumn> nColumns = new ArrayList<InfoShowColumn>();
        String text = "";
        int i = 0;
        while (i < columns.size()) {
            InfoShowColumn column = (InfoShowColumn)columns.get(i);
            Object o = columnValues.get(column.getColumnId());
            if (o != null) {
                String value = o.toString().trim();
                column.setColumnValue(value);
                text = value.trim();
                if (column.getInfoShowProperty() != null) {
                    if (column.getInfoShowProperty().getPropertyType() != null && (column.getInfoShowProperty().getPropertyType().equals("IDStringPicker") || column.getInfoShowProperty().getPropertyType().equals("ID_Selector"))) {
                        if (column.getInfoShowProperty().getPropertyType().equals("IDStringPicker")) {
                            String assitInfo = column.getInfoShowProperty().getAssitInfo();
                            assitInfo = StringTool.replaceKeyWord(assitInfo);
                            text = dao.getdropDownOptionValue(column.getInfoShowProperty().getDataSourceName(), assitInfo, value);
                        } else {
                            String[] params = (String[])StringTool.strToArray(column.getInfoShowProperty().getAssitInfo());
                            if (params.length < 4) {
                                System.out.println("\u67e5\u8be2\u5b57\u6bb5\u542b\u4e49\u4fe1\u606f\u65f6\u51fa\u73b0\u9519\u8bef\uff1a\u5b57\u6bb5\u542b\u4e49[" + column.getInfoShowProperty().getPropertyName() + "]\u53c2\u6570[" + column.getInfoShowProperty().getAssitInfo() + "]\u8bbe\u7f6e\u9519\u8bef\u3002");
                            } else {
                                String tableName = params[3];
                                String nameCol = params[2];
                                String idCol = params[1];
                                text = dao.getNameById(column.getInfoShowProperty().getDataSourceName(), "", tableName, nameCol, idCol, value);
                            }
                        }
                    } else if (column.getInfoShowProperty().getPropertyType() != null && column.getInfoShowProperty().getPropertyType().equals("DateTime") && value.length() != 0) {
                        Date date = DateTool.parseDate(value);
                        Object[] tmp = StringTool.strToArray(column.getInfoShowProperty().getAssitInfo());
                        if (date != null && tmp.length > 0) {
                            text = DateTool.dateToStr(date, tmp[0].toString());
                        }
                    }
                }
                column.setColumnText(text);
            }
            nColumns.add(column);
            ++i;
        }
        return nColumns;
    }

    public static List attachColumns(List columns, List attColumns) {
        int index = 0;
        int i = 0;
        while (i < attColumns.size()) {
            InfoShowColumn col = (InfoShowColumn)attColumns.get(i);
            index = col.getShowOrder();
            if (index < columns.size()) {
                columns.add(index, col);
            } else {
                columns.add(col);
            }
            ++i;
        }
        return columns;
    }
}

