/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.CommonCell;
import com.sdjxd.pms.platform.tool.StringTool;
import java.io.PrintWriter;
import java.io.Writer;

public class IFrame
extends CommonCell {
    private static final long serialVersionUID = 1L;
    String src;

    public IFrame(Form pattern) {
        super(pattern);
        this.setPattern(pattern);
        this.tagName = "iframe";
    }

    @Override
    public String getTextAttribute() {
        return "src";
    }

    @Override
    public String getValueAttribute() {
        return "src";
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        this.src = model.assitInfo;
        String scroll = "auto";
        if (model.compareTypeId != -1) {
            if (model.compareTypeId == 0) {
                scroll = "yes";
            } else if (model.compareTypeId == 1) {
                scroll = "no";
            }
        }
        this.attributes.put("scrolling", scroll);
        String oWidth = String.valueOf(this.width) + "px";
        if (this.widthScale != null && this.widthScale.length() != 0) {
            oWidth = this.widthScale;
        }
        this.style.put("width", oWidth);
        String oHeight = String.valueOf(this.height) + "px";
        if (this.heightScale != null && this.heightScale.length() != 0 && !this.heightScale.equals("0")) {
            oHeight = this.heightScale;
        }
        this.style.put("height", oHeight);
    }

    @Override
    public void render(FormInstance form) throws Exception {
        String src = StringTool.replaceKeyWord(this.src);
        String srcCode = StringTool.unescapeUrl(src);
        this.attributes.put("src", StringTool.escapeHtml(srcCode));
        this.attributes.put("frameborder", "0");
        super.render(form);
        PrintWriter renderHtml1 = form.getRenderHtml();
        ((Writer)renderHtml1).write(this.outSctipt());
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        String src = StringTool.replaceKeyWord(this.src);
        StringBuffer sb = new StringBuffer();
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.cell.IFrame({id:");
        sb.append(this.id);
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        sb.append(",url:\"" + StringTool.toJson(src)).append("\"");
        sb.append(",needSave:false");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append(",isPrint:");
        sb.append(this.data.isPrint);
        sb.append("}));");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    private String outSctipt() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n<script>");
        if (this.heightScale != null && this.heightScale.equals("100%")) {
            sb.append("\n var top = document.getElementById('" + this.cellId + "').style.top==''?0:document.getElementById('" + this.cellId + "').style.top;");
            sb.append("\n function iframeResize_" + this.cellId + "(){document.getElementById('" + this.cellId + "').style.height = document.body.clientHeight - parseInt(top) - 10;}");
            sb.append("\n window.resize=iframeResize_" + this.cellId + ";");
            sb.append("\n iframeResize_" + this.cellId + "()");
        }
        sb.append("\n</script>");
        return sb.toString();
    }
}

