/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.form.model.CellActionBean;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.DynamicCell;
import com.sdjxd.pms.platform.tool.StringTool;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class Hyperlink
extends DynamicCell {
    private static final long serialVersionUID = 1L;
    protected String href;
    protected String openType;
    private String inputType = "hyperlink";

    public Hyperlink(Form pattern) {
        super(pattern);
        this.tagName = "a";
        this.attributes.put("type", this.inputType);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        String readBkColorStyle = model.readBkColorStyle;
        if (model.limit == 1) {
            model.readBkColorStyle = "S105";
        }
        super.setData(model);
        model.readBkColorStyle = readBkColorStyle;
        if (model.assitInfo == null || model.assitInfo.length() == 0) {
            return;
        }
        String[] temp = (String[])StringTool.strToArray(model.assitInfo);
        if (temp.length < 1) {
            this.href = "#";
            this.openType = "3";
        } else if (temp.length == 1) {
            this.href = temp[1];
            this.openType = "3";
        } else if (temp.length > 1) {
            this.href = temp[1];
            this.openType = temp[0];
        }
        this.attributes.put("cv", this.href);
        this.attributes.put("value", this.cellName);
        if (model.limit == 1) {
            this.attributes.put("disabled ", new Boolean(true));
        }
        this.style.put("cursor", "pointer");
    }

    @Override
    public void renderBody(FormInstance form) throws IOException {
        PrintWriter renderHtml = form.getRenderHtml();
        ((Writer)renderHtml).write(this.cellName);
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        StringBuffer sb = new StringBuffer();
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.cell.Hyperlink({id:");
        sb.append(this.id);
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        sb.append(",isPrint:");
        sb.append(this.data.isPrint);
        sb.append(",needSave:false");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append(",hyperlinkAddress:");
        sb.append("\"").append(this.href).append("\"");
        sb.append(",hyperlinkText:");
        sb.append("\"").append(this.cellName).append("\"");
        sb.append(",openType:");
        sb.append("\"").append(this.openType).append("\"");
        sb.append("}));\r\n");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    @Override
    public void addEvent(CellActionBean cellAction) {
        this.addEvent("onclick", "defaultForm.getCellById(" + this.id + ").openHref()");
    }
}

