/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.cell.DynamicCell;
import com.sdjxd.pms.platform.form.service.cell.Text;
import com.sdjxd.pms.platform.form.service.cell.TextArea;
import com.sdjxd.pms.platform.tool.StringTool;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class HtmlSelectorBtn
extends DynamicCell {
    private static final long serialVersionUID = 1L;
    protected String colMeanUrl;
    protected String colMeanActArg;
    protected String colMeanIdField;
    protected String colMeanNameField;
    protected String colMeanTableName;
    protected String colMeanDialogArg;
    protected String btnLabel;
    protected int btnHeight;
    protected int btnWidth;
    protected String btnTextStyle;
    protected String btnReadOnlyStyle;
    protected String btnBkStyle;
    protected String btnFontStyle;

    public HtmlSelectorBtn(Form pattern) {
        super(pattern);
        this.setPattern(pattern);
        this.tagName = "input";
        this.attributes.put("type", "button");
        this.btnHeight = 30;
        this.btnWidth = 23;
        this.btnLabel = "...";
    }

    @Override
    public void setData(CellBean model) {
        this.data = model;
        this.id = model.cellId;
        this.setStyle();
        this.attributes.put("value", this.btnLabel);
        this.attributes.put("id", "cellId" + model.cellId + "selectorBtn");
        this.style.put("border", "0px");
        this.style.put("height", String.valueOf(this.btnHeight) + "px");
        this.style.put("width", String.valueOf(this.btnWidth) + "px");
        this.style.put("position", "absolute");
        this.style.put("padding-left", "0px");
        if ("TextArea".equals(SheetConstants.CELL.getType(model.cellType))) {
            this.style.put("top", String.valueOf(model.height - this.btnHeight) + "px");
            this.style.put("left", String.valueOf(model.width - this.btnWidth) + "px");
        } else {
            this.style.put("top", String.valueOf(model.y1) + "px");
            this.style.put("left", String.valueOf(model.x1 + model.width - this.btnWidth) + "px");
        }
        if (model.fieldMeanType != null && (model.fieldMeanType.equals("Name_Selector") || model.fieldMeanType.equals("ID_Selector")) && model.fieldMeanValue != null && model.fieldMeanValue.length() != 0) {
            String[] temp = (String[])StringTool.strToArray(model.fieldMeanValue);
            String[] url_actArg = temp[0].split("\\?");
            if (url_actArg.length > 0) {
                this.colMeanUrl = url_actArg[0];
            }
            if (url_actArg.length > 1) {
                this.colMeanActArg = url_actArg[1];
            }
            this.colMeanIdField = temp[1];
            this.colMeanNameField = temp[2];
            this.colMeanTableName = temp[3];
            this.colMeanDialogArg = temp[4];
            this.meanDataSourceName = model.meanDataSourceName;
        }
        this.setClassName();
    }

    @Override
    protected void setStyle() {
        if (this.getParentControls() instanceof Text) {
            this.setPosition(this.data.position);
            this.setTop(this.data.y1);
            this.setLeft(this.data.x1 + this.data.width - this.btnWidth);
        } else if (this.getParentControls() instanceof TextArea) {
            this.setPosition(this.data.position);
            this.setTop(this.data.height - 19);
            this.setLeft(this.data.width - this.btnWidth);
        }
    }

    @Override
    protected void renderBody(FormInstance form) throws IOException {
    }

    @Override
    protected void renderEnable(FormInstance form) throws IOException {
        ICell parentControl = this.getParentControls();
        FormCell[] cells = form.getCell();
        if (parentControl.getId() < cells.length && cells[parentControl.getId()] != null && !cells[parentControl.getId()].isEnabled()) {
            PrintWriter renderHtml = form.getRenderHtml();
            ((Writer)renderHtml).write(" disabled=");
            ((Writer)renderHtml).write(SheetConstants.HTML.ATTTRUE);
            ((Writer)renderHtml).write("");
        }
    }

    @Override
    protected void renderVisible(FormInstance form) throws Exception {
        if (this.id < form.getCell().length && form.getCell()[this.id] != null && !form.getCell()[this.id].isVisible()) {
            PrintWriter renderHtml1 = form.getRenderHtml();
            ((Writer)renderHtml1).write("display:none;");
        }
    }

    @Override
    protected void renderEvent(FormInstance form) {
    }

    @Override
    protected void setClassName() {
        if (this.btnTextStyle != null && this.btnTextStyle.length() != 0) {
            this.classNames.put("text", this.btnTextStyle);
        }
        if (this.btnFontStyle != null && this.btnFontStyle.length() != 0) {
            this.classNames.put("font", this.btnFontStyle);
        }
        if (this.btnReadOnlyStyle != null && this.btnReadOnlyStyle.length() != 0) {
            this.classNames.put("read", this.btnReadOnlyStyle);
        }
        if (this.btnBkStyle != null && this.btnBkStyle.length() != 0) {
            this.classNames.put("edit", this.btnBkStyle);
        }
    }
}

