/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.DropDownOptionBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.ComboBox;
import com.sdjxd.pms.platform.form.service.cell.DynamicCell;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class HtmlSelect
extends DynamicCell {
    private static final long serialVersionUID = 1L;
    private boolean autoSort = false;
    private static PatternDao dao;
    private TreeMap optionsForSort = null;
    private List options = null;
    private String selectedText;
    private String selectedValue;
    private boolean isAddNullOption;
    private ComboBox belongSelect;

    public HtmlSelect(Form pattern) {
        super(pattern);
        this.setPattern(pattern);
        this.tagName = "select";
    }

    @Override
    public String getTextAttribute() {
        return "options[selectedIndex].text";
    }

    @Override
    public String getValueAttribute() {
        return "value";
    }

    @Override
    protected void renderBody(FormInstance form) throws IOException {
        String assitInfo = this.data.assitInfo;
        assitInfo = StringTool.replaceKeyWord(assitInfo);
        assitInfo = FormInstance.replaceParaValue(assitInfo, form);
        dao = (PatternDao)BeanFactory.getSingleInstance("PatternDao");
        this.options = dao.getdropDownOption(this.meanDataSourceName, assitInfo, this.getLimitInfoArray());
        PrintWriter renderHtml = form.getRenderHtml();
        String cellValue = null;
        String cellText = null;
        FormCell[] formCell = form.getCell();
        if (this.id < formCell.length && formCell[this.id] != null) {
            cellValue = formCell[this.id].getValue();
            cellText = formCell[this.id].getText();
        }
        TreeMap<String, String> selectedKey = new TreeMap<String, String>();
        if (this.id < form.getCell().length && formCell[this.id] != null && formCell[this.id].isEnabled() && cellValue != null && cellValue.length() != 0) {
            String[] selectedValue = cellValue.split("@");
            int index = 0;
            while (index < selectedValue.length) {
                selectedKey.put(selectedValue[index], selectedValue[index]);
                ++index;
            }
        }
        if (this.isAddNullOption) {
            ((Writer)renderHtml).write("<option");
            ((Writer)renderHtml).write(" value=\"");
            ((Writer)renderHtml).write("\">");
            ((Writer)renderHtml).write("</option>");
        }
        if (this.autoSort && this.optionsForSort != null) {
            Iterator it = this.optionsForSort.entrySet().iterator();
            while (it.hasNext()) {
                DropDownOptionBean option = (DropDownOptionBean)it.next().getValue();
                ((Writer)renderHtml).write("<option");
                if (selectedKey.containsKey(option.getOptionValue())) {
                    ((Writer)renderHtml).write(" selected");
                    this.selectedText = option.getOptionText();
                    this.selectedValue = option.getOptionValue();
                }
                ((Writer)renderHtml).write(" value=\"");
                ((Writer)renderHtml).write(option.getOptionValue());
                ((Writer)renderHtml).write("\">");
                ((Writer)renderHtml).write(option.getOptionText());
                ((Writer)renderHtml).write("</option>");
            }
        } else if (this.options != null) {
            String defaultValue = this.label;
            String[] defaultValueArr = null;
            try {
                String temp = StringTool.replaceKeyWord(defaultValue, form);
                temp = FormInstance.replaceParaValue(temp, form);
                defaultValueArr = (String[])StringTool.strToArray(temp);
            }
            catch (Exception temp) {
                // empty catch block
            }
            int index = 0;
            while (index < this.options.size()) {
                DropDownOptionBean option = (DropDownOptionBean)this.options.get(index);
                ((Writer)renderHtml).write("<option");
                if (defaultValueArr != null && this.belongSelect != null && (DataModify.NEW.is(form.getModify()) && this.getDefaultValueTime() != 1 || StringTool.isEmpty(form.getCellValue(this.id)) && this.getDefaultValueTime() == 1 && form.getCell()[this.id].isEnabled())) {
                    if (defaultValueArr[0].equals("0")) {
                        if (defaultValueArr.length > 1 && Integer.parseInt(defaultValueArr[1]) == index) {
                            ((Writer)renderHtml).write(" selected");
                            formCell[this.id].setValue(option.getOptionValue());
                            formCell[this.id].setText(option.getOptionText());
                        }
                    } else if (defaultValueArr.length > 1 && defaultValueArr[1].equals(option.getOptionValue())) {
                        ((Writer)renderHtml).write(" selected");
                        formCell[this.id].setValue(option.getOptionValue());
                        formCell[this.id].setText(option.getOptionText());
                    }
                } else {
                    if (cellValue.length() == 0 && cellText.length() == 0 && index == 0 && !this.isAddNullOption && formCell[this.id].isEnabled()) {
                        ((Writer)renderHtml).write(" selected");
                        formCell[this.id].setValue(option.getOptionValue());
                        formCell[this.id].setText(option.getOptionText());
                    }
                    if (cellValue.equals(option.getOptionValue())) {
                        ((Writer)renderHtml).write(" selected");
                        if (cellText.length() == 0) {
                            formCell[this.id].setText(option.getOptionText());
                        }
                    } else if (cellValue.length() == 0 && !cellText.equals("") && cellText.equals(option.getOptionText())) {
                        ((Writer)renderHtml).write(" selected");
                        formCell[this.id].setValue(option.getOptionValue());
                    }
                }
                ((Writer)renderHtml).write(" value=\"");
                ((Writer)renderHtml).write(option.getOptionValue());
                ((Writer)renderHtml).write("\">");
                ((Writer)renderHtml).write(option.getOptionText());
                ((Writer)renderHtml).write("</option>");
                ++index;
            }
        }
        if (this.belongSelect != null && form.getModify() != null) {
            form.getModify().is(DataModify.NEW);
        }
        ((Writer)renderHtml).write(this.cellBody);
    }

    protected void setAutoSort(boolean autoSort) {
        if (this.optionsForSort == null && this.options != null) {
            int index = 0;
            while (index < this.options.size()) {
                DropDownOptionBean option = (DropDownOptionBean)this.options.get(index);
                this.optionsForSort.put(option.getOptionValue(), option);
                ++index;
            }
        }
        this.autoSort = autoSort;
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
    }

    public String getSelectedText() {
        return this.selectedText;
    }

    public ComboBox getBelongSelect() {
        return this.belongSelect;
    }

    public void setBelongSelect(ComboBox belongSelect) {
        this.belongSelect = belongSelect;
    }

    public String getSelectedValue() {
        return this.selectedValue;
    }

    public boolean isAddNullOption() {
        return this.isAddNullOption;
    }

    public void setAddNullOption(boolean isAddNullOption) {
        this.isAddNullOption = isAddNullOption;
    }
}

