/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.DynamicCell;
import java.io.PrintWriter;
import java.io.Writer;

public class HtmlRadio
extends DynamicCell {
    private static final long serialVersionUID = 1L;
    private String inputType = "radio";
    private String defaultValue = "1";

    public HtmlRadio(Form pattern) {
        super(pattern);
        this.setPattern(pattern);
        this.tagName = "input";
        this.attributes.put("type", this.inputType);
    }

    @Override
    public String getTextAttribute() {
        return "checked?parentNode.innerText:''";
    }

    @Override
    public String getValueAttribute() {
        return "checked?'" + this.defaultValue + "':'0'";
    }

    @Override
    protected void renderValue(FormInstance form) throws Exception {
        PrintWriter renderHtml = form.getRenderHtml();
        String checked = "";
        String cellValue = this.id < form.getCell().length && form.getCell()[this.id] != null && form.getCell()[this.id].getValue() != null && form.getCell()[this.id].getValue().length() != 0 ? form.getCell()[this.id].getValue().trim() : this.data.assitInfo;
        if (cellValue != null && cellValue.equals(this.defaultValue)) {
            checked = " checked";
        }
        ((Writer)renderHtml).write(checked);
    }

    @Override
    protected void renderAttribute(FormInstance form) throws Exception {
        super.renderAttribute(form);
        this.renderValue(form);
    }

    @Override
    protected void renderEvent(FormInstance form) {
        if (this.getParentControls() == null) {
            super.renderEvent(form);
        }
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        this.attributes.put("value", this.defaultValue);
    }
}

