/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.Css;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.CommonCell;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.StringTool;

public class Ellipse
extends CommonCell {
    private static final long serialVersionUID = 1L;

    public Ellipse(Form pattern) {
        super(pattern);
        pattern.setOldPattern(true);
        this.tagName = "div";
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        String fillColor;
        StringBuffer sb = new StringBuffer();
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.cell.Ellipse({id:");
        sb.append(this.id);
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        sb.append(",needSave:false");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append(",isPrint:");
        sb.append(this.data.isPrint);
        sb.append(",top:");
        sb.append(this.top);
        sb.append(",left:");
        sb.append(this.left);
        sb.append(",width:");
        sb.append(this.width);
        sb.append(",height:");
        sb.append(this.height);
        sb.append(",lineWidth:");
        sb.append(this.data.lineWidth);
        String lineColor = this.getLineColor();
        if (lineColor != null) {
            sb.append(",lineColor:");
            sb.append("\"").append(lineColor).append("\"");
        }
        if ((fillColor = this.getFillColor()) != null) {
            sb.append(",fillColor:");
            sb.append("\"").append(fillColor).append("\"");
        }
        sb.append("}));");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    @Override
    public void setData(CellBean model) throws Exception {
        if (model == null) {
            return;
        }
        super.setData(model);
        this.id = this.data.cellId;
        this.setCellId(String.valueOf(this.cellPrefix) + this.id);
        if (this.data.bkColorStyle == null) {
            this.data.bkColorStyle = "";
        }
        if (this.data.bkColorStyle.length() > 0) {
            Css css = (Css)Form.getCss().get(this.data.bkColorStyle);
            if (css != null) {
                String cssText = css.getValue("background-color");
                if (cssText != null) {
                    this.attributes.put("fillcolor", cssText);
                } else {
                    this.attributes.put("fillcolor", SheetConstants.CELL.LINECOLOR);
                }
            } else {
                this.attributes.put("strokecolor", SheetConstants.CELL.LINECOLOR);
            }
        }
        this.classNames.remove("edit");
        this.setStyle();
        this.style.remove("border-width");
        this.style.remove("border-style");
        this.style.remove("border-color");
        if (this.data.createDate != null && this.data.createDate.length() != 0) {
            this.modifyTime = DateTool.parseDate(this.data.createDate);
        }
    }

    private String getLineColor() {
        String cssText;
        Css css = (Css)Form.getCss().get(this.data.borderStyle);
        if (css != null && (cssText = css.getValue("border-color")) != null) {
            return cssText;
        }
        return null;
    }

    private String getFillColor() {
        String cssText;
        Css css = (Css)Form.getCss().get(this.data.bkColorStyle);
        if (css != null && (cssText = css.getValue("background-color")) != null) {
            return cssText;
        }
        return null;
    }
}

