/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.form.model.CellActionBean;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.CommonCell;
import com.sdjxd.pms.platform.table.service.mean.FieldMean;
import com.sdjxd.pms.platform.table.service.mean.Text;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;

public class DynamicCell
extends CommonCell {
    private static final long serialVersionUID = 1L;
    protected Text[] verifyMeans;

    public DynamicCell(Form pattern) {
        super(pattern);
    }

    @Override
    public void addEvent(CellActionBean action) {
        if (!this.hasEvent("onblur")) {
            if (this.data.maxSize > 0) {
                this.addEvent("onblur", "if(CheckSize(" + this.cellId + "," + this.data.maxSize + ")==false) return false;");
            }
            this.addEvent("onblur", "com.sdjxd.pms.platform.form.Condition.prototype.isEnabled(sender)");
        }
        super.addEvent(action);
    }

    public void copy(FormInstance oldForm, FormInstance newForm) {
        FormCell[] cell = oldForm.getCell();
        if (cell[this.id] != null) {
            newForm.addText(this.id, cell[this.id].getText(), cell[this.id].getValue());
        }
    }

    public void deleteInstance(String formInstanceId, List sqlList) {
    }

    @Override
    public void save(FormInstance form, List list) {
        try {
            FormCell[] formCell = form.getCell();
            if (formCell[this.id] == null || !this.isNeedSave()) {
                return;
            }
            String textField1 = this.getTextField();
            String valueField1 = this.getValueField();
            boolean saveText = true;
            boolean saveValue = true;
            StringBuffer sql2 = new StringBuffer(256);
            int sortIndex = 0;
            String tableName = String.valueOf(this.pattern.getDataUserName()) + this.pattern.getTextTable();
            sql2.append("DELETE FROM ");
            sql2.append(tableName);
            sql2.append(" WHERE SHEETID='");
            sql2.append(form.getId());
            if (Form.FOrmType.equals("0")) {
                sql2.append("' AND CELLID=");
                sql2.append(this.data.entityAttrId);
            }
            list.add(sql2.toString());
            if (saveText || saveValue) {
                if (formCell[this.id] == null) {
                    return;
                }
                String text = formCell[this.id].getText();
                String cellValue = formCell[this.id].getValue();
                if (text == null) {
                    text = "";
                }
                if (cellValue == null) {
                    cellValue = "";
                }
                int valueLen = cellValue.length();
                int textLen = text.length();
                sortIndex = 0;
                while (sortIndex * 150 <= valueLen || sortIndex * 150 <= textLen) {
                    sql2.setLength(0);
                    String curValue = valueLen > (sortIndex + 1) * 150 ? cellValue.substring(sortIndex * 150, sortIndex * 150 + 150) : (valueLen <= (sortIndex + 1) * 150 && valueLen > sortIndex * 150 ? cellValue.substring(sortIndex * 150) : "");
                    String curText = textLen > (sortIndex + 1) * 150 ? text.substring(sortIndex * 150, sortIndex * 150 + 150) : (textLen <= (sortIndex + 1) * 150 && textLen > sortIndex * 150 ? text.substring(sortIndex * 150) : "");
                    sql2.append("INSERT INTO ");
                    sql2.append(tableName);
                    sql2.append("(SHEETID,CELLID,SORTID,CELLVALUE,CELLTEXT) VALUES('");
                    sql2.append(form.getId());
                    sql2.append("',");
                    sql2.append(this.data.entityAttrId);
                    sql2.append(",");
                    sql2.append(sortIndex);
                    sql2.append(",'");
                    if (saveValue) {
                        sql2.append(DbOper.toDb(curValue));
                    }
                    sql2.append("','");
                    if (saveText) {
                        sql2.append(DbOper.toDb(curText));
                    }
                    sql2.append("')");
                    list.add(sql2.toString());
                    ++sortIndex;
                }
            }
        }
        catch (Exception exp) {
            System.out.print(exp);
        }
    }

    @Override
    public void saveCell(FormInstance form, List list, int cellId) {
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        this.setCondition();
        this.setCommWordType();
        this.setTextField();
        this.setValueField();
        if (this.data.compareText != null && this.data.compareText.length() != 0) {
            this.attributes.put("t", this.data.compareText);
            this.attributes.put("ct", String.valueOf(this.data.compareTypeId));
        }
        if (this.data.maxSize > 0) {
            this.attributes.put("maxSize", String.valueOf(this.data.maxSize));
        }
        this.attributes.put("minfont", String.valueOf(this.data.fontId2));
        if (this.data.verifyMeans != null) {
            this.verifyMeans = new Text[this.data.verifyMeans.length];
            int i = 0;
            while (i < this.data.verifyMeans.length) {
                this.verifyMeans[i] = (Text)FieldMean.getInstance(this.data.verifyMeans[i]);
                ++i;
            }
        }
    }

    @Override
    protected void renderAttribute(FormInstance form) throws Exception {
        this.renderEnable(form);
        this.renderBlank(form);
        super.renderAttribute(form);
    }

    @Override
    protected void renderClass(FormInstance form) throws Exception {
        PrintWriter renderHtml1 = form.getRenderHtml();
        ((Writer)renderHtml1).write(" class=\"");
        this.renderCommonClass(form);
        if (this.id < form.getCell().length && form.getCell()[this.id] != null && form.getCell()[this.id].isEnabled()) {
            this.renderEditClass(form);
        } else {
            this.renderReadClass(form);
        }
        ((Writer)renderHtml1).write("\"");
    }

    @Override
    protected void setName(String cellName) {
        super.setName(cellName);
        this.attributes.put("title", cellName);
    }
}

