/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.form.SheetConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Dom
extends BaseClass {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String tagName = null;
    protected String cellBody = "";
    protected String position = SheetConstants.CELL.DEFAULTVALUE.POSITION;
    protected int top = 0;
    protected int left = 0;
    protected String width;
    protected String height;
    protected int tabindex = 0;
    protected boolean visible = true;
    protected TreeMap attributes = null;
    protected TreeMap style = new TreeMap();
    protected TreeMap classNames = new TreeMap();
    protected List controls = new ArrayList();

    public Dom() {
        this.attributes = new TreeMap();
    }

    public Dom(String tag) {
        this();
        this.tagName = tag;
    }

    public void add(String key, String value) {
        this.attributes.put(key, value);
    }

    public void remove(String key) {
        this.attributes.remove(key);
    }

    public void on(String eventName, String script) {
        this.add("on" + eventName, script);
    }

    public void un(String eventName) {
        this.remove("on" + eventName);
    }

    public void addStyle(String key, String value) {
        this.style.put(key, value);
    }

    public void removeStyle(String key) {
        this.style.remove(key);
    }

    public void addClass(String key, String value) {
        this.classNames.put(key, value);
    }

    public void removeClass(String key) {
        this.classNames.remove(key);
    }

    public void appendChild(Dom dom) {
        this.controls.add(dom);
    }

    public void render(StringBuffer html) {
        html.append("<");
        html.append(this.tagName);
        this.renderAttribute(html);
        if (this.isNeedClose()) {
            html.append(">");
        } else {
            html.append("/>");
        }
        int i = 0;
        while (i < this.controls.size()) {
            html.append("\n");
            ((Dom)this.controls.get(i)).render(html);
            ++i;
        }
        html.append(this.cellBody);
        if (this.isNeedClose()) {
            html.append("</");
            html.append(this.tagName);
            html.append(">");
        }
    }

    protected void renderAttribute(StringBuffer html) {
        for (Map.Entry entry : this.attributes.entrySet()) {
            html.append(" ").append(entry.getKey());
            html.append("=\"");
            html.append(entry.getValue());
            html.append("\"");
        }
        this.renderStyle(html);
        this.renderClass(html);
    }

    protected void renderStyle(StringBuffer html) {
        if (this.style.size() <= 0) {
            return;
        }
        html.append(" style=\"");
        for (Map.Entry entry : this.style.entrySet()) {
            html.append(entry.getKey());
            html.append(":");
            html.append(entry.getValue());
            html.append(";");
        }
        html.append("\"");
    }

    protected void renderClass(StringBuffer html) {
        if (this.classNames.size() <= 0) {
            return;
        }
        html.append(" class=\"");
        for (Map.Entry entry : this.classNames.entrySet()) {
            html.append(" ");
            html.append(entry.getValue());
        }
        html.append("\"");
    }

    public String getCellBody() {
        return this.cellBody;
    }

    public void setCellBody(String cellBody) {
        this.cellBody = cellBody;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
        this.addStyle("height", this.height);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.add("id", this.id);
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
        this.addStyle("left", "" + this.left);
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
        this.addStyle("position", this.position);
    }

    public int getTabindex() {
        return this.tabindex;
    }

    public void setTabindex(int tabindex) {
        this.tabindex = tabindex;
        this.add("tabindex", "" + tabindex);
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
        this.addStyle("top", "" + this.top);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.addStyle("display", visible ? "inline" : "none");
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
        this.addStyle("width", width);
    }

    public boolean isNeedClose() {
        if ("INPUT".equalsIgnoreCase(this.tagName)) {
            return false;
        }
        return !"IMG".equalsIgnoreCase(this.tagName);
    }

    public void addCet(Class A) {
        String className = A.getName();
        int index = className.lastIndexOf(".") + 1;
        this.add("cet", className.substring(index));
    }
}

