/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.form.model.CellActionBean;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.Text;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.StringTool;
import java.io.PrintWriter;
import java.io.Writer;

public class DateTime
extends Text {
    private static final long serialVersionUID = 1L;
    protected String fieldMeanValue;

    public DateTime(Form pattern) {
        super(pattern);
        pattern.setOldPattern(true);
    }

    @Override
    public void addEvent(CellActionBean action) {
        if (!this.hasEvent("onclick")) {
            this.addEvent("onclick", "sender.popupCalendar()");
        }
        this.addEvent("onblur", "");
        super.addEvent(action);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        String[] mean = (String[])StringTool.strToArray(this.data.fieldMeanValue);
        this.fieldMeanValue = mean != null && mean.length > 0 ? mean[0] : "yyyy-MM-dd HH:mm:ss";
        this.attributes.put("readonly", "true");
        this.attributes.put("a", this.fieldMeanValue);
    }

    @Override
    protected void renderEnable(FormInstance form) throws Exception {
        if (this.id < form.getCell().length && form.getCell()[this.id] != null && !form.getCell()[this.id].isEnabled()) {
            PrintWriter renderHtml = form.getRenderHtml();
            ((Writer)renderHtml).write(" d=1");
        }
    }

    @Override
    public String getValue(FormCell formCell) {
        return formCell.getValue();
    }

    protected void renderEnable() throws Exception {
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        StringBuffer sb = new StringBuffer();
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.cell.DateTime({id:");
        sb.append(this.id);
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        sb.append(",format:\"");
        sb.append(this.fieldMeanValue);
        sb.append("\",value:\"");
        sb.append(form.getCell()[this.id].getValue());
        if (Form.FOrmType.equals("0")) {
            sb.append("\",needSave:");
            sb.append(this.isNeedSave());
            sb.append(",bgColorStyle:'").append(this.data.bkColorStyle).append("'");
            sb.append(",readOnlyBgColorStyle:'").append(this.data.readBkColorStyle).append("'");
            sb.append(",showName:\"" + this.cellName + "\"");
            sb.append(",label:\"" + StringTool.toJson(this.label) + "\"");
        }
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        if (this.data.checkCondition != -1) {
            sb.append(",conditionId:" + this.data.checkCondition);
        }
        sb.append("}));");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    @Override
    public void render(FormInstance form) throws Exception {
        FormCell[] formCell = form.getCell();
        if (this.id < formCell.length && formCell[this.id] != null && formCell[this.id].getValue() != null && formCell[this.id].getValue().length() != 0 && (formCell[this.id].getText() == null || formCell[this.id].getText().length() == 0)) {
            formCell[this.id].setText(DateTool.formatDate(formCell[this.id].getValue(), this.fieldMeanValue));
        }
        super.render(form);
    }

    @Override
    public void setDefault(FormInstance form) {
        super.setDefault(form);
        FormCell formCell = form.getCell()[this.id];
        formCell.setValue(formCell.getText());
        formCell.setText(DateTool.formatDate(formCell.getText(), this.fieldMeanValue));
    }
}

