/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.Css;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.CommonCell;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.StringTool;

public class DashLine
extends CommonCell {
    private static final long serialVersionUID = 1L;
    protected static String[] DASHTYPE = new String[]{"dash", "dot", "dashdot"};
    protected int dashType;

    public DashLine(Form pattern) {
        super(pattern);
        this.tagName = "v:line";
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        StringBuffer sb = new StringBuffer();
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.cell.Line({id:");
        sb.append(this.id);
        sb.append(",typeName:'Line'");
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        sb.append(",needSave:false");
        sb.append(",isDashType:true");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append(",lineType:");
        sb.append(this.dashType);
        sb.append("}));");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    @Override
    public void setData(CellBean model) throws Exception {
        if (model == null) {
            return;
        }
        super.setData(model);
        this.id = this.data.cellId;
        this.setCellId(String.valueOf(this.cellPrefix) + this.id);
        if (this.data.readBkColorStyle == null) {
            this.data.readBkColorStyle = "";
        }
        if (this.data.readBkColorStyle.length() == 0) {
            this.attributes.put("strokecolor", SheetConstants.CELL.LINECOLOR);
        } else {
            Css css = (Css)Form.getCss().get(this.data.readBkColorStyle);
            if (css != null) {
                String cssText = css.getValue("background-color");
                if (cssText != null) {
                    this.attributes.put("strokecolor", cssText);
                } else {
                    this.attributes.put("strokecolor", SheetConstants.CELL.LINECOLOR);
                }
            } else {
                this.attributes.put("strokecolor", SheetConstants.CELL.LINECOLOR);
            }
        }
        this.setStyle();
        this.style.remove("border-width");
        this.style.remove("border-style");
        this.style.remove("border-color");
        this.attributes.put("strokeweight", String.valueOf(this.data.lineWidth) + "px");
        this.attributes.put("from", "0,0");
        this.attributes.put("to", String.valueOf(this.data.width) + "," + this.data.height);
        if (this.data.createDate != null && this.data.createDate.length() != 0) {
            this.modifyTime = DateTool.parseDate(this.data.createDate);
        }
        this.dashType = this.data.assitInfo == null || this.data.assitInfo.length() == 0 ? 0 : Integer.parseInt(this.data.assitInfo);
        this.cellBody = "<v:Stroke dashstyle=\"" + DASHTYPE[this.dashType] + "\"></v:Stroke>";
    }
}

