/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.CellIndex;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.cell.VisualCell;
import java.util.List;

public class CommonCell
extends VisualCell {
    private static final long serialVersionUID = 1L;
    protected String meanDataSourceName;

    public CommonCell(Form pattern) {
        super(pattern);
        this.cellPrefix = SheetConstants.CELL.CELL_PREFIX;
    }

    protected void setValueField() {
        if (this.data.valueField != null && this.data.valueField.length() != 0) {
            this.valueField = this.data.valueField;
            this.attributes.put("v", this.valueField);
            CellIndex cellIndex = (CellIndex)this.pattern.getCellIndex().get(this.valueField);
            if (cellIndex != null) {
                cellIndex.setCell(CellIndex.VALUE, this.id);
            }
        }
    }

    protected void setTextField() {
        if (this.data.textField != null && this.data.textField.length() != 0) {
            this.textField = this.data.textField;
            this.attributes.put("t", this.textField);
            CellIndex cellIndex = (CellIndex)this.pattern.getCellIndex().get(this.textField);
            if (cellIndex != null) {
                cellIndex.setCell(CellIndex.TEXT, this.id);
            }
        }
    }

    @Override
    protected void setParentControls(ICell parentControls) {
        if (this.getParentControls() == null) {
            this.pattern.removeCell(this);
        }
        super.setParentControls(parentControls);
        if (parentControls != null) {
            this.setPosition(parentControls.getChildPosition());
        }
    }

    @Override
    public void setData(CellBean model) throws Exception {
        if (model == null) {
            return;
        }
        super.setData(model);
        this.meanDataSourceName = model.meanDataSourceName;
        this.setGroup();
        this.setLimit(model.limit);
        if (model.readonly == 0) {
            this.setReadonly(true);
        } else {
            this.setReadonly(false);
        }
    }

    public void setData(CellBean model, List sbList) throws Exception {
    }

    public String getMeanDataSourceName() {
        return this.meanDataSourceName;
    }
}

