/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.hussar.core.base72.GlobalSql;
import com.sdjxd.pms.platform.Rubbish.IDStringPicker;
import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.model.CellActionBean;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.ComboBoxColumnMeanBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.DynamicCell;
import com.sdjxd.pms.platform.form.service.cell.HtmlSelect;
import com.sdjxd.pms.platform.form.service.cell.Text;
import com.sdjxd.pms.platform.tool.CheckClient;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.util.ArrayList;
import java.util.Map;

public class ComboBox
extends DynamicCell {
    private static final long serialVersionUID = 1L;
    protected static String EDIT = "1";
    protected static String MULTI = "1";
    protected static String PYJS = "1";
    protected Text text;
    protected HtmlSelect select;
    protected boolean isEditable;
    protected boolean isMulti = false;
    protected boolean isPyjs = false;
    protected boolean isAddNullOption = false;
    protected String optionInfo;
    protected String fieldMeanValue;
    protected boolean isShowSelect;

    public ComboBox(Form pattern) {
        super(pattern);
        pattern.setOldPattern(true);
        this.setPattern(pattern);
        this.text = (Text)BeanFactory.getClass("Text", new Object[]{pattern});
        this.select = (HtmlSelect)BeanFactory.getClass("HtmlSelect", new Object[]{pattern});
        this.isEditable = false;
        this.optionInfo = "";
        this.isShowSelect = false;
    }

    @Override
    public String getValueAttribute() {
        return "cv";
    }

    @Override
    public void setData(CellBean model) throws Exception {
        Object[] assitInfo;
        if (model.fieldMeanValue != null && model.fieldMeanValue.length() != 0) {
            Object[] assitInfos = StringTool.strToArray(model.fieldMeanValue);
            this.optionInfo = model.fieldMeanValue;
            if (assitInfos.length > 1) {
                this.isEditable = assitInfos[2].equals(EDIT);
            }
            if (assitInfos.length > 2) {
                this.isMulti = assitInfos[3].equals(MULTI);
            }
            if (assitInfos.length > 3) {
                this.isPyjs = assitInfos[4].equals(PYJS);
            }
            if (assitInfos.length > 4) {
                this.isAddNullOption = assitInfos[5].equals("1");
            }
        }
        if (model.assitInfo != null && !model.assitInfo.equals("") && (assitInfo = StringTool.strToArray(model.assitInfo)) != null && assitInfo.length > 0 && ((String)assitInfo[0]).equals("1")) {
            this.isShowSelect = true;
        }
        this.meanDataSourceName = model.meanDataSourceName;
        this.fieldMeanValue = model.fieldMeanValue;
        super.setData(model);
        this.text.setParentControls(this);
        this.text.setData(model);
        this.text.setReadonly(!this.isEditable);
        this.attributes.put("title", "");
        if (!this.isMulti) {
            this.select.setData(model);
            this.select.setCellId(String.valueOf(this.cellId) + "select");
            this.select.getData().assitInfo = this.optionInfo;
            if (this.isShowSelect) {
                this.text.getStyle().put("visibility", "hidden");
            } else {
                this.select.getStyle().put("visibility", "hidden");
            }
            this.select.setBelongSelect(this);
            this.select.setParentControls(this);
            this.select.setAddNullOption(this.isAddNullOption);
        }
        this.text.setParentControls(this);
    }

    @Override
    public void render(FormInstance form) throws Exception {
        this.renderChild(form);
        this.renderScriptObject(form);
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.text.setVisible(visible);
    }

    @Override
    public void addEvent(CellActionBean action) {
        if (this.isEditable) {
            this.text.addEvent("ondblclick", "com.sdjxd.pms.platform.form.cell.ComboBox.showSelect(" + this.text.getCellId() + "," + this.id + ")");
        } else {
            this.text.addEvent("onfocus", "com.sdjxd.pms.platform.form.cell.ComboBox.showSelect(" + this.text.getCellId() + "," + this.id + ")");
        }
        if (this.label == null || !this.label.equals("[NOSAVE]")) {
            this.text.addEvent("onchange", "doChange(this)");
        } else {
            this.text.label = "";
            this.label = "";
        }
        if (!this.isMulti) {
            this.text.addEvent("onblur", "com.sdjxd.pms.platform.form.cell.ComboBox.showSelectText(" + this.text.getCellId() + ", sender)");
        }
        this.text.addEvent(action);
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        StringBuffer sb = new StringBuffer();
        ComboBoxColumnMeanBean bean = new ComboBoxColumnMeanBean(this.meanDataSourceName, this.fieldMeanValue, this.getLimitInfoArray());
        sb.append("var cmbMean" + this.id);
        sb.append(" = new com.sdjxd.pms.platform.form.cell.ComboBoxColumnMean({");
        if (!"".equals(bean.assistInfo)) {
            sb.append("assistInfo:").append(bean.assistInfo);
        }
        if (!"".equals(bean.dataSourceName)) {
            sb.append(",dataSourceName:\"").append(bean.dataSourceName).append("\"");
        }
        if (bean.fillMode != 0) {
            sb.append(",fillMode:").append(bean.fillMode);
        }
        if (!"".equals(bean.id)) {
            sb.append(",id:\"").append(bean.id).append("\"");
        }
        if (!"".equals(bean.moduleName)) {
            sb.append(",moduleName:\"").append(bean.moduleName).append("\"");
        }
        if (!"".equals(bean.name)) {
            sb.append(",name:\"").append(bean.name).append("\"");
        }
        sb.append("});\r\n");
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.cell.ComboBox({id:");
        sb.append(this.id);
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",isShowSelect:").append(this.isShowSelect);
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        sb.append(",bgColorStyle:'").append(this.data.bkColorStyle).append("'");
        sb.append(",readOnlyBgColorStyle:'").append(this.data.readBkColorStyle).append("'");
        sb.append(",showName:\"" + this.cellName + "\"");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append(",needSave:");
        sb.append(this.isNeedSave());
        sb.append("}, cmbMean");
        sb.append(this.id);
        sb.append("));");
        if (this.isMulti && (DataModify.NEW.is(form.getModify()) && this.getDefaultValueTime() != 1 || StringTool.isEmpty(form.getCellValue(this.id)) && this.getDefaultValueTime() == 1 && form.getCell()[this.id].isEnabled())) {
            String defaultValue = this.label;
            sb.append("defaultForm.getCellById(").append(this.id).append(").setDefault(").append(StringTool.replaceKeyWord(defaultValue)).append(");");
        }
        if (this.isEditable && this.data.maxSize > 0) {
            sb.append("defaultForm.getCellById(").append(this.id).append(").getTag().attachEvent(\"onblur\",function(){CheckSize(" + this.cellId + "," + this.data.maxSize + ")})");
        }
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    public String getFieldMeanValue() {
        return this.fieldMeanValue;
    }

    public static ArrayList[] refresh(String dataSourceName, String assistInfo) {
        if ("1".equals(Global.getConfig("isSafeMode"))) {
            return null;
        }
        ComboBoxColumnMeanBean bean = new ComboBoxColumnMeanBean(dataSourceName, assistInfo, null);
        return bean.refresh();
    }

    public static ArrayList[] refresh(String dataSourceName, String assistInfo, String formId, int cellId) throws Exception {
        String defenseSQLInjection = Global.getConfig("defenseSQLInjection");
        if ("true".equalsIgnoreCase(defenseSQLInjection)) {
            throw new Exception("\u542f\u7528\u9632sql\u6ce8\u5165\u65f6\uff0c\u7981\u6b62\u8c03\u7528\u8be5\u65b9\u6cd5\uff01");
        }
        if (!"1".equals(Global.getConfig("isSafeMode")) || cellId == -1) {
            return ComboBox.refresh(dataSourceName, assistInfo);
        }
        IDStringPicker idStringPicker = new IDStringPicker();
        String fieldMeanValue = idStringPicker.getFieldMeanValue(formId, cellId);
        ComboBoxColumnMeanBean beanCell = new ComboBoxColumnMeanBean(dataSourceName, fieldMeanValue, null);
        ComboBoxColumnMeanBean beanClient = new ComboBoxColumnMeanBean(dataSourceName, assistInfo, null);
        CheckClient check = new CheckClient();
        if (!check.checkFilter(beanClient.filter)) {
            return null;
        }
        if (beanClient.filter != null && !beanClient.filter.equals("")) {
            beanCell.filter = String.valueOf(beanCell.filter) + " and (";
            beanCell.filter = String.valueOf(beanCell.filter) + beanClient.filter.substring(6);
            beanCell.filter = String.valueOf(beanCell.filter) + ")";
        }
        return beanCell.refresh();
    }

    public static ArrayList[] refreshByQueryParam(String dataSourceName, String formId, int cellId, Map<String, Object> queryParam) throws Exception {
        IDStringPicker idStringPicker = new IDStringPicker();
        String fieldMeanValue = idStringPicker.getFieldMeanValue(formId, cellId);
        ComboBoxColumnMeanBean beanCell = new ComboBoxColumnMeanBean(dataSourceName, fieldMeanValue, null);
        String filterSql = GlobalSql.getQuerySql(queryParam);
        if (!StringTool.isEmpty(filterSql)) {
            beanCell.filter = " where " + filterSql;
        }
        return beanCell.refresh();
    }

    public static ArrayList[] refreshByQueryParam(String dataSourceName, String meanId, Map<String, Object> queryParam) throws Exception {
        IDStringPicker idStringPicker = new IDStringPicker();
        String fieldMeanValue = idStringPicker.getFieldMeanValue(meanId);
        ComboBoxColumnMeanBean beanCell = new ComboBoxColumnMeanBean(dataSourceName, fieldMeanValue, null);
        String filterSql = GlobalSql.getQuerySql(queryParam);
        if (!StringTool.isEmpty(filterSql)) {
            beanCell.filter = " where " + filterSql;
        }
        return beanCell.refresh();
    }
}

