/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.Css;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.CommonCell;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.StringTool;

public class Circle
extends CommonCell {
    private static final long serialVersionUID = 1L;

    public Circle(Form pattern) {
        super(pattern);
        this.tagName = "v:oval";
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        StringBuffer sb = new StringBuffer();
        sb.append("defaultForm.cellArray.push(new com.sdjxd.pms.platform.form.cell.Circle({id:");
        sb.append(this.id);
        sb.append(",typeName:'Circle'");
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append(",needSave:false");
        sb.append("}));");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    @Override
    public void setData(CellBean model) throws Exception {
        if (model == null) {
            return;
        }
        super.setData(model);
        this.id = this.data.cellId;
        this.setCellId(String.valueOf(this.cellPrefix) + this.id);
        if (this.data.readBkColorStyle == null) {
            this.data.readBkColorStyle = "";
        }
        if (this.data.readBkColorStyle.length() > 0) {
            Css css = (Css)Form.getCss().get(this.data.readBkColorStyle);
            if (css != null) {
                String cssText = css.getValue("background-color");
                if (cssText != null) {
                    this.attributes.put("fillcolor", cssText);
                } else {
                    this.attributes.put("fillcolor", SheetConstants.CELL.LINECOLOR);
                }
            } else {
                this.attributes.put("strokecolor", SheetConstants.CELL.LINECOLOR);
            }
        }
        this.setStyle();
        this.style.remove("border-width");
        this.style.remove("border-style");
        this.style.remove("border-color");
        if (this.data.createDate != null && this.data.createDate.length() != 0) {
            this.modifyTime = DateTool.parseDate(this.data.createDate);
        }
    }
}

