/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.dao.DataConst;
import com.sdjxd.pms.platform.form.model.CellActionBean;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.CellEvent;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.StringTool;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class Cell
extends BaseClass
implements ICell {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Cell.class);
    public static int MAXEVENT = 100;
    protected TreeMap attributes = null;
    protected boolean blank = true;
    protected int border = 0;
    protected String childPosition;
    protected String cellId = null;
    protected int cellType;
    protected TreeMap classNames = null;
    protected String[] commWordType = null;
    protected List controls = null;
    protected int condition;
    protected String cellBody = "";
    protected String cellName = null;
    protected String cellPrefix = "";
    protected CellBean data = null;
    protected boolean enabled = true;
    protected CellEvent[] events;
    protected int[] groups = null;
    protected boolean hasRender = false;
    protected int height = 0;
    protected String heightScale;
    protected int id = -1;
    protected StringBuffer initScript;
    protected String label = null;
    protected int defaultValueTime;
    protected int left = 0;
    protected int limit = 1;
    protected Date modifyTime;
    protected String position = SheetConstants.CELL.DEFAULTVALUE.POSITION;
    protected boolean print = true;
    protected boolean readonly = false;
    protected StringBuffer renderHtml = null;
    protected TreeMap style = null;
    protected int tabindex = 0;
    protected String tagName = null;
    protected String textField;
    protected int top = 0;
    protected int width = 0;
    protected String widthScale;
    protected String valueField;
    protected boolean visible = true;
    private TreeMap contextMenu = null;
    private ICell parentControls = null;
    public String userDefinfo;

    public Cell() {
        this.events = new CellEvent[MAXEVENT];
        this.controls = new ArrayList();
        this.attributes = new TreeMap();
        String className = this.getClass().getName();
        int index = className.lastIndexOf(".") + 1;
        this.attributes.put("cet", className.substring(index));
    }

    @Override
    public void addEvent(CellActionBean action) {
        if (action == null) {
            return;
        }
        int eventId = action.getEventId();
        CellEvent event = this.events[eventId];
        if (event != null) {
            event.addAction(action);
        } else {
            this.events[eventId] = new CellEvent(action);
        }
    }

    @Override
    public void addEvent(String eventCode, String strAction) {
        CellEvent cellEvent = this.getEvent(eventCode);
        if (cellEvent != null) {
            cellEvent.addAction(this.id, strAction);
        } else {
            int eventId = CellEvent.getEventId(eventCode);
            if (eventId >= 0) {
                this.events[eventId] = cellEvent = new CellEvent(eventId, this.id, strAction);
            } else {
                log.error((Object)("\u672a\u5904\u7406\u7684\u4e8b\u4ef6\uff1a" + eventCode));
            }
        }
    }

    public void clearEvent() {
        int i = 0;
        while (i < MAXEVENT) {
            this.events[i] = null;
            ++i;
        }
    }

    @Override
    public TreeMap getAttributes() {
        return this.attributes;
    }

    public CellEvent getEvent(String eventCode) {
        int i = 0;
        while (i < MAXEVENT) {
            if (this.events[i] != null && this.events[i].getEventCode().equals(eventCode)) {
                return this.events[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public ArrayList getEventForMobile() {
        ArrayList<ArrayList> eventsList = new ArrayList<ArrayList>();
        int i = 0;
        while (i < this.events.length) {
            ArrayList eventList;
            if (this.events[i] != null && (eventList = this.events[i].getEventForMobile()) != null) {
                eventsList.add(eventList);
            }
            ++i;
        }
        if (eventsList.size() == 0) {
            return null;
        }
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        list.add(new Integer(this.id));
        list.add(eventsList);
        return list;
    }

    public int getBorder() {
        return this.border;
    }

    public String getCellBody() {
        return this.cellBody;
    }

    public String getCellId() {
        return this.cellId;
    }

    @Override
    public String getCellName() {
        return this.cellName;
    }

    public String getCellPrefix() {
        return this.cellPrefix;
    }

    @Override
    public int getCellType() {
        return this.cellType;
    }

    @Override
    public String getChildPosition() {
        if (this.childPosition == null) {
            if (this.parentControls != null) {
                return this.parentControls.getChildPosition();
            }
            return SheetConstants.CELL.DEFAULTVALUE.CHILD_POSITION;
        }
        return this.childPosition;
    }

    public String[] getCommWordType() {
        return this.commWordType;
    }

    public int getCondition() {
        return this.condition;
    }

    @Override
    public List getControls() {
        return this.controls;
    }

    public CellBean getData() {
        return this.data;
    }

    public int[] getGroups() {
        return this.groups;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public int getLeft() {
        return this.left;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public ICell getParentControls() {
        return this.parentControls;
    }

    public StringBuffer getRenderHtml() {
        return this.renderHtml;
    }

    public void getRenderHtml(FormInstance form) throws Exception {
        this.render(form);
    }

    public TreeMap getStyle() {
        return this.style;
    }

    public int getTabindex() {
        return this.tabindex;
    }

    public String getTableLinkId() {
        return this.data.tableLinkId;
    }

    public String getLimitInfo() {
        return this.data.LimitInfo;
    }

    @Override
    public String[] getLimitInfoArray() {
        Object[] temp = StringTool.strToArray(this.data.LimitInfo);
        if (temp == null || temp.length == 0) {
            return null;
        }
        return (String[])temp;
    }

    public String getTagName() {
        return this.tagName;
    }

    @Override
    public String getText(FormCell formCell) {
        return formCell.getText();
    }

    public String getTextAttribute() {
        return "value";
    }

    @Override
    public String getTextField() {
        return this.textField;
    }

    public int getTop() {
        return this.top;
    }

    @Override
    public String getValue(FormCell formCell) {
        return formCell.getText();
    }

    public String getValueAttribute() {
        return "value";
    }

    @Override
    public String getValueField() {
        return this.valueField;
    }

    public int getWidth() {
        return this.width;
    }

    public String getWidthScale() {
        return this.widthScale;
    }

    public boolean hasEvent(String eventCode) {
        if (eventCode == null || eventCode.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < MAXEVENT) {
            if (this.events[i] != null && eventCode.equals(this.events[i].getEventCode())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isBlank() {
        return this.blank;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isHasRender() {
        return this.hasRender;
    }

    public boolean isNeedSave() {
        return this.data.isNeedSave == 1;
    }

    public boolean isPrint() {
        return this.print;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void render(FormInstance form) throws Exception {
        this.renderInstanceValue(form);
        this.renderStartTag(form);
        this.renderChild(form);
        this.renderBody(form);
        this.renderEndTag(form);
        this.renderContextMenu(form);
        this.renderScriptObject(form);
    }

    public void renderInstanceValue(FormInstance form) {
    }

    @Override
    public void renderAfterEnd(FormInstance form) throws Exception {
    }

    @Override
    public void save(FormInstance form, List sql2) {
    }

    public void setBlank(boolean blank) {
        this.blank = blank;
    }

    public void setCellBody(String cellBody) {
        this.cellBody = cellBody;
    }

    @Override
    public void setData(CellBean model) throws Exception {
        if (model == null) {
            return;
        }
        this.data = model;
        this.cellType = model.cellType;
        this.id = model.cellId;
        this.label = model.cellLabel;
        this.defaultValueTime = model.defaultValueTime;
        this.setCellId(String.valueOf(this.cellPrefix) + this.id);
        this.setName(model.cellName);
        this.userDefinfo = model.userDefinfo;
        if (model.createDate != null && model.createDate.length() != 0) {
            this.modifyTime = DateTool.parseDate(model.createDate);
        }
    }

    @Override
    public void setDefault(FormInstance form) {
        String defaultValue = this.label;
        String cellType = SheetConstants.CELL.getType(this.cellType);
        if (cellType.equals("ComboBox") || cellType.equals("Check")) {
            return;
        }
        defaultValue = StringTool.replaceKeyWord(defaultValue, form);
        defaultValue = FormInstance.replaceParaValue(defaultValue, form);
        int i = 0;
        while (i < this.controls.size()) {
            ((ICell)this.controls.get(i)).setDefault(form);
            ++i;
        }
        if (!StringTool.isEmpty(defaultValue)) {
            form.getCell()[this.id].setText(defaultValue);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getHeightScale() {
        return this.heightScale;
    }

    public void setHeightScale(String heightScale) {
        if (this.heightScale != null && (heightScale.length() == 0 || heightScale.equals("0"))) {
            this.heightScale = null;
        } else {
            this.heightScale = heightScale;
            this.style.put("height", this.heightScale);
        }
    }

    public void setLimit(int limit) {
        this.limit = limit;
        switch (limit) {
            case 0: {
                this.setVisible(false);
                this.setEnabled(false);
                this.setBlank(false);
                break;
            }
            case 1: {
                this.setVisible(true);
                this.setEnabled(false);
                this.setBlank(false);
                break;
            }
            case 2: {
                this.setVisible(true);
                this.setEnabled(true);
                this.setBlank(false);
                break;
            }
            case 3: {
                this.setVisible(true);
                this.setEnabled(true);
                this.setBlank(true);
                break;
            }
            default: {
                this.setVisible(true);
                this.setEnabled(false);
                this.setBlank(false);
            }
        }
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setWidthScale(String widthScale) {
        if (widthScale != null && (widthScale.length() == 0 || widthScale.equals("0"))) {
            this.widthScale = null;
        } else {
            this.widthScale = widthScale;
            this.style.put("width", this.widthScale);
        }
    }

    protected String attributeToString(String key, String value) {
        StringBuffer sb = new StringBuffer(128);
        sb.append(" ").append(key);
        sb.append("=\"").append(value);
        sb.append("\"");
        return sb.toString();
    }

    protected TreeMap getClassNames() {
        return this.classNames;
    }

    protected String getPosition() {
        return this.position;
    }

    @Override
    public void noRender() {
        this.hasRender = false;
    }

    protected void renderAttribute(FormInstance form) throws Exception {
        this.renderCommonAttribute(form);
    }

    protected void renderBlank(FormInstance form) throws Exception {
        if (this.id < form.getCell().length && form.getCell()[this.id] != null && !form.getCell()[this.id].isBlank() && form.getCell()[this.id].isEnabled()) {
            PrintWriter renderHtml1 = form.getRenderHtml();
            ((Writer)renderHtml1).write(" b=\"");
            ((Writer)renderHtml1).write(SheetConstants.HTML.ATTFALSE);
            ((Writer)renderHtml1).write("\"");
        }
    }

    protected void renderBody(FormInstance form) throws Exception {
        PrintWriter renderHtml1 = form.getRenderHtml();
        if (this.cellBody != null) {
            this.cellBody = StringTool.replaceKeyWord(this.cellBody);
            ((Writer)renderHtml1).write(this.cellBody);
        }
    }

    protected void renderChild(FormInstance form) throws Exception {
        if (this.controls == null) {
            return;
        }
        PrintWriter renderHtml1 = form.getRenderHtml();
        int i = 0;
        while (i < this.controls.size()) {
            ((ICell)this.controls.get(i)).render(form);
            ++i;
        }
    }

    protected void renderClass(FormInstance form) throws Exception {
        PrintWriter renderHtml1 = form.getRenderHtml();
        ((Writer)renderHtml1).write(" class=\"");
        this.renderCommonClass(form);
        ((Writer)renderHtml1).write("\"");
    }

    protected void renderCommonAttribute(FormInstance form) throws Exception {
        PrintWriter renderHtml1 = form.getRenderHtml();
        for (Map.Entry entry : this.attributes.entrySet()) {
            ((Writer)renderHtml1).write(" ");
            ((Writer)renderHtml1).write(entry.getKey().toString());
            ((Writer)renderHtml1).write("=\"");
            if (entry.getValue() != null) {
                if ("width".equalsIgnoreCase(entry.getKey().toString().trim()) || "left".equalsIgnoreCase(entry.getKey().toString().trim())) {
                    Object mobileRate = Global.getContext().getSession("weChatAdaptRate");
                    if (mobileRate != null) {
                        if ("width".equalsIgnoreCase(entry.getKey().toString().trim()) && entry.getValue().toString().indexOf("%") > -1) {
                            ((Writer)renderHtml1).append(entry.getValue().toString());
                        } else {
                            double actData;
                            String pData = entry.getValue().toString().trim();
                            if (pData.indexOf("px") > -1) {
                                pData = pData.substring(0, pData.indexOf("px"));
                            }
                            if ((actData = Double.parseDouble(pData) * Double.parseDouble(mobileRate.toString().trim())) < 1.0) {
                                actData = 1.0;
                            }
                            ((Writer)renderHtml1).append(String.valueOf(actData) + "px");
                        }
                    } else {
                        ((Writer)renderHtml1).append(entry.getValue().toString());
                    }
                } else {
                    ((Writer)renderHtml1).write(entry.getValue().toString());
                }
            }
            ((Writer)renderHtml1).write("\"");
        }
    }

    protected void renderCommonClass(FormInstance form) throws Exception {
        if (this.classNames == null) {
            return;
        }
        PrintWriter renderHtml1 = form.getRenderHtml();
        StringBuffer className = new StringBuffer(16);
        for (Map.Entry entry : this.classNames.entrySet()) {
            String key = entry.getKey().toString();
            if (key.equals("read") || key.equals("edit")) continue;
            className.append(" ").append(entry.getValue().toString());
        }
        if (className.length() > 1) {
            ((Writer)renderHtml1).write(className.substring(1));
        }
    }

    protected void renderCommonStyle(FormInstance form) throws Exception {
        PrintWriter renderHtml1 = form.getRenderHtml();
        StringBuffer styles = new StringBuffer(128);
        for (Map.Entry entry : this.style.entrySet()) {
            styles.append(entry.getKey().toString());
            styles.append(":");
            if ("width".equalsIgnoreCase(entry.getKey().toString().trim()) || "left".equalsIgnoreCase(entry.getKey().toString().trim())) {
                Object mobileRate = Global.getContext().getSession("weChatAdaptRate");
                if (mobileRate != null) {
                    if ("width".equalsIgnoreCase(entry.getKey().toString().trim()) && entry.getValue().toString().indexOf("%") > -1) {
                        styles.append(entry.getValue().toString());
                    } else {
                        double actData;
                        String pData = entry.getValue().toString().trim();
                        if (pData.indexOf("px") > -1) {
                            pData = pData.substring(0, pData.indexOf("px"));
                        }
                        if ((actData = Double.parseDouble(pData) * Double.parseDouble(mobileRate.toString().trim())) < 1.0 && actData != 0.0) {
                            actData = 1.0;
                        }
                        styles.append(String.valueOf(actData) + "px");
                    }
                } else {
                    styles.append(entry.getValue().toString());
                }
            } else {
                styles.append(entry.getValue().toString());
            }
            styles.append(";");
        }
        ((Writer)renderHtml1).write(styles.toString());
    }

    protected void renderContextMenu(FormInstance form) throws Exception {
        PrintWriter renderHtml1 = form.getRenderHtml();
        if (this.contextMenu == null || this.contextMenu.isEmpty() || renderHtml1 == null) {
            return;
        }
        ((Writer)renderHtml1).write("<div id=\"menu");
        ((Writer)renderHtml1).write(this.id);
        ((Writer)renderHtml1).write("\" onclick=\"hiddenMenu(");
        ((Writer)renderHtml1).write(this.id);
        ((Writer)renderHtml1).write(")\" onblur=\"hiddenMenu(");
        ((Writer)renderHtml1).write(this.id);
        ((Writer)renderHtml1).write(")\" style=\"display:none;position:absolute;z-index:101;background-color:#ffffe1;border:1px solid #000000;font-size:12px\"><table>");
        for (Map.Entry entry : this.contextMenu.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            ((Writer)renderHtml1).write("<tr><td><a href=\"#\" onclick=\"");
            ((Writer)renderHtml1).write(value);
            ((Writer)renderHtml1).write("\">");
            ((Writer)renderHtml1).write(key);
            ((Writer)renderHtml1).write("</a></td></tr>");
        }
        ((Writer)renderHtml1).write("</table></div>");
    }

    protected void renderEditClass(FormInstance form) throws Exception {
        if (this.classNames == null) {
            return;
        }
        PrintWriter renderHtml1 = form.getRenderHtml();
        if (this.id < form.getCell().length && form.getCell()[this.id] != null && this.classNames.containsKey("edit")) {
            ((Writer)renderHtml1).write(" ");
            ((Writer)renderHtml1).write(this.classNames.get("edit").toString());
        }
    }

    protected void renderEnable(FormInstance form) throws Exception {
        if (this.id < form.getCell().length && form.getCell()[this.id] != null && !form.getCell()[this.id].isEnabled()) {
            PrintWriter renderHtml1 = form.getRenderHtml();
            ((Writer)renderHtml1).write(" d=1 disabled=\"");
            ((Writer)renderHtml1).write(SheetConstants.HTML.ATTTRUE);
            ((Writer)renderHtml1).write("\"");
        }
    }

    protected void renderEndTag(FormInstance form) throws Exception {
        PrintWriter renderHtml1 = form.getRenderHtml();
        ((Writer)renderHtml1).write("</");
        ((Writer)renderHtml1).write(this.tagName);
        ((Writer)renderHtml1).write(">");
        if (this.initScript != null && this.initScript.length() > 0) {
            ((Writer)renderHtml1).write("<script>");
            ((Writer)renderHtml1).write(this.initScript.toString());
            ((Writer)renderHtml1).write("</script>");
        }
    }

    protected void renderEvent(FormInstance form) {
        FormCell formCell;
        if (this.id < form.getCell().length && (formCell = form.getCell()[this.id]) != null && formCell.isEnabled()) {
            StringBuffer sb = new StringBuffer(128);
            int i = 0;
            while (i < MAXEVENT) {
                if (this.events[i] != null) {
                    String sender = "onload".equals(this.events[i].getEventCode()) ? "window" : "defaultForm.getCellById(" + this.id + ")";
                    sb.append(this.events[i].toString(sender));
                }
                ++i;
            }
            form.addScript("form_obj_cell_" + this.id + "_event", sb.toString());
        }
    }

    protected String getEventScript(FormInstance form) {
        FormCell formCell;
        if (this.id < form.getCell().length && (formCell = form.getCell()[this.id]) != null && formCell.isEnabled()) {
            StringBuffer sb = new StringBuffer(128);
            int i = 0;
            while (i < MAXEVENT) {
                if (this.events[i] != null) {
                    String sender = "defaultForm.getCellById(" + this.id + ")";
                    sb.append(this.events[i].toString(sender));
                }
                ++i;
            }
            return sb.toString();
        }
        return "";
    }

    protected void renderPrint(FormInstance form) throws Exception {
        if (this.id < form.getCell().length && form.getCell()[this.id] != null && !form.getCell()[this.id].isPrint()) {
            PrintWriter renderHtml1 = form.getRenderHtml();
            ((Writer)renderHtml1).write("print:none;");
        }
    }

    protected void renderReadClass(FormInstance form) throws Exception {
        if (this.classNames == null) {
            return;
        }
        PrintWriter renderHtml1 = form.getRenderHtml();
        if (this.classNames.containsKey("read")) {
            ((Writer)renderHtml1).write(" ");
            ((Writer)renderHtml1).write(this.classNames.get("read").toString());
        }
    }

    protected void renderScriptObject(FormInstance form) {
    }

    protected void renderStartTag(FormInstance form) throws Exception {
        PrintWriter renderHtml1 = form.getRenderHtml();
        ((Writer)renderHtml1).write("<");
        ((Writer)renderHtml1).write(this.tagName);
        this.renderAttribute(form);
        ((Writer)renderHtml1).write(">");
    }

    protected void renderStyle(FormInstance form) throws Exception {
        PrintWriter renderHtml1 = form.getRenderHtml();
        ((Writer)renderHtml1).write(" style=\"");
        this.renderCommonStyle(form);
        ((Writer)renderHtml1).write("\"");
    }

    protected void renderValue(FormInstance form) throws Exception {
        PrintWriter renderHtml1 = form.getRenderHtml();
        if (this.id < form.getCell().length && form.getCell()[this.id] != null && form.getCell()[this.id].getValue() != null && form.getCell()[this.id].getValue().length() != 0) {
            ((Writer)renderHtml1).write(" cv=\"");
            ((Writer)renderHtml1).write(StringTool.toJson(form.getCell()[this.id].getValue()));
            ((Writer)renderHtml1).write("\"");
        }
        if (this.id < form.getCell().length && form.getCell()[this.id] != null && form.getCell()[this.id].getText() != null && form.getCell()[this.id].getText().length() != 0) {
            ((Writer)renderHtml1).write(" value=\"");
            ((Writer)renderHtml1).write(StringTool.escapeHtml(form.getCell()[this.id].getText()));
            ((Writer)renderHtml1).write("\"");
        }
    }

    protected void renderVisible(FormInstance form) throws Exception {
        if (this.id < form.getCell().length && form.getCell()[this.id] != null && !form.getCell()[this.id].isVisible()) {
            PrintWriter renderHtml1 = form.getRenderHtml();
            ((Writer)renderHtml1).write("display:none;");
        }
    }

    protected void setBorder(int lineWidth) {
        this.border = lineWidth;
        if (this.border > 0) {
            this.style.put("border-width", String.valueOf(this.border) + "px");
            this.style.put("border-style", "solid");
            this.style.put("border-color", SheetConstants.CELL.LINECOLOR);
            this.style.remove("border");
        } else if (this.border == 0) {
            this.style.put("border", "0px");
            this.style.remove("border-width");
            this.style.remove("border-style");
            this.style.remove("border-color");
        }
    }

    protected void setCellId(String cellId) {
        this.cellId = cellId;
        this.attributes.put("id", cellId);
        this.attributes.put("name", cellId);
    }

    protected void setClassName() {
        if (this.data.textColorStyle != null && this.data.textColorStyle.length() != 0) {
            this.classNames.put("text", this.data.textColorStyle);
        }
        if (this.data.alignStyle != null && this.data.alignStyle.length() != 0) {
            this.classNames.put("align", this.data.alignStyle);
        }
        if (this.data.fontStyle != null && this.data.fontStyle.length() != 0) {
            this.classNames.put("font", this.data.fontStyle);
        }
        if (this.data.readBkColorStyle != null && this.data.readBkColorStyle.length() != 0) {
            this.classNames.put("read", this.data.readBkColorStyle);
        }
        if (this.data.bkColorStyle != null && this.data.bkColorStyle.length() != 0) {
            this.classNames.put("edit", this.data.bkColorStyle);
        }
        if (this.data.borderStyle != null && this.data.borderStyle.length() != 0) {
            this.classNames.put("border", this.data.borderStyle);
            this.style.remove("border-color");
        }
    }

    public void addClassName(String classId, String className) {
        this.classNames.put(classId, className);
    }

    protected void setCommWordType() {
        if (this.data.commwordType == null || this.data.commwordType.length() == 0) {
            return;
        }
        this.attributes.put("w", this.data.commwordType.replaceAll("\"", "_"));
    }

    protected void setCondition() {
        if (this.data.checkCondition != -1) {
            this.condition = this.data.checkCondition;
            this.attributes.put("c", String.valueOf(this.condition));
            this.addEvent("onchange", "doChange(this)");
        }
    }

    protected void setGroup() {
        if (this.data.cellGroupInfo == null || this.data.cellGroupInfo.length() == 0) {
            return;
        }
        String[] groups1 = this.data.cellGroupInfo.split("&");
        StringBuffer groupIds = new StringBuffer(16);
        this.groups = new int[groups1.length];
        int i = 0;
        while (i < groups1.length) {
            String groupId = groups1[i].split("@")[0].split(",")[0];
            this.groups[i] = Integer.parseInt(groupId);
            groupIds.append(",").append(groupId);
            ++i;
        }
        if (groupIds.length() > 0) {
            this.attributes.put("g", groupIds.substring(1));
        }
    }

    protected void setHeight(int height) {
        this.noRender();
        this.height = height;
        if (StringTool.isEmpty(this.heightScale) || this.heightScale.equals("0")) {
            this.style.put("height", String.valueOf(String.valueOf(height)) + "px");
        }
    }

    protected void setLeft(int left) {
        this.noRender();
        this.left = left;
        if (this.position.equals(DataConst.CELL.POSITION.ABSOLUTE)) {
            this.style.put("left", String.valueOf(String.valueOf(left)) + "px");
        }
    }

    protected void setName(String cellName) {
        this.noRender();
        this.cellName = cellName;
    }

    protected void setParentControls(ICell iCell) {
        if (this.parentControls == null || !this.parentControls.equals(iCell)) {
            this.noRender();
            if (this.parentControls != null) {
                this.parentControls.noRender();
                this.parentControls.getControls().remove(this);
            }
            this.parentControls = iCell;
            if (iCell != null) {
                iCell.getControls().add(this);
                this.parentControls.noRender();
            }
        }
    }

    protected void setPosition(String position) {
        this.noRender();
        String string = this.position = position == null ? DataConst.CELL.POSITION.ABSOLUTE : position;
        if (!this.position.equals(DataConst.CELL.POSITION.ABSOLUTE)) {
            this.style.remove("top");
            this.style.remove("left");
        }
        this.style.put("position", this.position);
    }

    protected void setScroll(String scroll) {
        if (scroll != null && !scroll.equals(DataConst.CELL.SCROLL.NOSET)) {
            this.style.put("overflow", scroll);
        }
    }

    protected void setStyle() {
        this.setPosition(this.data.position);
        this.setTop(this.data.y1);
        this.setLeft(this.data.x1);
        this.setWidth(this.data.width);
        this.setWidthScale(this.data.widthScale);
        this.setHeightScale(this.data.heightScale);
        this.setTabindex();
        this.setBorder(this.data.lineWidth);
        this.setHeight(this.data.height);
        this.setScroll(this.data.scroll);
        if (!StringTool.isEmpty(this.data.zIndex)) {
            this.style.put("z-index", this.data.zIndex);
        }
    }

    protected void setTabindex() {
        this.tabindex = this.data.dtextNum;
        if (this.tabindex > 0) {
            this.attributes.put("tabindex", String.valueOf(this.tabindex));
        }
    }

    protected void setTop(int top) {
        this.noRender();
        this.top = top;
        if (this.position.equals(DataConst.CELL.POSITION.ABSOLUTE)) {
            this.style.put("top", String.valueOf(String.valueOf(top)) + "px");
        }
    }

    protected void setWidth(int width) {
        this.noRender();
        this.width = width;
        if (StringTool.isEmpty(this.widthScale) || this.widthScale.equals("0")) {
            this.style.put("width", String.valueOf(String.valueOf(width)) + "px");
        }
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public int getDefaultValueTime() {
        return this.defaultValueTime;
    }

    @Override
    public FormCell createCellInstance() {
        return new FormCell();
    }

    @Override
    public void saveCell(FormInstance form, List list, int cellId) {
    }
}

