/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.CommonCell;
import com.sdjxd.pms.platform.tool.StringTool;
import java.io.PrintWriter;
import java.io.Writer;

public class Button
extends CommonCell {
    private static final long serialVersionUID = 1L;
    private String inputType = "button";
    public static String CLOSE = "CLOSE";
    public static String WITHDRAW = "WITHDRAW";
    public static String OPENASSIST = "OPENASSIST";

    public Button(Form pattern) {
        super(pattern);
        pattern.setOldPattern(true);
        this.setPattern(pattern);
        this.tagName = "input";
        this.attributes.put("type", this.inputType);
    }

    @Override
    protected void renderClass(FormInstance form) throws Exception {
        PrintWriter renderHtml = form.getRenderHtml();
        ((Writer)renderHtml).write(" class=\"");
        this.renderCommonClass(form);
        if (this.id < form.getCell().length && form.getCell()[this.id] != null) {
            FormCell cell = form.getCell()[this.id];
            if (cell.isVisible() && !cell.isEnabled()) {
                this.renderReadClass(form);
            } else {
                this.renderEditClass(form);
            }
        } else {
            this.renderEditClass(form);
        }
        ((Writer)renderHtml).write("\"");
    }

    @Override
    protected void renderAttribute(FormInstance form) throws Exception {
        this.renderEnable(form);
        this.renderBlank(form);
        this.style.put("padding", "1px 0px 1px 0px");
        super.renderAttribute(form);
    }

    @Override
    protected void setName(String cellName) {
        super.setName(cellName);
        this.attributes.put("value", this.label);
        this.attributes.put("title", cellName);
    }

    @Override
    protected void renderEnable(FormInstance form) throws Exception {
        FormCell cell;
        if (this.id < form.getCell().length && form.getCell()[this.id] != null && (cell = form.getCell()[this.id]).isVisible() && !cell.isEnabled()) {
            PrintWriter renderHtml = form.getRenderHtml();
            ((Writer)renderHtml).write(" d=1 disabled=\"");
            ((Writer)renderHtml).write(SheetConstants.HTML.ATTTRUE);
            ((Writer)renderHtml).write("\"");
        }
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        StringBuffer sb = new StringBuffer();
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.cell.Button({id:");
        sb.append(this.id);
        sb.append(",needSave:false");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",typeName:'Button'");
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        sb.append("}));");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    @Override
    protected void renderVisible(FormInstance form) throws Exception {
        FormCell formCell;
        if (!(this.id >= form.getCell().length || (formCell = form.getCell()[this.id]) == null || formCell.isVisible() && formCell.isEnabled())) {
            PrintWriter renderHtml = form.getRenderHtml();
            ((Writer)renderHtml).write("display:none;");
        }
    }

    @Override
    protected void renderEvent(FormInstance form) {
        if (this.id < form.getCell().length) {
            FormCell formCell = form.getCell()[this.id];
            if (formCell == null) {
                return;
            }
            if (formCell.isVisible() && !formCell.isEnabled()) {
                return;
            }
            StringBuffer sb = new StringBuffer(128);
            int i = 0;
            while (i < MAXEVENT) {
                if (this.events[i] != null) {
                    String sender = "defaultForm.getCellById(" + this.id + ")";
                    sb.append(this.events[i].toString(sender));
                }
                ++i;
            }
            form.addScript("form_obj_cell_" + this.id + "_event", sb.toString());
        }
    }

    @Override
    public void render(FormInstance form) throws Exception {
        FormCell formCell;
        if (CLOSE.equals(this.data.assitInfo) && this.id < form.getCell().length) {
            formCell = form.getCell()[this.id];
            if (formCell == null) {
                formCell = new FormCell(this.id);
            }
            formCell.setLimit(3);
        }
        if (OPENASSIST.equals(this.data.assitInfo)) {
            formCell = form.getCell()[this.id];
            if (formCell == null) {
                formCell = new FormCell(this.id);
            }
            formCell.setLimit(3);
        }
        if (WITHDRAW.equals(this.data.assitInfo) && this.id < form.getCell().length && (formCell = form.getCell()[this.id]) == null) {
            FormCell formCell2 = new FormCell(this.id);
        }
        super.render(form);
    }
}

