/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.cell.VisualCell;
import com.sdjxd.pms.platform.tool.StringTool;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;

public class Area
extends VisualCell {
    private static final long serialVersionUID = 1L;
    private String oWidth = "";
    private int areaType;
    public static final int NOAREA = -1;
    public static final int NORMAL = 0;
    public static final int QUERY = 1;
    public static final int PRINT = 2;
    public static final int FLOAT = 3;

    public Area(Form pattern) {
        super(pattern);
        this.tagName = "div";
        this.cellPrefix = SheetConstants.CELL.AREA_PREFIX;
        this.controls = new ArrayList();
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        StringBuffer sb = new StringBuffer();
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.cell.Area({id:");
        sb.append(this.id);
        sb.append(",tagId:document.getElementById(\"a").append(this.id).append("\")");
        sb.append(",needSave:false");
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",areaType:").append(this.areaType);
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append(",childPosition:");
        sb.append("'" + this.childPosition + "'");
        sb.append("}));");
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    @Override
    public Form getPattern() {
        return this.pattern;
    }

    @Override
    protected void setStyle() {
        this.setPosition(this.data.position);
        this.setTop(this.data.y1);
        this.setLeft(this.data.x1);
        String oWidth = String.valueOf(this.data.width) + "px";
        this.setWidth(this.data.width);
        this.setHeight(this.data.height);
        this.setScroll(this.data.scroll);
        if (!StringTool.isEmpty(this.data.zIndex)) {
            this.style.put("z-index", this.data.zIndex);
        }
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        this.childPosition = model.childPosition;
        this.setLimit(model.limit);
        this.areaType = model.cellType;
        switch (this.areaType) {
            case 0: {
                this.oWidth = String.valueOf(this.width) + "px";
                if (model.widthScale != null && model.widthScale.length() != 0) {
                    this.oWidth = model.widthScale;
                }
                this.style.put("width", this.oWidth);
                String oHeight = String.valueOf(this.height) + "px";
                if (model.heightScale != null && model.heightScale.length() != 0) {
                    oHeight = model.heightScale;
                }
                this.style.put("height", oHeight);
                break;
            }
            case 1: {
                this.setLimit(0);
                break;
            }
            case 3: {
                this.style.put("z-index", "3");
                this.style.put("cursor", "move");
                this.style.put("background-color", "#eee");
                this.style.put("border", "#c3daf9 1px solid");
                this.pattern.addAttribute("fix", this.cellId);
                break;
            }
        }
        this.attributes.put("t", String.valueOf(model.cellType));
        this.attributes.put("top", String.valueOf(this.top) + "px");
        this.attributes.put("left", String.valueOf(this.left) + "px");
        this.addClassName("areaStyle", model.areaStyle);
        this.attributes.put("left", String.valueOf(this.left) + "px");
    }

    @Override
    public void setParentControls(ICell parentControls) {
        if (this.getParentControls() == null) {
            this.pattern.removeCell(this);
        }
        super.setParentControls(parentControls);
        if (parentControls != null) {
            this.setPosition(parentControls.getChildPosition());
        }
    }

    @Override
    public void renderBody(FormInstance form) throws Exception {
        super.renderBody(form);
        if (this.oWidth.equals("auto")) {
            PrintWriter renderHtml = form.getRenderHtml();
            ((Writer)renderHtml).write("<b style=\"float:right; height:0; overflow:hidden\"></b>");
        }
    }

    @Override
    public void setDefault(FormInstance form) {
    }
}

