/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.CommonCell;

public class Script
extends CommonCell {
    private static final long serialVersionUID = 1L;
    public String packageName;
    public String type;
    public String charset;
    private String name;
    public String path;

    public Script(Form pattern) {
        super(pattern);
        this.tagName = "script";
        this.type = "text/javascript";
        this.charset = "GBK";
    }

    @Override
    public void setData(CellBean model) {
        this.data = model;
        this.id = model.cellId;
        this.packageName = model.cellName;
        this.cellName = model.cellLabel;
        this.path = String.valueOf(Global.getName()) + model.assitInfo;
        this.attributes.put("id", this.path);
        this.attributes.put("type", this.type);
        this.attributes.put("charset", this.charset);
        this.attributes.put("src", String.valueOf(this.path) + "?_version=" + Global.sysTime);
    }

    @Override
    public void render(FormInstance form) throws Exception {
        if (this.path != null && this.path.indexOf("/pms/platform") < 0) {
            String pathType = ".js";
            pathType = this.path.substring(this.path.lastIndexOf(46), this.path.length());
            if (pathType.equals(".css")) {
                this.tagName = "link";
                this.type = "text/css";
                this.attributes.clear();
                this.attributes.put("id", this.path);
                this.attributes.put("type", this.type);
                this.attributes.put("charset", this.charset);
                this.attributes.put("rel", "stylesheet");
                this.attributes.put("href", this.path);
            }
            this.renderStartTag(form);
            this.renderEndTag(form);
        }
    }

    @Override
    protected void renderAttribute(FormInstance form) throws Exception {
        this.renderCommonAttribute(form);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

