/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service;

import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.pms.development.form.FormEvents;
import com.sdjxd.pms.platform.Limit.service.Limit;
import com.sdjxd.pms.platform.base.BaseObject;
import com.sdjxd.pms.platform.base.Context;
import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.base.DataStatus;
import com.sdjxd.pms.platform.base.MaxID;
import com.sdjxd.pms.platform.base.PlatformLogger;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.data.DbSession;
import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.dao.FormInstanceDao;
import com.sdjxd.pms.platform.form.model.FormInstanceBean;
import com.sdjxd.pms.platform.form.model.PatternBean;
import com.sdjxd.pms.platform.form.service.CellIndex;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormParameterData;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.PatternParameter;
import com.sdjxd.pms.platform.form.service.cell.WordCell;
import com.sdjxd.pms.platform.form.service.minicell.MiniCKEditor;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.table.dao.EditGridDao;
import com.sdjxd.pms.platform.table.model.EditGridBO;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import com.sdjxd.pms.platform.workflow.service.Flow;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import com.sdjxd.pms.platform.workflow.service.FlowNode;
import com.sdjxd.pms.platform.workflow.service.FlowNodeInstance;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class FormInstance
extends BaseObject {
    private static final long serialVersionUID = 1L;
    private static FormInstanceDao dao;
    private static Logger log;
    private static String CELLPREFIX;
    private static int MAX_OPENTIME;
    private static Hashtable formCache;
    private FlowInstance flowInstance;
    private String flowInstanceId;
    private int nodeInstanceId;
    private int flowFormId;
    private TreeMap script = null;
    private TreeMap scriptExtend = null;
    private boolean isWordJsInclude = false;
    private User opener;
    private boolean readonly = false;
    private boolean recordOpener = true;
    private String jsClassName;
    private String patternId;
    private Form pattern;
    private DataModify modify;
    private TreeMap index = new TreeMap();
    private TreeMap historyindex = new TreeMap();
    private String historysheetid;
    private FormInstanceBean formInstanceBean;
    private FormCell[] cell = new FormCell[SheetConstants.CELL.MAX_CELL];
    private EditGridBO[] editGridBOs;
    private FormParameterData[] paraData = new FormParameterData[SheetConstants.PARAMETER.MAX_PARA];
    protected boolean hasRender = false;
    protected int withDrawLimit = 0;

    static {
        formCache = new Hashtable();
        CELLPREFIX = "form";
        log = Logger.getLogger(FormInstance.class);
        dao = (FormInstanceDao)BeanFactory.getSingleInstance("FormInstanceDao");
        try {
            MAX_OPENTIME = Integer.parseInt(com.sdjxd.pms.platform.base.Global.getConfig("MAX_FORM_OPENTIME")) * 60 * 1000;
        }
        catch (Exception exp) {
            MAX_OPENTIME = 36000000;
        }
        FormInstance.updateAllOpener();
    }

    public boolean canOpen() {
        if (this.formInstanceBean == null) {
            return false;
        }
        String openerId = this.formInstanceBean.getOpenerid();
        if (openerId != null && openerId.length() != 0 && !User.isCurrent(openerId)) {
            Date lastOpenTime = this.formInstanceBean.getLastopentime().getTime();
            Date now = new Date();
            if (now.getTime() - lastOpenTime.getTime() < (long)MAX_OPENTIME && User.userIsOnline(openerId)) {
                this.setReadonly();
                String info = "\u5f53\u524d\u8868\u5355\u5df2\u88ab\u201c" + this.formInstanceBean.getOpener() + "\u201d\u6253\u5f00\uff0c\u8868\u5355\u5c06\u4ee5\u53ea\u8bfb\u65b9\u5f0f\u6253\u5f00";
                this.addScript("z_form_limit", "alert('" + info + "');");
                log.debug((Object)info);
                return false;
            }
        }
        return true;
    }

    public static FormInstance create(String patternId) throws Exception {
        FormInstance formData = (FormInstance)BeanFactory.getClass("FormData");
        Form pattern = Form.getPattern(patternId);
        String id = pattern.getNewFormId();
        FormEvents before = pattern.getBeforeCreateClass();
        if (before != null) {
            before.onBeforeCreate(pattern);
        }
        formData.init(pattern, id);
        formData.initCell();
        formData.initParameter(pattern);
        formData.setDefault();
        FormEvents after = pattern.getAfterCreateClass();
        if (after != null) {
            after.onAfterCreate(formData);
        }
        PlatformLogger.log(patternId, id, "\u8868\u5355\u5b9e\u4f8b", 1);
        formData.saveToCache();
        return formData;
    }

    protected void setDefault() {
        ICell[] patternCell = this.pattern.getCells();
        int index1 = 0;
        while (index1 < patternCell.length) {
            if (this.cell[index1] != null && patternCell[index1] != null && patternCell[index1].getDefaultValueTime() != 1) {
                patternCell[index1].setDefault(this);
            }
            ++index1;
        }
    }

    public void setEditDefault() {
        ICell[] patternCell = this.pattern.getCells();
        int index1 = 0;
        while (index1 < patternCell.length) {
            if (this.cell[index1] != null && patternCell[index1] != null) {
                if (patternCell[index1].getDefaultValueTime() == 1 && this.cell[index1].isEnabled() && StringTool.isEmpty(this.cell[index1].getValue()) && StringTool.isEmpty(this.cell[index1].getText())) {
                    patternCell[index1].setDefault(this);
                } else if (patternCell[index1].getDefaultValueTime() == 2) {
                    patternCell[index1].setDefault(this);
                }
            }
            ++index1;
        }
    }

    public static void delete(String patternId, String formId) throws Exception {
        Form pattern = Form.getPattern(patternId);
        TreeMap<String, String> index = new TreeMap<String, String>();
        index.put("SHEETID", formId);
        index.put("DATASTATUSID", String.valueOf(DataStatus.DELETE));
        pattern.modifyFormIndex(index);
        PlatformLogger.log(patternId, formId, "\u8868\u5355\u5b9e\u4f8b", 3);
    }

    public static FormInstance loadFromCache(String formInstanceId) {
        FormInstance form = null;
        if (com.sdjxd.pms.platform.base.Global.getContext() != null && !StringTool.isEmpty(formInstanceId) && !formInstanceId.equals("-1")) {
            String key = String.valueOf(CELLPREFIX) + formInstanceId;
            form = (FormInstance)com.sdjxd.pms.platform.base.Global.getContext().getSession(key);
        }
        return form;
    }

    public static FormInstance load(String formId, Form pattern) {
        FormInstance form = null;
        form = FormInstance.loadFromCache(formId);
        if (form == null) {
            form = FormInstance.loadFromDb(formId, pattern);
        }
        return form;
    }

    public static FormInstance load(String formId, String patternId) throws Exception {
        FormInstance form = null;
        if (patternId != null && patternId.length() != 0) {
            Form pattern = Form.getPattern(patternId);
            form = FormInstance.load(formId, pattern);
        }
        return form;
    }

    public static FormInstance fromDb(String formId, String patternId, boolean isReadOnly) throws Exception {
        Form pattern = Form.getPattern(patternId);
        return FormInstance.loadFromDb(formId, pattern, isReadOnly);
    }

    private static FormInstance loadFromDb(String formId, Form pattern, boolean isReadOnly) {
        if (pattern == null) {
            return null;
        }
        FormInstance form = (FormInstance)BeanFactory.getClass("FormData");
        form.init(pattern, formId);
        if (formId != null && formId.length() != 0 && !formId.equals("-1")) {
            form.read();
        } else {
            form.initCell();
            form.initParameter(pattern);
            form.setDefault();
        }
        if (isReadOnly) {
            form.setReadonly();
        } else {
            form.saveToCache();
        }
        return form;
    }

    public static FormInstance fromDb(String patternId) throws Exception {
        return FormInstance.fromDb("", patternId);
    }

    private static FormInstance loadFromDb(String formId, Form pattern) {
        if (pattern == null) {
            return null;
        }
        FormInstance form = (FormInstance)BeanFactory.getClass("FormData");
        form.init(pattern, formId);
        if (formId != null && formId.length() != 0 && !formId.equals("-1")) {
            form.read();
        } else {
            form.initCell();
            form.initParameter(pattern);
            form.setDefault();
        }
        form.saveToCache();
        return form;
    }

    private static FormInstance loadFromHistoryDb(String formId, Form pattern) {
        if (pattern == null) {
            return null;
        }
        FormInstance form = (FormInstance)BeanFactory.getClass("FormData");
        form.init(pattern, formId);
        if (formId != null && formId.length() != 0 && !formId.equals("-1")) {
            form.readHistory();
        } else {
            form.initCell();
            form.initParameter(pattern);
            form.setDefault();
        }
        form.saveToCache();
        return form;
    }

    public static FormInstance fromDb(String formId, String patternId) throws Exception {
        Form pattern = Form.getPattern(patternId);
        return FormInstance.loadFromDb(formId, pattern);
    }

    public static FormInstance fromHistoryDb(String formId, String patternId) throws Exception {
        Form pattern = Form.getPattern(patternId);
        return FormInstance.loadFromHistoryDb(formId, pattern);
    }

    public static TreeMap getIndex(Form pattern, String formId) {
        return dao.getFormIndex(pattern, formId, null);
    }

    public static boolean save(FormInstance client) throws Exception {
        boolean isSuc = false;
        FormInstance formData = FormInstance.loadFromCache(client.getId());
        Context context = com.sdjxd.pms.platform.base.Global.getContext();
        if (formData != null) {
            DbSession session = DbOper.openDb("defaultds");
            try {
                try {
                    formData.getClientData(client.getCell());
                    formData.editGridBOs = client.editGridBOs;
                    formData.save();
                    isSuc = true;
                    if (isSuc) {
                        DbOper.commitDb(session);
                    } else {
                        DbOper.rollbackDb(session);
                    }
                    PlatformLogger.log(formData.getPatternId(), formData.getId(), "\u8868\u5355\u5b9e\u4f8b", 2);
                }
                catch (Exception exp) {
                    DbOper.rollbackDb(session);
                    throw exp;
                }
            }
            finally {
                DbOper.closeDb(session);
            }
            try {
                formData.saveBlob();
            }
            catch (Exception exp) {
                exp.printStackTrace();
                throw exp;
            }
        }
        return isSuc;
    }

    public static boolean saveEditData(FormInstance client) throws Exception {
        boolean isSuc = false;
        FormInstance formData = FormInstance.loadFromCache(client.getId());
        Context context = com.sdjxd.pms.platform.base.Global.getContext();
        if (formData != null) {
            Form form = formData.getPattern();
            DbSession session = DbOper.openDb("defaultds");
            try {
                FormEvents before;
                if (context != null && (before = form.getBeforeSaveClass()) != null && !before.onBeforeSave(formData)) {
                    return false;
                }
                try {
                    FormEvents after;
                    formData.index = new TreeMap();
                    formData.index.put(form.getIndexTablePkCol(), client.getId());
                    formData.cell = client.getCell();
                    formData.getClientData(client.getCell());
                    formData.save();
                    isSuc = true;
                    if (context != null && (after = form.getAfterSaveClass()) != null) {
                        after.onAfterSave(formData);
                    }
                    DbOper.commitDb(session);
                    PlatformLogger.log(formData.getPatternId(), formData.getId(), "\u8868\u5355\u5b9e\u4f8b", 2);
                }
                catch (Exception exp) {
                    DbOper.rollbackDb(session);
                    throw exp;
                }
            }
            finally {
                DbOper.closeDb(session);
            }
        }
        return isSuc;
    }

    public static void undoDelete(String patternId, String formId) throws Exception {
        Form pattern = Form.getPattern(patternId);
        TreeMap<String, String> index = new TreeMap<String, String>();
        index.put("SHEETID", formId);
        index.put("DATASTATUSID", String.valueOf(DataStatus.NORMAL));
        pattern.modifyFormIndex(index);
    }

    public void setHistorysheetid(String historysheetid) {
        this.historysheetid = historysheetid;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getHistorysheetid() {
        return this.historysheetid;
    }

    public TreeMap getHistoryindex() {
        return this.historyindex;
    }

    public FormInstance() {
    }

    public FormInstance(Form pattern, String id) {
        this();
        this.init(pattern, id);
    }

    public EditGridBO[] getEditGridBOs() {
        return this.editGridBOs;
    }

    public void setEditGridBOs(EditGridBO[] editGridBOs) {
        this.editGridBOs = editGridBOs;
    }

    public FormInstance(String patternId, String id) throws Exception {
        this();
        this.init(patternId, id);
    }

    public void addIndex(String key, String value) {
        this.index.put(key, value);
    }

    public void addScript(String scriptName, String script1) {
        if (this.script == null) {
            this.script = new TreeMap();
        }
        this.script.put(scriptName, script1);
    }

    public void addText(int index1, String text, String value) {
        this.cell[index1].addText(text);
        this.cell[index1].setValue(value);
    }

    public void clearCache() {
        String key = String.valueOf(CELLPREFIX) + this.getId();
        formCache.remove(this.getId());
        if (com.sdjxd.pms.platform.base.Global.getContext() != null) {
            com.sdjxd.pms.platform.base.Global.getContext().removeSession(key);
        }
    }

    public static String outCache() {
        StringBuffer buffer = new StringBuffer(384);
        buffer.append(formCache.size());
        Enumeration enu = formCache.keys();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            buffer.append(",[s=").append(key).append(",p=").append(formCache.get(key)).append("]");
        }
        String ids = buffer.toString();
        log.error((Object)ids);
        return ids;
    }

    public void clearScript() {
        if (this.script != null) {
            this.script.clear();
        }
    }

    public void getClientData(FormCell[] cellValues) throws Exception {
        int i = 0;
        while (i < cellValues.length) {
            FormCell cell1 = cellValues[i];
            if (cell1 != null) {
                String cellText = cell1.getText();
                cellText = StringTool.replace(cellText, "<br/>", "\r\n");
                String cellValue = cell1.getValue();
                this.setText(i, cellText, cellValue);
            }
            ++i;
        }
    }

    public FormCell[] getCell() {
        return this.cell;
    }

    public FormCell getCell(int cellId) {
        return this.cell[cellId];
    }

    public FormParameterData[] getParaData() {
        return this.paraData;
    }

    public String getFlowInstanceId() {
        if (this.flowInstanceId == null) {
            return "";
        }
        return this.flowInstanceId;
    }

    public int getFlowNodeInstanceId() {
        return this.nodeInstanceId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getPatternId() {
        return this.patternId;
    }

    public TreeMap getIndex() {
        return this.index;
    }

    public DataModify getModify() {
        return this.modify;
    }

    public User getOpener() {
        return this.opener;
    }

    public Form getPattern() {
        return this.pattern;
    }

    public PrintWriter getRenderHtml() {
        return com.sdjxd.pms.platform.base.Global.getContext().getWriter();
    }

    protected StringBuffer getScript() {
        StringBuffer renderHtml1 = new StringBuffer(128);
        if (this.script == null) {
            return renderHtml1;
        }
        for (Map.Entry entry : this.script.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            renderHtml1.append(value);
            renderHtml1.append("\n");
        }
        return renderHtml1;
    }

    public String getSheetOrder(String patternId1) throws Exception {
        Form pattern1 = Form.getPattern(patternId1);
        String tableName = pattern1.getIndexTable();
        return dao.getSheetOrder(pattern1.getDataSourceName(), pattern1.getDataUserName(), tableName);
    }

    public void init(Form pattern1, String id1) {
        this.pattern = pattern1;
        this.patternId = pattern1.getPatternId();
        this.id = id1;
        this.jsClassName = id1 != null && id1.length() != 0 && !id1.equals("-1") ? "InstanceForm" : "StaticForm";
        ICell[] patternCell = this.pattern.getCells();
        if (patternCell != null && patternCell.length > 0) {
            int index1 = 0;
            while (index1 < patternCell.length) {
                if (this.cell[index1] == null && patternCell[index1] != null) {
                    this.cell[index1] = patternCell[index1].createCellInstance();
                    this.cell[index1].setLimit(patternCell[index1].getLimit());
                }
                ++index1;
            }
        }
    }

    public void init(String patternId1, String id1) throws Exception {
        this.patternId = patternId1;
        this.init(Form.getPattern(patternId1), id1);
    }

    public void initParameter(Form pattern1) {
        PatternParameter[] paras = pattern1.getParameters();
        String dataSourceName = pattern1.getDataSourceName();
        String dataUserName = pattern1.getDataUserName();
        String tableName = pattern1.getIndexTable();
        int nCount = paras.length;
        int i = 0;
        while (i < nCount) {
            block3: {
                FormParameterData dataItem;
                block5: {
                    int nType;
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    PatternParameter paraItem = paras[i];
                                    if (paraItem == null) break block3;
                                    dataItem = new FormParameterData(paraItem.getParaID());
                                    nType = paraItem.getParaType();
                                    dataItem.setParaType(nType);
                                    dataItem.setParaValue(paraItem.getParaValue());
                                    if (nType != SheetConstants.PARAMETER.TYPE_CELL) break block4;
                                    dataItem.setObjSrcSheetDataSourceName(dataSourceName);
                                    dataItem.setObjSrcSheetDataUserName(dataUserName);
                                    dataItem.setObjSrcTableName(tableName);
                                    break block5;
                                }
                                if (nType != SheetConstants.PARAMETER.TYPE_DEFCOL) break block6;
                                dataItem.setObjValue((String)this.index.get(dataItem.getParaValue()));
                                dataItem.setObjSrcSheetDataSourceName(dataSourceName);
                                dataItem.setObjSrcSheetDataUserName(dataUserName);
                                dataItem.setObjSrcTableName(tableName);
                                break block5;
                            }
                            if (nType != SheetConstants.PARAMETER.TYPE_OTHERSHEET) break block7;
                            this.setParaDataValue_otherSheet(dataItem);
                            break block5;
                        }
                        if (nType != SheetConstants.PARAMETER.TYPE_TEXT) break block8;
                        dataItem.setObjValue(StringTool.replaceKeyWord(dataItem.getParaValue()));
                        break block5;
                    }
                    if (nType != SheetConstants.PARAMETER.TYPE_USERDEFINE) break block3;
                    dataItem.setObjValue((String)this.index.get(dataItem.getParaValue()));
                }
                this.paraData[i] = dataItem;
            }
            ++i;
        }
    }

    public void initCell() {
        String pkColumn = this.getPattern().getIndexTablePkCol();
        if (pkColumn == null || pkColumn.equals("")) {
            pkColumn = "SHEETID";
        }
        if (this.formInstanceBean == null) {
            this.formInstanceBean = new FormInstanceBean();
        }
        this.initCell(pkColumn, this.id);
        this.initCell("PATTERNID", this.pattern.getPatternId());
        User user = User.getCurrentUser();
        if (user != null) {
            this.initCell("OPENER", user.getName());
            this.initCell("OPENERID", user.getId());
            this.initCell("CREATEUSER", user.getName());
            this.initCell("CREATEUSERID", user.getId());
            this.initCell("CREATEDEPT", user.getDeptName());
            this.initCell("CREATEDEPTID", user.getDeptId());
            this.initCell("CREATEORG", user.getCompName());
            this.initCell("CREATEORGID", user.getCompId());
        }
        this.initCell("CREATEDATE", DateTool.getNow());
        this.initCell("LASTOPENTIME", DateTool.getNow());
        this.initCell("DATASTATUSID", String.valueOf(DataStatus.NORMAL));
        if (this.pattern.getCellIndex() != null && this.pattern.getCellIndex().get("SHOWORDER") != null) {
            int orderNum = MaxID.getMaxID(this.pattern.getIndexTable(), "SHOWORDER");
            this.initCell("SHOWORDER", orderNum);
        }
        this.modify = DataModify.NEW;
    }

    public void initCell(String name1, int value) {
        this.initCell(name1, String.valueOf(value));
    }

    public void initCell(String name1, String value) {
        boolean isAddPrefix = false;
        String fieldName = name1;
        TreeMap indexs = this.pattern.getCellIndex();
        if (StringTool.isEmpty(name1) || indexs == null) {
            return;
        }
        int tableType = this.pattern.isViewIndexTable();
        if (!(tableType != 1 && tableType != 2 || fieldName.matches("^A[0-9]{1}_.*"))) {
            fieldName = "A0_" + fieldName;
            isAddPrefix = true;
        }
        if (this.pattern != null && name1.equals(this.pattern.getIndexTablePkCol())) {
            this.formInstanceBean.setSheetId(value);
        } else if (name1.equals("SHEETNAME")) {
            this.formInstanceBean.setSheetName(value);
        } else if (name1.equals("PATTERNID")) {
            this.formInstanceBean.setPatternId(value);
        } else if (name1.equals("OPENER")) {
            this.formInstanceBean.setOpener(value);
        } else if (name1.equals("OPENERID")) {
            this.formInstanceBean.setOpenerid(value);
        } else if (name1.equals("CREATEUSER")) {
            this.formInstanceBean.setCreateuser(value);
        } else if (name1.equals("CREATEUSERID")) {
            this.formInstanceBean.setCreateuserid(value);
        } else if (name1.equals("CREATEDEPT")) {
            this.formInstanceBean.setCreatedept(value);
        } else if (name1.equals("CREATEDEPTID")) {
            this.formInstanceBean.setCreatedeptid(value);
        } else if (name1.equals("CREATEORG")) {
            this.formInstanceBean.setCreateorg(value);
        } else if (name1.equals("CREATEORGID")) {
            this.formInstanceBean.setCreateorgid(value);
        } else if (name1.equals("CREATEDATE")) {
            this.formInstanceBean.setCreatedate(DateTool.parseCal(value));
        } else if (name1.equals("LASTOPENTIME")) {
            this.formInstanceBean.setLastopentime(DateTool.parseCal(value));
        } else if (name1.equals("DATASTATUSID")) {
            this.dataStatus = DataStatus.getInstance(Integer.parseInt(value));
            this.formInstanceBean.setDataStatusId(this.dataStatus);
        } else if (name1.equals("SHOWORDER")) {
            this.formInstanceBean.setShowOrder(Integer.parseInt(value));
        } else if (name1.equals("CREATEORGID")) {
            this.formInstanceBean.setCreateorgid(value);
        } else if (name1.equals("CREATEORGID")) {
            this.formInstanceBean.setCreateorgid(value);
        } else if (name1.equals("FLOWOBJECTID") || name1.equals("FLOWINSTANCEID")) {
            this.flowInstanceId = value;
            this.formInstanceBean.setFlowobjectid(value);
        } else if (name1.equals("SHEETSTATUSNAME")) {
            this.formInstanceBean.setSheetstatusname(value);
        } else if (name1.equals("SHEETSTATUSID")) {
            this.formInstanceBean.setSheetstatusid(value);
        } else if (name1.equals("FLOWNODENAME")) {
            this.formInstanceBean.setFlownodename(value);
        } else if (name1.equals("FLOWNODEID")) {
            this.formInstanceBean.setFlownodeid(value);
        } else if (name1.equals("SHEETNAME")) {
            this.name = value;
            this.formInstanceBean.setSheetName(value);
        } else if (name1.equals("HSHEETID")) {
            this.historysheetid = value;
        } else if (name1.equals("FLOWID")) {
            this.formInstanceBean.setFlowid(value);
        } else if (isAddPrefix) {
            fieldName = fieldName.substring(3);
        }
        CellIndex cellIndex = (CellIndex)indexs.get(fieldName);
        if (cellIndex != null) {
            int cellId = cellIndex.cell;
            if (cellId >= 0 && this.pattern.getCells()[cellId] != null) {
                this.index.put(fieldName, value);
                if (cellIndex.indexType.equals(CellIndex.TEXT)) {
                    this.cell[cellId].setText((String)this.index.get(name1));
                } else if (cellIndex.indexType.equals(CellIndex.VALUE)) {
                    this.cell[cellId].setValue((String)this.index.get(name1));
                }
            } else {
                this.index.put(fieldName, value);
            }
        }
    }

    public String getCellText(int cellId) {
        return this.pattern.getCells()[cellId].getText(this.cell[cellId]);
    }

    public String getCellValue(int cellId) {
        return this.pattern.getCells()[cellId].getValue(this.cell[cellId]);
    }

    public void read() {
        this.formInstanceBean = dao.getFormInstanceBean(this.id);
        dao.getFormIndex(this);
        if (this.index.containsKey("FLOWOBJECTID")) {
            this.flowInstanceId = (String)this.index.get("FLOWOBJECTID");
            this.formInstanceBean.setFlowobjectid(this.flowInstanceId);
        } else if (this.index.containsKey("FLOWINSTANCEID")) {
            this.flowInstanceId = (String)this.index.get("FLOWINSTANCEID");
            this.formInstanceBean.setFlowobjectid(this.flowInstanceId);
        }
        if (this.index.containsKey("SHEETNAME")) {
            this.name = (String)this.index.get("SHEETNAME");
            this.formInstanceBean.setSheetName(this.name);
        }
        if (this.index.containsKey("DATASTATUSID") && this.index.get("DATASTATUSID") != null) {
            this.dataStatus = DataStatus.getInstance(Integer.parseInt(String.valueOf(this.index.get("DATASTATUSID"))));
            this.formInstanceBean.setDataStatusId(this.dataStatus);
        }
        dao.getFormText(this);
        ICell[] patternCell = this.pattern.getCells();
        int index1 = 0;
        while (index1 < patternCell.length) {
            if (index1 < patternCell.length && patternCell[index1] != null) {
                String textField;
                String valueField = patternCell[index1].getValueField();
                if (valueField != null && valueField.length() != 0) {
                    this.cell[index1].setValue((String)this.index.get(valueField));
                }
                if ((textField = patternCell[index1].getTextField()) != null && textField.length() != 0) {
                    this.cell[index1].setText((String)this.index.get(textField));
                }
            }
            ++index1;
        }
        List paraDatas = dao.getFormParameter(this);
        if (paraDatas != null) {
            int nCount = paraDatas.size();
            int i = 0;
            while (i < nCount) {
                FormParameterData paraDataItem = (FormParameterData)paraDatas.get(i);
                if (paraDataItem.getParaType() == 2) {
                    paraDataItem.setObjValue(dao.getParaValueFromOtherSheet(paraDataItem));
                }
                this.paraData[i] = paraDataItem;
                ++i;
            }
        }
        this.modify = DataModify.SAVED;
    }

    public void readHistory() {
        this.formInstanceBean = dao.getFormInstanceBean(this.id);
        dao.getHistoryIndex(this, null);
        if (this.index.containsKey("FLOWOBJECTID")) {
            this.flowInstanceId = (String)this.index.get("FLOWOBJECTID");
            this.formInstanceBean.setFlowobjectid(this.flowInstanceId);
        } else if (this.index.containsKey("FLOWINSTANCEID")) {
            this.flowInstanceId = (String)this.index.get("FLOWINSTANCEID");
            this.formInstanceBean.setFlowobjectid(this.flowInstanceId);
        }
        if (this.index.containsKey("SHEETNAME")) {
            this.name = (String)this.index.get("SHEETNAME");
            this.formInstanceBean.setSheetName(this.name);
        }
        if (this.index.containsKey("DATASTATUSID") && this.index.get("DATASTATUSID") != null) {
            this.dataStatus = DataStatus.getInstance(Integer.parseInt(String.valueOf(this.index.get("DATASTATUSID"))));
            this.formInstanceBean.setDataStatusId(this.dataStatus);
        }
        dao.getHistoryText(this, null);
        ICell[] patternCell = this.pattern.getCells();
        int index1 = 0;
        while (index1 < patternCell.length) {
            if (index1 < patternCell.length && patternCell[index1] != null) {
                String textField;
                String valueField = patternCell[index1].getValueField();
                if (valueField != null && valueField.length() != 0) {
                    this.cell[index1].setValue((String)this.index.get(valueField));
                }
                if ((textField = patternCell[index1].getTextField()) != null && textField.length() != 0) {
                    this.cell[index1].setText((String)this.index.get(textField));
                }
            }
            ++index1;
        }
        this.modify = DataModify.SAVED;
    }

    public boolean render() {
        FormEvents eventClass;
        if (!this.readonly) {
            if (this.flowInstance != null) {
                if (this.recordOpener && !this.flowInstance.updateOpener(true)) {
                    String info = "\u5f53\u524d\u6d41\u7a0b\u5df2\u88ab\u3010" + this.flowInstance.getOpener().getName() + "\u3011\u6253\u5f00\uff0c\u6d41\u7a0b\u5c06\u4ee5\u53ea\u8bfb\u65b9\u5f0f\u6253\u5f00";
                    this.addScript("z_flow_limit", "alert('" + info + "');");
                    this.readonly = true;
                    this.setLimitUpper(1);
                } else if (this.getId().length() != 0 && !this.updateOpener(true)) {
                    this.setLimitUpper(1);
                    this.flowInstance.updateOpener(false);
                }
            } else if (this.getId().length() != 0 && !this.updateOpener(true)) {
                this.setLimitUpper(1);
            }
        } else {
            this.setLimitUpper(1);
        }
        StringBuffer script1 = new StringBuffer();
        script1.append("window.defaultForm = new com.sdjxd.pms.platform.form.");
        script1.append(this.jsClassName);
        script1.append("({align:'").append(this.pattern.getAlign().toString()).append("'");
        script1.append(",title:\"").append(StringTool.toJson(this.getName())).append("\"");
        script1.append(",formId:'").append(this.patternId).append("'");
        script1.append(",formName:\"").append(StringTool.toJson(this.pattern.getName())).append("\"");
        if (this.jsClassName.equals("InstanceForm")) {
            script1.append(",formInstanceId:'").append(this.getId()).append("'");
            script1.append(",formInstanceName:\"").append(StringTool.toJson(this.getName())).append("\"");
            script1.append(",isCreate:").append(this.modify.is(DataModify.NEW));
        }
        script1.append(",flowInstanceId:'").append(this.getFlowInstanceId()).append("'");
        script1.append(",readonly:").append(this.isReadonly());
        script1.append(",height:").append(this.getPattern().height);
        script1.append(",width:").append(this.getPattern().width);
        script1.append("});");
        this.addScript("form_obj", script1.toString());
        this.addScript("form_obj_init", "defaultForm.init();window.COMPattachEvent(window,\"onload\",com.sdjxd.pms.platform.form.Form.autoSizeWindow);");
        script1.setLength(0);
        String strScript = FormParameterData.renderScript(this);
        if (strScript.length() > 10) {
            this.addScript("form_para", strScript);
        }
        if (this.flowInstance != null) {
            this.addScript("flow_obj", this.flowInstance.toWholeJson(this.nodeInstanceId));
        }
        if ((eventClass = this.pattern.getBeforeRenderClass()) != null) {
            try {
                eventClass.onBeforeRender(this);
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
        }
        return true;
    }

    @Override
    public String getName() {
        if (this.name == null || "".equals(this.name)) {
            this.name = this.pattern.getName();
        }
        return super.getName();
    }

    public void save() throws Exception {
        Form form;
        FormEvents after;
        Form form2;
        FormEvents before;
        Context context;
        if (this.formInstanceBean == null) {
            return;
        }
        String openerId = this.formInstanceBean.getOpenerid();
        if (openerId != null && openerId.length() != 0 && !User.isCurrent(openerId)) {
            Date lastOpenTime = this.formInstanceBean.getLastopentime().getTime();
            Date now = new Date();
            if (now.getTime() - lastOpenTime.getTime() < (long)MAX_OPENTIME && User.userIsOnline(openerId)) {
                this.setReadonly();
                throw new Exception("\u8868\u5355\u5df2\u88ab\u3010" + this.formInstanceBean.getOpener() + "\u3011\u6253\u5f00\uff0c\u65e0\u6cd5\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\uff01");
            }
        }
        if ((context = com.sdjxd.pms.platform.base.Global.getContext()) != null && (before = (form2 = this.getPattern()).getBeforeSaveClass()) != null && !before.onBeforeSave(this)) {
            throw new Exception("\u8868\u5355\u4fdd\u5b58\u524d\u6821\u9a8c\u5931\u8d25\uff01");
        }
        CellIndex cellIndex = (CellIndex)this.pattern.getCellIndex().get("LASTOPENTIME");
        if (cellIndex != null) {
            this.index.put("LASTOPENTIME", DateTool.getNow());
        }
        this.formInstanceBean.setLastsavetime(Calendar.getInstance());
        User currentUser = User.getCurrentUser();
        if (currentUser != null) {
            cellIndex = (CellIndex)this.pattern.getCellIndex().get("EDITUSER");
            if (cellIndex != null) {
                this.index.put("EDITUSER", currentUser.getName());
            }
            this.formInstanceBean.setSaver(currentUser.getName());
            cellIndex = (CellIndex)this.pattern.getCellIndex().get("EDITUSERID");
            if (cellIndex != null) {
                this.index.put("EDITUSERID", currentUser.getId());
            }
            this.formInstanceBean.setSaverid(currentUser.getId());
        }
        dao.saveForm(this, null);
        EditGridBO[] editGridBOs = this.editGridBOs;
        boolean isSuc = true;
        int i = 0;
        while (editGridBOs != null && i < editGridBOs.length) {
            EditGridBO editGridBO = editGridBOs[i];
            if (editGridBO != null && !editGridBO.isSave()) {
                EditGridDao dao = new EditGridDao(editGridBO.getDataSourceName(), editGridBO.getDataUserName(), editGridBO.getTableName(), editGridBO.getPkCol(), editGridBO.getIsView(), editGridBO.getRowInfo());
                boolean success = dao.saveRowInfo();
                if (success) {
                    editGridBO.setSave(true);
                }
                isSuc = isSuc && success;
            }
            ++i;
        }
        if (!isSuc) {
            throw new Exception("\u5217\u8868\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        if (this.flowInstanceId != null && this.flowInstanceId.length() != 0) {
            String varId;
            FlowInstance flowInstance1 = FlowInstance.load(this.flowInstanceId);
            HashMap<String, String> formVar = new HashMap<String, String>();
            HashMap<String, String> formVarValue = new HashMap<String, String>();
            HashMap<String, String> formVarText = new HashMap<String, String>();
            int i2 = 0;
            while (i2 < this.cell.length) {
                if (this.cell[i2] != null) {
                    String cellValue = this.cell[i2].getValue();
                    if (cellValue == null || cellValue.length() == 0) {
                        cellValue = this.cell[i2].getText();
                    }
                    varId = StringTool.arrayToStr(new String[]{String.valueOf(i2), this.patternId});
                    formVar.put(varId, cellValue);
                    formVarValue.put(varId, this.cell[i2].getValue());
                    formVarText.put(varId, this.cell[i2].getText());
                }
                ++i2;
            }
            HashMap<String, String> formParam = new HashMap<String, String>();
            FormParameterData[] paraDatas = this.getParaData();
            int i3 = 0;
            while (i3 < paraDatas.length) {
                int type;
                FormParameterData dataItem = paraDatas[i3];
                if (dataItem != null && (type = dataItem.getParaType()) == SheetConstants.PARAMETER.TYPE_USERDEFINE) {
                    varId = String.valueOf(dataItem.getParaID());
                    String paramValue = dataItem.getObjValue();
                    formParam.put(varId, paramValue);
                }
                ++i3;
            }
            flowInstance1.save(formVar, formVarValue, formVarText, this.flowFormId, formParam);
        }
        this.modify = DataModify.SAVED;
        if (context != null && (after = (form = this.getPattern()).getAfterSaveClass()) != null) {
            after.onAfterSave(this);
        }
    }

    public void saveBlob() throws Exception {
        dao.saveFormBlob(this);
    }

    public void saveIndex() throws Exception {
        dao.saveIndex(this, null);
    }

    public void saveToCache() {
        if (com.sdjxd.pms.platform.base.Global.getContext() != null) {
            if (!(StringTool.isEmpty(this.id) || this.id.equals("-1") || this.isReadonly())) {
                FormInstance cache = FormInstance.loadFromCache(this.id);
                if (cache == null || this.patternId != null && this.patternId.equals(cache.getPatternId())) {
                    String key = String.valueOf(CELLPREFIX) + this.getId();
                    formCache.put(this.getId(), this.getPatternId());
                    com.sdjxd.pms.platform.base.Global.getContext().setSession(key, this);
                } else if (this.patternId != null && !this.patternId.equals(cache.getPatternId()) && cache.isReadonly()) {
                    log.info((Object)"\u8868\u5355\u5b9e\u4f8b\u88ab\u5176\u4ed6\u8868\u5355\u6a21\u677f\u53ea\u8bfb\u6253\u5f00\uff0c\u53ef\u4ee5\u7f16\u8f91");
                    String key = String.valueOf(CELLPREFIX) + this.getId();
                    formCache.put(this.getId(), this.getPatternId());
                    com.sdjxd.pms.platform.base.Global.getContext().setSession(key, this);
                } else {
                    String info = "\u5f53\u524d\u8868\u5355\u5b9e\u4f8b\u4ee5\u88ab\u5176\u4ed6\u8868\u5355\u6253\u5f00\uff0c\u5f53\u524d\u8868\u5355\u5c06\u4ee5\u53ea\u8bfb\u65b9\u5f0f\u6253\u5f00\uff1a\u8868\u5355\u7f16\u7801\u4e3a" + cache.getPatternId();
                    log.info((Object)info);
                    this.setReadonly();
                }
            }
        } else {
            log.info((Object)"\u65e0\u6cd5\u4fdd\u5b58\u8868\u5355\u5b9e\u4f8b\u5230\u7f13\u5b58\uff0c\u627e\u4e0d\u5230\u4e0a\u4e0b\u6587");
        }
    }

    public void setCellBlank(int[] cellId) {
        int i = 0;
        while (i < cellId.length) {
            this.cell[cellId[i]].setBlank(true);
            ++i;
        }
    }

    public void setCellEnabled(int[] cellId) {
        int i = 0;
        while (i < cellId.length) {
            this.cell[cellId[i]].setEnabled(true);
            ++i;
        }
    }

    public void setCellReadOnlyByFields() {
        if (this.readonly) {
            return;
        }
        if (this.pattern.limitIdArray == null || this.pattern.limitIdArray.length == 0) {
            return;
        }
        ICell[] patternCell = this.pattern.getCells();
        List tempList = Limit.getLimitData(this.pattern.limitIdArray, null);
        ArrayList fieldLimitInfo = null;
        ArrayList<String> sheetIdsInLimit = new ArrayList<String>();
        ArrayList<String> fieldNotReadOnlyList = new ArrayList<String>();
        if (tempList == null) {
            if (this.getModify() != null && (this.getModify().is(DataModify.SAVED) || this.getModify().is(DataModify.MODIFY))) {
                this.setReadonly();
            }
            return;
        }
        int i = 0;
        while (i < tempList.size()) {
            if (tempList.get(i) instanceof TreeMap) {
                String sheetId = (String)((TreeMap)tempList.get(i)).get("SHEETID");
                sheetIdsInLimit.add(sheetId);
            } else if (!(tempList.get(i) instanceof String) || !"1".equals(tempList.get(i))) {
                if (fieldLimitInfo == null) {
                    fieldLimitInfo = new ArrayList();
                }
                fieldLimitInfo.add(tempList.get(i));
            }
            ++i;
        }
        if (this.getModify() != null && (this.getModify().is(DataModify.SAVED) || this.getModify().is(DataModify.MODIFY)) && sheetIdsInLimit.size() > 0 && !sheetIdsInLimit.contains(this.id)) {
            this.setReadonly();
            return;
        }
        if (fieldLimitInfo == null) {
            return;
        }
        i = 0;
        while (i < fieldLimitInfo.size()) {
            String[] tempArr2;
            Object[] tempArr1 = StringTool.strToArray((String)fieldLimitInfo.get(i));
            if (tempArr1 != null && tempArr1.length > 0 && (tempArr2 = (String[])tempArr1[0]) != null && tempArr2.length > 0) {
                int j = 1;
                while (j < tempArr2.length) {
                    fieldNotReadOnlyList.add(tempArr2[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (patternCell != null) {
            i = 0;
            while (i < this.cell.length) {
                if (patternCell[i] != null) {
                    String valueField = patternCell[i].getValueField();
                    String textField = patternCell[i].getTextField();
                    if (valueField != null && textField == null && !fieldNotReadOnlyList.contains(valueField)) {
                        this.cell[i].setLimit(1);
                    } else if (valueField == null && textField != null && !fieldNotReadOnlyList.contains(textField)) {
                        this.cell[i].setLimit(1);
                    } else if (valueField != null && textField != null && !fieldNotReadOnlyList.contains(valueField) && !fieldNotReadOnlyList.contains(textField)) {
                        this.cell[i].setLimit(1);
                    }
                }
                ++i;
            }
        }
    }

    public void setButtonCellReadOnly() {
        ICell[] patternCell = this.pattern.getCells();
        if (patternCell != null) {
            int i = 0;
            while (i < this.cell.length) {
                String[] limit;
                if (patternCell[i] != null && (SheetConstants.CELL.getType(patternCell[i].getCellType()).equals("Button") || SheetConstants.CELL.getType(patternCell[i].getCellType()).equals("cell147")) && (limit = patternCell[i].getLimitInfoArray()) != null && limit.length != 0) {
                    boolean readOnly;
                    boolean bl = readOnly = !Limit.getLimitPolicy(limit, null);
                    if (readOnly) {
                        this.cell[i].setLimit(0);
                    }
                }
                ++i;
            }
        }
    }

    public void setCellLimit() {
        ICell[] patternCell = this.pattern.getCells();
        if (patternCell != null) {
            int i = 0;
            while (i < this.cell.length) {
                if (patternCell[i] != null) {
                    this.cell[i].setLimit(patternCell[i].getLimit());
                }
                ++i;
            }
        }
    }

    public TreeMap getCellLimitByLimitGroup() throws Exception {
        if (!StringTool.isEmpty(this.pattern.usedLimitGroupIds)) {
            return (TreeMap)BeanTool.invokeMethod("com.sdjxd.hussar.core.form72.service.FormLimitServices", "getCellLimitByLimitGroupFor71", (Object[])new String[]{this.patternId, this.pattern.usedLimitGroupIds});
        }
        return null;
    }

    public void setLimitByLimitGroup(Map limit) {
        this.setLimitByFlow(limit);
    }

    public void setCellLimit(TreeMap limit) {
        if (limit == null || limit.isEmpty()) {
            return;
        }
        for (Map.Entry entry : limit.entrySet()) {
            int cellId = (Integer)entry.getKey();
            int cellLimit = (Integer)entry.getValue();
            if (this.cell[cellId] == null) continue;
            this.cell[cellId].setLimit(cellLimit);
        }
    }

    public void setLimitByFlow(Map limit) {
        if (limit == null || limit.isEmpty()) {
            return;
        }
        for (Map.Entry entry : limit.entrySet()) {
            String[] id1 = (String[])StringTool.strToArray((String)entry.getKey());
            if (!this.patternId.equals(id1[1])) continue;
            int cellId = Integer.parseInt(id1[0]);
            int cellLimit = Integer.parseInt((String)entry.getValue());
            if (this.cell[cellId] == null) continue;
            this.cell[cellId].setLimit(cellLimit);
            this.cell[cellId].addKey(id1, entry.getValue());
        }
    }

    public void setCellLimit(int limit) {
        block6: {
            ICell[] patternCell = this.pattern.getCells();
            if (patternCell == null) break block6;
            if (limit == -1) {
                int i = 0;
                while (i < this.cell.length) {
                    if (patternCell[i] != null) {
                        this.cell[i].setLimit(patternCell[i].getLimit());
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.cell.length) {
                    if (patternCell[i] != null) {
                        this.cell[i].setLimit(limit);
                    }
                    ++i;
                }
            }
        }
    }

    public void setCellLimit(int limit, int[] cellId) {
        ICell[] patternCell = this.pattern.getCells();
        int i = 0;
        while (i < cellId.length) {
            if (limit == -1) {
                this.cell[i].setLimit(patternCell[i].getLimit());
            } else {
                this.cell[cellId[i]].setLimit(limit);
            }
            ++i;
        }
    }

    public void setCellVisible(int[] cellId) {
        int i = 0;
        while (i < cellId.length) {
            this.cell[cellId[i]].setVisible(true);
            ++i;
        }
    }

    public void setLimitUpper(int limit) {
        block7: {
            ICell[] patternCell = this.pattern.getCells();
            if (patternCell == null) break block7;
            if (limit == -1) {
                int i = 0;
                while (i < this.cell.length) {
                    if (patternCell[i] != null) {
                        int oldLimit = this.cell[i].getLimit();
                        int newLimit = patternCell[i].getLimit();
                        if (newLimit < oldLimit) {
                            this.cell[i].setLimit(newLimit);
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.cell.length) {
                    int oldLimit;
                    if (patternCell[i] != null && limit < (oldLimit = this.cell[i].getLimit())) {
                        this.cell[i].setLimit(limit);
                    }
                    ++i;
                }
            }
        }
    }

    public void setIndex(TreeMap index) {
        if (index != null) {
            String pk;
            if (this.pattern != null && index.containsKey(pk = this.pattern.getIndexTablePkCol())) {
                this.formInstanceBean.setSheetId((String)index.get(pk));
            }
            if (this.formInstanceBean == null) {
                this.formInstanceBean = new FormInstanceBean();
            }
            if (index.containsKey("CREATEDATE")) {
                this.formInstanceBean.setCreatedate(DateTool.parseCal((String)index.get("CREATEDATE")));
            }
            if (index.containsKey("CREATEDEPT")) {
                this.formInstanceBean.setCreatedept((String)index.get("CREATEDEPT"));
            }
            if (index.containsKey("CREATEDEPTID")) {
                this.formInstanceBean.setCreatedeptid((String)index.get("CREATEDEPTID"));
            }
            if (index.containsKey("CREATEORG")) {
                this.formInstanceBean.setCreateorg((String)index.get("CREATEORG"));
            }
            if (index.containsKey("CREATEORGID")) {
                this.formInstanceBean.setCreateorgid((String)index.get("CREATEORGID"));
            }
            if (index.containsKey("CREATEUSER")) {
                this.formInstanceBean.setCreateuser((String)index.get("CREATEUSER"));
            }
            if (index.containsKey("CREATEUSERID")) {
                this.formInstanceBean.setCreateuserid((String)index.get("CREATEUSERID"));
            }
            if (index.containsKey("FLOWID")) {
                this.formInstanceBean.setFlowid((String)index.get("FLOWID"));
            }
            if (index.containsKey("FLOWOBJECTID")) {
                this.formInstanceBean.setFlowobjectid((String)index.get("FLOWOBJECTID"));
            }
            if (index.containsKey("FLOWNODEID")) {
                this.formInstanceBean.setFlownodeid((String)index.get("FLOWNODEID"));
            }
            if (index.containsKey("FLOWNODENAME")) {
                this.formInstanceBean.setFlownodename((String)index.get("FLOWNODENAME"));
            }
            if (index.containsKey("SHEETSTATUSID")) {
                this.formInstanceBean.setSheetstatusid((String)index.get("SHEETSTATUSID"));
            }
            if (index.containsKey("SHEETSTATUSNAME")) {
                this.formInstanceBean.setSheetstatusname((String)index.get("SHEETSTATUSNAME"));
            }
            if (index.containsKey("LASTOPENTIME")) {
                this.formInstanceBean.setLastopentime(DateTool.parseCal((String)index.get("LASTOPENTIME")));
            }
            if (index.containsKey("LASTSAVETIME")) {
                this.formInstanceBean.setLastsavetime(DateTool.parseCal((String)index.get("LASTSAVETIME")));
            }
            if (index.containsKey("OPENER")) {
                this.formInstanceBean.setOpener((String)index.get("OPENER"));
            }
            if (index.containsKey("OPENERID")) {
                this.formInstanceBean.setOpenerid((String)index.get("OPENERID"));
            }
            if (index.containsKey("EDITUSER")) {
                this.formInstanceBean.setSaver((String)index.get("EDITUSER"));
            }
            if (index.containsKey("EDITUSERID")) {
                this.formInstanceBean.setSaverid((String)index.get("EDITUSERID"));
            }
            if (index.containsKey("SHEETNAME")) {
                this.formInstanceBean.setSheetName((String)index.get("SHEETNAME"));
            }
            if (index.containsKey("PATTERNID")) {
                this.formInstanceBean.setPatternId((String)index.get("PATTERNID"));
            }
            if (index.containsKey("SHOWORDER")) {
                String temp = (String)index.get("SHOWORDER");
                if (temp == null) {
                    this.formInstanceBean.setShowOrder(0);
                } else {
                    this.formInstanceBean.setShowOrder(Integer.parseInt(temp));
                }
            }
            this.index = index;
        }
    }

    public void setOpener(User opener) {
        this.opener = opener;
    }

    public void setText(int index, String text, String value) throws Exception {
        String field;
        ICell[] cells = this.pattern.getCells();
        if (cells[index] == null) {
            throw new Exception("\u5143\u4ef6\u4e0d\u5b58\u5728\uff1a" + index);
        }
        if ("true".equalsIgnoreCase(Global.getConfig((String)"defenseSQLInjection"))) {
            if (cells[index] instanceof MiniCKEditor) {
                text = MiniCKEditor.replaceTextBase(text);
            }
            if (cells[index] instanceof WordCell) {
                text = WordCell.replaceTextBase(text);
            }
        }
        if ((field = cells[index].getTextField()) != null && field.length() != 0) {
            String newValue;
            if (field.equals("SHEETORDER") && (text == null || text.trim().length() == 0)) {
                String patternId1 = this.patternId;
                newValue = this.getSheetOrder(patternId1);
            } else {
                newValue = text;
            }
            this.initCell(field, newValue);
            this.historyindex.put(field, newValue);
        } else {
            this.cell[index].setText(text);
            this.cell[index].setValue(value);
        }
        field = this.pattern.getCells()[index].getValueField();
        if (field != null && field.length() != 0) {
            this.initCell(field, value);
            this.historyindex.put(field, value);
        } else {
            this.cell[index].setText(text);
            this.cell[index].setValue(value);
        }
    }

    public boolean updateOpener(boolean isOpen) {
        if (!this.isRecordOpener()) {
            return true;
        }
        if (this.getModify().is(DataModify.NEW)) {
            this.opener = User.getCurrentUser();
            return true;
        }
        this.withDrawLimit = 0;
        if (isOpen) {
            if (this.canOpen()) {
                dao.updateOpener(this, isOpen);
                this.opener = User.getCurrentUser();
                return true;
            }
        } else {
            String openerId = this.formInstanceBean.getOpenerid();
            if (this.opener != null && this.opener.getId().equals(openerId)) {
                dao.updateOpener(this, isOpen);
                this.opener = User.getCurrentUser();
                return true;
            }
        }
        return false;
    }

    public static void close(String patternId, String formId) throws Exception {
        FlowInstance flowIns;
        FormInstance formData = FormInstance.load(formId, patternId);
        if (formData != null && !formData.isReadonly()) {
            log.debug((Object)("\u5173\u95ed\u8868\u5355:" + formId));
            formData.updateOpener(false);
            formData.clearCache();
        }
        if (formData.flowInstanceId != null && formData.flowInstanceId.length() > 0 && (flowIns = FlowInstance.load(formData.flowInstanceId)) != null) {
            flowIns.close();
            flowIns.clearCache();
        }
    }

    public void setFlowInstanceId(String flowInstanceId) {
        this.flowInstanceId = flowInstanceId;
        this.initCell("FLOWOBJECTID", flowInstanceId);
        this.initCell("FLOWINSTANCEID", flowInstanceId);
    }

    public void setFlowNodeInstanceId(int flowNodeInstanceId) {
        this.nodeInstanceId = flowNodeInstanceId;
    }

    public void setFlowStatus(String flowStatusId, String flowStatusName) {
        this.initCell("SHEETSTATUSNAME", flowStatusName);
        this.initCell("SHEETSTATUSID", flowStatusId);
    }

    public void setFlowId(String flowId) {
        this.initCell("FLOWID", flowId);
    }

    public void setFlowInstance(FlowInstance flowInstance, int nodeInstanceId, int flowFormId) {
        this.flowInstance = flowInstance;
        this.formInstanceBean.setFlowid(flowInstance.getFlowId());
        this.setFlowInstanceId(flowInstance.getId());
        this.setFlowNodeInstanceId(nodeInstanceId);
        this.flowFormId = flowFormId;
        this.setFlowId(flowInstance.getFlowId());
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly() {
        this.readonly = true;
        this.setRecordOpener(false);
    }

    public static String replaceParaValue(String text, FormInstance form) {
        if (form == null) {
            return text;
        }
        FormParameterData[] paraData = form.getParaData();
        int nCount = paraData.length;
        String newText = text;
        int i = 0;
        while (i < nCount) {
            FormParameterData dataItem = paraData[i];
            if (dataItem != null) {
                String strOld = "";
                String value = paraData[i].getObjValue();
                if (value == null) {
                    value = "";
                }
                int paraID = paraData[i].getParaID();
                strOld = "[para" + String.valueOf(paraID) + "]";
                newText = StringTool.replace(newText, strOld, value);
            }
            ++i;
        }
        return newText;
    }

    private void setParaDataValue_otherSheet(FormParameterData dataItem) {
        String strParaValue = dataItem.getParaValue().replace('.', ',');
        String[] arrTemp = strParaValue.split(",");
        if (arrTemp.length != 2) {
            return;
        }
        PatternBean patternData = this.pattern.getPatternData(arrTemp[0]);
        if (patternData == null) {
            return;
        }
        String srcTable = String.valueOf(patternData.table) + "_P";
        String srcSheetID = com.sdjxd.pms.platform.base.Global.getContext().getParameter("h_ps");
        if (srcSheetID == null) {
            return;
        }
        dataItem.setObjSrcTableName(srcTable);
        dataItem.setObjSrcSheetDataSourceName(patternData.dataSourceName);
        dataItem.setObjSrcSheetDataUserName(patternData.dataUserName);
        dataItem.setObjSrcParaID(Integer.parseInt(arrTemp[1]));
        dataItem.setObjSrcSheetID(srcSheetID);
        dataItem.setObjValue(dao.getParaValueFromOtherSheet(dataItem));
    }

    public static void autoCreate(String flowId, String formInstanceId, String formPatternId) throws Exception {
        FlowInstance flowInstance = null;
        FlowNodeInstance nodeInstance = null;
        flowInstance = Flow.createInstance(flowId);
        nodeInstance = flowInstance.getLastNodeInstance();
        int nodeInstanceId = nodeInstance.getNodeInstanceId();
        flowInstance.exec(nodeInstanceId);
        FormInstance formData = FormInstance.fromDb(formInstanceId, formPatternId);
        formData.initCell("OPENER", "");
        formData.initCell("OPENERID", "");
        int flowFormId = flowInstance.getTemplet().getStartNode().getDefaultForm();
        formData.setFlowInstance(flowInstance, nodeInstanceId, flowFormId);
        flowInstance.addFormInstance(flowFormId, formInstanceId, nodeInstanceId);
        formData.save();
        flowInstance.clearCache();
        formData.clearCache();
    }

    public static void autoCreate(String flowId) throws Exception {
        FlowInstance flowInstance = null;
        FlowNodeInstance nodeInstance = null;
        flowInstance = Flow.createInstance(flowId);
        Flow flow = flowInstance.getTemplet();
        nodeInstance = flowInstance.getLastNodeInstance();
        int nodeInstanceId = nodeInstance.getNodeInstanceId();
        int flowNodeId = nodeInstance.getFlowNodeId();
        FlowNode flowNode = flow.getNodeById(flowNodeId);
        flowInstance.exec(nodeInstanceId);
        int flowFormId = flowNode.getDefaultForm();
        String formPatternId = flow.getForm(flowFormId).getFormPatternId();
        FormInstance formData = FormInstance.create(formPatternId);
        formData.initCell("OPENER", "");
        formData.initCell("OPENERID", "");
        formData.setFlowInstance(flowInstance, nodeInstanceId, flowFormId);
        flowInstance.addFormInstance(flowFormId, formData.getId(), nodeInstanceId);
        formData.save();
    }

    public boolean isRecordOpener() {
        return this.recordOpener;
    }

    public void setRecordOpener(boolean recordOpener) {
        this.recordOpener = recordOpener;
    }

    public FormInstanceBean getFormInstanceBean() {
        return this.formInstanceBean;
    }

    public static void updateAllOpener() {
        if ("1".equals(com.sdjxd.pms.platform.base.Global.getConfig("clearopeneronstart"))) {
            try {
                ArrayList tableInfo = dao.getTableOfForm();
                String[] sysTable = new String[]{"JXD7_PM_INDEX", "defaultds", "[S]."};
                tableInfo.add(sysTable);
                dao.updateOpener(tableInfo);
            }
            catch (Exception exp) {
                exp.fillInStackTrace();
            }
        }
    }

    public static boolean saveHistory(FormInstance client) throws Exception {
        boolean isSuc = false;
        FormInstance formData = FormInstance.loadFromCache(client.getId());
        if (formData != null) {
            DbSession session = DbOper.openDb("defaultds");
            try {
                try {
                    formData.getClientData(client.getCell());
                    formData.saveHistory();
                    isSuc = true;
                    DbOper.commitDb(session);
                    PlatformLogger.log(formData.getPatternId(), formData.getId(), "\u8868\u5355\u5b9e\u4f8b", 2);
                }
                catch (Exception exp) {
                    DbOper.rollbackDb(session);
                    throw exp;
                }
            }
            finally {
                DbOper.closeDb(session);
            }
            try {
                formData.saveBlob();
            }
            catch (Exception exp) {
                exp.printStackTrace();
                throw exp;
            }
        }
        return isSuc;
    }

    public static boolean saveHistoryAndRelease(FormInstance client) throws Exception {
        boolean isSuc = false;
        FormInstance formData = FormInstance.loadFromCache(client.getId());
        if (formData != null) {
            DbSession session = DbOper.openDb("defaultds");
            try {
                try {
                    formData.getClientData(client.getCell());
                    formData.saveHistory();
                    dao.releaseHistory(formData.getPattern(), formData.getHistorysheetid());
                    if (!dao.isexistIndexForm(formData.getPattern(), formData.getId())) {
                        formData.modify = DataModify.NEW;
                    }
                    formData.save();
                    isSuc = true;
                    DbOper.commitDb(session);
                    PlatformLogger.log(formData.getPatternId(), formData.getId(), "\u8868\u5355\u5b9e\u4f8b", 2);
                }
                catch (Exception exp) {
                    DbOper.rollbackDb(session);
                    throw exp;
                }
            }
            finally {
                DbOper.closeDb(session);
            }
            try {
                formData.saveBlob();
            }
            catch (Exception exp) {
                exp.printStackTrace();
                throw exp;
            }
        }
        return isSuc;
    }

    public void saveHistory() throws Exception {
        User currentUser;
        CellIndex cellIndex = (CellIndex)this.pattern.getHistoryIndex().get("EDITTIME");
        if (cellIndex != null) {
            this.historyindex.put("EDITTIME", DateTool.getNow());
        }
        if ((currentUser = User.getCurrentUser()) != null) {
            cellIndex = (CellIndex)this.pattern.getHistoryIndex().get("EDITUSER");
            if (cellIndex != null) {
                this.historyindex.put("EDITUSER", currentUser.getName());
            }
            if ((cellIndex = (CellIndex)this.pattern.getHistoryIndex().get("EDITUSERID")) != null) {
                this.historyindex.put("EDITUSERID", currentUser.getId());
            }
        }
        if ((cellIndex = (CellIndex)this.pattern.getHistoryIndex().get("DATASTATUSID")) != null) {
            this.historyindex.put("DATASTATUSID", String.valueOf(DataStatus.NORMAL));
        }
        if ((cellIndex = (CellIndex)this.pattern.getHistoryIndex().get("ISRELEASE")) != null) {
            this.historyindex.put("ISRELEASE", "0");
        }
        if ((cellIndex = (CellIndex)this.pattern.getHistoryIndex().get("HSHEETID")) != null) {
            this.historyindex.put("HSHEETID", this.id);
        }
        if ((cellIndex = (CellIndex)this.pattern.getHistoryIndex().get("PATTERNID")) != null) {
            this.historyindex.put("PATTERNID", this.patternId);
        }
        if (StringTool.isEmpty(this.historysheetid)) {
            this.historysheetid = Guid.create();
        }
        if ((cellIndex = (CellIndex)this.pattern.getHistoryIndex().get("SHEETID")) != null) {
            this.historyindex.put("SHEETID", this.historysheetid);
        }
        dao.saveHistory(this, null);
        this.modify = DataModify.SAVED;
    }

    public static List getCompareInfo(String sheetid1, String sheetid2, String tablename) {
        return dao.getCompareInfo(sheetid1, sheetid2, tablename);
    }

    public static List getHistoryInfo(String sheetid1, String sheetid2, HashMap[] dlist, String tablename) {
        List<HashMap> wdList = Arrays.asList(dlist);
        return dao.getHistoryInfo(sheetid1, sheetid2, wdList, tablename);
    }

    public static List getHistoryInfoByCellId(String sheetid1, String sheetid2, String cellid, String tablename) {
        return dao.getHistoryInfoByCellId(sheetid1, sheetid2, cellid, tablename);
    }

    public static List getHistoryInfoByFieldId(String sheetid1, String sheetid2, String fieldid, String tablename) {
        return dao.getHistoryInfoByFieldId(sheetid1, sheetid2, fieldid, tablename);
    }

    public static String getHistorySheetid(String patternId, String hsheetid) throws Exception {
        Form pattern = Form.getPattern(patternId);
        return dao.getHistorySheetid(pattern, hsheetid);
    }

    public static String getHistoryEditer(String patternId, String hsheetid) throws Exception {
        Form pattern = Form.getPattern(patternId);
        return dao.getHistoryEditer(pattern, hsheetid);
    }

    public static String getTableNameById(String patternid) {
        return dao.getTableNameById(patternid);
    }

    public void addScriptExtend(String scriptName, String script1) {
        if (this.scriptExtend == null) {
            this.scriptExtend = new TreeMap();
        }
        this.scriptExtend.put(scriptName, script1);
    }

    protected StringBuffer getScriptExtend() {
        StringBuffer renderHtml1 = new StringBuffer(128);
        if (this.scriptExtend == null) {
            return renderHtml1;
        }
        for (Map.Entry entry : this.scriptExtend.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            renderHtml1.append("<script charset=\"GBK\" type=\"text/javascript\" src=" + value + "></script>\n");
        }
        return renderHtml1;
    }

    public boolean isWordJsInclude() {
        return this.isWordJsInclude;
    }

    public void setWordJsInclude(boolean isWordJsInclude) {
        this.isWordJsInclude = isWordJsInclude;
    }
}

