/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.DataModify;
import java.util.HashMap;

public class FormCell
extends BaseClass {
    private static final long serialVersionUID = 1L;
    protected int cellId = -1;
    protected String text;
    protected String value;
    protected String lastText;
    protected String lastValue;
    protected boolean visible = true;
    protected boolean enabled = true;
    protected boolean blank = true;
    protected boolean print = true;
    protected int limit;
    protected HashMap keys;
    protected DataModify modify = DataModify.NEW;

    public FormCell() {
    }

    public FormCell(int cellId) {
        this.setCellId(cellId);
    }

    public FormCell(int cellId, String text, String value) {
        this.setCellId(cellId);
        this.setText(text);
        this.setValue(value);
    }

    public String getText() {
        return this.text == null ? "" : this.text;
    }

    public void setText(String text) {
        this.lastText = this.text;
        this.text = text;
    }

    public void addText(String text) {
        if (this.text != null) {
            if (text != null) {
                this.text = new StringBuffer(this.text).append(text).toString();
            }
        } else {
            this.text = text;
        }
    }

    public String getValue() {
        return this.value == null ? "" : this.value;
    }

    public void setValue(String value) {
        this.lastValue = this.value;
        this.value = value;
    }

    public void addValue(String value) {
        this.value = this.value != null ? String.valueOf(this.value) + value : value;
    }

    public boolean isBlank() {
        return this.blank;
    }

    public void setBlank(boolean blank) {
        this.blank = blank;
    }

    public void setLimit(int limitId) {
        this.limit = limitId;
        switch (limitId) {
            case 0: {
                this.setVisible(false);
                this.setEnabled(false);
                this.setBlank(false);
                break;
            }
            case 1: {
                this.setVisible(true);
                this.setEnabled(false);
                this.setBlank(false);
                break;
            }
            case 2: {
                this.setVisible(true);
                this.setEnabled(true);
                this.setBlank(false);
                break;
            }
            case 3: 
            case 4: {
                this.setVisible(true);
                this.setEnabled(true);
                this.setBlank(true);
                break;
            }
            default: {
                this.setVisible(true);
                this.setEnabled(false);
                this.setBlank(false);
            }
        }
    }

    public void setLimit(String[] key, int limitId) {
        this.setLimit(limitId);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isPrint() {
        return this.print;
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public DataModify getModify() {
        return this.modify;
    }

    public void setModify(DataModify modify) {
        this.modify = modify;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getLastText() {
        return this.lastText;
    }

    public String getLastValue() {
        return this.lastValue;
    }

    public int getCellId() {
        return this.cellId;
    }

    public void setCellId(int cellId) {
        this.cellId = cellId;
    }

    public void addKey(Object key, Object value) {
        if (this.keys == null) {
            this.keys = new HashMap();
        }
        if (!this.keys.containsKey(key)) {
            this.keys.put(key, value);
        }
    }

    public HashMap getKeys() {
        return this.keys;
    }
}

