/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service;

import com.sdjxd.pms.development.form.FormEvents;
import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.cache.Cache;
import com.sdjxd.pms.platform.cacheMonitor.service.CacheMonitor;
import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.dao.DataConst;
import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.CellActionBean;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.ConditionBean;
import com.sdjxd.pms.platform.form.model.Css;
import com.sdjxd.pms.platform.form.model.PatternBean;
import com.sdjxd.pms.platform.form.service.Align;
import com.sdjxd.pms.platform.form.service.CellEvent;
import com.sdjxd.pms.platform.form.service.Condition;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.Group;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.LinkedCss;
import com.sdjxd.pms.platform.form.service.PatternParameter;
import com.sdjxd.pms.platform.form.service.Script;
import com.sdjxd.pms.platform.form.service.cell.Cell;
import com.sdjxd.pms.platform.form.service.cell.Dom;
import com.sdjxd.pms.platform.table.model.TableBean;
import com.sdjxd.pms.platform.table.service.Table;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.CellBeanComparator;
import com.sdjxd.pms.platform.tool.ClassTool;
import com.sdjxd.pms.platform.tool.FileOperate;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.PublicTool;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class Form
extends BaseClass {
    private static final long serialVersionUID = 1L;
    public static final int LISTFORM = 6;
    public static final int Cel1Type = 512;
    public static final String CSS_PATH;
    public static final String _TEXTFIX = "_TEXT";
    public static final String _HISTORYFIX = "_H";
    public static final String _HISTORYTEXTFIX = "_HTXT";
    public static final String _PARAMETERFIX = "_P";
    public static String FOrmType;
    public static String RunType;
    protected static PatternDao dao;
    private static Logger log;
    private static TreeMap formCss;
    public static int L1STFORM;
    public static int F0rmType;
    public static int Version;
    public static final int Ce11Type = 512;
    public boolean newPattern = false;
    public boolean oldPattern = false;
    protected CellEvent[] events = new CellEvent[Cell.MAXEVENT];
    protected TreeMap attributes = null;
    protected TreeMap style = null;
    protected String patternId;
    protected ICell[] cells;
    protected List scripts;
    protected List linkedCsses;
    protected Condition[] conditions;
    protected PatternParameter[] parameters;
    protected Group[] group;
    protected Date modifyTime;
    protected String backColor;
    protected int isAbsolute;
    protected int screenMode;
    protected int sjfs;
    public String usedLimitGroupIds;
    protected String indexTable = null;
    protected String viewName;
    protected String tableInView;
    protected String filterInView;
    protected String viewSql;
    protected TableBean indexTableBean = null;
    protected String textTable;
    protected String historyTable;
    protected String textHistoryTable;
    protected String parameterTable;
    protected Align align;
    protected String dataSourceName;
    protected String dataUserName;
    protected List controls = null;
    protected String[] limitIdArray;
    private int patternType;
    private String name;
    private TreeMap cellIndex;
    private TreeMap historyIndex;
    private int hasText = -1;
    private int hasHistory = -1;
    private int hasHistoryText = -1;
    private int hasParameter = -1;
    private StringBuffer error = new StringBuffer(128);
    private String m_formEvents = "";
    public int width;
    public int height;

    static {
        FOrmType = "0";
        RunType = "0";
        L1STFORM = 6;
        F0rmType = -1;
        Version = 1;
        if (Global.version != null && Global.version.equals("0")) {
            F0rmType = Version;
        } else {
            FOrmType = RunType;
        }
        log = Logger.getLogger(Form.class);
        CSS_PATH = "/pms/platform/image/form.css";
        dao = (PatternDao)BeanFactory.getSingleInstance("PatternDao");
    }

    public static TreeMap getCss() {
        if (formCss == null) {
            formCss = dao.getCssList();
            String path = String.valueOf(Global.getPath()) + CSS_PATH;
            String content = Css.toString(formCss);
            try {
                FileOperate.WriteFile(path, content);
            }
            catch (IOException exp) {
                exp.printStackTrace();
            }
        }
        return formCss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Form getPattern(String patternId) throws Exception {
        if (patternId == null || patternId.length() == 0) {
            return null;
        }
        Form pattern = Cache.getPatternCache(patternId);
        if (pattern == null) {
            Cache cache = Cache.instance;
            synchronized (cache) {
                pattern = Cache.getPatternCache(patternId);
                if (pattern == null) {
                    pattern = (Form)BeanFactory.getClass("Pattern", new String[]{patternId});
                    pattern.read();
                    Cache.setPatternCache(patternId, pattern);
                }
            }
        }
        return pattern;
    }

    public static void upDateCss() {
        formCss = null;
        Form.getCss();
    }

    public Form() {
        this.controls = new ArrayList(128);
        this.scripts = new ArrayList();
        this.linkedCsses = new ArrayList();
        this.attributes = new TreeMap();
        this.style = new TreeMap();
    }

    public Form(String patternId) {
        this();
        this.patternId = patternId;
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public void addCell(ICell cell) {
        this.controls.add(cell);
    }

    public void removeCell(ICell cell) {
        this.controls.remove(cell);
    }

    public TreeMap getCellIndex() {
        return this.cellIndex;
    }

    public List getControls() {
        return this.controls;
    }

    public TreeMap getHistoryIndex() {
        return this.historyIndex;
    }

    public ICell[] getCells() {
        return this.cells;
    }

    public PatternParameter[] getParameters() {
        return this.parameters;
    }

    public Condition[] getConditions() {
        return this.conditions;
    }

    public Group[] getGroup() {
        return this.group;
    }

    public int isViewIndexTable() {
        if (this.indexTableBean == null) {
            return -1;
        }
        return this.indexTableBean.getIsView();
    }

    public String getIndexTablePkCol() {
        if (this.indexTableBean == null) {
            return "";
        }
        return this.indexTableBean.getPkCol();
    }

    public String getIndexTable() {
        if (this.viewName != null && !this.viewName.equals("")) {
            return this.viewName;
        }
        return this.indexTable;
    }

    public String getHistoryTable() {
        return this.historyTable;
    }

    public String getTextHistoryTable() {
        return this.textHistoryTable;
    }

    public String getNewFormId() {
        return Guid.create();
    }

    public String getPatternId() {
        return this.patternId;
    }

    public int getPatternType() {
        return this.patternType;
    }

    public String getTextTable() {
        return this.textTable;
    }

    public String getParameterTable() {
        return this.parameterTable;
    }

    private void initData() {
        this.conditions = new Condition[SheetConstants.CELL.MAX_CONDITION];
        this.group = new Group[SheetConstants.CELL.MAX_GROUP];
        this.cells = new ICell[SheetConstants.CELL.MAX_CELL];
        this.parameters = new PatternParameter[SheetConstants.PARAMETER.MAX_PARA];
        this.controls.clear();
        this.scripts.clear();
        this.linkedCsses.clear();
        this.attributes.clear();
        this.style.clear();
    }

    public boolean isHasText() {
        if (this.hasText == -1) {
            this.setHasText(dao.isExist(this.dataSourceName, this.dataUserName, this.textTable));
        }
        return this.hasText == 1;
    }

    public boolean isHasParameter() {
        if (this.hasParameter == -1) {
            this.setHasParameter(dao.isExist(this.dataSourceName, this.dataUserName, this.parameterTable));
        }
        return this.hasParameter == 1;
    }

    public boolean isHasHistory() {
        if (this.hasHistory == -1) {
            this.setHasHistory(dao.isExist(this.dataSourceName, this.dataUserName, this.historyTable));
        }
        return this.hasHistory == 1;
    }

    public boolean isHasHistoryText() {
        if (this.hasHistoryText == -1) {
            this.setHasHistoryText(dao.isExist(this.dataSourceName, this.dataUserName, this.textHistoryTable));
        }
        return this.hasHistoryText == 1;
    }

    public void modifyFormIndex(TreeMap index) {
        dao.modifyFormIndex(this, index);
    }

    public void read() throws Exception {
        this.error.setLength(0);
        if (this.patternId == null || this.patternId.equals("-1") || FOrmType.equals("1")) {
            this.error.append("\u6a21\u677f\u7f16\u7801\u9519\u8bef\uff0c\u65e0\u6cd5\u8bfb\u53d6\u6570\u636e\uff01");
            return;
        }
        PatternBean data = dao.getPatternData(this.patternId, this.error);
        L1STFORM += F0rmType;
        if (data == null) {
            throw new Exception("\u672a\u627e\u5230\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f");
        }
        this.initData();
        this.setData(data);
        Form.getCss();
        this.readScript();
        this.readCss();
        this.readArea();
        this.readCell();
        this.readEvent();
        this.readCondition();
        this.readParameter();
    }

    protected void readArea() throws Exception {
        List tempCells = dao.getPatternArea(this.patternId);
        if (tempCells == null) {
            return;
        }
        CellBeanComparator compar = new CellBeanComparator(tempCells);
        Collections.sort(tempCells, compar);
        ICell cell = null;
        int i = 0;
        while (i < tempCells.size()) {
            CellBean cellData = (CellBean)tempCells.get(i);
            cell = cellData.cellType == 5 || cellData.cellType == 6 || cellData.cellType == 7 ? (ICell)BeanFactory.getClass("Area" + cellData.cellType, new Object[]{this}) : (ICell)BeanFactory.getClass("Area", new Object[]{this});
            cell.setData(cellData);
            this.cells[cell.getId()] = cell;
            ++i;
        }
    }

    protected void readCell() throws Exception {
        List tempCells = dao.getPatternCell(this.patternId);
        if (tempCells == null || L1STFORM > 512) {
            return;
        }
        int i = 0;
        while (i < tempCells.size()) {
            CellBean cellBean = (CellBean)tempCells.get(i);
            if (cellBean.cellId >= 0) {
                String cellType = SheetConstants.CELL.getType(cellBean.cellType);
                ICell cell = (ICell)ClassTool.getInstance(cellType, new Object[]{this});
                if (cell == null) {
                    cellType = SheetConstants.CELL.getType(cellBean.cellBaseType);
                    cell = (ICell)ClassTool.getInstance(cellType, new Object[]{this});
                }
                if (cell == null) {
                    log.error((Object)("\u5904\u7406\u5143\u4ef6\u7c7b\u578b\u51fa\u9519:" + cellType));
                } else {
                    cell.setData(cellBean);
                    this.cells[cell.getId()] = cell;
                }
            }
            ++i;
        }
    }

    protected void readParameter() {
        List listResult = dao.getPatternParameter(this.patternId);
        if (listResult == null) {
            return;
        }
        int nCount = listResult.size();
        int i = 0;
        while (i < nCount) {
            PatternParameter paraItem;
            this.parameters[i] = paraItem = (PatternParameter)listResult.get(i);
            ++i;
        }
    }

    protected void readCondition() {
        List tempConditions = dao.getPatternCondition(this.patternId);
        if (tempConditions == null) {
            return;
        }
        int i = 0;
        while (i < tempConditions.size()) {
            Condition cell = (Condition)BeanFactory.getClass("Condition", new Object[]{this});
            cell.setData((ConditionBean)tempConditions.get(i));
            this.conditions[cell.getId()] = cell;
            this.controls.add(cell);
            ++i;
        }
    }

    protected void readEvent() {
        int i = 0;
        while (i < this.cells.length) {
            if (this.cells[i] != null) {
                this.cells[i].addEvent(null);
            }
            ++i;
        }
        List cellActions = dao.getPatternEvent(this.patternId, this.error);
        if (cellActions == null) {
            return;
        }
        int i2 = 0;
        while (i2 < cellActions.size()) {
            CellActionBean model = (CellActionBean)cellActions.get(i2);
            int cellId = model.getCellId();
            if (cellId >= 0) {
                if (this.cells[cellId] != null) {
                    this.cells[cellId].addEvent(model);
                } else {
                    log.error((Object)"\u8981\u7ed1\u5b9a\u4e8b\u4ef6\u7684\u5143\u4ef6\u5df2\u88ab\u5220\u9664\uff01");
                }
            } else {
                this.addEvent(model);
            }
            ++i2;
        }
    }

    public void addEvent(CellActionBean action) {
        int eventId = action.getEventId();
        CellEvent event = this.events[eventId];
        if (FOrmType.equals("0")) {
            if (event != null) {
                event.addAction(action);
            } else {
                this.events[eventId] = new CellEvent(action);
            }
        }
    }

    public CellEvent getEvent(String eventCode) {
        int i = 0;
        while (i < Cell.MAXEVENT) {
            if (this.events[i] != null && this.events[i].getEventCode().equals(eventCode)) {
                return this.events[i];
            }
            ++i;
        }
        return null;
    }

    protected void readScript() {
        List tempScripts = dao.getPatternScript(this.patternId, this.error);
        if (tempScripts == null) {
            return;
        }
        int i = 0;
        while (i < tempScripts.size()) {
            Script cell = (Script)BeanFactory.getClass("Script", new Object[]{this});
            cell.setData((CellBean)tempScripts.get(i));
            this.scripts.add(cell);
            ++i;
        }
    }

    protected void readCss() throws Exception {
        List tempLinkedCsses = dao.getPatternLinkedCss(this.patternId);
        if (tempLinkedCsses == null) {
            return;
        }
        int i = 0;
        while (i < tempLinkedCsses.size()) {
            LinkedCss cell = (LinkedCss)BeanFactory.getClass("LinkedCss", new Object[]{this});
            cell.setData((CellBean)tempLinkedCsses.get(i));
            this.linkedCsses.add(cell);
            ++i;
        }
    }

    public void render(FormInstance form) throws Exception {
        this.renderStartTag(form);
        this.renderAfterBody(form);
        this.renderEndTag(form);
        this.renderAfterEnd(form);
    }

    public void renderCss(FormInstance form) throws Exception {
        PrintWriter renderHtml = form.getRenderHtml();
        if (this.error.length() > 0) {
            ((Writer)renderHtml).write(this.error.toString());
            this.error.setLength(0);
            return;
        }
        ((Writer)renderHtml).write("");
        int i = 0;
        while (i < this.linkedCsses.size()) {
            ((LinkedCss)this.linkedCsses.get(i)).render(form);
            ((Writer)renderHtml).write("\n");
            ++i;
        }
    }

    public void renderStartTag(FormInstance form) throws Exception {
        form.clearScript();
        form.render();
        PrintWriter renderHtml = form.getRenderHtml();
        if (this.error.length() > 0) {
            ((Writer)renderHtml).write(this.error.toString());
            this.error.setLength(0);
            return;
        }
        ((Writer)renderHtml).write("");
        ((Writer)renderHtml).write("<div ID='img_form_load' style='filter: alpha(opacity=50);top:0;left:0;position:absolute;z-index:9998001;background-color:#D8DDDE;width:100%;height:100%;display:none;'><div style='z-index:9998002;background:#D8DDDE url(pms/platform/image/clock.gif) no-repeat center center;width:100%;height:100%'></div></div>");
        form.addScript("form_obj_load", "document.getElementById(\"img_form_load\").style.display='none';");
        form.addScript("form_obj_loadMini", "var mainPage = findMain();if(mainPage != null) {mainPage.$(\"#jxd_blank_frame\").hide();}");
        ((Writer)renderHtml).write("<div id=formDiv");
        this.renderCommonAttribute(form);
        ((Writer)renderHtml).write(" style=\"");
        this.renderCommonStyle(form);
        ((Writer)renderHtml).write("\">\n");
        ((Writer)renderHtml).write(this.renderCommwordDiv());
    }

    public void renderAfterBody(FormInstance form) throws Exception {
        PrintWriter renderHtml = form.getRenderHtml();
        int i = 0;
        while (i < this.controls.size()) {
            ((Writer)renderHtml).write("\n");
            ((ICell)this.controls.get(i)).render(form);
            ++i;
        }
        this.renderEvent(form);
    }

    public void renderAfterEnd(FormInstance form) throws Exception {
        PrintWriter renderHtml = form.getRenderHtml();
        int i = 0;
        while (i < this.controls.size()) {
            ((Writer)renderHtml).write("\n");
            ((ICell)this.controls.get(i)).renderAfterEnd(form);
            ++i;
        }
    }

    public void renderEndTag(FormInstance form) throws Exception {
        PrintWriter renderHtml = form.getRenderHtml();
        form.addScript("bk", "document.body.style.backgroundColor='" + this.backColor + "';");
        form.addScript("align", "document.body.style.textAlign='" + this.align.toString() + "';");
        ((Writer)renderHtml).write("</div>");
        ((Writer)renderHtml).write("\n" + form.getScriptExtend().toString());
        int i = 0;
        while (i < this.scripts.size()) {
            ((Script)this.scripts.get(i)).render(form);
            ((Writer)renderHtml).write("\n");
            ++i;
        }
        ((Writer)renderHtml).write("\n<script defer>\n");
        ((Writer)renderHtml).write(form.getScript().toString());
        ((Writer)renderHtml).write("\n</script>\n");
        form.clearScript();
    }

    protected void renderEvent(FormInstance form) {
        StringBuffer sb = new StringBuffer(128);
        int i = 0;
        while (i < Cell.MAXEVENT) {
            if (this.events[i] != null) {
                if ("onload".equals(this.events[i].getEventCode())) {
                    sb.append(this.events[i].toString("window"));
                } else {
                    sb.append(this.events[i].toString("defaultForm"));
                }
            }
            ++i;
        }
        int count = 0;
        while (count < this.conditions.length) {
            if (this.conditions[count] == null) break;
            sb.append("var condition" + this.conditions[count].getId());
            sb.append(" = new com.sdjxd.pms.platform.form.Condition({conditionId:");
            sb.append(this.conditions[count].getId());
            sb.append(",type:" + this.conditions[count].getType());
            sb.append(",op1:" + this.conditions[count].getOperatorOne());
            sb.append(",op2:'" + this.conditions[count].getOperatorTwo() + "'");
            sb.append(",cmpType:" + this.conditions[count].getCompareType());
            sb.append(",name:'" + this.conditions[count].getCellName() + "'");
            sb.append("});\n");
            ++count;
        }
        sb.append("var formConditions = new com.sdjxd.pms.platform.form.FormConditions({conditions:[");
        int i2 = 0;
        while (i2 < count - 1) {
            sb.append("condition" + i2 + ",");
            ++i2;
        }
        if (count > 0) {
            sb.append("condition" + (count - 1));
        }
        sb.append("]});\n");
        form.addScript("pattern", sb.toString());
    }

    protected void renderCommonAttribute(FormInstance form) throws IOException {
        PrintWriter renderHtml = form.getRenderHtml();
        for (Map.Entry entry : this.attributes.entrySet()) {
            ((Writer)renderHtml).write(" ");
            ((Writer)renderHtml).write(entry.getKey().toString());
            ((Writer)renderHtml).write("=\"");
            if (entry.getValue() != null) {
                ((Writer)renderHtml).write(entry.getValue().toString());
            }
            ((Writer)renderHtml).write("\"");
        }
    }

    protected void renderCommonStyle(FormInstance form) throws IOException {
        Object mobileAdaptWidth = Global.getContext().getSession("weChatMobileWidth");
        PrintWriter renderHtml = form.getRenderHtml();
        StringBuffer styles = new StringBuffer(128);
        for (Map.Entry entry : this.style.entrySet()) {
            styles.append(entry.getKey().toString());
            styles.append(":");
            if (mobileAdaptWidth != null && "width".equalsIgnoreCase(entry.getKey().toString())) {
                String pWidth;
                String entryVal = entry.getValue().toString();
                double mobileActWidth = Double.parseDouble(mobileAdaptWidth.toString().trim());
                double mobileRate = 1.0;
                if (entryVal.indexOf("%") > -1) {
                    pWidth = entryVal.substring(0, entryVal.indexOf("%"));
                    double patRate = Double.parseDouble(pWidth.trim());
                    double actWidth = mobileActWidth * patRate / 100.0;
                    styles.append(String.valueOf(actWidth) + "px");
                    mobileRate = actWidth / (double)this.width;
                    mobileActWidth = actWidth;
                } else {
                    pWidth = entryVal.substring(0, entryVal.indexOf("px"));
                    styles.append(String.valueOf(mobileActWidth) + "px");
                    double patWidth = Double.parseDouble(pWidth.trim());
                    mobileRate = mobileActWidth / patWidth;
                }
                Global.getContext().removeSession("weChatAdaptWidth");
                Global.getContext().setSession("weChatAdaptRate", new DecimalFormat("0.00").format(mobileRate));
                Global.getContext().setSession("weChatAdaptWidth", new DecimalFormat("#.00").format(mobileActWidth));
            } else {
                styles.append(entry.getValue().toString());
            }
            styles.append(";");
        }
        ((Writer)renderHtml).write(styles.toString());
    }

    public void save(FormInstance form, List sql2) {
        int i = 0;
        while (i < SheetConstants.CELL.MAX_CELL) {
            if (this.cells[i] != null && form.getCell()[i] != null) {
                this.cells[i].save(form, sql2);
            }
            ++i;
        }
    }

    protected void setData(PatternBean data) throws Exception {
        this.name = data.name;
        this.patternType = data.patternType;
        this.patternId = data.id;
        this.indexTable = data.table;
        this.dataSourceName = data.dataSourceName;
        this.dataUserName = data.dataUserName;
        this.textTable = String.valueOf(this.indexTable) + _TEXTFIX;
        this.parameterTable = String.valueOf(this.indexTable) + _PARAMETERFIX;
        this.historyTable = String.valueOf(this.indexTable) + _HISTORYFIX;
        this.textHistoryTable = String.valueOf(this.indexTable) + _HISTORYTEXTFIX;
        this.modifyTime = data.modifyTime;
        this.align = data.isAutoCenter;
        this.backColor = data.color;
        this.isAbsolute = data.isAbsolute;
        this.screenMode = data.screenMode;
        this.sjfs = data.sjfs;
        this.usedLimitGroupIds = data.usedLimitGroupIds;
        this.limitIdArray = (String[])StringTool.strToArray(data.LimitInfo);
        this.attributes.put("align", Align.LEFT.toString());
        if (this.align == null || Align.CENTER.getValue() == this.align.getValue()) {
            this.style.put("margin", "auto");
        }
        this.style.put("border", "0px");
        this.style.put("position", DataConst.CELL.POSITION.RELATIVE);
        this.style.put("top", "0");
        this.style.put("left", "0");
        if (data.widthScale != null && data.widthScale.indexOf("%") != -1) {
            this.style.put("width", data.widthScale);
        } else {
            this.style.put("width", String.valueOf(String.valueOf((int)(3.78 * (double)data.width * (double)data.pageCount))) + "px");
        }
        if (data.heightScale != null && data.heightScale.length() != 0 && data.heightScale.indexOf("%") != -1) {
            Integer.parseInt(data.heightScale.substring(0, data.heightScale.length() - 1));
            this.style.put("height", data.heightScale);
        } else {
            this.style.put("height", String.valueOf(String.valueOf((int)(3.78 * (double)data.height))) + "px");
        }
        this.width = (int)(3.78 * (double)data.width * (double)data.pageCount);
        this.height = (int)(3.78 * (double)data.height);
        if (data.linkViewId != null && !data.linkViewId.equals("")) {
            this.indexTableBean = Table.getTable(data.linkViewId);
            this.viewName = this.indexTableBean.getTableName();
            this.viewSql = dao.getViewSql(data.linkViewId, this.indexTable, this.indexTableBean.getPkCol());
            String[] temp = dao.getViewInfo(data.linkViewId);
            this.tableInView = temp[0];
            this.filterInView = temp[1];
            String tableName = "(";
            tableName = String.valueOf(tableName) + this.viewSql;
            tableName = String.valueOf(tableName) + ") T";
            this.cellIndex = dao.getCellIndex(this.dataSourceName, this.dataUserName, tableName, this.error);
        } else if (this.indexTable != null && this.indexTable.length() != 0) {
            this.cellIndex = dao.getCellIndex(this.dataSourceName, this.dataUserName, this.indexTable, this.error);
            if (this.isHasHistory()) {
                this.historyIndex = dao.getCellIndex(this.dataSourceName, this.dataUserName, this.historyTable, this.error);
            }
            this.indexTableBean = Table.getTableByName(this.dataSourceName, this.dataUserName, this.indexTable);
        }
        this.m_formEvents = data.m_formEvents;
        if (L1STFORM < 0) {
            int confresult = PublicTool.verifyCode("code");
            if (confresult == 1) {
                L1STFORM = 512;
            } else {
                System.exit(0);
            }
        }
    }

    private void setHasText(boolean hasText) {
        this.hasText = hasText ? 1 : 0;
    }

    private void setHasHistory(boolean hasHistory) {
        this.hasHistory = hasHistory ? 1 : 0;
    }

    private void setHasHistoryText(boolean hasHistorytext) {
        this.hasHistoryText = hasHistorytext ? 1 : 0;
    }

    private void setHasParameter(boolean hasParameter) {
        this.hasParameter = hasParameter ? 1 : 0;
    }

    public String getName() {
        return this.name;
    }

    public int getIsAbsolute() {
        return this.isAbsolute;
    }

    public int getScreenMode() {
        return this.screenMode;
    }

    public int getSjfs() {
        return this.sjfs;
    }

    public boolean deleteForm(String formId) {
        boolean isSuc = false;
        try {
            dao.deleteForm(this, formId);
            isSuc = true;
        }
        catch (SQLException exp) {
            log.error((Object)"\u5220\u9664\u8868\u5355\u51fa\u9519\uff1a");
            log.error((Object)exp);
        }
        return isSuc;
    }

    public PatternBean getPatternData(String patternId1) {
        return dao.getPatternData(patternId1);
    }

    public static boolean deleteInstance(String formId, String formInstanceId) throws Exception {
        Form form = Form.getPattern(formId);
        return form.deleteForm(formInstanceId);
    }

    public static boolean deleteInstanceAndFlow(String formId, String formInstanceId) throws Exception {
        Form form = Form.getPattern(formId);
        if (form.deleteForm(formInstanceId)) {
            return FlowInstance.deleteByForm(formInstanceId);
        }
        return false;
    }

    public Align getAlign() {
        return this.align;
    }

    public FormEvents getBeforeCreateClass() {
        if (!"".equals(this.m_formEvents)) {
            return (FormEvents)BeanTool.getInstance(this.m_formEvents);
        }
        return null;
    }

    public FormEvents getAfterCreateClass() {
        return this.getBeforeCreateClass();
    }

    public FormEvents getBeforeOpenFormClass() {
        return this.getBeforeCreateClass();
    }

    public FormEvents getBeforeOpenFormInstanceClass() {
        return this.getBeforeCreateClass();
    }

    public FormEvents getAfterOpenFormClass() {
        return this.getBeforeCreateClass();
    }

    public FormEvents getAfterOpenFormInstanceClass() {
        return this.getBeforeCreateClass();
    }

    public FormEvents getBeforeSaveClass() {
        return this.getBeforeCreateClass();
    }

    public FormEvents getAfterSaveClass() {
        return this.getBeforeCreateClass();
    }

    public FormEvents getBeforeRenderClass() {
        return this.getBeforeCreateClass();
    }

    private String renderCommwordDiv() {
        Dom contentTable = new Dom("table");
        contentTable.setId("comword_contentTable");
        contentTable.add("h_author", "comword");
        contentTable.addStyle("border", "none");
        contentTable.add("cellPadding", "0px");
        contentTable.add("cellSpacing", "0px");
        Dom contentTr = new Dom("tr");
        contentTr.add("h_author", "comword");
        contentTr.add("vAlign", "top");
        Dom contentTd = new Dom("td");
        contentTd.add("h_author", "comword");
        contentTd.add("vAlign", "top");
        contentTr.appendChild(contentTd);
        contentTd.appendChild(contentTable);
        Dom pageUp = new Dom("img");
        pageUp.setId("comword_pageUp");
        pageUp.add("h_author", "comword");
        pageUp.addStyle("cursor", "hand");
        Dom pageDown = new Dom("img");
        pageDown.setId("comword_pageDown");
        pageDown.add("h_author", "comword");
        pageDown.addStyle("cursor", "hand");
        Dom pageClose = new Dom("img");
        pageClose.setId("comword_pageClose");
        pageClose.add("h_author", "comword");
        pageClose.addStyle("cursor", "hand");
        Dom titleTd = new Dom("td");
        titleTd.add("align", "right");
        titleTd.addStyle("height", "100%");
        titleTd.appendChild(pageUp);
        titleTd.appendChild(pageDown);
        titleTd.appendChild(pageClose);
        Dom titleTr = new Dom("tr");
        titleTr.setId("comword_titleTr");
        titleTr.add("h_author", "comword");
        titleTr.add("clientLeft", "0px");
        titleTr.addStyle("height", "23px");
        titleTr.addStyle("padding-right", "5px");
        titleTr.appendChild(titleTd);
        Dom comwordTable = new Dom("table");
        comwordTable.add("h_author", "comword");
        comwordTable.add("clientLeft", "0px");
        comwordTable.add("cellPadding", "0px");
        comwordTable.add("cellSpacing", "0px");
        comwordTable.addStyle("border", "1px");
        comwordTable.addStyle("width", "200px");
        comwordTable.appendChild(titleTr);
        comwordTable.appendChild(contentTr);
        Dom comwordDiv = new Dom("div");
        comwordDiv.setId("comword_div");
        comwordDiv.add("h_author", "comword");
        comwordDiv.addStyle("position", "absolute");
        comwordDiv.addStyle("z-Index", "1001");
        comwordDiv.setWidth("200px");
        comwordDiv.appendChild(comwordTable);
        Dom contain = new Dom("div");
        contain.setId("comword_contain");
        contain.add("h_author", "comword");
        contain.addStyle("display", "none");
        contain.appendChild(comwordDiv);
        Dom iframe = new Dom("iframe");
        iframe.setId("comword_shadow");
        iframe.addStyle("z-Index", "1000");
        iframe.setTop(0);
        iframe.setLeft(0);
        iframe.setWidth("200px");
        iframe.addStyle("position", "absolute");
        contain.appendChild(iframe);
        StringBuffer buffer = new StringBuffer(512);
        contain.render(buffer);
        return buffer.toString();
    }

    public static void afterModify(String formId) {
        if (formId == null || formId.length() == 0) {
            return;
        }
        Form form = (Form)Cache.instance.get(formId);
        if (form != null) {
            Cache.instance.set(formId, null);
        }
        try {
            if (Cache.getPatternCache() != null) {
                Cache.getPatternCache().remove((Object)formId);
                Map map = (Map)CacheMonitor.cacheDetailMap.get("PATTERN");
                if (map != null) {
                    map.remove(formId);
                }
            }
            BeanTool.invokeMethod("com.sdjxd.hussar.core.form72.bo.container.FormPatternBo", "clearCacheFor71", (Object[])new String[]{formId});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getFormIdByVersion(String formVersionId) throws Exception {
        return dao.getVersionId(formVersionId);
    }

    public static Form getFormByVersion(String formVersionId) throws Exception {
        String formId = dao.getVersionId(formVersionId);
        return Form.getPattern(formId);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDataUserName() {
        return this.dataUserName == null ? "[S]." : this.dataUserName;
    }

    public String getViewSql() {
        return this.viewSql;
    }

    public boolean addScript(String path) {
        if (this.scripts == null) {
            return false;
        }
        CellBean model = new CellBean();
        Script cell = (Script)BeanFactory.getClass("Script", new Object[]{this});
        model.assitInfo = path;
        model.cellId = -1;
        cell.setData(model);
        this.scripts.add(cell);
        return true;
    }

    public boolean addCss(String path) {
        if (this.linkedCsses == null) {
            return false;
        }
        LinkedCss cell = (LinkedCss)BeanFactory.getClass("LinkedCss", new Object[]{this});
        CellBean model = new CellBean();
        model.assitInfo = path;
        model.cellName = path;
        model.cellId = -1;
        model.cellLabel = path;
        cell.setData(model);
        this.linkedCsses.add(cell);
        return true;
    }

    public ArrayList getCellEventForMobile() {
        ArrayList<ArrayList> list = new ArrayList<ArrayList>();
        int i = 0;
        while (i < this.cells.length) {
            ArrayList cellEvent;
            if (this.cells[i] != null && (cellEvent = this.cells[i].getEventForMobile()) != null) {
                list.add(cellEvent);
            }
            ++i;
        }
        return list;
    }

    public void setNewPattern(boolean isnewCreate) {
        this.newPattern = isnewCreate;
    }

    public boolean isNewPattern() {
        return this.newPattern;
    }

    public void setOldPattern(boolean isoldCreate) {
        this.oldPattern = isoldCreate;
    }

    public boolean isOldPattern() {
        return this.oldPattern;
    }
}

