/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.CellActionBean;
import com.sdjxd.pms.platform.form.model.CellEventBean;
import com.sdjxd.pms.platform.form.service.Action;
import com.sdjxd.pms.platform.form.service.cell.Cell;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.util.ArrayList;
import java.util.List;

public class CellEvent
extends BaseClass {
    private static final long serialVersionUID = 1L;
    protected int eventId;
    private static CellEventBean[] allEvent;
    protected String eventCode;
    protected int cellId;
    private static int MAXACTION;
    protected Action[] actions = new Action[MAXACTION];
    protected String[] strAction = new String[MAXACTION];
    protected int strActionSize = 0;

    static {
        CellEvent.getEvent();
        MAXACTION = 10;
    }

    private CellEvent() {
    }

    public CellEvent(CellActionBean data) {
        this();
        this.eventId = data.getEventId();
        this.eventCode = data.getEventCode();
        this.addAction(data);
    }

    public CellEvent(String eventCode, int cellId, String strAction) {
        this();
        this.eventId = CellEvent.getEventId(eventCode);
        this.eventCode = eventCode;
        this.addAction(cellId, strAction);
    }

    public CellEvent(int eventId, int cellId, String strAction) {
        this();
        this.eventId = eventId;
        this.eventCode = allEvent[eventId].getEventCode();
        this.addAction(cellId, strAction);
    }

    public static CellEventBean[] getEvent() {
        if (allEvent == null) {
            allEvent = new CellEventBean[Cell.MAXEVENT];
            List beans = ((PatternDao)BeanFactory.getSingleInstance("PatternDao")).getEvent();
            int len = beans.size();
            int i = 0;
            while (i < len) {
                CellEventBean bean;
                CellEvent.allEvent[bean.getEventId()] = bean = (CellEventBean)beans.get(i);
                ++i;
            }
        }
        return allEvent;
    }

    public static int getEventId(String eventCode) {
        if (eventCode == null || eventCode.length() == 0) {
            return -1;
        }
        int i = 0;
        while (i < Cell.MAXEVENT) {
            if (allEvent[i] != null && eventCode.equals(allEvent[i].getEventCode())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addAction(CellActionBean data) {
        this.cellId = data.getCellId();
        int actionOrder = data.getActionOrder();
        if (this.actions[actionOrder] != null) {
            this.actions[actionOrder].addParam(data);
        } else {
            this.actions[actionOrder] = new Action(data);
        }
    }

    public void addAction(int cellId, String action) {
        if (action != null && action.length() != 0 && !this.hasAction(action)) {
            this.cellId = cellId;
            this.strAction[this.strActionSize++] = action;
        }
    }

    public boolean hasAction(int actionOrder) {
        return this.actions[actionOrder] == null;
    }

    public boolean hasAction(String action) {
        int i = 0;
        while (i < this.actions.length) {
            if (this.strAction[i] != null && this.strAction[i].equals(action)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Action getAction(int actionOrder) {
        return this.actions[actionOrder];
    }

    public Action getAction(String actionId) {
        if (StringTool.isEmpty(actionId)) {
            return null;
        }
        int i = 0;
        while (i < MAXACTION) {
            if (this.actions[i] != null && actionId.equals(this.actions[i].getId())) {
                return this.actions[i];
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        System.out.println("toString\u5df2\u52a0\u53c2\u6570:param sender \u4e8b\u4ef6\u6240\u6709\u8005");
        return "toString\u5df2\u52a0\u53c2\u6570:param sender \u4e8b\u4ef6\u6240\u6709\u8005";
    }

    public String toString(String sender) {
        StringBuffer sb = new StringBuffer(128);
        if (sender != null) {
            if ("window".equals(sender)) {
                sb.append("window.COMPattachEvent(").append(sender).append(",\"").append(this.getEventCode());
            } else {
                sb.append(sender).append(".attachEvent(\"").append(this.getEventCode());
            }
            sb.append("\",function(sender){\nvar r=null;\n");
            int i = 0;
            while (i < MAXACTION) {
                if (this.actions[i] != null) {
                    sb.append("r=").append(this.actions[i].toString()).append("\n");
                }
                ++i;
            }
            i = 0;
            while (i < MAXACTION) {
                if (this.strAction[i] != null) {
                    sb.append(this.strAction[i]).append("\n");
                }
                ++i;
            }
            if ("onQueryClose".equals(this.eventCode)) {
                sb.append("if(typeof(r)!=\"undefined\" || r==true)\n return true;\nelse return r;\n});\n");
            } else {
                sb.append("if(typeof(r)!=\"undefined\" && r==false)\n return false;\nelse return true;\n});\n");
            }
        }
        return sb.toString();
    }

    public boolean invokeAction() throws Exception {
        boolean result = false;
        int i = 0;
        while (i < MAXACTION) {
            if (this.actions[i] != null && Boolean.FALSE.equals(result = this.actions[i].invokeAction())) break;
            ++i;
        }
        return result;
    }

    public ArrayList getEventForMobile() {
        ArrayList<ArrayList> actionsList = new ArrayList<ArrayList>();
        int i = 0;
        while (i < MAXACTION) {
            ArrayList actionList;
            if (this.actions[i] != null && (actionList = this.actions[i].getActionForMobile()) != null) {
                actionsList.add(actionList);
            }
            ++i;
        }
        if (actionsList.size() == 0) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.eventCode);
        list.add(actionsList);
        return list;
    }

    public String getEventCode() {
        return this.eventCode;
    }

    public int getEventId() {
        return this.eventId;
    }

    public Action[] getActions() {
        return this.actions;
    }

    public String getEasyUIDataGridString() {
        StringBuffer sb = new StringBuffer(128);
        int i = 0;
        while (i < MAXACTION) {
            if (this.actions[i] != null) {
                sb.append(this.actions[i].toString()).append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public String renderMiniEvent(String sender) {
        StringBuffer sb = new StringBuffer(128);
        if (sender != null) {
            sb.append(sender).append(".on(\"").append(this.getEventCode());
            sb.append("\",function(sender,e){\nvar r=null;\n");
            int i = 0;
            while (i < MAXACTION) {
                if (this.actions[i] != null) {
                    sb.append("r=").append(this.actions[i].toString()).append("\n");
                }
                ++i;
            }
            i = 0;
            while (i < MAXACTION) {
                if (this.strAction[i] != null) {
                    sb.append(this.strAction[i]).append("\n");
                }
                ++i;
            }
            sb.append("if(typeof(r)!=\"undefined\" && r==false)\n return false;\nelse return true;\n});\n");
        }
        return sb.toString();
    }
}

