/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.base.DataStatus;
import com.sdjxd.pms.platform.base.DataType;
import com.sdjxd.pms.platform.form.model.ActionBean;
import com.sdjxd.pms.platform.form.model.CellActionBean;
import com.sdjxd.pms.platform.form.service.ActionParam;
import com.sdjxd.pms.platform.serviceBreak.dao.ServiceBreakDao;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Action
extends BaseClass {
    private static final long serialVersionUID = 1L;
    private static ServiceBreakDao dao = (ServiceBreakDao)BeanFactory.getSingleInstance("ServiceBreakDao");
    protected String code;
    protected String id;
    protected String sid;
    protected String name;
    private static int MAXPARAM = 20;
    private int paramSize = 0;
    private DataStatus dataStatus;
    private DataType dataType;
    private DataModify modify;
    protected ActionParam[] params = new ActionParam[MAXPARAM];
    private static String[] MOBILE_ACTION = new String[]{""};

    public Action() {
    }

    public Action(CellActionBean data) {
        this();
        this.setData(data);
    }

    public void setData(CellActionBean data) {
        this.setId(data.getId());
        this.setCode(data.getCode());
        this.setName(data.getName());
        this.addParam(data);
    }

    public void setData(ActionBean data) {
        this.setId(data.getId());
        this.setCode(data.getCode());
        this.setName(data.getName());
        this.setSid(data.getSid());
        this.setDataType(DataType.getInstance(data.getDataType()));
        this.setDataStatus(DataStatus.getInstance(data.getDataStatusId()));
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setId(String id) {
        if (this.id == null) {
            int i = 0;
            while (i < MAXPARAM) {
                if (this.params[i] != null) {
                    this.params[i].setActionId(id);
                }
                ++i;
            }
        }
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(128);
        str.append(this.code);
        str.append("(");
        if (this.paramSize > 0) {
            int i = 0;
            while (i < MAXPARAM) {
                if (this.params[i] != null) {
                    str.append(this.params[i].toString());
                    str.append(",");
                }
                ++i;
            }
            str.setLength(str.length() - 1);
        }
        str.append(")");
        return str.toString();
    }

    public void addParam(CellActionBean data) {
        String paramId = data.getParamId();
        if (paramId != null && paramId.length() != 0) {
            int paramOrder = data.getParamOrder();
            this.params[paramOrder] = new ActionParam(data);
            ++this.paramSize;
        }
    }

    public void save() throws SQLException {
        if (this.modify.is(DataModify.NEW)) {
            dao.addAction(this);
        } else {
            dao.updateAction(this);
        }
        if (this.paramSize > 0) {
            int i = 0;
            while (i < MAXPARAM) {
                if (this.params[i] != null) {
                    this.params[i].save();
                }
                ++i;
            }
        }
    }

    public void addParam(ActionParam param) {
        String paramName;
        if (this.id != null) {
            param.setActionId(this.id);
        }
        if ((paramName = param.getName()) != null && paramName.length() != 0) {
            this.params[this.paramSize] = param;
            param.setParamOrder(this.paramSize);
            ++this.paramSize;
        }
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getCode() {
        if (this.code == null) {
            return "";
        }
        return this.code;
    }

    public String getId() {
        return this.id;
    }

    public DataModify getModify() {
        return this.modify;
    }

    public void setModify(DataModify modify) {
        this.modify = modify;
    }

    public DataStatus getDataStatus() {
        return this.dataStatus;
    }

    public void setDataStatus(DataStatus dataStatus) {
        this.dataStatus = dataStatus;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        int i = 0;
        while (i < MAXPARAM) {
            if (this.params[i] != null) {
                this.params[i].setDataType(dataType);
            }
            ++i;
        }
        this.dataType = dataType;
    }

    public static final List getEventMethod(String className) throws Exception {
        List methods = BeanTool.searchMethod(className);
        List methodData = BeanTool.getMethodData(methods);
        System.out.println(BeanTool.toJson(methodData));
        return methodData;
    }

    public boolean invokeAction() throws Exception {
        if (this.isMobileServerAction()) {
            int classNameEnd = this.code.lastIndexOf(".");
            ArrayList<Object> arguments = new ArrayList<Object>();
            int i = 0;
            while (i < MAXPARAM) {
                if (this.params[i] != null) {
                    arguments.add(this.params[i].getParamValue());
                }
                ++i;
            }
            boolean result = (Boolean)BeanTool.invokeMethod(this.code.substring(0, classNameEnd), this.code.substring(classNameEnd + 1), arguments.toArray());
            return result;
        }
        return false;
    }

    public Object getPramValue(String paramId) {
        if (StringTool.isEmpty(paramId)) {
            return null;
        }
        int i = 0;
        while (i < MAXPARAM) {
            if (this.params[i] != null && paramId.equals(this.params[i].getId())) {
                return this.params[i].getParamValue();
            }
            ++i;
        }
        return null;
    }

    public ArrayList getActionForMobile() {
        if (this.isMobileClientAction()) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.code);
            ArrayList<Object> paramsList = new ArrayList<Object>();
            int i = 0;
            while (i < MAXPARAM) {
                if (this.params[i] != null) {
                    paramsList.add(this.params[i].getParamValue());
                }
                ++i;
            }
            list.add(paramsList);
            return list;
        }
        return null;
    }

    public boolean isMobileClientAction() {
        return this.code.startsWith("com.sdjxd.mobile.services.requestmethods.MobileRequestMethod");
    }

    public boolean isMobileServerAction() {
        return !this.code.equalsIgnoreCase("com.sdjxd.mobile.services.requestmethods.MobileRequestMethod.mobileClientMethod");
    }
}

