/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.model;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.ListStyleColumnData;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.ListCell;
import com.sdjxd.pms.platform.table.service.mean.FieldMean;
import com.sdjxd.pms.platform.table.sql.EditGridSql;
import com.sdjxd.pms.platform.tool.BeanTool;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class EditGridData {
    private static Logger daoLogger = Logger.getLogger((String)"EditGridData");
    private List defaultValue = new ArrayList();
    private String queryCondition = "";
    private Map fieldMeans = null;
    private Map verifyMeans = null;

    public EditGridData() {
    }

    public EditGridData(ListCell h_listCell, FormInstance h_formIns) {
        this();
        CellBean cellData = h_listCell.getData();
        TreeMap Item = this.getTableLinkInfo(cellData.tableLinkId, h_formIns);
        if (Item != null) {
            this.queryCondition = Item.get("field") + " = '" + Item.get("fieldValue") + "'";
            this.defaultValue.add(Item);
        }
    }

    public void setFieldMeansDB(String h_styleId, List h_columnData) throws Exception {
        if (h_columnData == null) {
            return;
        }
        this.fieldMeans = new HashMap();
        this.verifyMeans = new HashMap();
        Map mapMean = FieldMean.getListFieldMeanDb(h_styleId);
        int cols = h_columnData.size();
        int i = 0;
        while (i < cols) {
            String[] verifyMeansId;
            ListStyleColumnData column = (ListStyleColumnData)h_columnData.get(i);
            String meanId = column.getMeanId();
            String colName = column.getAsName();
            if (meanId != null && meanId.length() != 0) {
                this.fieldMeans.put(colName, mapMean.get(meanId));
            }
            if ((verifyMeansId = column.getVerifyMeans()) != null && verifyMeansId.length != 0) {
                this.verifyMeans.put(colName, FieldMean.getFieldMeansBean(verifyMeansId));
            }
            ++i;
        }
    }

    public String getQueryCondition() {
        return this.queryCondition;
    }

    public String toJsonString() {
        Map.Entry entry;
        String strItems;
        StringBuffer strJson = new StringBuffer();
        strJson.append("{");
        strJson.append("queryCondition:").append(BeanTool.toJson(this.queryCondition));
        strJson.append(",defaultValue:[");
        int i = 0;
        while (i < this.defaultValue.size()) {
            if (i == 0) {
                strJson.append(BeanTool.toJson(this.defaultValue.get(i)));
            } else {
                strJson.append(",").append(BeanTool.toJson(this.defaultValue.get(i)));
            }
            ++i;
        }
        strJson.append("]");
        if (this.fieldMeans != null) {
            strJson.append(",fieldMeans:{");
            Iterator it = this.fieldMeans.entrySet().iterator();
            strItems = "";
            while (it.hasNext()) {
                entry = it.next();
                strItems = String.valueOf(strItems) + ",";
                strItems = String.valueOf(strItems) + entry.getKey();
                strItems = String.valueOf(strItems) + ":";
                strItems = String.valueOf(strItems) + BeanTool.toJson(entry.getValue());
            }
            if (strItems.length() > 2) {
                strJson.append(strItems.substring(1));
            }
            strJson.append("}");
        }
        if (this.verifyMeans != null) {
            strJson.append(",verifyMeans:{");
            Iterator it = this.verifyMeans.entrySet().iterator();
            strItems = "";
            while (it.hasNext()) {
                entry = it.next();
                strItems = String.valueOf(strItems) + ",";
                strItems = String.valueOf(strItems) + entry.getKey();
                strItems = String.valueOf(strItems) + ":";
                strItems = String.valueOf(strItems) + BeanTool.toJson(entry.getValue());
            }
            if (strItems.length() > 2) {
                strJson.append(strItems.substring(1));
            }
            strJson.append("}");
        }
        strJson.append("}");
        return strJson.toString();
    }

    private TreeMap getTableLinkInfo(String h_tableLinkId, FormInstance h_formIns) {
        String field = "";
        String PField = "";
        String fieldValue = "";
        String sql2 = EditGridSql.getTableLinkSql(h_tableLinkId);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs != null && rs.next()) {
                field = rs.getString("LINKCOLUMNID");
                PField = rs.getString("PKEYCOLUMNID");
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)exp);
            return null;
        }
        fieldValue = h_formIns.getId();
        if (fieldValue == null || "".equals(fieldValue)) {
            fieldValue = Global.getContext().getParameter("parentID");
        }
        if (field == null || "".equals(field) || fieldValue == null || "".equals(fieldValue)) {
            return null;
        }
        TreeMap<String, String> item = new TreeMap<String, String>();
        item.put("type", "0");
        item.put("field", field);
        item.put("fieldValue", fieldValue);
        return item;
    }
}

