/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.dao;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.Constants;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.DropDownOptionBean;
import com.sdjxd.pms.platform.form.model.LinkApp;
import com.sdjxd.pms.platform.form.model.LinkAppTable;
import com.sdjxd.pms.platform.form.model.TreeDaoBean;
import com.sdjxd.pms.platform.form.model.TreeNodeBean;
import com.sdjxd.pms.platform.form.sql.PatternSql;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class TreeDao
extends BaseClass {
    private static final long serialVersionUID = 1L;
    private static Logger daoLogger = Logger.getLogger(PatternDao.class);
    private HashMap m_appMap = new HashMap();
    private List m_appLinkList = new ArrayList();
    private List m_appTableList = new ArrayList();
    private String m_appId = "";
    private HashMap m_hasChildsMap = new HashMap();
    private LinkApp linkApp = null;

    private static PatternSql getSqlHelper(String m_dataSourceName) {
        return (PatternSql)BeanFactory.getSqlInstance(TreeDao.class, "PatternSql", m_dataSourceName);
    }

    public TreeDao(String appId) {
        this.m_appId = appId;
        if (!this.init()) {
            this.m_appId = "";
        }
    }

    public boolean init() {
        this.m_appMap.clear();
        this.m_appLinkList.clear();
        this.m_appTableList.clear();
        TreeDaoBean treeDaoBean = TreeDaoBean.getTreeDaoBean(this.m_appId);
        if (treeDaoBean != null) {
            this.m_appMap = treeDaoBean.getM_appMap();
            this.getLinkApp();
            this.m_appLinkList = treeDaoBean.getM_appLinkList();
            this.m_appTableList = treeDaoBean.getM_appTableList();
            return true;
        }
        return false;
    }

    public TreeNodeBean[] getLinkAppRootNodeArray(LinkApp linkApp, boolean createAllNode, StringBuffer script, boolean outputJS) {
        String sql2 = TreeDao.getSqlHelper(linkApp.getDataSourceName()).getLinkAppRootNodeSQL(linkApp);
        String nodeKey = String.valueOf(linkApp.getTableId()) + "__0_";
        if (createAllNode) {
            this.getHasChildNodesSheetID(linkApp.getTableId(), "", "0", "", null, null, null, null);
        }
        TreeNodeBean[] rootNodeArray = new TreeNodeBean[1000];
        int curLen = 0;
        try {
            sql2 = StringTool.replaceKeyWord(sql2);
            RowSet rs = DbOper.executeQuery(linkApp.getDataSourceName(), sql2);
            String value = "";
            while (rs.next()) {
                Object o;
                String key;
                String picPath;
                String id = rs.getString("SHEETID");
                String name = this.getNodeShowName(rs, linkApp.getNameColumn());
                String nodeGuid = Guid.create();
                if (!createAllNode) {
                    this.getHasChildNodesSheetID(linkApp.getTableId(), "", "0", linkApp.getDataUserName(), linkApp.getTableName(), linkApp.getKeyColumn(), linkApp.getKeyColumn(), id);
                }
                if (outputJS) {
                    script.append("nodeInfo=new TreeNode();");
                    script.append("nodeInfo.objectId='").append(id).append("';");
                    script.append("nodeInfo.id='").append(nodeGuid).append("';");
                    script.append("nodeInfo.text='").append(StringTool.toJson(StringTool.toJson(name))).append("';");
                    script.append("nodeInfo.tableId='").append(linkApp.getTableId()).append("';");
                    script.append("nodeInfo.parentObjectId='';");
                    script.append("nodeInfo.parentId='';");
                    script.append("nodeInfo.isShowInfo='").append(linkApp.getIsShowInfo()).append("';");
                    script.append("nodeInfo.infoFormId='").append(linkApp.getInfoFormID()).append("';");
                    script.append("nodeInfo.infoShowProjectId='").append(linkApp.getInfoShowProject()).append("';");
                    if (createAllNode) {
                        script.append("nodeInfo.isGetData=true;");
                    } else {
                        script.append("nodeInfo.isGetData=false;");
                    }
                    if (this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + id) || this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + "AllSheetIDContains")) {
                        script.append("nodeInfo.childs=new Array();");
                    } else {
                        script.append("nodeInfo.childs=null;");
                    }
                    picPath = linkApp.getPicPath();
                    if (picPath == null || picPath.length() == 0) {
                        picPath = "/pms/platform/image/folder2.gif";
                    } else {
                        script.append("nodeInfo.miniIconSrc='").append(Global.getName()).append(this.getNodeShowName(rs, picPath)).append("';");
                    }
                    script.append("nodeInfo.iconSrc='").append(Global.getName()).append(this.getNodeShowName(rs, picPath)).append("';");
                    int i = 1;
                    while (i <= rs.getMetaData().getColumnCount()) {
                        key = rs.getMetaData().getColumnName(i);
                        if (!key.equals("SHEETID") && !key.equals("SHEETNAME")) {
                            o = rs.getObject(key);
                            value = o != null ? o.toString() : "";
                            script.append("nodeInfo.").append(key).append("='").append(StringTool.toJson(StringTool.toJson(value)).replaceAll("'", "\\\\\\\\'")).append("';");
                        }
                        ++i;
                    }
                    script.append(linkApp.getJsName()).append("._nodeInfoArray.push(nodeInfo);");
                    script.append(linkApp.getJsName()).append("._nodeArray['").append(nodeGuid).append("']=nodeInfo;");
                    if (!createAllNode || !this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + id) && !this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + "AllSheetIDContains")) continue;
                    HashMap loadedNodeInfo = new HashMap();
                    if (!createAllNode) continue;
                    this.getLinkAppTableNodeArray(linkApp.getAppId(), linkApp.getDataSourceName(), linkApp.getTableId(), "", id, linkApp.getCellId(), "0", "", loadedNodeInfo, script, nodeGuid, true);
                    continue;
                }
                rootNodeArray[curLen] = new TreeNodeBean();
                rootNodeArray[curLen].setObjectId(id);
                rootNodeArray[curLen].setId(nodeGuid);
                rootNodeArray[curLen].setText(name);
                rootNodeArray[curLen].setTableId(linkApp.getTableId());
                rootNodeArray[curLen].setParentObjectId("");
                rootNodeArray[curLen].setParentId("");
                rootNodeArray[curLen].setIsShowInfo(linkApp.getIsShowInfo());
                rootNodeArray[curLen].setInfoFormId(linkApp.getInfoFormID());
                rootNodeArray[curLen].setInfoShowProjectId(linkApp.getInfoShowProject());
                if (createAllNode) {
                    rootNodeArray[curLen].setGetData(true);
                } else {
                    rootNodeArray[curLen].setGetData(false);
                }
                if (this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + id) || this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + "AllSheetIDContains")) {
                    rootNodeArray[curLen].setChilds(new TreeNodeBean[0]);
                } else {
                    rootNodeArray[curLen].setChilds(null);
                }
                picPath = linkApp.getPicPath();
                if (picPath == null || picPath.length() == 0) {
                    picPath = "/pms/platform/image/folder2.gif";
                } else {
                    rootNodeArray[curLen].setMiniIconSrc(String.valueOf(Global.getName()) + this.getNodeShowName(rs, picPath));
                }
                rootNodeArray[curLen].setIconSrc(String.valueOf(Global.getName()) + this.getNodeShowName(rs, picPath));
                int i = 1;
                while (i <= rs.getMetaData().getColumnCount()) {
                    key = rs.getMetaData().getColumnName(i);
                    if (!key.equals("SHEETID") && !key.equals("SHEETNAME")) {
                        o = rs.getObject(key);
                        value = o != null ? o.toString() : "";
                        rootNodeArray[curLen].attachField.put(key, value);
                    }
                    ++i;
                }
                if (createAllNode && (this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + id) || this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + "AllSheetIDContains"))) {
                    HashMap loadedNodeInfo = new HashMap();
                    if (createAllNode) {
                        TreeNodeBean[] childNodes = this.getLinkAppTableNodeArray(linkApp.getAppId(), linkApp.getDataSourceName(), linkApp.getTableId(), "", id, linkApp.getCellId(), "0", "", loadedNodeInfo, script, nodeGuid, false);
                        rootNodeArray[curLen].setChilds(childNodes);
                    }
                }
                ++curLen;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            daoLogger.error((Object)("getLinkAppRootNode(LinkApp linkApp)\u62a5\u9519\uff1a" + e.getMessage()));
        }
        TreeNodeBean[] curRootArray = new TreeNodeBean[curLen];
        int i = 0;
        while (i < curLen) {
            curRootArray[i] = rootNodeArray[i];
            ++i;
        }
        return curRootArray;
    }

    public TreeNodeBean[] getLinkAppTableNodeArray(String appId, String dataSourceName, String tableId, String linkId, String sheetId, int cellId, String isGroup, String gId, HashMap loadedNodeInfo, StringBuffer script, String parentNodeGuid, boolean outputJS) {
        LinkAppTable lat = null;
        ArrayList<LinkAppTable> list = new ArrayList<LinkAppTable>();
        List latList = null;
        RowSet rs = null;
        HashMap tmpMap = null;
        latList = this.getLinkAppTable(tableId, linkId, isGroup);
        int i = 0;
        while (i < latList.size()) {
            tmpMap = (HashMap)latList.get(i);
            lat = new LinkAppTable();
            lat.setAppId(this.m_appId);
            lat.setTableId((String)tmpMap.get("TABLEID"));
            lat.setTableName((String)tmpMap.get("TABLENAME"));
            lat.setAttColumn((String)tmpMap.get("ATTCOLUMN"));
            lat.setAttTable((String)tmpMap.get("ATTTABLE"));
            lat.setFilter((String)tmpMap.get("FILTER"));
            lat.setOrderBy((String)tmpMap.get("ORDERBY"));
            lat.setNameColumn((String)tmpMap.get("SHOWNAMECOL"));
            lat.setKeyColumn((String)tmpMap.get("PKCOL"));
            lat.setPicPath((String)tmpMap.get("PICPATH"));
            lat.setTableName((String)tmpMap.get("TABLENAME"));
            lat.setDataUserName((String)tmpMap.get("DATAUSERNAME"));
            lat.setLinkColumn((String)tmpMap.get("LINKCOLUMNID"));
            lat.setLinkId((String)tmpMap.get("LINKID"));
            lat.setIsShowInfo(Integer.parseInt((String)tmpMap.get("ISSHOWINFO")));
            lat.setInfoFormID((String)tmpMap.get("INFOFORMID"));
            lat.setInfoShowProject((String)tmpMap.get("INFOJMID"));
            lat.setLimitId((String)tmpMap.get("LIMITINFO"));
            if (!"1".equals(isGroup)) {
                lat.setShowType(Integer.parseInt((String)tmpMap.get("SHOWTYPE")));
            }
            lat.setGroupColumn((String)tmpMap.get("GROUPCOLUMN"));
            lat.setGroupOrderby((String)tmpMap.get("GROUPORDERBY"));
            if (tmpMap.get("ATTGROUP") == null) {
                lat.setAttachGroup("");
            } else {
                lat.setAttachGroup((String)tmpMap.get("ATTGROUP"));
            }
            list.add(lat);
            ++i;
        }
        StringBuffer[] arrSB = new StringBuffer[list.size()];
        TreeNodeBean[] nodeArray = new TreeNodeBean[10000];
        int curLen = 0;
        String[] attachGroupNodeText = new String[list.size()];
        int curAttachGroupNodeText = 0;
        if (list.size() != 0) {
            int j = 0;
            while (j < list.size()) {
                lat = (LinkAppTable)list.get(j);
                if (lat != null) {
                    String nodeGuid;
                    String sql2;
                    arrSB[j] = new StringBuffer();
                    if (SheetConstants.LINK_SHOW_TYPE.isDirect(lat.getShowType())) {
                        String nodeKey = String.valueOf(lat.getTableId()) + "__0_";
                        if (loadedNodeInfo != null) {
                            this.getHasChildNodesSheetID(lat.getTableId(), "", "0", "", null, null, null, null);
                        } else {
                            this.getHasChildNodesSheetID(lat.getTableId(), "", "0", lat.getDataUserName(), lat.getTableName(), lat.getLinkColumn(), lat.getKeyColumn(), sheetId);
                        }
                        sql2 = TreeDao.getSqlHelper(dataSourceName).getLinkAppTableNodeSQL(lat, sheetId, isGroup, gId);
                        sql2 = StringTool.replaceKeyWord(sql2);
                        sql2 = StringTool.replace(sql2, "='" + Constants.resources_blankRootNodeId + "'", " is null");
                        try {
                            rs = DbOper.executeQuery(dataSourceName, sql2);
                            String value = "";
                            while (rs.next()) {
                                Object o;
                                String key;
                                String picpath = lat.getPicPath();
                                String miniPicPath = lat.getPicPath();
                                if (picpath == null || picpath.length() == 0) {
                                    try {
                                        if (rs.getObject("PICPATH") != null) {
                                            picpath = rs.getString("PICPATH");
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                picpath = picpath == null || picpath.length() == 0 ? "/pms/platform/image/folder2.gif" : this.getNodeShowName(rs, picpath);
                                String id = rs.getString("SHEETID");
                                String name = this.getNodeShowName(rs, lat.getNameColumn());
                                nodeGuid = Guid.create();
                                if (outputJS) {
                                    script.append("nodeInfo=new TreeNode();");
                                    script.append("nodeInfo.objectId='").append(id).append("';");
                                    script.append("nodeInfo.id='").append(nodeGuid).append("';");
                                    script.append("nodeInfo.text='").append(StringTool.toJson(StringTool.toJson(name))).append("';");
                                    script.append("nodeInfo.tableId='").append(lat.getTableId()).append("';");
                                    script.append("nodeInfo.parentObjectId='").append(sheetId).append("';");
                                    script.append("nodeInfo.linkId='").append(lat.getLinkId()).append("';");
                                    script.append("nodeInfo.infoShowProjectId='").append(lat.getInfoShowProject()).append("';");
                                    script.append("nodeInfo.iconSrc='").append(Global.getName()).append(picpath).append("';");
                                    if (!StringTool.isEmpty(miniPicPath)) {
                                        script.append("nodeInfo.miniIconSrc='").append(Global.getName()).append(miniPicPath).append("';");
                                    }
                                    script.append("nodeInfo.isShowInfo='").append(lat.getIsShowInfo()).append("';");
                                    script.append("nodeInfo.infoFormId='").append(lat.getInfoFormID()).append("';");
                                    script.append("nodeInfo.isGroup='0';");
                                    if (loadedNodeInfo != null) {
                                        script.append("nodeInfo.isGetData=true;");
                                    } else {
                                        script.append("nodeInfo.isGetData=false;");
                                    }
                                    if (this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + id) || this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + "AllSheetIDContains")) {
                                        script.append("nodeInfo.childs=new Array();");
                                    } else {
                                        script.append("nodeInfo.childs=null;");
                                    }
                                    int i2 = 1;
                                    while (i2 <= rs.getMetaData().getColumnCount()) {
                                        key = rs.getMetaData().getColumnName(i2);
                                        if (!key.equals("SHEETID") && !key.equals("SHEETNAME")) {
                                            o = rs.getObject(key);
                                            value = o != null ? o.toString() : "";
                                            script.append("nodeInfo.").append(key).append("='").append(StringTool.toJson(StringTool.toJson(value)).replaceAll("'", "\\\\\\\\'")).append("';");
                                        }
                                        ++i2;
                                    }
                                    script.append("nodeInfo.parentId='").append(parentNodeGuid).append("';");
                                    script.append("Tree_").append(cellId).append("._nodeArray['").append(nodeGuid).append("']=nodeInfo;");
                                    script.append("Tree_").append(cellId).append(".getNode('").append(parentNodeGuid).append("', true).childs.push(nodeInfo);");
                                    if (loadedNodeInfo == null || !this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + id) && !this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + "AllSheetIDContains")) continue;
                                    this.getLinkAppTableNodeArray(appId, dataSourceName, lat.getTableId(), lat.getLinkId(), id, cellId, "0", "", loadedNodeInfo, script, nodeGuid, true);
                                    continue;
                                }
                                if (curLen == 999) {
                                    curLen = 999;
                                }
                                nodeArray[curLen] = new TreeNodeBean();
                                nodeArray[curLen].setObjectId(rs.getString("SHEETID"));
                                nodeArray[curLen].setId(nodeGuid);
                                nodeArray[curLen].setText(this.getNodeShowName(rs, lat.getNameColumn()));
                                nodeArray[curLen].setTableId(lat.getTableId());
                                nodeArray[curLen].setParentObjectId(sheetId);
                                nodeArray[curLen].setLinkId(lat.getLinkId());
                                nodeArray[curLen].setInfoShowProjectId(lat.getInfoShowProject());
                                nodeArray[curLen].setExpanded(false);
                                nodeArray[curLen].setParentId(parentNodeGuid);
                                nodeArray[curLen].setIconSrc(String.valueOf(Global.getName()) + picpath);
                                if (!StringTool.isEmpty(miniPicPath)) {
                                    nodeArray[curLen].setMiniIconSrc(String.valueOf(Global.getName()) + miniPicPath);
                                }
                                nodeArray[curLen].setIsShowInfo(lat.getIsShowInfo());
                                nodeArray[curLen].setInfoFormId(lat.getInfoFormID());
                                nodeArray[curLen].setGroup("0");
                                int i3 = 1;
                                while (i3 <= rs.getMetaData().getColumnCount()) {
                                    key = rs.getMetaData().getColumnName(i3);
                                    if (!key.equals("SHEETID") && !key.equals("SHEETNAME")) {
                                        o = rs.getObject(key);
                                        value = o != null ? o.toString() : "";
                                        nodeArray[curLen].attachField.put(key, value);
                                    }
                                    ++i3;
                                }
                                if (loadedNodeInfo != null) {
                                    nodeArray[curLen].setGetData(true);
                                    if (this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + id) || this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + "AllSheetIDContains")) {
                                        TreeNodeBean[] childNodes = this.getLinkAppTableNodeArray(appId, dataSourceName, lat.getTableId(), lat.getLinkId(), id, cellId, "0", "", loadedNodeInfo, script, nodeArray[curLen].getId(), false);
                                        nodeArray[curLen].setChilds(childNodes);
                                    } else {
                                        nodeArray[curLen].setChilds(null);
                                    }
                                } else {
                                    nodeArray[curLen].setGetData(false);
                                    if (this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + id) || this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + "AllSheetIDContains")) {
                                        TreeNodeBean[] childNodes = new TreeNodeBean[]{};
                                        nodeArray[curLen].setChilds(childNodes);
                                    } else {
                                        nodeArray[curLen].setChilds(null);
                                    }
                                }
                                ++curLen;
                            }
                        }
                        catch (Exception e) {
                            daoLogger.error((Object)("getLinkAppTableNodeInfo(String appId, String tableId)\u62a5\u95192\uff1a" + e.getMessage()));
                        }
                    } else if (SheetConstants.LINK_SHOW_TYPE.isGroup(lat.getShowType()) && lat.getAttachGroup().length() == 0) {
                        sql2 = TreeDao.getSqlHelper(dataSourceName).getColumnPropertyInfo(lat.getTableId(), lat.getGroupColumn());
                        boolean isIdStrPicker = false;
                        String assitInfo = "";
                        String meanType = "";
                        String meanDataSourceName = "";
                        try {
                            rs = DbOper.executeQuery("defaultds", sql2);
                            if (rs.next()) {
                                meanType = rs.getString("MEANTYPE");
                                assitInfo = rs.getString("ASSITINFO");
                                meanDataSourceName = rs.getString("DATASOURCENAME");
                            }
                        }
                        catch (Exception e) {
                            daoLogger.error((Object)("getLinkAppTableNodeInfo(String appId, String tableId)\u62a5\u95193\uff1a" + e.getMessage()));
                        }
                        if (meanType.length() != 0 && meanType.equals("IDStringPicker")) {
                            isIdStrPicker = true;
                        }
                        ArrayList<String> nodeNames = new ArrayList<String>();
                        ArrayList<String> nodeValues = new ArrayList<String>();
                        sql2 = TreeDao.getSqlHelper(dataSourceName).getLinkAppTableGroupNodeSQL(lat, sheetId);
                        sql2 = StringTool.replaceKeyWord(sql2);
                        try {
                            rs = DbOper.executeQuery(dataSourceName, sql2);
                            while (rs.next()) {
                                String groupName = rs.getString("GROUPNAME");
                                if (groupName == null || "".equals(groupName)) {
                                    if (nodeValues.contains("")) continue;
                                    nodeValues.add("");
                                    continue;
                                }
                                nodeValues.add(groupName);
                            }
                        }
                        catch (Exception e) {
                            daoLogger.error((Object)("getLinkAppTableNodeInfo(String appId, String tableId)\u62a5\u95194\uff1a" + e.getMessage()));
                        }
                        if (isIdStrPicker) {
                            assitInfo = StringTool.replaceKeyWord(assitInfo);
                            List options = ((PatternDao)BeanFactory.getSingleInstance("PatternDao")).getdropDownOption(meanDataSourceName, assitInfo, null);
                            int i4 = 0;
                            while (i4 < nodeValues.size()) {
                                String value = nodeValues.get(i4) == null ? "" : nodeValues.get(i4).toString();
                                boolean hasName = false;
                                int k = 0;
                                while (k < options.size()) {
                                    DropDownOptionBean option = (DropDownOptionBean)options.get(k);
                                    if (option.getOptionValue().equals(value.trim())) {
                                        nodeNames.add(option.getOptionText());
                                        hasName = true;
                                        break;
                                    }
                                    ++k;
                                }
                                if (!hasName) {
                                    nodeNames.add(value);
                                }
                                ++i4;
                            }
                        }
                        int k = 0;
                        while (k < nodeValues.size()) {
                            nodeGuid = Guid.create();
                            String id = nodeValues.get(k).toString();
                            String name = nodeNames.size() != 0 ? nodeNames.get(k).toString() : id;
                            if (name.length() == 0) {
                                name = "\u7a7a";
                            }
                            if (outputJS) {
                                script.append("nodeInfo=new TreeNode();");
                                script.append("nodeInfo.objectId='").append(id).append("';");
                                script.append("nodeInfo.id='").append(nodeGuid).append("';");
                                script.append("nodeInfo.text='").append(StringTool.toJson(StringTool.toJson(name))).append("';");
                                script.append("nodeInfo.tableId='").append(lat.getTableId()).append("';");
                                script.append("nodeInfo.parentObjectId='").append(sheetId).append("';");
                                script.append("nodeInfo.linkId='").append(lat.getLinkId()).append("';");
                                script.append("nodeInfo.isGroup='").append("1").append("';");
                                script.append("nodeInfo.iconSrc='").append(Global.getName()).append("/pms/platform/image/folder1.gif").append("';");
                                if (loadedNodeInfo != null) {
                                    script.append("nodeInfo.isGetData=true;");
                                } else {
                                    script.append("nodeInfo.isGetData=false;");
                                }
                                script.append("nodeInfo.childs=new Array();");
                                script.append("nodeInfo.parentId='").append(parentNodeGuid).append("';");
                                script.append("Tree_").append(cellId).append("._nodeArray['").append(nodeGuid).append("']=nodeInfo;");
                                script.append("Tree_").append(cellId).append(".getNode('").append(parentNodeGuid).append("', true).childs.push(nodeInfo);");
                                if (loadedNodeInfo != null) {
                                    this.getLinkAppTableNodeArray(appId, dataSourceName, lat.getTableId(), lat.getLinkId(), sheetId, cellId, "1", id, loadedNodeInfo, script, nodeGuid, true);
                                }
                            } else {
                                TreeNodeBean[] childNodes;
                                nodeArray[curLen] = new TreeNodeBean();
                                nodeArray[curLen].setObjectId(id);
                                nodeArray[curLen].setId(nodeGuid);
                                nodeArray[curLen].setText(name);
                                nodeArray[curLen].setTableId(lat.getTableId());
                                nodeArray[curLen].setParentObjectId(sheetId);
                                nodeArray[curLen].setLinkId(lat.getLinkId());
                                nodeArray[curLen].setExpanded(false);
                                nodeArray[curLen].setParentId(parentNodeGuid);
                                nodeArray[curLen].setIconSrc(String.valueOf(Global.getName()) + "/pms/platform/image/folder1.gif");
                                nodeArray[curLen].setGroup("1");
                                if (loadedNodeInfo != null) {
                                    nodeArray[curLen].setGetData(true);
                                    childNodes = this.getLinkAppTableNodeArray(appId, dataSourceName, lat.getTableId(), lat.getLinkId(), sheetId, cellId, "1", id, loadedNodeInfo, script, nodeArray[curLen].getId(), false);
                                    nodeArray[curLen].setChilds(childNodes);
                                } else {
                                    nodeArray[curLen].setGetData(false);
                                    childNodes = new TreeNodeBean[]{};
                                    nodeArray[curLen].setChilds(childNodes);
                                }
                                ++curLen;
                            }
                            ++k;
                        }
                    } else if (SheetConstants.LINK_SHOW_TYPE.isGroup(lat.getShowType()) && lat.getAttachGroup().length() != 0) {
                        int i5;
                        String attachGroup = lat.getAttachGroup();
                        String[] arrAttachGroup = attachGroup.split("\\|");
                        this.getHasChildNodesSheetID(lat.getTableId(), lat.getLinkId(), "1", "", null, null, null, null);
                        boolean hasChild = this.m_hasChildsMap.containsKey(String.valueOf(lat.getTableId()) + "_" + lat.getLinkId() + "_1_" + sheetId) || this.m_hasChildsMap.containsKey(String.valueOf(lat.getTableId()) + "_" + lat.getLinkId() + "_1_AllSheetIDContains");
                        boolean exsit = false;
                        if (outputJS) {
                            i5 = 0;
                            while (i5 < curAttachGroupNodeText) {
                                if (attachGroupNodeText[i5].equals(arrAttachGroup[0])) {
                                    exsit = true;
                                    break;
                                }
                                ++i5;
                            }
                        } else {
                            i5 = 0;
                            while (i5 < curLen) {
                                if (nodeArray[i5].getText().equals(arrAttachGroup[0])) {
                                    exsit = true;
                                    break;
                                }
                                ++i5;
                            }
                        }
                        if (!exsit) {
                            String id = arrAttachGroup[0];
                            nodeGuid = Guid.create();
                            if (outputJS) {
                                script.append("nodeInfo=new TreeNode();");
                                script.append("nodeInfo.objectId='\u9644\u52a0\u5206\u7ec4").append(sheetId).append("';");
                                script.append("nodeInfo.id='").append(nodeGuid).append("';");
                                script.append("nodeInfo.text='").append(id).append("';");
                                script.append("nodeInfo.tableId='").append(lat.getTableId()).append("';");
                                script.append("nodeInfo.parentObjectId='").append(sheetId).append("';");
                                script.append("nodeInfo.parentId='").append(parentNodeGuid).append("';");
                                script.append("nodeInfo.linkId='").append(lat.getLinkId()).append("';");
                                script.append("nodeInfo.isGroup='").append("1").append("';");
                                script.append("nodeInfo.iconSrc='").append(Global.getName()).append("/pms/platform/image/folder1.gif").append("';");
                                attachGroupNodeText[curAttachGroupNodeText] = id;
                                ++curAttachGroupNodeText;
                                if (arrAttachGroup.length > 1) {
                                    script.append("nodeInfo.childs=new Array();");
                                    script.append("nodeInfo.isGetData=true;");
                                    script.append("Tree_").append(cellId).append("._nodeArray['").append(nodeGuid).append("']=nodeInfo;");
                                    script.append("Tree_").append(cellId).append(".getNode('").append(parentNodeGuid).append("', true).childs.push(nodeInfo);");
                                    this.createAttachGroupNode(list, String.valueOf(arrAttachGroup[0]) + "|", sheetId, cellId, appId, dataSourceName, nodeGuid, loadedNodeInfo, script, true);
                                } else if (arrAttachGroup.length == 1) {
                                    if (loadedNodeInfo != null) {
                                        script.append("nodeInfo.isGetData=true;");
                                        if (hasChild) {
                                            script.append("nodeInfo.childs=new Array();");
                                        } else {
                                            script.append("nodeInfo.childs=null;");
                                        }
                                        script.append("Tree_").append(cellId).append("._nodeArray['").append(nodeGuid).append("']=nodeInfo;");
                                        script.append("Tree_").append(cellId).append(".getNode('").append(parentNodeGuid).append("', true).childs.push(nodeInfo);");
                                        if (hasChild) {
                                            this.getLinkAppTableNodeArray(appId, dataSourceName, lat.getTableId(), lat.getLinkId(), sheetId, cellId, "1", "\u9644\u52a0\u5206\u7ec4" + sheetId, loadedNodeInfo, script, nodeGuid, true);
                                        }
                                    } else {
                                        if (hasChild) {
                                            script.append("nodeInfo.isGetData=false;");
                                            script.append("nodeInfo.childs=new Array();");
                                        } else {
                                            script.append("nodeInfo.isGetData=true;");
                                            script.append("nodeInfo.childs=null;");
                                        }
                                        script.append("Tree_").append(cellId).append("._nodeArray['").append(nodeGuid).append("']=nodeInfo;");
                                        script.append("Tree_").append(cellId).append(".getNode('").append(parentNodeGuid).append("', true).childs.push(nodeInfo);");
                                    }
                                }
                            } else {
                                TreeNodeBean[] childNodes;
                                nodeArray[curLen] = new TreeNodeBean();
                                nodeArray[curLen].setObjectId("\u9644\u52a0\u5206\u7ec4" + sheetId);
                                nodeArray[curLen].setId(nodeGuid);
                                nodeArray[curLen].setText(id);
                                nodeArray[curLen].setTableId(lat.getTableId());
                                nodeArray[curLen].setParentObjectId(sheetId);
                                nodeArray[curLen].setParentId(parentNodeGuid);
                                nodeArray[curLen].setLinkId(lat.getLinkId());
                                nodeArray[curLen].setExpanded(false);
                                nodeArray[curLen].setIconSrc(String.valueOf(Global.getName()) + "/pms/platform/image/folder1.gif");
                                nodeArray[curLen].setGroup("1");
                                if (arrAttachGroup.length > 1) {
                                    nodeArray[curLen].setGetData(true);
                                    childNodes = this.createAttachGroupNode(list, String.valueOf(arrAttachGroup[0]) + "|", sheetId, cellId, appId, dataSourceName, nodeGuid, loadedNodeInfo, script, false);
                                    nodeArray[curLen].setChilds(childNodes);
                                } else if (arrAttachGroup.length == 1) {
                                    if (loadedNodeInfo != null) {
                                        nodeArray[curLen].setGetData(true);
                                        childNodes = this.getLinkAppTableNodeArray(appId, dataSourceName, lat.getTableId(), lat.getLinkId(), id, cellId, "0", "", loadedNodeInfo, script, nodeArray[curLen].getId(), false);
                                        nodeArray[curLen].setChilds(childNodes);
                                    } else {
                                        nodeArray[curLen].setGetData(false);
                                        if (hasChild) {
                                            childNodes = new TreeNodeBean[]{};
                                            nodeArray[curLen].setChilds(childNodes);
                                        } else {
                                            nodeArray[curLen].setChilds(null);
                                        }
                                    }
                                }
                                ++curLen;
                            }
                        }
                    }
                }
                ++j;
            }
        }
        TreeNodeBean[] curNodeArray = new TreeNodeBean[curLen];
        int i6 = 0;
        while (i6 < curLen) {
            curNodeArray[i6] = nodeArray[i6];
            ++i6;
        }
        return curNodeArray;
    }

    public LinkApp getLinkApp() {
        if (this.m_appId.equals("")) {
            return null;
        }
        if (this.linkApp == null) {
            LinkApp app = new LinkApp();
            app.setAppId(this.m_appId);
            app.setAppName((String)this.m_appMap.get("APPNAME"));
            app.setAttColumn((String)this.m_appMap.get("ATTCOLUMN"));
            app.setAttTable((String)this.m_appMap.get("ATTTABLE"));
            app.setTableId((String)this.m_appMap.get("TABLEID"));
            app.setTableName((String)this.m_appMap.get("TABLENAME"));
            app.setDataSourceName((String)this.m_appMap.get("DATASOURCENAME"));
            app.setDataUserName((String)this.m_appMap.get("DATAUSERNAME"));
            app.setFilter((String)this.m_appMap.get("FILTER"));
            app.setOrderBy((String)this.m_appMap.get("ORDERBY"));
            if (this.m_appMap.get("ISSHOWINFO") == null) {
                app.setIsShowInfo(0);
            } else {
                app.setIsShowInfo(Integer.parseInt((String)this.m_appMap.get("ISSHOWINFO")));
            }
            app.setInfoFormID((String)this.m_appMap.get("INFOFORMID"));
            app.setInfoShowProject((String)this.m_appMap.get("INFOJMID"));
            app.setNameColumn((String)this.m_appMap.get("SHOWNAMECOL"));
            app.setKeyColumn((String)this.m_appMap.get("PKCOL"));
            app.setPicPath((String)this.m_appMap.get("PICPATH"));
            app.setLimitId((String)this.m_appMap.get("LIMITINFO"));
            this.linkApp = app;
        }
        return this.linkApp;
    }

    public static List getLinkAppTableNodeInfo(String appId, String tableId) {
        LinkAppTable lat = null;
        ArrayList<LinkAppTable> list = new ArrayList<LinkAppTable>();
        RowSet rs = null;
        String sql2 = TreeDao.getSqlHelper("defaultds").getLinkAppTableSQL(appId, tableId);
        try {
            rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                lat = new LinkAppTable();
                lat.setAppId(rs.getString("APPID"));
                lat.setTableId(rs.getString("TABLEID"));
                lat.setTableName(rs.getString("TABLENAME"));
                lat.setDataUserName(rs.getString("DATAUSERNAME"));
                lat.setTableMsg(rs.getString("TABLEMSG"));
                lat.setAttColumn(rs.getString("ATTCOLUMN"));
                lat.setAttTable(rs.getString("ATTTABLE"));
                lat.setFilter(rs.getString("FILTER"));
                lat.setOrderBy(rs.getString("ORDERBY"));
                lat.setLinkId(rs.getString("LINKID"));
                lat.setListShowProject(rs.getString("LISTJMID"));
                lat.setInfoShowProject(rs.getString("INFOJMID"));
                lat.setListFormID(rs.getString("LISTFORMID"));
                lat.setInfoFormID(rs.getString("INFOFORMID"));
                lat.setLinkColumn(rs.getString("LINKCOLUMNID"));
                lat.setLimitId(rs.getString("LIMITINFO"));
                list.add(lat);
            }
        }
        catch (Exception e) {
            daoLogger.error((Object)e.getMessage());
        }
        return list;
    }

    private List getLinkAppTable(String tableId, String linkId, String isGroup) {
        ArrayList list;
        block11: {
            if (this.m_appId.equals("")) {
                return null;
            }
            list = new ArrayList();
            if ("1".equals(isGroup)) {
                HashMap linkAppTableMap = new HashMap();
                int i = 0;
                while (i < this.m_appLinkList.size()) {
                    HashMap tmpMap = (HashMap)this.m_appLinkList.get(i);
                    String temp = (String)tmpMap.get("LINKID");
                    if (temp.equals(linkId)) {
                        linkAppTableMap.putAll(tmpMap);
                        int j = 0;
                        while (j < this.m_appTableList.size()) {
                            tmpMap = (HashMap)this.m_appTableList.get(j);
                            temp = (String)tmpMap.get("LINKID");
                            if (temp.equals(linkId) && (temp = (String)tmpMap.get("TABLEID")).equals(tableId)) {
                                linkAppTableMap.putAll(tmpMap);
                                list.add(linkAppTableMap);
                                break block11;
                            }
                            ++j;
                        }
                        break;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.m_appLinkList.size()) {
                    HashMap linkAppTableMap = new HashMap();
                    HashMap tmpMap = (HashMap)this.m_appLinkList.get(i);
                    String temp = (String)tmpMap.get("PTABLEID");
                    if (temp.equals(tableId)) {
                        linkAppTableMap.putAll(tmpMap);
                        int j = 0;
                        while (j < this.m_appTableList.size()) {
                            tmpMap = (HashMap)this.m_appTableList.get(j);
                            temp = (String)tmpMap.get("LINKID");
                            if (temp.equals(linkAppTableMap.get("LINKID"))) {
                                linkAppTableMap.putAll(tmpMap);
                                list.add(linkAppTableMap);
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        return list;
    }

    private TreeNodeBean[] createAttachGroupNode(List latList, String groupName, String sheetId, int cellId, String appId, String dataSourceName, String parentNodeGuid, HashMap loadedNodeInfo, StringBuffer script, boolean outputJS) {
        TreeNodeBean[] newAttachGroupNode = new TreeNodeBean[latList.size()];
        LinkAppTable lat = null;
        int curLen = 0;
        String[] attachGroupNodeText = new String[latList.size()];
        int curAttachGroupNodeText = 0;
        int i = 0;
        while (i < latList.size()) {
            lat = (LinkAppTable)latList.get(i);
            String attachGroup = lat.getAttachGroup();
            if (SheetConstants.LINK_SHOW_TYPE.isGroup(lat.getShowType()) && lat.getAttachGroup().length() != 0 && attachGroup.startsWith(groupName)) {
                int k;
                String subNodes = attachGroup.substring(groupName.length());
                String id = subNodes.split("\\|")[0];
                boolean exsit = false;
                if (outputJS) {
                    k = 0;
                    while (k < curAttachGroupNodeText) {
                        if (attachGroupNodeText[k].equals(id)) {
                            exsit = true;
                            break;
                        }
                        ++k;
                    }
                } else {
                    k = 0;
                    while (k < curLen) {
                        if (newAttachGroupNode[k].getText().equals(id)) {
                            exsit = true;
                            break;
                        }
                        ++k;
                    }
                }
                if (!exsit) {
                    this.getHasChildNodesSheetID(lat.getTableId(), lat.getLinkId(), "1", "", null, null, null, null);
                    boolean hasChild = this.m_hasChildsMap.containsKey(String.valueOf(lat.getTableId()) + "_" + lat.getLinkId() + "_1_" + sheetId) || this.m_hasChildsMap.containsKey(String.valueOf(lat.getTableId()) + "_" + lat.getLinkId() + "_1_AllSheetIDContains");
                    String nodeGuid = Guid.create();
                    if (outputJS) {
                        script.append("nodeInfo=new TreeNode();");
                        script.append("nodeInfo.objectId='\u9644\u52a0\u5206\u7ec4").append(sheetId).append("';");
                        script.append("nodeInfo.id='").append(nodeGuid).append("';");
                        script.append("nodeInfo.text='").append(id).append("';");
                        script.append("nodeInfo.tableId='").append(lat.getTableId()).append("';");
                        script.append("nodeInfo.parentObjectId='").append(sheetId).append("';");
                        script.append("nodeInfo.parentId='").append(parentNodeGuid).append("';");
                        script.append("nodeInfo.linkId='").append(lat.getLinkId()).append("';");
                        script.append("nodeInfo.isGroup='").append("1").append("';");
                        script.append("nodeInfo.iconSrc='").append(Global.getName()).append("/pms/platform/image/folder1.gif").append("';");
                        attachGroupNodeText[curAttachGroupNodeText] = id;
                        ++curAttachGroupNodeText;
                        if (subNodes.split("\\|").length > 1) {
                            script.append("nodeInfo.childs=new Array();");
                            script.append("nodeInfo.isGetData=true;");
                            script.append("Tree_").append(cellId).append("._nodeArray['").append(nodeGuid).append("']=nodeInfo;");
                            script.append("Tree_").append(cellId).append(".getNode('").append(parentNodeGuid).append("', true).childs.push(nodeInfo);");
                            this.createAttachGroupNode(latList, String.valueOf(groupName) + subNodes.split("\\|")[0] + "|", sheetId, cellId, appId, dataSourceName, nodeGuid, loadedNodeInfo, script, true);
                        } else if (subNodes.split("\\|").length == 1) {
                            if (loadedNodeInfo != null) {
                                script.append("nodeInfo.isGetData=true;");
                                if (hasChild) {
                                    script.append("nodeInfo.childs=new Array();");
                                } else {
                                    script.append("nodeInfo.childs=null;");
                                }
                                script.append("Tree_").append(cellId).append("._nodeArray['").append(nodeGuid).append("']=nodeInfo;");
                                script.append("Tree_").append(cellId).append(".getNode('").append(parentNodeGuid).append("', true).childs.push(nodeInfo);");
                                if (hasChild) {
                                    this.getLinkAppTableNodeArray(appId, dataSourceName, lat.getTableId(), lat.getLinkId(), sheetId, cellId, "1", "", loadedNodeInfo, script, nodeGuid, true);
                                }
                            } else if (hasChild) {
                                script.append("nodeInfo.childs=new Array();");
                                script.append("nodeInfo.isGetData=false;");
                                script.append("Tree_").append(cellId).append("._nodeArray['").append(nodeGuid).append("']=nodeInfo;");
                                script.append("Tree_").append(cellId).append(".getNode('").append(parentNodeGuid).append("', true).childs.push(nodeInfo);");
                            } else {
                                script.append("nodeInfo.childs=null;");
                                script.append("nodeInfo.isGetData=true;");
                                script.append("Tree_").append(cellId).append("._nodeArray['").append(nodeGuid).append("']=nodeInfo;");
                                script.append("Tree_").append(cellId).append(".getNode('").append(parentNodeGuid).append("', true).childs.push(nodeInfo);");
                            }
                        }
                    } else {
                        TreeNodeBean[] childNodes;
                        TreeNodeBean newNode = new TreeNodeBean();
                        newNode.setObjectId("\u9644\u52a0\u5206\u7ec4" + sheetId);
                        newNode.setId(nodeGuid);
                        newNode.setText(id);
                        newNode.setTableId(lat.getTableId());
                        newNode.setParentObjectId(sheetId);
                        newNode.setParentId(parentNodeGuid);
                        newNode.setLinkId(lat.getLinkId());
                        newNode.setExpanded(false);
                        newNode.setIconSrc(String.valueOf(Global.getName()) + "/pms/platform/image/folder1.gif");
                        newNode.setGroup("1");
                        if (subNodes.split("\\|").length > 1) {
                            newNode.setGetData(true);
                            childNodes = this.createAttachGroupNode(latList, String.valueOf(groupName) + subNodes.split("\\|")[0] + "|", sheetId, cellId, appId, dataSourceName, nodeGuid, loadedNodeInfo, script, false);
                            newNode.setChilds(childNodes);
                        } else if (subNodes.split("\\|").length == 1) {
                            if (loadedNodeInfo != null && hasChild) {
                                newNode.setGetData(true);
                                childNodes = this.getLinkAppTableNodeArray(appId, dataSourceName, lat.getTableId(), lat.getLinkId(), sheetId, cellId, "1", "", loadedNodeInfo, script, nodeGuid, false);
                                newNode.setChilds(childNodes);
                            } else if (hasChild) {
                                newNode.setGetData(false);
                                childNodes = new TreeNodeBean[]{};
                                newNode.setChilds(childNodes);
                            } else {
                                newNode.setGetData(true);
                                newNode.setChilds(null);
                            }
                        }
                        newAttachGroupNode[curLen] = newNode;
                        ++curLen;
                    }
                }
            }
            ++i;
        }
        TreeNodeBean[] curAttachGroupNode = new TreeNodeBean[curLen];
        int j = 0;
        while (j < curLen) {
            curAttachGroupNode[j] = newAttachGroupNode[j];
            ++j;
        }
        return curAttachGroupNode;
    }

    private boolean getHasChildNodesSheetID(String tableId, String linkId, String isGroup, String parentDataUserName, String parentTableName, String parentLinkColumn, String parentPKColumn, String parentSheetId) {
        LinkAppTable lat = null;
        ArrayList<LinkAppTable> list = new ArrayList<LinkAppTable>();
        List latList = null;
        RowSet rs = null;
        HashMap tmpMap = null;
        String nodeKey = String.valueOf(tableId) + "_" + linkId + "_" + isGroup + "_";
        if (this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + "isLoaded_abc!@#$") && parentTableName == null) {
            return true;
        }
        this.m_hasChildsMap.put(String.valueOf(nodeKey) + "isLoaded_abc!@#$", String.valueOf(nodeKey) + "isLoaded_abc!@#$");
        latList = this.getLinkAppTable(tableId, linkId, isGroup);
        int i = 0;
        while (i < latList.size()) {
            tmpMap = (HashMap)latList.get(i);
            lat = new LinkAppTable();
            lat.setAppId(this.m_appId);
            lat.setTableId((String)tmpMap.get("TABLEID"));
            lat.setAttColumn((String)tmpMap.get("ATTCOLUMN"));
            lat.setAttTable((String)tmpMap.get("ATTTABLE"));
            lat.setFilter((String)tmpMap.get("FILTER"));
            lat.setOrderBy((String)tmpMap.get("ORDERBY"));
            lat.setNameColumn((String)tmpMap.get("SHOWNAMECOL"));
            lat.setKeyColumn((String)tmpMap.get("PKCOL"));
            lat.setPicPath((String)tmpMap.get("PICPATH"));
            lat.setTableName((String)tmpMap.get("TABLENAME"));
            lat.setDataUserName((String)tmpMap.get("DATAUSERNAME"));
            lat.setLinkColumn((String)tmpMap.get("LINKCOLUMNID"));
            lat.setShowType(Integer.parseInt((String)tmpMap.get("SHOWTYPE")));
            lat.setGroupColumn((String)tmpMap.get("GROUPCOLUMN"));
            lat.setGroupOrderby((String)tmpMap.get("GROUPORDERBY"));
            if (tmpMap.get("ATTGROUP") == null) {
                lat.setAttachGroup("");
            } else {
                lat.setAttachGroup((String)tmpMap.get("ATTGROUP"));
            }
            lat.setLimitId((String)tmpMap.get("LIMITINFO"));
            list.add(lat);
            ++i;
        }
        if (list.size() != 0) {
            int j = 0;
            while (j < list.size()) {
                lat = (LinkAppTable)list.get(j);
                if (lat != null) {
                    if (lat.getAttachGroup() != null && lat.getAttachGroup().length() > 0) {
                        this.m_hasChildsMap.put(String.valueOf(nodeKey) + "AllSheetIDContains", "AllSheetIDContains");
                        return true;
                    }
                    String sql2 = TreeDao.getSqlHelper(this.getLinkApp().getDataSourceName()).getSimpleLinkAppTableNodeSQL(lat, parentDataUserName, parentTableName, parentLinkColumn, parentPKColumn, parentSheetId);
                    sql2 = StringTool.replaceKeyWord(sql2);
                    try {
                        rs = DbOper.executeQuery(this.getLinkApp().getDataSourceName(), sql2);
                        while (rs.next()) {
                            if (this.m_hasChildsMap.containsKey(String.valueOf(nodeKey) + rs.getString("SHEETID"))) continue;
                            this.m_hasChildsMap.put(String.valueOf(nodeKey) + rs.getString("SHEETID"), rs.getString("SHEETID"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                ++j;
            }
        }
        return true;
    }

    private String getNodeShowName(RowSet rs, String nameField) {
        String nodeShowName = nameField;
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            int i = 1;
            while (i <= columnCount) {
                if (nodeShowName.equals(rsmd.getColumnName(i))) {
                    nodeShowName = rs.getObject(nodeShowName).toString();
                    break;
                }
                String fieldValue = "";
                if (rs.getObject(rsmd.getColumnName(i)) != null) {
                    fieldValue = rs.getObject(rsmd.getColumnName(i)).toString();
                }
                nodeShowName = StringTool.replace(nodeShowName, "[" + rsmd.getColumnName(i) + "]", fieldValue);
                ++i;
            }
        }
        catch (Exception e) {
            daoLogger.error((Object)e.getMessage());
            e.printStackTrace();
            nodeShowName = "";
        }
        return nodeShowName;
    }
}

