/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.dao;

import com.sdjxd.pms.platform.base.DataStatus;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.form.dao.DataConst;
import com.sdjxd.pms.platform.form.dao.FormInstanceDao;
import com.sdjxd.pms.platform.form.model.CellActionBean;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.CellEventBean;
import com.sdjxd.pms.platform.form.model.ComboBoxColumnMeanBean;
import com.sdjxd.pms.platform.form.model.ConditionBean;
import com.sdjxd.pms.platform.form.model.Css;
import com.sdjxd.pms.platform.form.model.DropDownOptionBean;
import com.sdjxd.pms.platform.form.model.FileBean;
import com.sdjxd.pms.platform.form.model.InfoShowColumn;
import com.sdjxd.pms.platform.form.model.InfoShowProperty;
import com.sdjxd.pms.platform.form.model.InfoShowStyle;
import com.sdjxd.pms.platform.form.model.InfoShowTable;
import com.sdjxd.pms.platform.form.model.ListExtendColumnData;
import com.sdjxd.pms.platform.form.model.ListExtendData;
import com.sdjxd.pms.platform.form.model.ListStyleColumnData;
import com.sdjxd.pms.platform.form.model.ListStyleData;
import com.sdjxd.pms.platform.form.model.PatternBean;
import com.sdjxd.pms.platform.form.service.Align;
import com.sdjxd.pms.platform.form.service.CellIndex;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.PatternParameter;
import com.sdjxd.pms.platform.form.service.cell.ListStyle;
import com.sdjxd.pms.platform.form.service.cell.Upload;
import com.sdjxd.pms.platform.form.service.cell.easyui.ListExtend;
import com.sdjxd.pms.platform.form.sql.PatternSql;
import com.sdjxd.pms.platform.table.model.TableBean;
import com.sdjxd.pms.platform.table.service.Table;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.sql.RowSet;
import org.apache.commons.fileupload.FileItem;
import org.apache.log4j.Logger;

public class PatternDao {
    private static Logger daoLogger = null;

    static {
        daoLogger = Logger.getLogger(PatternDao.class);
    }

    private static PatternSql getSqlHelper(String m_dataSourceName) {
        return (PatternSql)BeanFactory.getSqlInstance(PatternDao.class, "PatternSql", m_dataSourceName);
    }

    public TreeMap getCellIndex(String dataSourceName, String dataUserName, String tableName, StringBuffer error) {
        TreeMap<String, CellIndex> cellIndex;
        block4: {
            cellIndex = null;
            if (tableName == null || tableName.length() == 0) {
                return null;
            }
            String sql2 = PatternDao.getSqlHelper(dataSourceName).getTableColumn(dataUserName, tableName);
            try {
                RowSet rs = DbOper.executeQuery(dataSourceName, sql2);
                cellIndex = new TreeMap<String, CellIndex>();
                int i = 1;
                while (i <= rs.getMetaData().getColumnCount()) {
                    String key = rs.getMetaData().getColumnName(i);
                    String columnTypeName = rs.getMetaData().getColumnTypeName(i);
                    cellIndex.put(key, new CellIndex(key, columnTypeName));
                    ++i;
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u8bfb\u53d6\u6a21\u7248\u7d22\u5f15\u8868\u7ed3\u6784\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
                if (error == null) break block4;
                error.append("\u8bfb\u53d6\u6a21\u7248\u7d22\u5f15\u8868\u7ed3\u6784\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage());
            }
        }
        return cellIndex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TreeMap getCssList() {
        RowSet rs;
        TreeMap<String, Css> cssMap = new TreeMap<String, Css>();
        String sql2 = PatternDao.getSqlHelper("defaultds").getCssSql();
        try {
            try {
                rs = DbOper.executeQuery("defaultds", sql2);
                while (rs != null) {
                    if (!rs.next()) {
                        return cssMap;
                    }
                    Css css = new Css();
                    String styleCode = rs.getString("STYLECODE");
                    css.setStylecode(styleCode);
                    css.setStyletext(rs.getString("STYLETEXT"));
                    cssMap.put(styleCode, css);
                }
                return cssMap;
            }
            catch (SQLException exp) {
                daoLogger.error((Object)exp);
                Object rs2 = null;
                return null;
            }
        }
        finally {
            rs = null;
        }
    }

    public boolean isExist(String dataSourceName, String dataUserName, String tableName) {
        return DbOper.isExist(dataSourceName, dataUserName, tableName);
    }

    public List getdropDownOption(String dataSourceName, String assistInfo, String[] limitIdArr) {
        if (assistInfo == null || "".equals(assistInfo)) {
            return null;
        }
        ComboBoxColumnMeanBean bean = new ComboBoxColumnMeanBean(dataSourceName, assistInfo, limitIdArr);
        ArrayList[] result = bean.refresh();
        ArrayList<DropDownOptionBean> options = new ArrayList<DropDownOptionBean>();
        int i = 0;
        while (i < result[0].size()) {
            DropDownOptionBean model = new DropDownOptionBean();
            model.setOptionValue((String)result[1].get(i));
            model.setOptionText((String)result[0].get(i));
            options.add(model);
            ++i;
        }
        if (options.isEmpty()) {
            options = null;
        }
        return options;
    }

    public String getdropDownOptionValue(String dataSourceName, String assistInfo, String id) {
        if (assistInfo == null || "".equals(assistInfo)) {
            return null;
        }
        String rValue = id;
        ComboBoxColumnMeanBean bean = new ComboBoxColumnMeanBean(dataSourceName, assistInfo, null);
        ArrayList[] result = bean.refresh();
        int i = 0;
        while (i < result[0].size()) {
            if (id.equals(result[1].get(i))) {
                rValue = (String)result[0].get(i);
            }
            ++i;
        }
        return rValue;
    }

    public List getPatternArea(String patternId) {
        return this.getPatternArea(patternId, null);
    }

    public List getPatternArea(String patternId, StringBuffer error) {
        ArrayList<CellBean> cells;
        block10: {
            HashMap extAttrs = new HashMap();
            String extAttrsSql = null;
            try {
                extAttrsSql = PatternDao.getSqlHelper("defaultds").getPatternCellExtAttrs(patternId);
                RowSet rs = DbOper.executeQuery("defaultds", extAttrsSql);
                while (rs.next()) {
                    int cellId = rs.getInt("CELLID");
                    String attributeId = rs.getString("ATTRIBUTEID");
                    String attributeValue = rs.getString("ATTRIBUTEVALUE");
                    if (extAttrs.containsKey(cellId)) {
                        ((Map)extAttrs.get(cellId)).put(attributeId, attributeValue);
                        continue;
                    }
                    HashMap<String, String> extAttr = new HashMap<String, String>();
                    extAttr.put(attributeId, attributeValue);
                    extAttrs.put(cellId, extAttr);
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u83b7\u53d6\u8868\u5355\u5143\u4ef6\u6269\u5c55\u5c5e\u6027\u503c\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + extAttrsSql));
            }
            cells = new ArrayList<CellBean>();
            String sql2 = PatternDao.getSqlHelper("defaultds").getPatternArea(patternId);
            try {
                RowSet rs = DbOper.executeQuery("defaultds", sql2);
                while (rs.next()) {
                    CellBean model = new CellBean();
                    model.cellId = rs.getInt("AREAID");
                    model.cellName = rs.getString("AREANAME");
                    model.cellType = rs.getInt("ISQUERY");
                    model.fontStyle = rs.getString("AREASTYLE");
                    model.x1 = rs.getInt("X1");
                    model.y1 = rs.getInt("Y1");
                    model.width = rs.getInt("AREAWIDTH");
                    model.height = rs.getInt("AREAHEIGHT");
                    model.position = DataConst.CELL.POSITION.getValue(rs.getInt("DWTYPE"));
                    model.childPosition = DataConst.CELL.POSITION.getValue(rs.getInt("CELLDWTYPE"));
                    model.scroll = DataConst.CELL.SCROLL.getValue(rs.getInt("NEEDSCROLL"));
                    model.limit = model.cellType == 1 ? 0 : 1;
                    model.widthScale = rs.getString("WIDTHSCALE");
                    model.heightScale = rs.getString("HEIGHTSCALE");
                    model.alignStyle = rs.getString("ALIGNSTYLE");
                    model.areaId = rs.getInt("AREACELL");
                    model.zIndex = rs.getString("ZINDEX");
                    String araStyle = rs.getString("AREARSTYLE");
                    if (araStyle == null) {
                        araStyle = "";
                    }
                    model.areaStyle = araStyle;
                    model.patternId = patternId;
                    if (extAttrs.containsKey(model.cellId)) {
                        model.extAttrs = (Map)extAttrs.get(model.cellId);
                    }
                    cells.add(model);
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u8bfb\u53d6\u6a21\u7248\u533a\u57df\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
                if (error == null) break block10;
                error.append("\u8bfb\u53d6\u6a21\u7248\u533a\u57df\u8868\u5931\u8d25\uff01\n");
            }
        }
        if (cells.size() == 0) {
            cells = null;
        }
        return cells;
    }

    public List getPatternParameter(String patternId) {
        return this.getPatternParameter(patternId, null);
    }

    public List getPatternParameter(String patternId, StringBuffer error) {
        ArrayList<PatternParameter> listResult;
        block4: {
            listResult = new ArrayList<PatternParameter>();
            String sql2 = null;
            try {
                sql2 = PatternDao.getSqlHelper("defaultds").getPatternParameter(patternId);
                RowSet rs = DbOper.executeQuery("defaultds", sql2);
                while (rs.next()) {
                    int paraID = rs.getInt("PARAMETERID");
                    String paraName = rs.getString("PARAMETERNAME");
                    int paraType = rs.getInt("PARAMETERTYPE");
                    String paraValue = rs.getString("PARAMETERVALUE");
                    PatternParameter paraItem = new PatternParameter(paraID, paraName, paraType, paraValue);
                    listResult.add(paraItem);
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u8bfb\u53d6\u8868\u5355\u53c2\u6570\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
                if (error == null) break block4;
                error.append("\u8bfb\u53d6\u8868\u5355\u53c2\u6570\u8868\u5931\u8d25\uff01\n");
            }
        }
        if (listResult.size() <= 0) {
            listResult = null;
        }
        return listResult;
    }

    public List getPatternCell(String patternId) {
        return this.getPatternCell(patternId, null);
    }

    public List getPatternCell(String patternId, StringBuffer error) {
        ArrayList<CellBean> cells;
        block12: {
            HashMap extAttrs = new HashMap();
            String extAttrsSql = null;
            try {
                extAttrsSql = PatternDao.getSqlHelper("defaultds").getPatternCellExtAttrs(patternId);
                RowSet rs = DbOper.executeQuery("defaultds", extAttrsSql);
                while (rs.next()) {
                    int cellId = rs.getInt("CELLID");
                    String attributeId = rs.getString("ATTRIBUTEID");
                    String attributeValue = rs.getString("ATTRIBUTEVALUE");
                    if (extAttrs.containsKey(cellId)) {
                        ((Map)extAttrs.get(cellId)).put(attributeId, attributeValue);
                        continue;
                    }
                    HashMap<String, String> extAttr = new HashMap<String, String>();
                    extAttr.put(attributeId, attributeValue);
                    extAttrs.put(cellId, extAttr);
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u83b7\u53d6\u8868\u5355\u5143\u4ef6\u6269\u5c55\u5c5e\u6027\u503c\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + extAttrsSql));
            }
            cells = new ArrayList<CellBean>(128);
            String sql2 = null;
            try {
                sql2 = PatternDao.getSqlHelper("defaultds").getPatternCell(patternId);
                RowSet rs = DbOper.executeQuery("defaultds", sql2);
                while (rs.next()) {
                    CellBean model = new CellBean();
                    model.patternId = patternId;
                    model.cellId = rs.getInt("CELLID");
                    String temp = rs.getString("CELLNAME");
                    model.cellName = temp == null ? "" : temp;
                    temp = rs.getString("CELLLABEL");
                    model.cellLabel = temp == null ? "" : temp;
                    model.cellType = rs.getInt("CELLEXTENDTYPEID") != 0 ? rs.getInt("CELLEXTENDTYPEID") : rs.getInt("CELLTYPEID");
                    model.cellBaseType = rs.getInt("CELLTYPEID");
                    model.userCellType = rs.getString("USERCELLTYPEID");
                    model.fontId2 = rs.getInt("FONTID2");
                    model.areaId = rs.getInt("AREAID");
                    model.x1 = rs.getInt("X1");
                    model.y1 = rs.getInt("Y1");
                    model.maxSize = rs.getInt("MAXSIZE");
                    model.width = rs.getInt("WIDTH");
                    model.height = rs.getInt("HEIGHT");
                    temp = rs.getString("TEXTCOLORSTYLE");
                    model.textColorStyle = temp == null ? "" : temp;
                    temp = rs.getString("READBKCOLORSTYLE");
                    model.readBkColorStyle = temp == null ? "" : temp;
                    temp = rs.getString("BKCOLORSTYLE");
                    model.bkColorStyle = temp == null ? "" : temp;
                    model.alignStyle = rs.getString("ALIGNSTYLE");
                    model.fontStyle = rs.getString("FONTSTYLE");
                    model.borderStyle = rs.getString("BORDERCOLOR");
                    model.isPrint = rs.getInt("ISPRINT");
                    model.commwordType = rs.getString("COMMWORDTYPE");
                    model.cellGroupInfo = rs.getString("CELLGROUPINFO");
                    model.dtextNum = rs.getInt("DTEXTNUM");
                    model.checkCondition = rs.getInt("CHECKCONDITION");
                    temp = rs.getString("VALUEFIELD");
                    model.valueField = temp == null ? null : temp.trim();
                    temp = rs.getString("TEXTFIELD");
                    model.textField = temp == null ? null : temp.trim();
                    model.slaveSignCells = rs.getString("SLAVESIGNCELLS");
                    temp = rs.getString("MEANID");
                    model.fieldMeanId = temp == null ? "" : temp;
                    temp = rs.getString("MEANTYPE");
                    model.fieldMeanType = temp == null ? "" : temp;
                    temp = rs.getString("MEANINFO");
                    model.fieldMeanValue = temp == null ? "" : temp;
                    temp = rs.getString("MEANDATASOURCENAME");
                    model.meanDataSourceName = temp == null ? "" : temp;
                    try {
                        Object verifymean = BeanTool.parse(rs.getString("VERIFYMEAN"));
                        if (verifymean != null && verifymean.getClass().isArray() && ((Object[])verifymean).length > 0) {
                            model.verifyMeans = (String[])BeanTool.parse(rs.getString("VERIFYMEAN"));
                        }
                    }
                    catch (Exception exp) {
                        daoLogger.error((Object)("\u5143\u4ef6\u7684\u6821\u9a8c\u5b57\u6bb5\u542b\u4e49\u8bfb\u53d6\u9519\u8bef\u3002cellId:" + model.cellId));
                        exp.printStackTrace();
                    }
                    model.assitInfo = (temp = rs.getString("ASSITINFO")) == null ? "" : temp;
                    model.compareText = rs.getString("COMPARETEXT");
                    model.compareTypeId = rs.getInt("COMPARETYPEID");
                    model.lineWidth = rs.getInt("LINEWIDTH");
                    model.limit = rs.getInt("LIMIT");
                    model.scroll = DataConst.CELL.SCROLL.getValue(-2);
                    model.readonly = rs.getInt("READONLY");
                    model.widthScale = rs.getObject("WIDTHSCALE") == null ? "" : rs.getString("WIDTHSCALE");
                    model.heightScale = rs.getObject("HEIGHTSCALE") == null ? "" : rs.getString("HEIGHTSCALE");
                    model.isNeedSave = rs.getInt("ISNEEDSAVE");
                    model.tableLinkId = rs.getString("TABLELINKID");
                    model.LimitInfo = rs.getString("LIMITINFO");
                    model.userDefinfo = rs.getString("USERDEFINFO");
                    model.zIndex = rs.getString("ZINDEX");
                    model.defaultValueTime = rs.getInt("DEFAULTVALUETIME");
                    model.entityAttrId = rs.getInt("ENTITYATTRIBUTEID");
                    if (extAttrs.containsKey(model.cellId)) {
                        model.extAttrs = (Map)extAttrs.get(model.cellId);
                    }
                    cells.add(model);
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u8bfb\u53d6\u6a21\u7248\u5143\u4ef6\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
                if (error == null) break block12;
                error.append("\u8bfb\u53d6\u6a21\u7248\u5143\u4ef6\u8868\u5931\u8d25\uff01\n");
            }
        }
        if (cells.size() == 0) {
            cells = null;
        }
        return cells;
    }

    public Map<String, String> getPatternCellAttributes1(String patternId, String cellId) {
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        String sql2 = null;
        try {
            sql2 = PatternDao.getSqlHelper("defaultds").getPatternCellAttributes(patternId, cellId);
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                String attributeId = rs.getString("ATTRIBUTEID");
                String attributeValue = rs.getString("ATTRIBUTEVALUE");
                if (StringTool.isEmpty(attributeId)) continue;
                attributeMap.put(attributeId, attributeValue);
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u83b7\u53d6\u8868\u5355\u4e0a\u5143\u4ef6\u7684\u6240\u6709\u5c5e\u6027\u503c\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
        }
        return attributeMap;
    }

    public List getPatternCondition(String patternId) {
        return this.getPatternCondition(patternId, null);
    }

    public List getPatternCondition(String patternId, StringBuffer error) {
        ArrayList<ConditionBean> cons;
        block4: {
            cons = new ArrayList<ConditionBean>();
            String sql2 = PatternDao.getSqlHelper("defaultds").getPatternCondition(patternId);
            try {
                RowSet rs = DbOper.executeQuery("defaultds", sql2);
                while (rs.next()) {
                    ConditionBean model = new ConditionBean();
                    model.id = rs.getInt("CONDITIONID");
                    model.patternId = patternId;
                    model.name = rs.getString("CONDITIONNAME");
                    model.operatorOne = rs.getString("OPERATORONE");
                    model.operatorTwo = rs.getString("OPERATORTWO");
                    model.type = DataConst.CONDITION.TYPE.getValue(rs.getInt("CONDITIONTYPE"));
                    model.compareType = rs.getInt("COMPARETYPE");
                    cons.add(model);
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u8bfb\u53d6\u6a21\u7248\u6761\u4ef6\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
                if (error == null) break block4;
                error.append("\u8bfb\u53d6\u6a21\u7248\u6761\u4ef6\u8868\u5931\u8d25\uff01\n");
            }
        }
        if (cons.size() == 0) {
            cons = null;
        }
        return cons;
    }

    public PatternBean getPatternData(String patternId) {
        return this.getPatternData(patternId, null);
    }

    public PatternBean getPatternData(String patternId, StringBuffer error) {
        PatternBean pattern;
        block7: {
            pattern = null;
            String sql2 = PatternDao.getSqlHelper("defaultds").getPatternData(patternId);
            try {
                RowSet rs = DbOper.executeQuery("defaultds", sql2);
                if (rs.next()) {
                    pattern = new PatternBean();
                    pattern.id = patternId;
                    pattern.moduleId = rs.getString("MODULEID");
                    pattern.name = rs.getString("PATTERNNAME");
                    pattern.patternType = rs.getInt("PATTERNTYPE");
                    pattern.sheetSize = rs.getInt("SHEETSIZE");
                    pattern.width = rs.getInt("PATTERNWIDTH");
                    pattern.widthScale = rs.getString("widthScale") == null ? String.valueOf(rs.getInt("PATTERNWIDTH")) : rs.getString("widthScale");
                    pattern.heightScale = rs.getString("HEIGHTSCALE") == null ? String.valueOf(rs.getInt("PATTERNHEIGHT")) : rs.getString("HEIGHTSCALE");
                    pattern.height = rs.getInt("PATTERNHEIGHT");
                    pattern.direct = rs.getInt("PATTERNDIRECT");
                    int color = rs.getInt("BKCOLOR");
                    StringBuffer sbColor = new StringBuffer(7);
                    sbColor.append("#");
                    if (color % 256 < 16) {
                        sbColor.append("0");
                    }
                    sbColor.append(Integer.toHexString(color % 256));
                    if ((color >>= 8) % 256 < 16) {
                        sbColor.append("0");
                    }
                    sbColor.append(Integer.toHexString(color % 256));
                    if ((color >>= 8) < 16) {
                        sbColor.append("0");
                    }
                    sbColor.append(Integer.toHexString(color));
                    pattern.color = sbColor.toString();
                    pattern.pageCount = rs.getInt("PAGECOUNT");
                    pattern.table = rs.getString("TABLENAME");
                    pattern.dataSourceName = rs.getString("DATASOURCENAME");
                    pattern.dataUserName = rs.getString("DATAUSERNAME");
                    pattern.propertyPattern = rs.getString("SHEETPATTERNID");
                    pattern.attachPattern = rs.getString("ATTACHPATTERNID");
                    pattern.devType = rs.getInt("DEVTYPE");
                    pattern.isAutoCenter = Align.create(rs.getInt("ISAUTOCENTER"));
                    String modifyTime = rs.getString("CREATEDATE");
                    if (modifyTime != null && modifyTime.length() != 0) {
                        pattern.modifyTime = DateTool.parseDate(modifyTime);
                    }
                    pattern.m_formEvents = StringTool.trim(rs.getString("FORM_EVENTS"));
                    pattern.LimitInfo = rs.getString("LIMITINFO");
                    pattern.linkViewId = rs.getString("LINKVIEWID");
                    pattern.isAbsolute = rs.getInt("ISABSOLUTE");
                    pattern.screenMode = rs.getInt("SCREENMODE");
                    pattern.sjfs = rs.getInt("SJFS");
                    pattern.usedLimitGroupIds = rs.getString("USEDLIMITGROUPIDS");
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u8bfb\u53d6\u6a21\u7248\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
                if (error == null) break block7;
                error.append("\u8bfb\u53d6\u6a21\u7248\u8868\u5931\u8d25\uff01\n");
            }
        }
        return pattern;
    }

    public List getPatternEvent(String patternId, StringBuffer error) {
        ArrayList<CellActionBean> cellActions;
        block5: {
            cellActions = new ArrayList<CellActionBean>();
            String sql2 = PatternDao.getSqlHelper("defaultds").getPatternEvent(patternId);
            try {
                RowSet rs = DbOper.executeQuery("defaultds", sql2);
                while (rs.next()) {
                    CellActionBean model = new CellActionBean();
                    model.setCellId(rs.getInt("CELLID"));
                    model.setEventId(rs.getInt("EVENTID"));
                    model.setEventCode(rs.getString("EVENTCODE"));
                    model.setActionOrder(rs.getInt("ACTIONORDER"));
                    model.setId(rs.getString("ACTIONID"));
                    model.setCode(rs.getString("ACTIONCODE"));
                    model.setName(rs.getString("ACTIONNAME"));
                    model.setParamOrder(rs.getInt("PARAMORDER"));
                    model.setParamId(rs.getString("PARAMID"));
                    model.setParamName(rs.getString("PARAMNAME"));
                    String paramValue = rs.getString("PARAMVALUE");
                    if (paramValue == null) {
                        paramValue = "";
                    }
                    model.setParamValue(paramValue);
                    model.setParamType(rs.getInt("PARAMTYPEID"));
                    model.setDefaultValue(rs.getString("DEFAULTVALUE"));
                    model.setDescription(rs.getString("PARAMDESCRIPTION"));
                    cellActions.add(model);
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u8bfb\u53d6\u6a21\u7248\u4e8b\u4ef6\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
                if (error == null) break block5;
                error.append("\u8bfb\u53d6\u6a21\u7248\u4e8b\u4ef6\u5931\u8d25\uff01\n");
            }
        }
        if (cellActions.size() == 0) {
            cellActions = null;
        }
        return cellActions;
    }

    public List getPatternScript(String patternId) {
        return this.getPatternScript(patternId, null);
    }

    public List getPatternScript(String patternId, StringBuffer error) {
        ArrayList<CellBean> cells;
        block4: {
            cells = new ArrayList<CellBean>();
            String sql2 = PatternDao.getSqlHelper("defaultds").getPatternScript(patternId);
            try {
                RowSet rs = DbOper.executeQuery("defaultds", sql2);
                while (rs.next()) {
                    CellBean model = new CellBean();
                    model.cellName = StringTool.replace(rs.getString("SID"), "-", "");
                    model.cellId = -1;
                    model.cellLabel = rs.getString("PACKAGENAME");
                    model.assitInfo = rs.getString("FILEPATH");
                    cells.add(model);
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u8bfb\u53d6\u6a21\u7248\u811a\u672c\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
                if (error == null) break block4;
                error.append("\u8bfb\u53d6\u6a21\u7248\u811a\u672c\u8868\u5931\u8d25\uff01\n");
            }
        }
        if (cells.size() == 0) {
            cells = null;
        }
        return cells;
    }

    public List getPatternLinkedCss(String patternId) throws Exception {
        ArrayList<CellBean> cells = new ArrayList<CellBean>();
        String sql2 = PatternDao.getSqlHelper("defaultds").getPatternLinkedCss(patternId);
        RowSet rs = DbOper.executeQuery("defaultds", sql2);
        while (rs.next()) {
            CellBean model = new CellBean();
            model.cellName = model.assitInfo = rs.getString("FILEPATH");
            model.cellId = -1;
            model.cellLabel = model.assitInfo;
            cells.add(model);
        }
        if (cells.size() == 0) {
            cells = null;
        }
        return cells;
    }

    public List getScriptPattern(String scriptId) {
        return this.getScriptPattern(scriptId, null);
    }

    public List getScriptPattern(String scriptId, StringBuffer error) {
        ArrayList<String> patternIds;
        block4: {
            patternIds = new ArrayList<String>();
            String sql2 = PatternDao.getSqlHelper("defaultds").getScriptPattern(scriptId);
            try {
                RowSet rs = DbOper.executeQuery("defaultds", sql2);
                while (rs.next()) {
                    patternIds.add(String.valueOf(rs.getString("PATTERNID")));
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u8bfb\u53d6\u6a21\u7248\u811a\u672c\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
                if (error == null) break block4;
                error.append("\u8bfb\u53d6\u6a21\u7248\u811a\u672c\u8868\u5931\u8d25\uff01\n");
            }
        }
        if (patternIds.size() == 0) {
            patternIds = null;
        }
        return patternIds;
    }

    public void modifyFormIndex(Form pattern, TreeMap index) {
        String sql2 = PatternDao.getSqlHelper("defaultds").modifyFormIndex(pattern, index);
        try {
            DbOper.executeNonQuery(pattern.getDataSourceName(), sql2);
        }
        catch (SQLException e) {
            StringBuffer logError = new StringBuffer(256);
            logError.append("\u4fdd\u5b58\u8868\u5355\u7d22\u5f15\u5931\u8d25,\u9519\u8bef\u4e3a:");
            logError.append(e.getMessage());
            logError.append("\nsql\u4e3a\uff1a");
            logError.append(sql2);
            daoLogger.error((Object)logError);
        }
    }

    public boolean deleteForm(Form form, String formInstanceId) throws SQLException {
        boolean isSuc = false;
        int patternType = form.getPatternType();
        String tableName = form.getIndexTable();
        String dataUserName = form.getDataUserName();
        TableBean table = Table.getTableByName(form.getDataSourceName(), dataUserName, tableName);
        String pkCol = null;
        if (table != null) {
            pkCol = table.getPkCol();
        }
        if (pkCol == null || pkCol.length() == 0) {
            pkCol = "SHEETID";
        }
        ArrayList<String> sql2 = new ArrayList<String>(64);
        sql2.add(PatternDao.getSqlHelper(form.getDataSourceName()).deleteData(dataUserName, tableName, pkCol, formInstanceId));
        if (patternType != 6 && form.isHasText()) {
            sql2.add(PatternDao.getSqlHelper(form.getDataSourceName()).deleteData(dataUserName, form.getTextTable(), "SHEETID", formInstanceId));
        }
        FormInstanceDao dao = new FormInstanceDao();
        dao.deleteInstance(form, formInstanceId, sql2);
        try {
            DbOper.executeNonQuery(form.getDataSourceName(), sql2);
            isSuc = true;
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5220\u9664\u8868\u5355\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage()));
            throw e;
        }
        return isSuc;
    }

    public TreeMap getColumnValueByTableId(String tableId, String sheetId) throws Exception {
        TreeMap<String, Object> columnValue = null;
        TableBean tableBean = Table.getTable(tableId);
        String tableName = tableBean.getTableName();
        String keyColumn = tableBean.getPkCol();
        String dataSourceName = tableBean.getDataSourceName();
        String dataUserName = tableBean.getDataUserName();
        String sql2 = PatternDao.getSqlHelper(dataSourceName).getColumnValueSQL(dataUserName, tableName, sheetId, keyColumn);
        try {
            RowSet rs = DbOper.executeQuery(dataSourceName, sql2);
            if (rs.next()) {
                columnValue = new TreeMap<String, Object>();
                int i = 1;
                while (i <= rs.getMetaData().getColumnCount()) {
                    String key = rs.getMetaData().getColumnName(i);
                    columnValue.put(key, rs.getObject(key));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            daoLogger.error((Object)("getColumnValueByTableId(String tableId)\u62a5\u9519\uff1a" + e.getMessage()));
        }
        return columnValue;
    }

    public String getNameById(String dataSourceName, String dataUserName, String tableName, String nameCol, String idCol, String idValue) {
        String result = idValue;
        String sql2 = PatternDao.getSqlHelper(dataSourceName).getNameByIdSQL(dataUserName, tableName, nameCol, idCol, idValue);
        try {
            RowSet rs = DbOper.executeQuery(dataSourceName, sql2);
            if (rs.next()) {
                result = rs.getString(nameCol);
            }
            rs.close();
        }
        catch (Exception e) {
            daoLogger.error((Object)("getNameById(String tableName, String nameCol, String idCol, String idValue)\u62a5\u9519\uff1a" + e.getMessage()));
        }
        return result;
    }

    public String[] getViewInfo(String viewId) {
        String sql2 = PatternDao.getSqlHelper("defaultds").getViewInfo(viewId);
        String[] viewInfo = new String[2];
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs.next()) {
                String tableName = "";
                String filter = "";
                String temp = rs.getString("VIEWFIELDINFO");
                Object[] tempArr1 = StringTool.strToArray(temp);
                int i = 0;
                while (i < tempArr1.length) {
                    Object[] tempArr2 = (Object[])tempArr1[i];
                    if (tempArr2.length >= 2) {
                        if (i > 0) {
                            tableName = String.valueOf(tableName) + ",";
                        }
                        TableBean tableBean = Table.getTable((String)tempArr2[0]);
                        tableName = String.valueOf(tableName) + tableBean.getDataUserName();
                        tableName = String.valueOf(tableName) + tempArr2[1];
                        tableName = String.valueOf(tableName) + " ";
                        tableName = String.valueOf(tableName) + tempArr2[2];
                    }
                    ++i;
                }
                viewInfo[0] = tableName;
                temp = rs.getString("VIEWCONDITION");
                tempArr1 = StringTool.strToArray(temp);
                if (tempArr1.length > 1) {
                    i = 1;
                    while (i < tempArr1.length) {
                        if (i > 1) {
                            filter = String.valueOf(filter) + " and ";
                        }
                        filter = String.valueOf(filter) + (String)tempArr1[i];
                        ++i;
                    }
                } else if (tempArr1.length == 1) {
                    filter = (String)tempArr1[0];
                }
                viewInfo[1] = filter;
            }
            rs.close();
        }
        catch (Exception e) {
            daoLogger.error((Object)e.getMessage());
        }
        return viewInfo;
    }

    public String getViewSql(String viewId, String mainTableName, String pkColumn) {
        String sql2 = PatternDao.getSqlHelper("defaultds").getViewInfo(viewId);
        StringBuffer viewSql = new StringBuffer();
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs.next()) {
                String tableName = "";
                viewSql.append("select ");
                String temp = rs.getString("VIEWFIELDINFO");
                Object[] tempArr1 = StringTool.strToArray(temp);
                int i = 0;
                while (i < tempArr1.length) {
                    Object[] tempArr2 = (Object[])tempArr1[i];
                    if (tempArr2.length >= 4) {
                        if (i > 0) {
                            tableName = String.valueOf(tableName) + ",";
                        }
                        TableBean tableBean = Table.getTable((String)tempArr2[0]);
                        tableName = String.valueOf(tableName) + tableBean.getDataUserName();
                        tableName = String.valueOf(tableName) + tempArr2[1];
                        tableName = String.valueOf(tableName) + " ";
                        tableName = String.valueOf(tableName) + tempArr2[2];
                        int j = 3;
                        while (j < tempArr2.length) {
                            String[] tempArr3 = (String[])tempArr2[j];
                            if (i > 0) {
                                viewSql.append(",");
                            } else if (j > 3) {
                                viewSql.append(",");
                            }
                            viewSql.append(tempArr2[2]);
                            viewSql.append(".");
                            viewSql.append(tempArr3[0]);
                            viewSql.append(" as ");
                            viewSql.append(tempArr3[1]);
                            ++j;
                        }
                        if (viewSql.length() > 1 && tempArr2[1].equals(mainTableName)) {
                            viewSql.append(",").append(tempArr2[2]).append(".").append(pkColumn);
                        }
                    }
                    ++i;
                }
                viewSql.append(" from ");
                viewSql.append(tableName);
                viewSql.append(" where ");
                temp = rs.getString("VIEWCONDITION");
                tempArr1 = StringTool.strToArray(temp);
                if (tempArr1.length > 1) {
                    i = 1;
                    while (i < tempArr1.length) {
                        if (i > 1) {
                            viewSql.append(" and ");
                        }
                        viewSql.append((String)tempArr1[i]);
                        ++i;
                    }
                } else if (tempArr1.length == 1) {
                    viewSql.append((String)tempArr1[0]);
                }
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return viewSql.toString();
    }

    public List getColumnInfo(String tableId) {
        String sql2 = PatternDao.getSqlHelper("defaultds").getColumnInfoSql(tableId);
        ArrayList<InfoShowColumn> list = new ArrayList<InfoShowColumn>();
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            InfoShowColumn column = null;
            while (rs.next()) {
                column = new InfoShowColumn();
                column.setColumnId(rs.getString("COLUMNID"));
                column.setColumnName(rs.getString("COLUMNNAME"));
                column.setColumnType(rs.getString("COLUMNTYPE"));
                list.add(column);
            }
        }
        catch (Exception e) {
            daoLogger.error((Object)("getColumnInfo(String tableId)\u62a5\u9519\uff1a" + sql2 + "," + e.getMessage()));
        }
        return list;
    }

    public InfoShowTable getInfoShowTableByStyleId(String styleId) {
        InfoShowTable table = null;
        String sql2 = PatternDao.getSqlHelper("defaultds").getInfoShowTableByStyleIdSQL(styleId);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs.next()) {
                table = new InfoShowTable("");
                table.setTableId(rs.getString("TABLEID"));
                table.setTableName(rs.getString("TABLENAME"));
                table.setDataSourceName(rs.getString("DATASOURCENAME"));
                table.setDataUserName(rs.getString("DATAUSERNAME"));
                InfoShowStyle style = new InfoShowStyle(styleId);
                style.setIsDefault(rs.getInt("ISDEFAULT"));
                style.setIsTwoColumn(rs.getInt("ISTWOCOLUMN"));
                style.setRowHeight(rs.getInt("ROWHEIGHT"));
                style.setStyleName(rs.getString("PROJECTNAME"));
                style.setStyleType(rs.getObject("PROJECTTYPE") == null ? 0 : rs.getInt("PROJECTTYPE"));
                style.setTitleWidth(rs.getInt("TITLEWIDTH"));
                style.setTableId(rs.getString("TABLEID"));
                style.setAttStyleId(rs.getString("ATTPROJECTID"));
                table.setInfoShowStyle(style);
            }
        }
        catch (Exception e) {
            daoLogger.error((Object)("getInfoShowTableByStyleId(String styleId)\u62a5\u9519\uff1a" + e.getMessage()));
        }
        if (table != null) {
            List columns = this.getInfoShowColumn(table.getTableId(), styleId);
            table.setColumns(columns);
        }
        return table;
    }

    public InfoShowStyle getInfoShowStyle(String styleId) {
        InfoShowStyle style = null;
        String sql2 = PatternDao.getSqlHelper("defaultds").getInfoShowStyleSql(styleId);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs.next()) {
                style = new InfoShowStyle(styleId);
                style.setIsDefault(rs.getInt("ISDEFAULT"));
                style.setIsTwoColumn(rs.getInt("ISTWOCOLUMN"));
                style.setRowHeight(rs.getInt("ROWHEIGHT"));
                style.setStyleName(rs.getString("PROJECTNAME"));
                style.setStyleType(rs.getObject("PROJECTTYPE") == null ? 0 : rs.getInt("PROJECTTYPE"));
                style.setTitleWidth(rs.getInt("TITLEWIDTH"));
                style.setTableId(rs.getString("TABLEID"));
                style.setAttStyleId(rs.getString("ATTPROJECTID"));
                style.setColId(rs.getString("COLID"));
                style.setAttachTable(rs.getString("ATTACHTABLE"));
                style.setAttachCol(rs.getString("ATTACHCOL"));
            }
        }
        catch (Exception e) {
            daoLogger.error((Object)("getInfoShowStyle(String styleId)\u62a5\u9519\uff1a" + e.getMessage()));
        }
        return style;
    }

    public InfoShowStyle getInfoShowStyleDefault(String tableId) {
        InfoShowStyle style = null;
        String sql2 = PatternDao.getSqlHelper("defaultds").getInfoShowStyleDefaultSql(tableId);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs.next()) {
                style = new InfoShowStyle("");
                style.setStyleId(rs.getString("PROJECTID"));
                style.setIsDefault(rs.getInt("ISDEFAULT"));
                style.setIsTwoColumn(rs.getInt("ISTWOCOLUMN"));
                style.setRowHeight(rs.getInt("ROWHEIGHT"));
                style.setStyleName(rs.getString("PROJECTNAME"));
                style.setStyleType(rs.getObject("PROJECTTYPE") == null ? 0 : rs.getInt("PROJECTTYPE"));
                style.setTitleWidth(rs.getInt("TITLEWIDTH"));
                style.setAttStyleId(rs.getString("ATTPROJECTID"));
                style.setColId(rs.getString("COLID"));
                style.setAttachTable(rs.getString("ATTACHTABLE"));
                style.setAttachCol(rs.getString("ATTACHCOL"));
                style.setTableId(tableId);
            }
        }
        catch (Exception e) {
            daoLogger.error((Object)("getInfoShowStyle(String styleId)\u62a5\u9519\uff1a" + e.getMessage()));
        }
        return style;
    }

    public List getInfoShowColumn(String tableId, String styleId) {
        String sql2 = PatternDao.getSqlHelper("defaultds").getInfoShowColumnSql(tableId, styleId);
        ArrayList<InfoShowColumn> list = new ArrayList<InfoShowColumn>();
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            InfoShowColumn column = null;
            InfoShowProperty property = null;
            while (rs != null && rs.next()) {
                column = new InfoShowColumn();
                column.setColumnId(rs.getString("COLUMNID"));
                column.setTableId(rs.getString("TABLEID"));
                column.setRowHeight(rs.getInt("ROWHEIGHT"));
                column.setAllowNull(rs.getInt("ALLOWNULL") == 1 ? rs.getInt("PALLOWNULL") : rs.getInt("ALLOWNULL"));
                column.setColumnLength(rs.getInt("COLUMNLENGTH"));
                String showName = rs.getString("COLUMNNAME");
                Object o = rs.getString("SHOWNAME");
                if (o != null && o.toString().length() != 0) {
                    showName = o.toString();
                }
                column.setColumnName(showName);
                column.setColumnType(rs.getString("COLUMNTYPE"));
                if (rs.getString("COLMEANID") != null) {
                    Object[] temp;
                    property = new InfoShowProperty(rs.getString("COLMEANID"));
                    property.setDataSourceName(rs.getString("DATASOURCENAME"));
                    property.setPropertyName(rs.getString("MEANNAME"));
                    String meanType = rs.getString("MEANTYPE");
                    property.setPropertyType(meanType);
                    String assitInfo = rs.getString("ASSITINFO");
                    property.setAssitInfo(assitInfo);
                    property.setAllowMulSel(0);
                    if (meanType != null && meanType.equals("IDStringPicker") && assitInfo != null && !assitInfo.equals("") && (temp = StringTool.strToArray(assitInfo)).length > 3) {
                        property.setAllowMulSel(Integer.parseInt((String)temp[3]));
                    }
                    column.setInfoShowProperty(property);
                }
                column.setIsReadOnly(rs.getInt("ISREADONLY"));
                column.setIsVisible(rs.getInt("ISVISIBLE"));
                column.setShowOrder(rs.getInt("SHOWORDER"));
                o = rs.getObject("ISWHOLEROW");
                int isWholeRow = 0;
                if (o != null && o.toString().length() != 0) {
                    isWholeRow = Integer.parseInt(o.toString());
                }
                column.setIsWholeRow(isWholeRow);
                o = rs.getObject("DEFAULTVALUE");
                String defaultValue = "";
                if (o != null && o.toString().length() != 0) {
                    defaultValue = o.toString();
                }
                column.setDefaultValue(defaultValue);
                list.add(column);
            }
        }
        catch (Exception e) {
            daoLogger.error((Object)("getInfoShowColumn(String tableId)\u62a5\u9519\uff1a" + e.getMessage()));
        }
        return list;
    }

    public TreeMap getAttachColumnValueByTableId(String tableId, String sheetId, String attColId) throws Exception {
        String columns = "";
        String blobColumn = "";
        List columnList = this.getColumnInfo(tableId);
        int i = 0;
        while (i < columnList.size()) {
            InfoShowColumn column = (InfoShowColumn)columnList.get(i);
            if (column.getColumnType().toUpperCase().equals("BLOB") || column.getColumnType().toUpperCase().equals("IMAGE")) {
                blobColumn = column.getColumnId();
            } else {
                columns = columns.length() == 0 ? column.getColumnId() : String.valueOf(columns) + ", " + column.getColumnId();
            }
            ++i;
        }
        TreeMap<String, Object> columnValue = null;
        TableBean tableBean = Table.getTable(tableId);
        String dataSourceName = tableBean.getDataSourceName();
        String dataUsreName = tableBean.getDataUserName();
        String tableName = tableBean.getTableName();
        String sql2 = PatternDao.getSqlHelper(dataSourceName).getColumnValueSQL(dataUsreName, tableName, sheetId, columns, attColId);
        try {
            RowSet rs = DbOper.executeQuery(dataSourceName, sql2);
            if (rs.next()) {
                columnValue = new TreeMap<String, Object>();
                int i2 = 1;
                while (i2 <= rs.getMetaData().getColumnCount()) {
                    String key = rs.getMetaData().getColumnName(i2);
                    columnValue.put(key, rs.getObject(key));
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            daoLogger.error((Object)("getAttachColumnValueByTableId(String tableId)\u62a5\u9519\uff1a" + sql2 + "," + e.getMessage()));
        }
        if (blobColumn.length() != 0) {
            sql2 = PatternDao.getSqlHelper(dataSourceName).getColumnValueSQL(dataUsreName, tableName, sheetId, blobColumn, attColId);
            try {
                byte[] bcontent = DbOper.getPictureData(dataSourceName, sql2);
                if (bcontent != null && columnValue != null) {
                    String content = new String(bcontent);
                    columnValue.put(blobColumn, content);
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("getAttachColumnValueByTableId(String tableId)\u62a5\u9519\uff1a" + sql2 + "," + e.getMessage()));
            }
        }
        return columnValue;
    }

    public boolean saveInfoShowTable(InfoShowTable table) {
        boolean isSuc = false;
        String sql2 = PatternDao.getSqlHelper(table.getDataSourceName()).getSaveInfoShowSql(table);
        try {
            DbOper.executeNonQuery(table.getDataSourceName(), sql2);
            isSuc = true;
        }
        catch (Exception e) {
            daoLogger.error((Object)("saveInfoShowTable(InfoShowTable table)\u62a5\u9519\uff1a" + e.getMessage()));
        }
        return isSuc;
    }

    public ListStyleData getListStyle(String styleId) {
        String sql2 = PatternDao.getSqlHelper("defaultds").getListStyle(styleId);
        ListStyleData style = null;
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs != null && rs.next()) {
                style = new ListStyleData();
                style.setStyleId(styleId);
                style.setStyleName(rs.getString("STYLENAME"));
                style.setTableId(rs.getString("TABLEID"));
                style.setOrderField(rs.getString("ORDERFIELD"));
                style.setFilterSql(rs.getString("FILTERSQL"));
                style.setHeaderSort(rs.getInt("HEADERSORT"));
                style.setPageDataSize(rs.getInt("PAGEDATASIZE"));
                style.setAllowPage(rs.getInt("ALLOWPAGE"));
                style.setLoadData(rs.getInt("ISLOADDATA"));
                style.setLinkViewId(rs.getString("LINKVIEWID"));
                style.setIsAutoHeight(rs.getInt("ISAUTOHEIGHT"));
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)exp);
        }
        return style;
    }

    public List getListStyleColumn(String styleId, int isView, String tableID) {
        int i;
        String sql2 = "";
        ArrayList<ListStyleColumnData> list = new ArrayList<ListStyleColumnData>();
        ListStyleColumnData styleColumn = null;
        String strViewConditionFields = ",";
        if (1 == isView) {
            try {
                sql2 = PatternDao.getSqlHelper("defaultds").getViewInfo(tableID);
                RowSet rs = DbOper.executeQuery("defaultds", sql2);
                if (rs != null && rs.next()) {
                    String fieldInfo = rs.getString("VIEWFIELDINFO");
                    String condition = rs.getString("VIEWCONDITION");
                    Object[] arrField = StringTool.strToArray(fieldInfo);
                    if (arrField != null) {
                        i = 0;
                        while (i < arrField.length) {
                            Object[] tableItem = (Object[])arrField[i];
                            String strTableBM = (String)tableItem[2];
                            int j = 3;
                            while (j < tableItem.length) {
                                Object[] fieldItem = (Object[])tableItem[j];
                                String strTemp = String.valueOf(strTableBM) + "." + (String)fieldItem[0];
                                String strViewField = (String)fieldItem[1];
                                if (condition == null || condition.indexOf("\"" + strTemp + " ") >= 0 || condition.indexOf(" " + strTemp + "\"") >= 0) {
                                    strViewConditionFields = String.valueOf(strViewConditionFields) + strViewField + ",";
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                }
            }
            catch (SQLException exp) {
                daoLogger.error((Object)exp);
            }
        }
        List listEvent = this.getEvent();
        try {
            sql2 = PatternDao.getSqlHelper("defaultds").getListStyleColumn(styleId);
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs != null) {
                while (rs.next()) {
                    styleColumn = new ListStyleColumnData();
                    styleColumn.setStyleId(styleId);
                    String columnId = StringTool.nullToStr(rs.getString("COLUMNID"));
                    styleColumn.setColumnId(columnId);
                    if (columnId.indexOf(" AS ") > 0) {
                        styleColumn.setAsName(columnId.split(" AS ")[1]);
                    } else {
                        styleColumn.setAsName(columnId);
                    }
                    styleColumn.setShowName(StringTool.nullToStr(rs.getString("SHOWNAME")));
                    styleColumn.setShowOrder(rs.getInt("SHOWORDER"));
                    styleColumn.setHAlign(rs.getInt("HALIGN"));
                    styleColumn.setCellStyle(rs.getInt("CELLSTYLE"));
                    styleColumn.setColumnType(rs.getInt("COLUMNTYPE"));
                    styleColumn.setColumnWidth(rs.getString("COLUMNWIDTH"));
                    styleColumn.setMeanId(rs.getString("MEANID"));
                    styleColumn.setVerifyMeans((String[])BeanTool.parse(rs.getString("VERIFYMEAN")));
                    styleColumn.setEventArg(rs.getString("EVENTARG"));
                    styleColumn.setAssitInfo(rs.getString("ASSITINFO"));
                    String strEventInfo = rs.getString("EVENTINFO");
                    styleColumn.setEventInfo(strEventInfo);
                    if (strEventInfo != null && strEventInfo.length() > 0) {
                        i = 0;
                        while (i < listEvent.size()) {
                            CellEventBean oneEvent = (CellEventBean)listEvent.get(i);
                            if (strEventInfo.equals(String.valueOf(oneEvent.getEventId()))) {
                                styleColumn.setEventName(oneEvent.getEventCode());
                                break;
                            }
                            ++i;
                        }
                    }
                    if (strViewConditionFields.indexOf("," + columnId + ",") >= 0) {
                        styleColumn.setDataLimit(1);
                    }
                    list.add(styleColumn);
                }
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)exp);
        }
        return list;
    }

    public int getDataCount(String dataSourceName, String dataUserName, String tableName, String query) throws Exception {
        int count = 0;
        String sql2 = PatternDao.getSqlHelper(dataSourceName).getDataCount(dataUserName, tableName, query);
        try {
            Object o = DbOper.executeQueryObject(dataSourceName, sql2);
            if (o != null) {
                count = Integer.parseInt(o.toString());
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)sql2);
            daoLogger.error((Object)exp);
            throw exp;
        }
        return count;
    }

    public int getDataCount(ListStyle style) throws Exception {
        return this.getDataCount(style.getDataSourceName(), style.getDataUserName(), style.getTableName(), style.getQuery());
    }

    public List getAllListData(ListStyle style) {
        ArrayList list;
        String sql2 = PatternDao.getSqlHelper(style.getDataSourceName()).getAllListData(style);
        try {
            list = DbOper.executeList(style.getDataSourceName(), sql2);
        }
        catch (Exception exp) {
            list = null;
        }
        return list;
    }

    public List getPageListData(ListStyle style) {
        ArrayList list;
        String sql2 = PatternDao.getSqlHelper(style.getDataSourceName()).getPageListData(style);
        try {
            list = DbOper.executeList(style.getDataSourceName(), sql2);
        }
        catch (Exception exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6a21\u7248\u5143\u4ef6\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + exp.getMessage() + "\nsql\u4e3a\uff1a" + sql2), (Throwable)exp);
            exp.printStackTrace();
            list = null;
        }
        return list;
    }

    public List getEvent() {
        ArrayList<CellEventBean> list = new ArrayList<CellEventBean>();
        CellEventBean event = null;
        String sql2 = PatternDao.getSqlHelper("defaultds").getEvent();
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                event = new CellEventBean();
                event.setEventCode(rs.getString("EVENTCODE"));
                event.setEventName(rs.getString("EVENTNAME"));
                event.setEventId(rs.getInt("EVENTID"));
                list.add(event);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)exp);
        }
        return list;
    }

    public boolean saveCommonsFile(String newFileId, String ext, String userid, FileItem fileItem, String sheetid, String path, String imgUploadMark) throws Exception {
        boolean isSuccess = false;
        try {
            if (Upload.IS_SAVE_DB) {
                String sql2 = PatternDao.getSqlHelper("defaultds").saveCommonsFileToDbSql(newFileId, ext, userid, fileItem, sheetid);
                isSuccess = DbOper.updatePicture("defaultds", sql2, fileItem.getInputStream(), fileItem.getSize());
            } else {
                File fileFolds;
                File file;
                String savepath = Global.getConfig("upload.tempDir");
                String fileFoldspath = "";
                if (!path.startsWith("/") && !path.equals("")) {
                    savepath = path;
                    if (!savepath.endsWith("/")) {
                        savepath = String.valueOf(savepath) + "/";
                    }
                    fileFoldspath = savepath;
                } else {
                    if (savepath.startsWith("/")) {
                        savepath = String.valueOf(Global.getPath()) + savepath;
                    }
                    if (!savepath.endsWith("/")) {
                        savepath = String.valueOf(savepath) + "/";
                    }
                    savepath = savepath.replaceAll("(\\\\)|(//)", "/");
                    savepath = savepath.replaceAll("(//)", "/");
                    savepath = String.valueOf(savepath) + path;
                    if (!(savepath = savepath.replaceAll("(//)", "/")).endsWith("/")) {
                        savepath = String.valueOf(savepath) + "/";
                    }
                    fileFoldspath = savepath;
                }
                String filePath = "";
                String fName = "";
                String reName = null;
                if ("1".equals(Global.getConfig("isSaveByName"))) {
                    int begin = fileItem.getName().lastIndexOf("\\");
                    fName = fileItem.getName().substring(begin + 1, fileItem.getName().length());
                    filePath = String.valueOf(savepath) + fName;
                    file = (File)BeanFactory.getClass("File", new String[]{filePath});
                    int m = 1;
                    while (file.exists() && file.isFile()) {
                        int index = fName.lastIndexOf(".");
                        reName = index == -1 ? String.valueOf(fName) + "(" + m + ")" : String.valueOf(fName.substring(0, index)) + "(" + m + ")" + fName.substring(index);
                        filePath = String.valueOf(savepath) + reName;
                        ++m;
                        file = (File)BeanFactory.getClass("File", new String[]{filePath});
                    }
                } else {
                    reName = newFileId;
                    if (ext != null && ext.length() != 0) {
                        reName = String.valueOf(reName) + "." + ext;
                    }
                    filePath = savepath = String.valueOf(savepath) + reName;
                    file = (File)BeanFactory.getClass("File", new String[]{filePath});
                }
                if (!(fileFolds = (File)BeanFactory.getClass("File", new String[]{fileFoldspath})).isAbsolute()) {
                    throw new Exception("\u521b\u5efa\u76ee\u5f55 \uff1a " + fileFoldspath + " \u5931\u8d25 \uff01");
                }
                String sql3 = PatternDao.getSqlHelper("defaultds").saveCommonsFileSql(newFileId, ext, userid, fileItem, sheetid, fileFoldspath, reName);
                if (!fileFolds.isDirectory()) {
                    fileFolds.mkdirs();
                }
                fileItem.write(file);
                isSuccess = DbOper.executeNonQuery("defaultds", sql3) > 0;
            }
        }
        catch (Exception e) {
            daoLogger.error((Object)e.getMessage());
            throw e;
        }
        return isSuccess;
    }

    public boolean saveDiskFile(FileBean fileBean) throws Exception {
        String fileId = fileBean.getFileId();
        String localFileName = fileBean.getFileName();
        String contentType = fileBean.getContentType();
        String createUserId = fileBean.getCreater();
        long streamSize = fileBean.getFileLength();
        String folderPath = fileBean.getSavedFilePath();
        String saveFileName = fileBean.getSavedFileName();
        boolean isSuccess = false;
        String sql2 = PatternDao.getSqlHelper("defaultds").saveDiskFileSql(fileId, localFileName, contentType, createUserId, streamSize, null, folderPath, saveFileName);
        isSuccess = DbOper.executeNonQuery("defaultds", sql2) > 0;
        return isSuccess;
    }

    public boolean saveDbFile(FileBean fileBean) throws Exception {
        String fileId = fileBean.getFileId();
        String localFileName = fileBean.getFileName();
        String contentType = fileBean.getContentType();
        String createUserId = fileBean.getCreater();
        long streamSize = fileBean.getFileLength();
        InputStream fileStream = fileBean.getFileStream();
        boolean isSuccess = false;
        String sql2 = PatternDao.getSqlHelper("defaultds").saveDbFileSql(fileId, localFileName, contentType, createUserId, streamSize, null);
        isSuccess = DbOper.updatePicture("defaultds", sql2, fileStream, streamSize);
        return isSuccess;
    }

    public boolean saveCommonsFile(String newFileId, String ext, String userid, FileItem fileItem, String sheetid, String path) throws Exception {
        return this.saveCommonsFile(newFileId, ext, userid, fileItem, sheetid, path, null);
    }

    public boolean delCommonsFile(String fileId) {
        String sql2 = PatternDao.getSqlHelper("defaultds").delCommonsFileSql(fileId);
        try {
            DbOper.executeNonQuery("defaultds", sql2);
        }
        catch (Exception e) {
            daoLogger.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    public FileBean getFile(String fileId) throws Exception {
        FileBean file = new FileBean();
        String sql2 = PatternDao.getSqlHelper("defaultds").getFile(fileId);
        Map map = DbOper.executeMap("defaultds", sql2);
        file.setFileId(fileId);
        file.setFileName((String)map.get("FILENAME"));
        file.setContentType((String)map.get("CONTENTTYPE"));
        return file;
    }

    public FileBean getDbFile(String fileId) throws Exception {
        FileBean file = new FileBean();
        String sql2 = PatternDao.getSqlHelper("defaultds").getFile(fileId);
        RowSet rs = DbOper.executeQuery("defaultds", sql2);
        if (rs != null && rs.next()) {
            file.setFileId(fileId);
            file.setFileName(rs.getString("FILENAME"));
            file.setContentType(rs.getString("CONTENTTYPE"));
            if (rs.getMetaData().getColumnCount() == 3) {
                file.setFileStream(rs.getBinaryStream("FILEDATA"));
            } else {
                StringBuffer fileSql = new StringBuffer();
                fileSql.append("SELECT FILEDATA FROM [SFILE].JXD7_PM_FILE");
                fileSql.append(" WHERE ID='").append(fileId).append("'");
                byte[] fileContent = DbOper.getPictureData(fileSql.toString());
                file.setFileStream(new ByteArrayInputStream(fileContent));
            }
        }
        return file;
    }

    public String getCellValueByPatternField(String patternId, String field, String sheetId) {
        String sql2 = PatternDao.getSqlHelper("defaultds").getCellIdByPatternField(patternId, field);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs.next()) {
                String tableName = "";
                PatternBean patternBean = this.getPatternData(patternId);
                if (patternBean != null) {
                    tableName = patternBean.table;
                    RowSet tempRs = rs.getString("VALUEFIELD").length() > 0 ? DbOper.executeQuery(patternBean.dataSourceName, "SELECT " + rs.getString("VALUEFIELD") + " FROM " + patternBean.dataUserName + tableName + " WHERE SHEETID='" + sheetId + "'") : DbOper.executeQuery(patternBean.dataSourceName, "SELECT CELLVALUE FROM " + patternBean.dataUserName + tableName + "_TEXT WHERE SHEETID='" + sheetId + "' AND CELLID='" + rs.getString("CELLID") + "'");
                    if (tempRs.next()) {
                        return tempRs.getString(1);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String getVersionId(String formVersion) throws SQLException {
        String formVersionId = null;
        String sql2 = "SELECT PATTERNID FROM [S].JXD7_PM_PATTERN WHERE PATTERNVERSION='" + formVersion + "' AND (STARTUPTIME IS NULL OR STARTUPTIME<='" + DateTool.getNow() + "') AND (TERMINATE IS NULL OR TERMINATE='' OR TERMINATE>='" + DateTool.getNow() + "') AND DATASTATUSID<>" + DataStatus.DELETE + " ORDER BY VERSIONID DESC";
        try {
            formVersionId = (String)DbOper.executeQueryObject("defaultds", sql2);
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u8868\u5355\u7248\u672c\u7f16\u7801\u5931\u8d25,\u9519\u8bef\u4e3a:\nsql\u4e3a\uff1a" + sql2));
            throw exp;
        }
        return formVersionId;
    }

    public String getUserSignImgUrl(String userId) throws SQLException {
        String userSignImgUrl = null;
        String sql2 = "SELECT SIGNIMGURL FROM [S].JXD7_XT_USER WHERE USERID='" + userId + "'";
        try {
            userSignImgUrl = (String)DbOper.executeQueryObject("defaultds", sql2);
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u8868\u5355\u7248\u672c\u7f16\u7801\u5931\u8d25,\u9519\u8bef\u4e3a:\nsql\u4e3a\uff1a" + sql2));
            throw exp;
        }
        return userSignImgUrl;
    }

    public void deleteFile(String formInstanceId) throws SQLException {
        StringBuffer sql2 = new StringBuffer(256);
        sql2.append("SELECT PATH,REALFILENAME FROM [SFILE].JXD7_PM_FILE WHERE SHEETID='").append(formInstanceId).append("'");
        RowSet rs = DbOper.executeQuery(sql2.toString());
        while (rs.next()) {
            String savepath = String.valueOf(rs.getString("PATH")) + rs.getString("REALFILENAME");
            File file = (File)BeanFactory.getClass("File", new String[]{savepath});
            if (!file.exists() || !file.isFile()) continue;
            file.delete();
        }
        sql2.setLength(0);
        sql2.append("DELETE FROM [SFILE].JXD7_PM_FILE WHERE SHEETID='").append(formInstanceId).append("'");
        DbOper.executeNonQuery(sql2.toString());
    }

    public String getAllSQLData(ListStyle style) {
        String sql2 = PatternDao.getSqlHelper(style.getDataSourceName()).getAllListData(style);
        return sql2;
    }

    public String getAllSQLData(ListStyle style, Map param) {
        String sql2 = PatternDao.getSqlHelper(style.getDataSourceName()).getAllListData(style, param);
        return sql2;
    }

    public ListExtendData getListExtend(String styleId) {
        String sql2 = PatternDao.getSqlHelper("defaultds").getListExtend(styleId);
        ListExtendData style = null;
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs != null && rs.next()) {
                style = new ListExtendData();
                style.setStyleId(styleId);
                style.setStyleName(rs.getString("STYLENAME"));
                style.setTableId(rs.getString("TABLEID"));
                style.setNewLine(rs.getInt("NEWLINE"));
                style.setPkField(rs.getString("PKFIELD"));
                style.setAllowPage(rs.getInt("ALLOWPAGE"));
                style.setPageSize(rs.getInt("PAGESIZE"));
                style.setOptionalPage(rs.getString("OPTIONALPAGE"));
                style.setMutiColSort(rs.getInt("MUTICOLSORT"));
                style.setSortWay(rs.getString("SORTWAY"));
                style.setSqlInfo(rs.getString("SQLINFO"));
                style.setSortWay(rs.getString("SORTWAY"));
                style.setLoadData(rs.getInt("ISLOADDATA"));
                style.setServerSort(rs.getInt("SERVERSORT"));
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)exp);
        }
        return style;
    }

    public List<ListExtendColumnData> getListExtendColumn(String styleId, int isView, String tableID) {
        RowSet rs;
        String sql2 = "";
        ArrayList<ListExtendColumnData> list = new ArrayList<ListExtendColumnData>();
        ListExtendColumnData styleColumn = null;
        String strViewConditionFields = ",";
        if (1 == isView) {
            try {
                sql2 = PatternDao.getSqlHelper("defaultds").getViewInfo(tableID);
                rs = DbOper.executeQuery("defaultds", sql2);
                if (rs != null && rs.next()) {
                    String fieldInfo = rs.getString("VIEWFIELDINFO");
                    String condition = rs.getString("VIEWCONDITION");
                    Object[] arrField = StringTool.strToArray(fieldInfo);
                    if (arrField != null) {
                        int i = 0;
                        while (i < arrField.length) {
                            Object[] tableItem = (Object[])arrField[i];
                            String strTableBM = (String)tableItem[2];
                            int j = 3;
                            while (j < tableItem.length) {
                                Object[] fieldItem = (Object[])tableItem[j];
                                String strTemp = String.valueOf(strTableBM) + "." + (String)fieldItem[0];
                                String strViewField = (String)fieldItem[1];
                                if (condition == null || condition.indexOf("\"" + strTemp + " ") >= 0 || condition.indexOf(" " + strTemp + "\"") >= 0) {
                                    strViewConditionFields = String.valueOf(strViewConditionFields) + strViewField + ",";
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                }
            }
            catch (SQLException exp) {
                daoLogger.error((Object)exp);
            }
        }
        try {
            sql2 = PatternDao.getSqlHelper("defaultds").getListExtendColumn(styleId);
            rs = DbOper.executeQuery("defaultds", sql2);
            if (rs != null) {
                while (rs.next()) {
                    styleColumn = new ListExtendColumnData();
                    styleColumn.setStyleId(styleId);
                    String columnId = StringTool.nullToStr(rs.getString("COLUMNID"));
                    columnId = StringTool.replaceKeyWord(columnId);
                    styleColumn.setColumnId(columnId);
                    styleColumn.setColumnTitle(StringTool.nullToStr(rs.getString("COLUMNTITLE")));
                    styleColumn.setColumnType(rs.getInt("COLUMNTYPE"));
                    styleColumn.setFreezen(rs.getInt("FREEZEN"));
                    styleColumn.setTitleAlign(rs.getInt("TITLEALIGN"));
                    styleColumn.setDataAlign(rs.getInt("DATAALIGN"));
                    styleColumn.setColumnWidth(rs.getInt("COLUMNWIDTH"));
                    styleColumn.setEditOption(rs.getString("EDITOPTION"));
                    styleColumn.setOptionType(rs.getInt("OPTIONTYPE"));
                    styleColumn.setVerifyMean(rs.getString("VERIFYMEAN"));
                    list.add(styleColumn);
                }
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)exp);
        }
        return list;
    }

    public List getExtendPageListData(ListExtend listExtend) {
        ArrayList list;
        String sql2 = PatternDao.getSqlHelper(listExtend.getDataSourceName()).getExtendPageListData(listExtend);
        try {
            list = DbOper.executeList(listExtend.getDataSourceName(), sql2);
        }
        catch (Exception exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6a21\u7248\u5143\u4ef6\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + exp.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
            exp.printStackTrace();
            list = null;
        }
        return list;
    }

    public List getExtendAllListData(ListExtend style) {
        ArrayList list;
        String sql2 = PatternDao.getSqlHelper(style.getDataSourceName()).getExtendAllListData(style);
        try {
            list = DbOper.executeList(style.getDataSourceName(), sql2);
        }
        catch (Exception exp) {
            list = null;
        }
        return list;
    }

    public int getDefSQLDataCount(String sql2, String query) {
        int nCount = 0;
        if (sql2 == null || sql2.trim().equals("")) {
            return 0;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT count(*) as cnt FROM (").append(sql2).append(") _t");
        sb.append(" WHERE ").append(StringTool.replaceKeyWord(query));
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sb.toString());
            if (rs != null && rs.next()) {
                nCount = rs.getInt("cnt");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nCount;
    }

    public void updateImgWidAndHeight(String fileId, String width, String height) throws SQLException {
        String sqlString = "UPDATE JXD7_PM_FILE SET IMGWIDTH = '" + width + "',IMGHEIGHT = '" + height + "' WHERE ID = '" + fileId + "'";
        try {
            DbOper.executeNonQuery(sqlString);
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u66f4\u65b0\u56fe\u7247\u957f\u5bbd\u9519\u8bef" + sqlString));
            e.printStackTrace();
            throw e;
        }
    }

    public String getImgWidAndHeight(String fileId) {
        StringBuilder sb = new StringBuilder();
        String sqlString = "SELECT IMGWIDTH,IMGHEIGHT from [S].JXD7_PM_FILE WHERE ID = '" + fileId + "'";
        try {
            RowSet rs = DbOper.executeQuery(sqlString);
            if (rs.next()) {
                String w = rs.getString("IMGWIDTH");
                String h = rs.getString("IMGHEIGHT");
                sb.append(w == null ? Integer.valueOf(0) : w);
                sb.append(",");
                sb.append(h == null ? Integer.valueOf(0) : h);
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u83b7\u53d6\u56fe\u7247\u5c3a\u5bf8\u9519\u8bef" + sqlString), (Throwable)e);
            e.printStackTrace();
        }
        return sb.toString();
    }

    public String getStyleByCode(String[] styleCode) throws SQLException {
        StringBuffer sql2 = new StringBuffer();
        StringBuffer styleBuffer = new StringBuffer();
        sql2.append("SELECT STYLECODE,STYLENAME,STYLETEXT FROM ").append("[S].JXD7_PM_STYLE where STYLECODE in (").append(DbOper.toInSql(styleCode)).append(") ORDER BY STYLECODE");
        RowSet rs = DbOper.executeQuery(sql2.toString());
        while (rs.next()) {
            String style = rs.getString("STYLETEXT");
            if (style == null || style.length() <= 0) continue;
            styleBuffer.append(style);
            if (style.charAt(style.length() - 1) == ';') continue;
            styleBuffer.append(";");
        }
        return styleBuffer.toString();
    }

    public static String getExtAttribute(String id, String pattenid) throws SQLException {
        String retStr = "";
        String sql2 = " SELECT ATTRIBUTEVALUE FROM JXD7_PM_CELLATTRIBUTE WHERE ATTRIBUTEID = '" + id + "' AND PATTERNID= '" + pattenid + "' ";
        Object obj = DbOper.executeQueryObject(sql2);
        if (obj != null) {
            retStr = obj.toString();
        }
        return retStr;
    }

    public static boolean updateNeedDel(String[] fileIds) {
        ArrayList<String> sqlList = new ArrayList<String>();
        boolean flag = false;
        int i = 0;
        while (i < fileIds.length) {
            StringBuffer sb = new StringBuffer();
            sb.append("UPDATE JXD7_PM_FILE SET NEEDDEL = '").append("unNeedDel").append("' WHERE ID = '").append(fileIds[i]).append("'");
            sqlList.add(sb.toString());
            ++i;
        }
        try {
            int row = DbOper.executeNonQuery(sqlList);
            if (row > 0) {
                flag = true;
            }
        }
        catch (Exception e) {
            daoLogger.error((Object)"\u6267\u884cUpdate SQL\u51fa\u9519\uff01");
            e.printStackTrace();
        }
        return flag;
    }
}

