/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.dao;

import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.base.DataStatus;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.model.FormInstanceBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.FormParameterData;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.PatternParameter;
import com.sdjxd.pms.platform.form.service.cell.DynamicCell;
import com.sdjxd.pms.platform.form.service.minicell.MiniCell;
import com.sdjxd.pms.platform.form.sql.FormDataSql;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.table.service.EditGrid;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class FormInstanceDao {
    private static Logger daoLogger = Logger.getLogger((String)"FormDataDao");

    private static FormDataSql getSqlHelper(String m_dataSourceName) {
        return (FormDataSql)BeanFactory.getSqlInstance(FormInstanceDao.class, "FormDataSql", m_dataSourceName);
    }

    public boolean deleteInstance(Form form, String formInstanceId, List sqlList) {
        ICell[] patternCell = form.getCells();
        int cellId = 0;
        while (cellId < patternCell.length) {
            if (patternCell[cellId] instanceof DynamicCell) {
                ((DynamicCell)patternCell[cellId]).deleteInstance(formInstanceId, sqlList);
            } else {
                boolean cfr_ignored_0 = patternCell[cellId] instanceof ICell;
            }
            ++cellId;
        }
        return false;
    }

    public TreeMap getFormIndex(Form pattern, String formId, StringBuffer error) {
        TreeMap<String, Object> index;
        block17: {
            index = new TreeMap<String, Object>();
            String sql2 = FormInstanceDao.getSqlHelper(pattern.getDataSourceName()).getFormIndex(pattern, formId);
            try {
                RowSet rs = DbOper.executeQuery(pattern.getDataSourceName(), sql2);
                if (rs.next()) {
                    int i = 1;
                    while (i <= rs.getMetaData().getColumnCount()) {
                        String key = rs.getMetaData().getColumnName(i);
                        String columnType = rs.getMetaData().getColumnTypeName(i);
                        if (columnType.equalsIgnoreCase("int") || columnType.equalsIgnoreCase("INTEGER")) {
                            index.put(key, String.valueOf(rs.getInt(i)));
                        } else if (columnType.equalsIgnoreCase("image")) {
                            try {
                                InputStream is = rs.getBinaryStream(i);
                                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                                byte[] data = new byte[4096];
                                int count = -1;
                                while ((count = is.read(data, 0, 4096)) != -1) {
                                    outStream.write(data, 0, count);
                                }
                                data = null;
                                String fieldValue = new String(outStream.toByteArray(), "GBK");
                                index.put(key, fieldValue);
                            }
                            catch (Exception e) {
                                daoLogger.error((Object)"\u8bfb\u53d6\u8868\u5355blob\u5b57\u6bb5\u5931\u8d25!");
                                if (error != null) {
                                    error.append("\u8bfb\u53d6\u8868\u5355blob\u5b57\u6bb5\u5931\u8d25\uff01\n");
                                }
                                e.printStackTrace();
                            }
                        } else if (columnType.equalsIgnoreCase("float")) {
                            BigDecimal num = rs.getBigDecimal(i);
                            if (num != null && num.scale() < 0) {
                                num = num.setScale(0);
                            }
                            index.put(key, num == null ? num : num.toString());
                        } else {
                            index.put(key, rs.getString(i));
                        }
                        ++i;
                    }
                } else if (formId != null && formId.length() != 0 && !formId.equals("-1")) {
                    throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u8bb0\u5f55\uff0c\u6216\u6ca1\u6709\u5f53\u524d\u8bb0\u5f55\u7684\u6743\u9650\u3002");
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u8bfb\u53d6\u8868\u5355\u7d22\u5f15\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
                if (error == null) break block17;
                error.append("\u8bfb\u53d6\u8868\u5355\u7d22\u5f15\u8868\u5931\u8d25\uff01\n");
            }
        }
        return index;
    }

    public TreeMap getHistoryIndex(Form pattern, String formId, StringBuffer error) {
        TreeMap<String, String> index;
        block13: {
            index = new TreeMap<String, String>();
            TreeMap indexType = pattern.getCellIndex();
            String sql2 = FormInstanceDao.getSqlHelper(pattern.getDataSourceName()).getHistoryIndex(pattern, formId);
            try {
                RowSet rs = DbOper.executeQuery(pattern.getDataSourceName(), sql2);
                if (rs.next()) {
                    int i = 1;
                    while (i <= rs.getMetaData().getColumnCount()) {
                        String key = rs.getMetaData().getColumnName(i);
                        if (indexType.get(key) != null) {
                            String columnType = rs.getMetaData().getColumnTypeName(i);
                            if (columnType.equalsIgnoreCase("int") || columnType.equalsIgnoreCase("INTEGER")) {
                                index.put(key, String.valueOf(rs.getInt(i)));
                            } else if (columnType.equalsIgnoreCase("image")) {
                                try {
                                    InputStream is = rs.getBinaryStream(i);
                                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                                    byte[] data = new byte[4096];
                                    int count = -1;
                                    while ((count = is.read(data, 0, 4096)) != -1) {
                                        outStream.write(data, 0, count);
                                    }
                                    data = null;
                                    String fieldValue = new String(outStream.toByteArray(), "GBK");
                                    index.put(key, fieldValue);
                                }
                                catch (Exception e) {
                                    daoLogger.error((Object)"\u8bfb\u53d6\u8868\u5355blob\u5b57\u6bb5\u5931\u8d25!");
                                    if (error != null) {
                                        error.append("\u8bfb\u53d6\u8868\u5355blob\u5b57\u6bb5\u5931\u8d25\uff01\n");
                                    }
                                    e.printStackTrace();
                                }
                            } else {
                                index.put(key, rs.getString(i));
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u8bfb\u53d6\u8868\u5355\u7d22\u5f15\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
                if (error == null) break block13;
                error.append("\u8bfb\u53d6\u8868\u5355\u7d22\u5f15\u8868\u5931\u8d25\uff01\n");
            }
        }
        return index;
    }

    public FormInstanceBean getFormInstanceBean(String formInstanceId) {
        FormInstanceBean formInstanceBean = new FormInstanceBean();
        String sql2 = FormInstanceDao.getSqlHelper("defaultds").getFormInstanceBeanSql(formInstanceId);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs.next()) {
                formInstanceBean.setPatternId(rs.getString("PATTERNID"));
                formInstanceBean.setOpener(rs.getString("OPENER"));
                formInstanceBean.setOpenerid(rs.getString("OPENERID"));
                formInstanceBean.setCreateuser(rs.getString("CREATEUSER"));
                formInstanceBean.setCreateuserid(rs.getString("PATTERNID"));
                formInstanceBean.setCreatedept(rs.getString("CREATEDEPT"));
                formInstanceBean.setCreatedeptid(rs.getString("CREATEDEPTID"));
                formInstanceBean.setCreateorg(rs.getString("CREATEORG"));
                formInstanceBean.setCreateorgid(rs.getString("PATTERNID"));
                formInstanceBean.setCreatedate(DateTool.parseCal(rs.getString("CREATEDATE")));
                formInstanceBean.setLastopentime(DateTool.parseCal(rs.getString("LASTOPENTIME")));
                formInstanceBean.setDataStatusId(DataStatus.getInstance(Integer.parseInt(rs.getString("DATASTATUSID"))));
                formInstanceBean.setShowOrder(Integer.parseInt(rs.getString("SHOWORDER")));
                formInstanceBean.setFlowid(rs.getString("FLOWID"));
                formInstanceBean.setFlownodeid(rs.getString("FLOWNODEID"));
                formInstanceBean.setFlownodename(rs.getString("FLOWNODENAME"));
                formInstanceBean.setFlowobjectid(rs.getString("FLOWOBJECTID"));
                formInstanceBean.setLastsavetime(DateTool.parseCal(rs.getString("LASTSAVETIME")));
                formInstanceBean.setSaver(rs.getString("EDITUSER"));
                formInstanceBean.setSaverid(rs.getString("EDITUSERID"));
                formInstanceBean.setSheetId(rs.getString("SHEETID"));
                formInstanceBean.setSheetName(rs.getString("SHEETNAME"));
                formInstanceBean.setSheetstatusid(rs.getString("SHEETSTATUSID"));
                formInstanceBean.setSheetstatusname(rs.getString("SHEETSTATUSNAME"));
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u8bfb\u53d6\u8868\u5355\u7d22\u5f15\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
        }
        return formInstanceBean;
    }

    public TreeMap getFormIndex(FormInstance form) {
        return this.getFormIndex(form, null);
    }

    public TreeMap getFormIndex(FormInstance form, StringBuffer error) {
        form.setIndex(this.getFormIndex(form.getPattern(), form.getId(), error));
        return form.getIndex();
    }

    public TreeMap getHistoryIndex(FormInstance form, StringBuffer error) {
        form.setIndex(this.getHistoryIndex(form.getPattern(), form.getId(), error));
        return form.getIndex();
    }

    public List getFormParameter(FormInstance form) {
        return this.getFormParameter(form, null);
    }

    public List getFormParameter(FormInstance form, StringBuffer error) {
        ArrayList<FormParameterData> listResult;
        block7: {
            listResult = new ArrayList<FormParameterData>();
            Form pattern = form.getPattern();
            if (!pattern.isHasParameter()) {
                return null;
            }
            PatternParameter[] patternParas = pattern.getParameters();
            String sql2 = FormInstanceDao.getSqlHelper(pattern.getDataSourceName()).getFormParameter(form);
            try {
                String dataSourceName = pattern.getDataSourceName();
                String dataUserName = pattern.getDataUserName();
                RowSet rs = DbOper.executeQuery(dataSourceName, sql2);
                while (rs.next()) {
                    int nParaID = rs.getInt("PARAMETERID");
                    FormParameterData dataItem = new FormParameterData(nParaID);
                    dataItem.setObjValue(rs.getString("PARAMETERVALUE"));
                    dataItem.setObjSrcSheetID(rs.getString("SRCSHEETID"));
                    dataItem.setObjSrcTableName(rs.getString("SRCTABLENAME"));
                    dataItem.setObjSrcSheetDataSourceName(dataSourceName);
                    dataItem.setObjSrcSheetDataUserName(dataUserName);
                    dataItem.setObjSrcParaID(rs.getInt("SRCPARAMETERID"));
                    int i = 0;
                    while (i < patternParas.length) {
                        if (patternParas[i] != null && patternParas[i].getParaID() == nParaID) {
                            dataItem.setParaType(patternParas[i].getParaType());
                            dataItem.setParaValue(patternParas[i].getParaValue());
                            break;
                        }
                        ++i;
                    }
                    listResult.add(dataItem);
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u8bfb\u53d6\u8868\u5355\u5185\u5bb9\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
                if (error == null) break block7;
                error.append("\u8bfb\u53d6\u8868\u5355\u5185\u5bb9\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage());
            }
        }
        if (listResult.size() <= 0) {
            listResult = null;
        }
        return listResult;
    }

    public FormCell[] getFormText(FormInstance form) {
        return this.getFormText(form, null);
    }

    public FormCell[] getFormText(FormInstance form, StringBuffer error) {
        FormCell[] text;
        block5: {
            text = form.getCell();
            Form pattern = form.getPattern();
            int patternType = pattern.getPatternType();
            if (patternType == 6 || !pattern.isHasText()) {
                return text;
            }
            String sql2 = FormInstanceDao.getSqlHelper(pattern.getDataSourceName()).getFormText(form);
            try {
                RowSet rs = DbOper.executeQuery(pattern.getDataSourceName(), sql2);
                while (rs.next()) {
                    int cellId = rs.getInt("CELLID");
                    if (cellId == -1) continue;
                    if (text[cellId] == null) {
                        text[cellId] = new FormCell(cellId, rs.getString("CELLTEXT"), rs.getString("CELLVALUE"));
                        text[cellId].setModify(DataModify.SAVED);
                        continue;
                    }
                    text[cellId].addText(rs.getString("CELLTEXT"));
                    text[cellId].addValue(rs.getString("CELLVALUE"));
                    text[cellId].setModify(DataModify.SAVED);
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u8bfb\u53d6\u8868\u5355\u5185\u5bb9\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
                if (error == null) break block5;
                error.append("\u8bfb\u53d6\u8868\u5355\u5185\u5bb9\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage());
            }
        }
        return text;
    }

    public FormCell[] getHistoryText(FormInstance form, StringBuffer error) {
        FormCell[] text;
        block5: {
            text = form.getCell();
            Form pattern = form.getPattern();
            int patternType = pattern.getPatternType();
            if (patternType == 6 || !pattern.isHasHistoryText()) {
                return text;
            }
            String sql2 = FormInstanceDao.getSqlHelper(pattern.getDataSourceName()).getHistoryText(form);
            try {
                RowSet rs = DbOper.executeQuery(pattern.getDataSourceName(), sql2);
                while (rs.next()) {
                    int cellId = rs.getInt("CELLID");
                    if (text[cellId] == null) {
                        text[cellId] = new FormCell(cellId, rs.getString("CELLTEXT"), rs.getString("CELLVALUE"));
                        text[cellId].setModify(DataModify.SAVED);
                        continue;
                    }
                    text[cellId].addText(rs.getString("CELLTEXT"));
                    text[cellId].addValue(rs.getString("CELLVALUE"));
                    text[cellId].setModify(DataModify.SAVED);
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u8bfb\u53d6\u8868\u5355\u5185\u5bb9\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
                if (error == null) break block5;
                error.append("\u8bfb\u53d6\u8868\u5355\u5185\u5bb9\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage());
            }
        }
        return text;
    }

    public String getParaValueFromOtherSheet(FormParameterData paraData) {
        String strValue = "";
        if (paraData != null && !StringTool.isEmpty(paraData.getObjSrcTableName())) {
            String sql2 = FormInstanceDao.getSqlHelper(paraData.getObjSrcSheetDataSourceName()).getSheetParaValueSql(paraData.getObjSrcSheetDataUserName(), paraData.getObjSrcTableName(), paraData.getObjSrcSheetID(), paraData.getObjSrcParaID());
            try {
                RowSet rs = DbOper.executeQuery(paraData.getObjSrcSheetDataSourceName(), sql2);
                if (rs.next()) {
                    strValue = rs.getString("PARAMETERVALUE");
                }
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u83b7\u53d6\u8868\u5355\u53c2\u6570\u503c\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
            }
        }
        return strValue;
    }

    public String getSheetOrder(String dataSourceName, String dataUserName, String tablename) {
        String sql2 = FormInstanceDao.getSqlHelper(dataSourceName).getSheetOrderSql(dataUserName, tablename);
        int newSheetOrder = -1;
        try {
            RowSet rs = DbOper.executeQuery(dataSourceName, sql2);
            if (rs.next()) {
                newSheetOrder = rs.getInt("NEWORDER");
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u83b7\u53d6\u6700\u5927\u6392\u5e8f\u7801\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
        }
        return "" + newSheetOrder;
    }

    public void modifyFormParaData(FormInstance form, List list) {
        Form pattern = form.getPattern();
        if (!pattern.isHasParameter()) {
            return;
        }
        list.add(FormInstanceDao.getSqlHelper(form.getPattern().getDataSourceName()).getPataDataDeleteSql(form));
        FormParameterData[] paraDatas = form.getParaData();
        int nCount = paraDatas.length;
        int i = 0;
        while (i < nCount) {
            block13: {
                FormParameterData dataItem;
                block15: {
                    int type;
                    block17: {
                        block16: {
                            block14: {
                                dataItem = paraDatas[i];
                                if (dataItem == null) break block13;
                                type = dataItem.getParaType();
                                if (type != SheetConstants.PARAMETER.TYPE_CELL) break block14;
                                String strParaValue = dataItem.getParaValue().replace('.', ',');
                                String[] arrTemp = strParaValue.split(",");
                                if (arrTemp.length == 2) {
                                    String strValue = "";
                                    int cellID = Integer.parseInt(arrTemp[0]);
                                    if (pattern.getCells()[cellID] instanceof DynamicCell || pattern.getCells()[cellID] instanceof MiniCell) {
                                        strValue = "Text".equals(arrTemp[1]) ? form.getCell()[cellID].getText() : form.getCell()[cellID].getValue();
                                    }
                                    dataItem.setObjValue(strValue);
                                }
                                break block15;
                            }
                            if (type != SheetConstants.PARAMETER.TYPE_DEFCOL) break block16;
                            TreeMap index = form.getIndex();
                            if (index.get(dataItem.getParaValue()) == null) {
                                dataItem.setObjValue("");
                            } else {
                                dataItem.setObjValue((String)index.get(dataItem.getParaValue()));
                            }
                            break block15;
                        }
                        if (type == SheetConstants.PARAMETER.TYPE_OTHERSHEET) break block15;
                        if (type != SheetConstants.PARAMETER.TYPE_TEXT) break block17;
                        dataItem.setObjValue(StringTool.replaceKeyWord(dataItem.getParaValue()));
                        break block15;
                    }
                    if (type != SheetConstants.PARAMETER.TYPE_USERDEFINE) break block13;
                    String paraValue = dataItem.getParaValue();
                    String objValue = dataItem.getParaValue();
                    String[] paraGroupTemp = paraValue.split("]");
                    int j = 0;
                    while (j < paraGroupTemp.length) {
                        String paraTemp = paraGroupTemp[j];
                        String paraStr = paraTemp.substring(paraTemp.indexOf("[") + 1);
                        String[] arrTemp = paraStr.split("\\.");
                        if (arrTemp.length == 2) {
                            String strValue = "";
                            int cellID = Integer.parseInt(arrTemp[0]);
                            if (pattern.getCells()[cellID] instanceof DynamicCell || pattern.getCells()[cellID] instanceof MiniCell) {
                                strValue = "Text".equals(arrTemp[1]) ? form.getCell()[cellID].getText() : form.getCell()[cellID].getValue();
                            }
                            paraStr = "\\[" + paraStr + "\\]";
                            objValue = objValue.replaceAll(paraStr, strValue);
                        }
                        ++j;
                    }
                    dataItem.setObjValue(objValue);
                }
                list.add(FormInstanceDao.getSqlHelper(form.getPattern().getDataSourceName()).getPataDataInsertSql(form, dataItem));
            }
            ++i;
        }
    }

    public void modifyFormText(FormInstance formInstance, List list) {
        Form pattern = formInstance.getPattern();
        int patternType = pattern.getPatternType();
        if (patternType == 6 || !pattern.isHasText()) {
            return;
        }
        FormCell[] formCell = formInstance.getCell();
        ICell[] patternCell = pattern.getCells();
        int cellId = 0;
        while (cellId < formCell.length) {
            if (patternCell[cellId] instanceof DynamicCell) {
                ((DynamicCell)patternCell[cellId]).save(formInstance, list);
            } else if (patternCell[cellId] instanceof MiniCell) {
                patternCell[cellId].save(formInstance, list);
            }
            ++cellId;
        }
    }

    public void UpdateFormHistoryText(FormInstance formInstance, List list) {
        Form pattern = formInstance.getPattern();
        int patternType = pattern.getPatternType();
        if (patternType == 6) {
            return;
        }
        FormCell[] formCell = formInstance.getCell();
        ICell[] patternCell = pattern.getCells();
        int cellId = 0;
        while (cellId < formCell.length) {
            if (patternCell[cellId] != null && patternCell[cellId] instanceof DynamicCell || patternCell[cellId] instanceof MiniCell) {
                try {
                    StringBuffer sql2 = new StringBuffer(256);
                    int sortIndex = 0;
                    String tableName = String.valueOf(pattern.getDataUserName()) + pattern.getTextHistoryTable();
                    sql2.append("DELETE FROM ");
                    sql2.append(tableName);
                    sql2.append(" WHERE SHEETID='");
                    sql2.append(formInstance.getHistorysheetid());
                    if (Form.FOrmType.equals("0")) {
                        sql2.append("' AND CELLID=");
                        sql2.append(cellId);
                    }
                    list.add(sql2.toString());
                    if (formCell[cellId] == null) {
                        return;
                    }
                    String text = formCell[cellId].getText();
                    String cellValue = formCell[cellId].getValue();
                    if (text == null) {
                        text = "";
                    }
                    if (cellValue == null) {
                        cellValue = "";
                    }
                    int valueLen = cellValue.length();
                    int textLen = text.length();
                    sortIndex = 0;
                    while (sortIndex * 150 <= valueLen || sortIndex * 150 <= textLen) {
                        sql2.setLength(0);
                        String curValue = valueLen > (sortIndex + 1) * 150 ? cellValue.substring(sortIndex * 150, sortIndex * 150 + 150) : (valueLen <= (sortIndex + 1) * 150 && valueLen > sortIndex * 150 ? cellValue.substring(sortIndex * 150) : "");
                        String curText = textLen > (sortIndex + 1) * 150 ? text.substring(sortIndex * 150, sortIndex * 150 + 150) : (textLen <= (sortIndex + 1) * 150 && textLen > sortIndex * 150 ? text.substring(sortIndex * 150) : "");
                        sql2.append("INSERT INTO ");
                        sql2.append(tableName);
                        sql2.append("(SHEETID,CELLID,SORTID,CELLVALUE,CELLTEXT) VALUES('");
                        sql2.append(formInstance.getHistorysheetid());
                        sql2.append("',");
                        sql2.append(cellId);
                        sql2.append(",");
                        sql2.append(sortIndex);
                        sql2.append(",'");
                        sql2.append(DbOper.toDb(curValue));
                        sql2.append("','");
                        sql2.append(DbOper.toDb(curText));
                        sql2.append("')");
                        list.add(sql2.toString());
                        ++sortIndex;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++cellId;
        }
    }

    public void saveForm(FormInstance form, StringBuffer error) throws Exception {
        String tmp;
        ArrayList<String> sql2 = new ArrayList<String>(64);
        int tableType = form.getPattern().isViewIndexTable();
        if (tableType == 1 || tableType == 2) {
            this.saveViewForm(form, error);
            this.modifyFormText(form, sql2);
            try {
                DbOper.executeNonQuery(form.getPattern().getDataSourceName(), sql2);
            }
            catch (SQLException e) {
                StringBuffer logError = new StringBuffer(256);
                logError.append("\u4fdd\u5b58\u8868\u5355\u5185\u5bb9\u5931\u8d25,\u9519\u8bef\u4e3a:");
                logError.append(e.getMessage());
                daoLogger.error((Object)logError);
                if (error != null) {
                    error.append("\u4fdd\u5b58\u8868\u5355\u5185\u5bb9\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage());
                }
                throw e;
            }
            return;
        }
        ArrayList<String> formInstanceBeanSql = new ArrayList<String>();
        FormDataSql sqlHelper = FormInstanceDao.getSqlHelper(form.getPattern().getDataSourceName());
        if (form.getModify().is(DataModify.NEW)) {
            sql2.add(sqlHelper.deleteFormIndex(form));
            sqlHelper.saveFormIndex(form, sql2);
            tmp = sqlHelper.delFormInstanceBean(form.getFormInstanceBean());
            formInstanceBeanSql.add(tmp);
            tmp = sqlHelper.createFormInstanceBean(form.getFormInstanceBean());
            formInstanceBeanSql.add(tmp);
        } else {
            sqlHelper.modifyFormIndex(form, sql2);
            tmp = sqlHelper.modifyFormInstanceBean(form.getFormInstanceBean());
            formInstanceBeanSql.add(tmp);
        }
        this.modifyFormText(form, sql2);
        this.modifyFormCell(form, sql2);
        this.modifyFormParaData(form, sql2);
        try {
            DbOper.executeNonQuery("defaultds", formInstanceBeanSql);
            DbOper.executeNonQuery(form.getPattern().getDataSourceName(), sql2);
            DbOper.executeNonQuery(sqlHelper.getUpdateFileDelTypeSql(form));
        }
        catch (SQLException e) {
            StringBuffer logError = new StringBuffer(256);
            logError.append("\u4fdd\u5b58\u8868\u5355\u5185\u5bb9\u5931\u8d25,\u9519\u8bef\u4e3a:");
            logError.append(e.getMessage());
            daoLogger.error((Object)logError);
            if (error != null) {
                error.append("\u4fdd\u5b58\u8868\u5355\u5185\u5bb9\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage());
            }
            throw e;
        }
    }

    public void saveHistory(FormInstance form, StringBuffer error) throws Exception {
        ArrayList sql2 = new ArrayList(64);
        FormDataSql sqlHelper = FormInstanceDao.getSqlHelper(form.getPattern().getDataSourceName());
        if (this.isNewHistory(form, form.getId())) {
            sqlHelper.modifyFormHistoryIndex(form, sql2);
        } else {
            sqlHelper.saveFormHistoryIndex(form, sql2);
        }
        this.UpdateFormHistoryText(form, sql2);
        try {
            DbOper.executeNonQuery(form.getPattern().getDataSourceName(), sql2);
        }
        catch (SQLException e) {
            StringBuffer logError = new StringBuffer(256);
            logError.append("\u4fdd\u5b58\u8868\u5355\u5185\u5bb9\u5931\u8d25,\u9519\u8bef\u4e3a:");
            logError.append(e.getMessage());
            daoLogger.error((Object)logError);
            if (error != null) {
                error.append("\u4fdd\u5b58\u8868\u5355\u5185\u5bb9\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage());
            }
            throw e;
        }
    }

    public void saveFormBlob(FormInstance form) throws Exception {
        FormDataSql sqlHelper = FormInstanceDao.getSqlHelper(form.getPattern().getDataSourceName());
        ArrayList sqlList = new ArrayList();
        ArrayList inputStreamList = new ArrayList();
        ArrayList lenList = new ArrayList();
        sqlHelper.saveFormIndexBlob(form, sqlList, inputStreamList, lenList);
        int i = 0;
        while (i < sqlList.size()) {
            DbOper.updatePicture(form.getPattern().getDataSourceName(), sqlList.get(i).toString(), (InputStream)inputStreamList.get(i), ((Integer)lenList.get(i)).intValue());
            ++i;
        }
    }

    public void saveIndex(FormInstance form, StringBuffer error) throws Exception {
        block4: {
            ArrayList<String> sql2 = new ArrayList<String>(64);
            if (form.getModify().is(DataModify.NEW)) {
                sql2.add(FormInstanceDao.getSqlHelper(form.getPattern().getDataSourceName()).deleteFormIndex(form));
                FormInstanceDao.getSqlHelper(form.getPattern().getDataSourceName()).saveFormIndex(form, sql2);
            } else {
                FormInstanceDao.getSqlHelper(form.getPattern().getDataSourceName()).modifyFormIndex(form, sql2);
            }
            try {
                DbOper.executeNonQuery(form.getPattern().getDataSourceName(), sql2);
            }
            catch (SQLException e) {
                StringBuffer logError = new StringBuffer(256);
                logError.append("\u4fdd\u5b58\u8868\u5355\u7d22\u5f15\u5931\u8d25,\u9519\u8bef\u4e3a:");
                logError.append(e.getMessage());
                daoLogger.error((Object)logError);
                if (error == null) break block4;
                error.append("\u4fdd\u5b58\u8868\u5355\u7d22\u5f15\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage());
            }
        }
    }

    public void updateOpener(FormInstance form, boolean isOpen) {
        String table = form.getPattern().getIndexTable();
        if (table == null || table.length() == 0) {
            return;
        }
        String[] sql2 = FormInstanceDao.getSqlHelper(form.getPattern().getDataSourceName()).updateOpener(form, isOpen);
        try {
            if (sql2.length > 1) {
                DbOper.executeNonQuery(form.getPattern().getDataSourceName(), sql2[0]);
                DbOper.executeNonQuery("defaultds", sql2[1]);
            } else {
                DbOper.executeNonQuery("defaultds", sql2);
            }
            if (!isOpen) {
                form.initCell("OPENER", "");
                form.initCell("OPENERID", "");
            } else {
                form.initCell("OPENER", User.getCurrentUser().getName());
                form.initCell("OPENERID", User.getCurrentUser().getId());
            }
        }
        catch (SQLException e) {
            StringBuffer logError = new StringBuffer(256);
            logError.append("\u6e05\u7a7a\u6216\u8005\u66f4\u65b0\u8868\u5355\u5bf9\u8c61\u6253\u5f00\u4eba\u5931\u8d25,\u9519\u8bef\u4e3a:");
            logError.append(e.getMessage());
            logError.append("\nsql\u4e3a\uff1a");
            logError.append("\n" + sql2[0]);
            logError.append("\n" + sql2[1]);
            daoLogger.error((Object)logError);
        }
    }

    public boolean saveViewForm(FormInstance formInstance, StringBuffer error) throws Exception {
        StringBuffer fieldData = new StringBuffer();
        StringBuffer data = new StringBuffer();
        for (Map.Entry entry : formInstance.getIndex().entrySet()) {
            String columnName = (String)entry.getKey();
            String columnValue = (String)entry.getValue();
            if (columnValue == null) continue;
            fieldData.append(",");
            fieldData.append("\"").append(columnName).append("\"");
            fieldData.append(":");
            fieldData.append("\"").append(columnValue).append("\"");
        }
        if (fieldData.length() == 0) {
            return true;
        }
        data.append("\"{");
        data.append("\"type\":");
        if (formInstance.getModify().is(DataModify.NEW)) {
            data.append("\"new\",");
        } else {
            data.append("\"modify\",");
        }
        data.append("\"data\":");
        data.append("{\"_c\":\"java.util.HashMap\",");
        data.append(fieldData.substring(1));
        data.append("}");
        data.append("}\"");
        String[] dataList = new String[]{data.toString()};
        Form form = formInstance.getPattern();
        String tableName = form.getIndexTable();
        String dataSourceName = form.getDataSourceName();
        String dataUserName = form.getDataUserName();
        String kpCol = form.getIndexTablePkCol();
        return EditGrid.saveEditGridData(dataSourceName, dataUserName, tableName, kpCol, 1, dataList);
    }

    public ArrayList getTableOfForm() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        String sql2 = FormInstanceDao.getSqlHelper("defaultds").getTableOfForm();
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                String[] tableInfo = new String[]{rs.getString("TABLENAME"), rs.getString("DATASOURCENAME"), rs.getString("DATAUSERNAME")};
                list.add(tableInfo);
            }
        }
        catch (Exception exp) {
            daoLogger.error((Object)"\u6e05\u7a7a\u6240\u6709\u8868\u5355\u5b9e\u4f8b\u7684\u6253\u5f00\u4eba\u4fe1\u606f\u5931\u8d25");
            exp.printStackTrace();
        }
        return list;
    }

    public void updateOpener(List allTableInfo) {
        if (allTableInfo != null) {
            int i = 0;
            while (i < allTableInfo.size()) {
                String[] tableInfo = (String[])allTableInfo.get(i);
                String sql2 = FormInstanceDao.getSqlHelper(tableInfo[1]).updateOpener(tableInfo);
                try {
                    DbOper.executeNonQuery(tableInfo[1], sql2);
                }
                catch (Exception exp) {
                    daoLogger.error((Object)"\u6e05\u7a7a\u6240\u6709\u8868\u5355\u5b9e\u4f8b\u7684\u6253\u5f00\u4eba\u4fe1\u606f\u5931\u8d25");
                }
                ++i;
            }
        }
    }

    public List getCompareInfo(String sheetid1, String sheetid2, String tablename) {
        String sql1 = FormInstanceDao.getSqlHelper("defaultds").getHisttroyText(sheetid1, tablename);
        String sql2 = FormInstanceDao.getSqlHelper("defaultds").getHisttroyText(sheetid2, tablename);
        RowSet rs1 = null;
        RowSet rs2 = null;
        HashMap map1 = new HashMap();
        ArrayList dlist = new ArrayList();
        try {
            HashMap<String, String> dimap;
            rs1 = DbOper.executeQuery(sql1);
            while (rs1.next()) {
                HashMap<String, String> rsmap = new HashMap<String, String>();
                String field1 = rs1.getString("TEXTFIELD");
                String cellid1 = rs1.getString("CELLID");
                rsmap.put("FIELDID", field1);
                rsmap.put("CELLID", cellid1);
                rsmap.put("CELLTEXT", rs1.getString("CELLTEXT"));
                rsmap.put("CELLVALUE", rs1.getString("CELLVALUE"));
                if (field1 != null && !field1.equals("")) {
                    map1.put(field1, rsmap);
                    continue;
                }
                if (cellid1 == null || cellid1.equals("")) continue;
                map1.put(cellid1, rsmap);
            }
            rs2 = DbOper.executeQuery(sql2);
            while (rs2.next()) {
                HashMap<String, String> dimap2;
                String prcellid;
                String prcellvalue;
                String prcelltext;
                Map prmap;
                String field2 = rs2.getString("TEXTFIELD");
                String cellid2 = rs2.getString("CELLID");
                String celltext2 = rs2.getString("CELLTEXT");
                String cellvalue2 = rs2.getString("CELLVALUE");
                if (field2 != null && !field2.equals("")) {
                    prmap = (Map)map1.get(field2);
                    if (prmap != null) {
                        map1.remove(field2);
                        prcelltext = (String)prmap.get("CELLTEXT");
                        prcellvalue = (String)prmap.get("CELLVALUE");
                        prcellid = (String)prmap.get("CELLID");
                        if (celltext2 != null) {
                            if (celltext2.equals(prcelltext)) continue;
                            dimap2 = new HashMap<String, String>();
                            dimap2.put("FIELDID", field2);
                            dimap2.put("CELLID2", cellid2);
                            dimap2.put("CELLID1", prcellid);
                            dimap2.put("TYPE", "EDIT");
                            dlist.add(dimap2);
                            continue;
                        }
                        if (cellvalue2 == null || cellvalue2.equals(prcellvalue)) continue;
                        dimap2 = new HashMap();
                        dimap2.put("FIELDID", field2);
                        dimap2.put("CELLID2", cellid2);
                        dimap2.put("CELLID1", prcellid);
                        dimap2.put("TYPE", "EDIT");
                        dlist.add(dimap2);
                        continue;
                    }
                    dimap = new HashMap();
                    dimap.put("FIELDID", field2);
                    dimap.put("CELLID2", cellid2);
                    dimap.put("CELLID1", "");
                    dimap.put("TYPE", "ADD");
                    dlist.add(dimap);
                    continue;
                }
                if (cellid2 == null || cellid2.equals("")) continue;
                prmap = (Map)map1.get(cellid2);
                if (prmap != null) {
                    map1.remove(cellid2);
                    prcelltext = (String)prmap.get("CELLTEXT");
                    prcellvalue = (String)prmap.get("CELLVALUE");
                    prcellid = (String)prmap.get("CELLID");
                    if (celltext2 != null) {
                        if (celltext2.equals(prcelltext)) continue;
                        dimap2 = new HashMap();
                        dimap2.put("FIELDID", field2);
                        dimap2.put("CELLID2", cellid2);
                        dimap2.put("CELLID1", prcellid);
                        dimap2.put("TYPE", "EDIT");
                        dlist.add(dimap2);
                        continue;
                    }
                    if (cellvalue2 == null || cellvalue2.equals(prcellvalue)) continue;
                    dimap2 = new HashMap();
                    dimap2.put("FIELDID", field2);
                    dimap2.put("CELLID2", cellid2);
                    dimap2.put("CELLID1", prcellid);
                    dimap2.put("TYPE", "EDIT");
                    dlist.add(dimap2);
                    continue;
                }
                dimap = new HashMap();
                dimap.put("FIELDID", field2);
                dimap.put("CELLID2", cellid2);
                dimap.put("CELLID1", "");
                dimap.put("TYPE", "ADD");
                dlist.add(dimap);
            }
            if (map1.size() > 0) {
                for (Map.Entry entry : map1.entrySet()) {
                    Map prmap = (Map)entry.getValue();
                    String fieldid = (String)prmap.get("FIELDID");
                    String cellid = (String)prmap.get("CELLID");
                    dimap = new HashMap<String, String>();
                    dimap.put("FIELDID", fieldid);
                    dimap.put("CELLID1", cellid);
                    dimap.put("CELLID2", "");
                    dimap.put("TYPE", "DEL");
                    dlist.add(dimap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dlist;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getHistoryInfoByCellId(String sheetid1, String sheetid2, String cellid, String tablename) {
        String sql2 = FormInstanceDao.getSqlHelper("defaultds").getCellHistoryByCellIdSql(sheetid1, sheetid2, cellid, tablename);
        ArrayList list = new ArrayList();
        RowSet rs = null;
        String celltext = "";
        String cellvalue = "";
        String cellfiled = null;
        try {
            rs = DbOper.executeQuery(sql2);
            while (true) {
                if (!rs.next()) {
                    return list;
                }
                String text = rs.getString("CELLTEXT");
                String value = rs.getString("CELLVALUE");
                String field = rs.getString("TEXTFIELD");
                if (text == null) {
                    text = "";
                }
                if (value == null) {
                    value = "";
                }
                if (field == null || "".equals(field)) {
                    if (cellfiled == null) {
                        cellfiled = "";
                    }
                    if (!cellfiled.equals(field)) {
                        return null;
                    }
                }
                if (field != null && !"".equals(field)) {
                    if (cellfiled == null) {
                        cellfiled = field;
                    }
                    if (!cellfiled.equals(field)) {
                        return null;
                    }
                }
                if ((!celltext.equals("") || !cellvalue.equals("")) && celltext.equals(text)) continue;
                celltext = text;
                cellvalue = value;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("EDITTIME", rs.getString("EDITTIME"));
                map.put("EDITUSER", rs.getString("EDITUSER"));
                map.put("EDITUSERID", rs.getString("EDITUSERID"));
                map.put("CELLID", cellid);
                map.put("CELLTEXT", celltext);
                map.put("CELLVALUE", cellvalue);
                list.add(map);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public List getHistoryInfo(String sheetid1, String sheetid2, List dlist, String tablename) {
        ArrayList<List> map = new ArrayList<List>();
        List list = null;
        int i = 0;
        while (i < dlist.size()) {
            Map dimap = (Map)dlist.get(i);
            String fieldid = (String)dimap.get("FIELDID");
            if (!"".equals(fieldid) && fieldid != null) {
                String cellid = (String)dimap.get("CELLID");
                list = this.getHistoryInfoByCellId(sheetid1, sheetid2, cellid, tablename);
            } else {
                list = this.getHistoryInfoByFieldId(sheetid1, sheetid2, fieldid, tablename);
            }
            map.add(list);
            ++i;
        }
        return map;
    }

    public List getHistoryInfoByFieldId(String sheetid1, String sheetid2, String fieldid, String tablename) {
        String sql2 = FormInstanceDao.getSqlHelper("defaultds").getCellHistoryByFieldIdSql(sheetid1, sheetid2, fieldid, tablename);
        ArrayList list = new ArrayList();
        RowSet rs = null;
        String celltext = "";
        String cellvalue = "";
        try {
            rs = DbOper.executeQuery(sql2);
            while (rs.next()) {
                String text = rs.getString("CELLTEXT");
                String value = rs.getString("CELLVALUE");
                if (text == null) {
                    text = "";
                }
                if (value == null) {
                    value = "";
                }
                if ((!celltext.equals("") || !cellvalue.equals("")) && celltext.equals(text) && cellvalue.equals(value)) continue;
                celltext = text;
                cellvalue = value;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("EDITTIME", rs.getString("EDITTIME"));
                map.put("EDITUSER", rs.getString("EDITUSER"));
                map.put("EDITUSERID", rs.getString("EDITUSERID"));
                map.put("CELLID", rs.getString("CELLID"));
                map.put("CELLTEXT", celltext);
                map.put("CELLVALUE", cellvalue);
                list.add(map);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public String getHistorySheetid(Form pattern, String hsheetid) {
        FormDataSql sqlHelper = FormInstanceDao.getSqlHelper(pattern.getDataSourceName());
        String newsheetid = "";
        try {
            String sql1 = sqlHelper.getHistorySql(pattern.getHistoryTable(), hsheetid);
            RowSet rs = DbOper.executeQuery(pattern.getDataSourceName(), sql1);
            if (rs.next() && !"1".equals(rs.getString("ISRELEASE"))) {
                newsheetid = rs.getString("SHEETID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return newsheetid;
        }
        return newsheetid;
    }

    public String getHistoryEditer(Form pattern, String hsheetid) {
        FormDataSql sqlHelper = FormInstanceDao.getSqlHelper(pattern.getDataSourceName());
        String edituser = null;
        try {
            String sql1 = sqlHelper.getHistorySql(pattern.getHistoryTable(), hsheetid);
            RowSet rs = DbOper.executeQuery(pattern.getDataSourceName(), sql1);
            if (rs.next() && !"1".equals(rs.getString("ISRELEASE")) && !User.isCurrent(rs.getString("EDITUSERID"))) {
                edituser = rs.getString("EDITUSER");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return edituser;
    }

    public boolean isNewHistory(FormInstance form, String hsheetid) throws Exception {
        Form pattern = form.getPattern();
        FormDataSql sqlHelper = FormInstanceDao.getSqlHelper(pattern.getDataSourceName());
        boolean isUpdate = false;
        String sql1 = sqlHelper.getHistorySql(pattern.getHistoryTable(), hsheetid);
        RowSet rs = DbOper.executeQuery(pattern.getDataSourceName(), sql1);
        if (rs.next()) {
            if (!"1".equals(rs.getString("ISRELEASE"))) {
                isUpdate = true;
            } else if (!StringTool.isEmpty(rs.getString("SHEETID")) && rs.getString("SHEETID").equals(form.getHistorysheetid())) {
                throw new Exception("\u5f53\u524d\u8868\u5355\u5df2\u53d1\u5e03\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u5e03\uff01");
            }
        }
        return isUpdate;
    }

    public boolean isexistIndexForm(Form pattern, String hsheetid) {
        try {
            FormDataSql sqlHelper = FormInstanceDao.getSqlHelper(pattern.getDataSourceName());
            RowSet hrs = DbOper.executeQuery(sqlHelper.getFormIndex(pattern, hsheetid));
            return hrs.next();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void releaseHistory(Form pattern, String sheetid) {
        FormDataSql sqlHelper = FormInstanceDao.getSqlHelper(pattern.getDataSourceName());
        try {
            DbOper.executeNonQuery(sqlHelper.setHistoryReleaseSql(pattern.getHistoryTable(), sheetid));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getTableNameById(String patternid) {
        String tablename = "";
        String sql2 = FormInstanceDao.getSqlHelper("defaultds").getPatternById(patternid);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                tablename = rs.getString("TABLENAME");
            }
        }
        catch (Exception exp) {
            daoLogger.error((Object)"\u83b7\u5f97\u8868\u5355\u5bf9\u5e94\u8868\u540d\u5931\u8d25");
            exp.printStackTrace();
        }
        return tablename;
    }

    public void modifyFormCell(FormInstance form, List list) {
        Form pattern = form.getPattern();
        FormCell[] formCell = form.getCell();
        ICell[] patternCell = pattern.getCells();
        int cellId = 0;
        while (cellId < formCell.length) {
            if (patternCell[cellId] instanceof DynamicCell) {
                ((DynamicCell)patternCell[cellId]).saveCell(form, list, cellId);
            }
            ++cellId;
        }
    }
}

