/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form;

import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.form.dao.DataConst;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public final class SheetConstants {

    public static final class CELL {
        private static HashMap m_cellClassMap;
        private static final Logger m_logger;
        public static String LINECOLOR;
        public static String CELL_PREFIX;
        public static String PATTERN_PREFIX;
        public static String AREA_PREFIX;
        public static String CONDITION_PREFIX;
        public static String GROUP_PREFIX;
        public static String SHARE_PREFIX;
        public static String FORMDATA_PREFIX;
        public static int MAX_PATTERN;
        public static int MAX_AREA;
        public static int MAX_CELL;
        public static int MAX_SCRIPT;
        public static int MAX_CONDITION;
        public static int MAX_GROUP;
        public static int MAX_SHARE;

        static {
            m_logger = Logger.getLogger(CELL.class);
            m_cellClassMap = new HashMap();
            String sql2 = "select cell_type_id, java_class from [S].JXD7_PM_UD_CELL";
            try {
                RowSet rs = DbOper.executeQuery("defaultds", sql2);
                while (rs.next()) {
                    m_cellClassMap.put(rs.getString("cell_type_id"), rs.getString("java_class"));
                }
            }
            catch (SQLException e) {
                m_logger.error((Object)e.getMessage());
            }
            LINECOLOR = "#000";
            CELL_PREFIX = "cellId";
            PATTERN_PREFIX = "p";
            AREA_PREFIX = "a";
            CONDITION_PREFIX = "c";
            GROUP_PREFIX = "g";
            SHARE_PREFIX = "s";
            FORMDATA_PREFIX = "f";
            MAX_PATTERN = 500;
            MAX_AREA = 50;
            MAX_CELL = 5000;
            MAX_SCRIPT = 30;
            MAX_CONDITION = 50;
            MAX_GROUP = 50;
            MAX_SHARE = 50;
        }

        public static String getType(int typeId) {
            String cellType;
            switch (typeId) {
                case 1: {
                    cellType = "Line";
                    break;
                }
                case 2: {
                    cellType = "DashLine";
                    break;
                }
                case 3: {
                    cellType = "Rect";
                    break;
                }
                case 4: {
                    cellType = "Ellipse";
                    break;
                }
                case 5: {
                    cellType = "StaticText";
                    break;
                }
                case 10: {
                    cellType = "Text";
                    break;
                }
                case 11: {
                    cellType = "TextArea";
                    break;
                }
                case 12: {
                    cellType = "Sign";
                    break;
                }
                case 13: {
                    cellType = "DateTime";
                    break;
                }
                case 14: {
                    cellType = "User";
                    break;
                }
                case 15: {
                    cellType = "ComboBox";
                    break;
                }
                case 16: {
                    cellType = "Picture";
                    break;
                }
                case 17: {
                    cellType = "File";
                    break;
                }
                case 18: {
                    cellType = "Button";
                    break;
                }
                case 19: {
                    cellType = "CzpCell";
                    break;
                }
                case 20: {
                    cellType = "SnapCell";
                    break;
                }
                case 21: {
                    cellType = "Stamp";
                    break;
                }
                case 30: {
                    cellType = "Radio";
                    break;
                }
                case 32: {
                    cellType = "WxdCell";
                    break;
                }
                case 31: {
                    cellType = "Check";
                    break;
                }
                case 34: {
                    cellType = "Navigate";
                    break;
                }
                case 35: {
                    cellType = "Grid";
                    break;
                }
                case 36: {
                    cellType = "Vector";
                    break;
                }
                case 37: {
                    cellType = "Stat";
                    break;
                }
                case 39: {
                    cellType = "Measure";
                    break;
                }
                case 41: {
                    cellType = "DevRunType";
                    break;
                }
                case 42: {
                    cellType = "Grid";
                    break;
                }
                case 43: {
                    cellType = "Grid";
                    break;
                }
                case 44: {
                    cellType = "TabPageCell";
                    break;
                }
                case 45: {
                    cellType = "Upload";
                    break;
                }
                case 46: {
                    cellType = "UploadImg";
                    break;
                }
                case 47: {
                    cellType = "MultiLine";
                    break;
                }
                case 48: {
                    cellType = "WordCell";
                    break;
                }
                case 49: {
                    cellType = "Tree";
                    break;
                }
                case 51: {
                    cellType = "Area";
                    break;
                }
                case 52: {
                    cellType = "IFrame";
                    break;
                }
                case 53: {
                    cellType = "HtmlCommon";
                    break;
                }
                case 54: {
                    cellType = "InfoShow";
                    break;
                }
                case 55: {
                    cellType = "ToolBar";
                    break;
                }
                case 56: {
                    cellType = "MultiCheckBoxList";
                    break;
                }
                case 57: {
                    cellType = "Spliter";
                    break;
                }
                case 58: {
                    cellType = "NumberSelector";
                    break;
                }
                case 59: {
                    cellType = "Hyperlink";
                    break;
                }
                case 60: {
                    cellType = "SelectList";
                    break;
                }
                case 62: {
                    cellType = "BaseList";
                    break;
                }
                case 131: {
                    cellType = "EasyUIDataGrid";
                    break;
                }
                default: {
                    cellType = "Text";
                    cellType = 10000 < typeId && m_cellClassMap.containsKey(String.valueOf(typeId)) ? "/" + (String)m_cellClassMap.get(String.valueOf(typeId)) : "cell" + typeId;
                }
            }
            return cellType;
        }

        public static class DATA {
            public static int PRINT = 1;
        }

        public static final class DEFAULTVALUE {
            public static boolean VISIBLE = true;
            public static boolean ENABLED = true;
            public static boolean BLANK = true;
            public static String CHILD_POSITION = DataConst.CELL.POSITION.ABSOLUTE;
            public static String POSITION = DataConst.CELL.POSITION.ABSOLUTE;
            public static String RADIO_CHECKED = "1";
        }

        public static final class LIMIT {
            public static final int DEFAULT = -1;
            public static final int NOT_VISIBLE = 0;
            public static final int VISIBLE = 1;
            public static final int EDIT = 2;
            public static final int BLANK = 3;
            public static final int All_VISIBLE = 4;
        }
    }

    public static final class CONDITION {

        public static final class COMPARETYPE {
            public static int LIKE = 0;
            public static int LESS = 1;
            public static int LESSEQUAL = 2;
            public static int OVER = 3;
            public static int OVEREQUAL = 4;
            public static int EQUAL = 5;
            public static int UNEQUAL = 6;
            public static int AND = 7;
            public static int OR = 8;
            public static int NOT = 9;
            public static int NOTLIKE = 10;

            public static int getValue(int typeId) {
                return typeId;
            }
        }

        public static final class TYPE {
            public static int CELL_CONST = 0;
            public static int CELL_CELL = 1;
            public static int CON_CON = 2;
            public static int TAB_SHEET = 2;
            public static int SHEET_CONST = 3;

            public static int getValue(int typeId) {
                return typeId;
            }
        }
    }

    public static final class FORM {
        public static String CSS_PATH = "/products/base/user_form.css";
    }

    public static final class HTML {
        public static String ATTTRUE = "true";
        public static String ATTFALSE = "false";
    }

    public static final class LINK_SHOW_TYPE {
        public static final int DIRECT = 0;
        public static final int GROUP = 1;
        public static final int TABPAGE = 2;
        public static final int DIRECT_TABPAGE = 3;
        public static final int GROUP_TABPAGE = 4;

        public static final boolean isDirect(int showType) {
            return showType == 0 || showType == 3;
        }

        public static final boolean isGroup(int showType) {
            return showType == 1 || showType == 4;
        }

        public static final boolean isTabPage(int showType) {
            return showType == 2 || showType == 3 || showType == 4;
        }
    }

    public static final class PARAMETER {
        public static int MAX_PARA = 1000;
        public static int TYPE_CELL = 0;
        public static int TYPE_DEFCOL = 1;
        public static int TYPE_OTHERSHEET = 2;
        public static int TYPE_TEXT = 3;
        public static int TYPE_USERDEFINE = 4;
    }

    public static final class SHARE {
        public static final int SHARE = 1;
        public static final int LINK = 2;

        public static final class TYPE {
            public static final int CONSISTENCY = 0;
            public static final int INFODISTILL = 1;
        }
    }
}

