/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.dbproxy;

import com.sdjxd.pms.platform.dbproxy.AbstractResponseBody;
import com.sdjxd.pms.platform.dbproxy.JdaException;
import com.sdjxd.pms.platform.dbproxy.PacketHeader;
import java.io.IOException;
import java.io.OutputStream;

public final class Response {
    private final PacketHeader header;
    private final AbstractResponseBody body;

    public Response(PacketHeader header, AbstractResponseBody body) {
        this.header = header;
        this.body = body;
    }

    public void output(OutputStream outputStream) throws JdaException {
        try {
            if (this.body == null) {
                this.header.setContentRawLength(0);
                this.header.setContentLength(0);
            } else {
                this.header.setContentRawLength(this.body.getLength());
                this.header.setContentLength(this.body.getLength());
            }
            outputStream.write(this.header.getBytes());
            if (this.body != null) {
                this.body.output(outputStream);
            }
        }
        catch (IOException e) {
            throw new JdaException(e.getMessage(), e);
        }
    }
}

