/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.dbproxy;

import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.dbproxy.AbstractRequest;
import com.sdjxd.pms.platform.dbproxy.JdaException;
import com.sdjxd.pms.platform.dbproxy.PacketHeader;
import com.sdjxd.pms.platform.dbproxy.Parameter;
import com.sdjxd.pms.platform.dbproxy.Recordset;
import com.sdjxd.pms.platform.dbproxy.RecordsetCollection;
import com.sdjxd.pms.platform.dbproxy.Response;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.RowSet;

public final class RequestNcQuery
extends AbstractRequest {
    private final byte allowBlob;
    private final String[] sqls;
    private final Parameter[] parameters;

    protected RequestNcQuery(PacketHeader header, InputStream inputStream) throws JdaException {
        super(header);
        byte[] buffer = new byte[4];
        RequestNcQuery.read(inputStream, buffer, 4);
        this.allowBlob = buffer[0];
        this.sqls = this.readStrings(inputStream, header.getByteOrder(), this.requestHeader.getStringCharsetString());
        this.parameters = this.readSqlParameters(inputStream, this.requestHeader.getByteOrder(), this.requestHeader.getStringCharsetString());
    }

    @Override
    public Response execute(String m_dataSourceName) throws JdaException {
        if (this.sqls.length > 0) {
            RowSet rowSet = 1 == this.sqls.length && this.parameters.length != 0 ? this.executeSingle(m_dataSourceName) : this.query(m_dataSourceName, this.sqls[0]);
            Recordset recordset = new Recordset(rowSet, this.requestHeader.getStringCharsetString());
            RecordsetCollection rsCollection = new RecordsetCollection();
            rsCollection.addRecordset(recordset);
            PacketHeader responseHeader = new PacketHeader();
            responseHeader.setStringCharset(this.requestHeader.getStringCharset());
            responseHeader.setMessageType(this.requestHeader.getMessageType());
            responseHeader.setResponseCode(200);
            Response result = new Response(responseHeader, rsCollection);
            return result;
        }
        throw new JdaException(4390914, "SQL\u8bed\u53e5\u4e3a\u7a7a\u3002");
    }

    public byte getAllowBlob() {
        return this.allowBlob;
    }

    private RowSet executeSingle(String m_dataSourceName) throws JdaException {
        if (this.sqls[0] != null && this.sqls[0].length() != 0) {
            PreparedStatement preparedStatement = this.getPreparedStatement(m_dataSourceName, this.sqls[0]);
            try {
                RowSet result;
                this.setSqlParameter(preparedStatement, this.parameters);
                ResultSet resultSet = preparedStatement.executeQuery();
                RowSet rowSet = result = DbOper.getRowSet(m_dataSourceName, resultSet);
                return rowSet;
            }
            catch (SQLException e) {
                throw this.createExecuteFailedException(e);
            }
            finally {
                this.closePreparedStatement(preparedStatement);
            }
        }
        throw new JdaException(500, "RequestNcQuery.executeSingle(): \u7a7aSQL\u8bed\u53e5\u3002");
    }

    private RowSet query(String m_dataSourceName, String sql2) throws JdaException {
        try {
            return DbOper.executeQuery(m_dataSourceName, sql2);
        }
        catch (SQLException e) {
            throw new JdaException(4390913, "\u6267\u884c\u67e5\u8be2\u5931\u8d25: " + e.getMessage(), e);
        }
    }
}

