/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.dbproxy;

import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.dbproxy.AbstractRequest;
import com.sdjxd.pms.platform.dbproxy.JdaException;
import com.sdjxd.pms.platform.dbproxy.PacketHeader;
import com.sdjxd.pms.platform.dbproxy.Parameter;
import com.sdjxd.pms.platform.dbproxy.Response;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class RequestNcExecute
extends AbstractRequest {
    private final String[] sqls;
    private final Parameter[] parameters;

    protected RequestNcExecute(PacketHeader header, InputStream inputStream) throws JdaException {
        super(header);
        byte[] buffer = new byte[4];
        RequestNcExecute.read(inputStream, buffer, 4);
        this.sqls = this.readStrings(inputStream, header.getByteOrder(), this.requestHeader.getStringCharsetString());
        this.parameters = 1 == this.sqls.length ? this.readSqlParameters(inputStream, this.requestHeader.getByteOrder(), this.requestHeader.getStringCharsetString()) : new Parameter[0];
    }

    @Override
    public Response execute(String m_dataSourceName) throws JdaException {
        if (this.sqls.length > 0) {
            if (1 == this.sqls.length) {
                if (this.parameters.length != 0) {
                    this.executeSingle(m_dataSourceName);
                } else {
                    try {
                        DbOper.executeNonQuery(m_dataSourceName, this.sqls[0]);
                    }
                    catch (SQLException e) {
                        throw this.createExecuteFailedException(e);
                    }
                }
            } else {
                try {
                    DbOper.executeNonQuery(m_dataSourceName, this.sqls);
                }
                catch (SQLException e) {
                    throw this.createExecuteFailedException(e);
                }
            }
        } else {
            throw new JdaException(655362, "SQL\u8bed\u53e5\u4e3a\u7a7a\u3002");
        }
        PacketHeader responseHeader = new PacketHeader();
        responseHeader.setStringCharset(this.requestHeader.getStringCharset());
        responseHeader.setMessageType(this.requestHeader.getMessageType());
        responseHeader.setResponseCode(200);
        Response result = new Response(responseHeader, null);
        return result;
    }

    private void executeSingle(String m_dataSourceName) throws JdaException {
        if (this.sqls[0] != null && this.sqls[0].length() != 0) {
            PreparedStatement preparedStatement = this.getPreparedStatement(m_dataSourceName, this.sqls[0]);
            try {
                try {
                    this.setSqlParameter(preparedStatement, this.parameters);
                    preparedStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw this.createExecuteFailedException(e);
                }
            }
            finally {
                this.closePreparedStatement(preparedStatement);
            }
        }
    }
}

