/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.dbproxy;

import com.sdjxd.pms.platform.dbproxy.AbstractResponseBody;
import com.sdjxd.pms.platform.dbproxy.JdaCommon;
import com.sdjxd.pms.platform.dbproxy.JdaException;
import com.sdjxd.pms.platform.dbproxy.Recordset;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public final class RecordsetCollection
extends AbstractResponseBody {
    private final List recordsetList = new ArrayList();
    private int length = 4;

    public void addRecordset(Recordset recordset) {
        this.length += 4 + recordset.getLength();
        this.recordsetList.add(recordset);
    }

    @Override
    public void output(OutputStream outputStream) throws JdaException {
        try {
            Recordset recordset;
            int rsCount = this.recordsetList.size();
            int startPos = 4 + 4 * rsCount;
            outputStream.write(JdaCommon.intToBytes(rsCount));
            int i = 0;
            while (i < rsCount) {
                recordset = (Recordset)this.recordsetList.get(i);
                outputStream.write(JdaCommon.intToBytes(startPos));
                startPos += recordset.getLength();
                ++i;
            }
            i = 0;
            while (i < rsCount) {
                recordset = (Recordset)this.recordsetList.get(i);
                recordset.writeTo(outputStream);
                ++i;
            }
        }
        catch (IOException e) {
            throw new JdaException("IO error.", e);
        }
    }

    @Override
    public int getLength() {
        return this.length;
    }
}

