/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.dbproxy;

import com.sdjxd.pms.platform.dbproxy.BitArray;
import com.sdjxd.pms.platform.dbproxy.Field;
import com.sdjxd.pms.platform.dbproxy.JdaCommon;
import com.sdjxd.pms.platform.dbproxy.JdaException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.RowSet;

public final class Recordset {
    private static final int FIXED_LEN = 24;
    private final String stringCharset;
    private final List rowList = new ArrayList();
    private int rowCount = 0;
    private Field[] fieldList;
    private int fieldDataLength = 0;
    private int rowDataLength = 0;
    private static int[] m_typeLenTable;

    static {
        int[] nArray = new int[30];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 8;
        nArray[9] = 1;
        nArray[10] = 2;
        nArray[11] = 4;
        nArray[12] = 8;
        nArray[16] = 1;
        nArray[17] = 4;
        nArray[18] = 8;
        nArray[19] = 16;
        nArray[20] = -1;
        nArray[21] = -1;
        nArray[22] = -1;
        nArray[24] = -1;
        m_typeLenTable = nArray;
    }

    public Recordset(RowSet rowSet, String stringCharset) throws JdaException {
        this.stringCharset = stringCharset;
        this.createFieldInfo(rowSet);
        this.createRowInfo(rowSet);
    }

    public int getLength() {
        return 24 + this.fieldDataLength + this.rowDataLength;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        int fieldCount = this.fieldList.length;
        outputStream.write(JdaCommon.intToBytes(this.getLength()));
        outputStream.write(JdaCommon.intToBytes(fieldCount));
        outputStream.write(JdaCommon.intToBytes(this.rowCount));
        outputStream.write(JdaCommon.intToBytes(24));
        outputStream.write(JdaCommon.intToBytes(0));
        outputStream.write(JdaCommon.intToBytes(24 + this.fieldDataLength));
        int i = 0;
        while (i < fieldCount) {
            outputStream.write(JdaCommon.intToBytes(this.fieldList[i].size));
            outputStream.write(JdaCommon.intToBytes(this.fieldList[i].type));
            outputStream.write(JdaCommon.intToBytes(this.fieldList[i].name.length + 1));
            outputStream.write(this.fieldList[i].name);
            outputStream.write(0);
            ++i;
        }
        i = 0;
        while (i < this.rowList.size()) {
            outputStream.write((byte[])this.rowList.get(i));
            ++i;
        }
    }

    private void createRowInfo(RowSet rowSet) throws JdaException {
        BitArray emptyFlag = new BitArray(this.fieldList.length);
        BitArray nullFlag = new BitArray(this.fieldList.length);
        ArrayList record = new ArrayList();
        int flagLength = nullFlag.length() + emptyFlag.length();
        this.rowDataLength = 0;
        try {
            while (rowSet.next()) {
                int recordLength = this.readRecord(rowSet, nullFlag, emptyFlag, record);
                ++this.rowCount;
                this.rowList.add(nullFlag.getBytes());
                this.rowList.add(emptyFlag.getBytes());
                this.rowList.addAll(record);
                this.rowDataLength += flagLength + recordLength;
            }
        }
        catch (SQLException e) {
            throw new JdaException(589825, "\u6267\u884c\u67e5\u8be2\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private void createFieldInfo(RowSet rowSet) throws JdaException {
        try {
            ResultSetMetaData rsmd = rowSet.getMetaData();
            int fieldCount = rsmd.getColumnCount();
            this.fieldDataLength = 13 * fieldCount;
            this.fieldList = new Field[fieldCount];
            int i = 0;
            while (i < fieldCount) {
                int fieldType;
                String fieldName = rsmd.getColumnName(i + 1);
                int columnType = rsmd.getColumnType(i + 1);
                switch (columnType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: 
                    case 16: {
                        fieldType = 3;
                        break;
                    }
                    case 6: {
                        fieldType = 17;
                        break;
                    }
                    case 8: {
                        fieldType = 18;
                        break;
                    }
                    case 2: 
                    case 3: {
                        int nPrecisionLength = rsmd.getPrecision(i + 1);
                        int nScaleLength = rsmd.getScale(i + 1);
                        if (nPrecisionLength <= 9) {
                            if (nScaleLength > 0) {
                                fieldType = 17;
                                break;
                            }
                            fieldType = 3;
                            break;
                        }
                        if (nScaleLength > 0 || nPrecisionLength > 38) {
                            fieldType = 18;
                            break;
                        }
                        fieldType = 4;
                        break;
                    }
                    case -15: 
                    case -9: 
                    case -3: 
                    case -1: 
                    case 0: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        fieldType = 20;
                        break;
                    }
                    case -4: 
                    case 2004: {
                        fieldType = 22;
                        break;
                    }
                    default: {
                        throw new JdaException(589825, "\u4e0d\u652f\u6301\u7684JDBC\u5b57\u6bb5\u7c7b\u578b" + columnType);
                    }
                }
                int fieldLength = m_typeLenTable[fieldType];
                byte[] nameBytes = fieldName.getBytes(this.stringCharset);
                this.fieldList[i] = new Field(fieldLength, fieldType, nameBytes);
                this.fieldDataLength += nameBytes.length;
                ++i;
            }
        }
        catch (SQLException e) {
            throw new JdaException(589825, "\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new JdaException(506, "Unsupported string charset.", e);
        }
    }

    private int readRecord(RowSet rowSet, BitArray nullFlag, BitArray emptyFlag, List record) throws JdaException {
        int recordLength = 0;
        emptyFlag.reset();
        nullFlag.reset();
        record.clear();
        try {
            int i = 0;
            while (i < this.fieldList.length) {
                int colType = this.fieldList[i].type;
                switch (colType) {
                    case 3: {
                        byte[] btColData = JdaCommon.intToBytes(rowSet.getInt(i + 1));
                        if (rowSet.wasNull()) {
                            nullFlag.set(i);
                            break;
                        }
                        record.add(btColData);
                        recordLength += btColData.length;
                        break;
                    }
                    case 4: {
                        byte[] btColData = JdaCommon.longToBytes(rowSet.getLong(i + 1));
                        if (rowSet.wasNull()) {
                            nullFlag.set(i);
                            break;
                        }
                        record.add(btColData);
                        recordLength += btColData.length;
                        break;
                    }
                    case 17: {
                        byte[] btColData = JdaCommon.floatToBytes(rowSet.getFloat(i + 1));
                        if (rowSet.wasNull()) {
                            nullFlag.set(i);
                            break;
                        }
                        record.add(btColData);
                        recordLength += btColData.length;
                        break;
                    }
                    case 18: {
                        byte[] btColData = JdaCommon.doubleToBytes(rowSet.getDouble(i + 1));
                        if (rowSet.wasNull()) {
                            nullFlag.set(i);
                            break;
                        }
                        record.add(btColData);
                        recordLength += btColData.length;
                        break;
                    }
                    case 20: {
                        byte[] btColData;
                        String value = rowSet.getString(i + 1);
                        if (value == null) {
                            nullFlag.set(i);
                            break;
                        }
                        if (value.length() == 0) {
                            emptyFlag.set(i);
                            break;
                        }
                        try {
                            btColData = value.getBytes(this.stringCharset);
                        }
                        catch (Exception e) {
                            throw new JdaException(506, "\u4e0d\u652f\u6301\u7684\u7f16\u7801\u7c7b\u578b: " + e.getMessage(), e);
                        }
                        record.add(JdaCommon.intToBytes(btColData.length));
                        record.add(btColData);
                        recordLength += btColData.length + 4;
                        break;
                    }
                    case 22: {
                        InputStream blob = rowSet.getBinaryStream(i + 1);
                        if (blob == null) {
                            nullFlag.set(i);
                            break;
                        }
                        int length = 0;
                        byte[] buffer = null;
                        try {
                            int readLen;
                            length = blob.available();
                            if (length != 0 && (readLen = blob.read(buffer = new byte[length])) != length) {
                                throw new JdaException(589825, "\u8bfb\u53d6blob\u5b57\u6bb5\u5931\u8d25\u3002");
                            }
                        }
                        catch (IOException e) {
                            throw new JdaException(589825, "\u8bfb\u53d6blob\u5b57\u6bb5\u5931\u8d25\u3002", e);
                        }
                        if (length == 0) {
                            nullFlag.set(i);
                            break;
                        }
                        record.add(JdaCommon.intToBytes(length));
                        record.add(buffer);
                        recordLength += 4 + length;
                        break;
                    }
                    default: {
                        throw new JdaException(589825, "\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u7c7b\u578b" + colType);
                    }
                }
                ++i;
            }
        }
        catch (SQLException e) {
            throw new JdaException(589825, "\u6267\u884c\u67e5\u8be2\u5931\u8d25: " + e.getMessage(), e);
        }
        return recordLength;
    }
}

