/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.dbproxy;

import com.sdjxd.pms.platform.dbproxy.JdaCommon;
import com.sdjxd.pms.platform.dbproxy.JdaException;

public final class PacketHeader {
    private static final int MAGICNUMBER = 20071022;
    private static final int LENGTH = 48;
    private byte version;
    private byte type;
    private byte encryptionType = 0;
    private byte compressionType = 0;
    private byte stringCharset = (byte)3;
    private byte messageType = (byte)-1;
    private byte xorValue = 0;
    private int contentRawLength = 0;
    private int contentLength = 0;
    private int responseCode = 200;
    private int connectionId = 0;
    private int serialNumber = 0;
    private int byteOrder = 2;
    private static final String[] charsetString = new String[]{"", "ANSI", "GB2312", "GBK", "Unicode", "Utf8", "Unicode big endian"};

    public PacketHeader() {
        this.type = (byte)2;
        this.version = 1;
    }

    public PacketHeader(byte type) {
        this.type = type;
        this.version = 1;
    }

    public PacketHeader(byte[] buffer) throws JdaException {
        byte[] intBytes = new byte[4];
        System.arraycopy(buffer, 0, intBytes, 0, 4);
        this.byteOrder = 16909060 == JdaCommon.bytesToInt(intBytes, 2) ? 2 : 1;
        System.arraycopy(buffer, 4, intBytes, 0, 4);
        int magicNumber = JdaCommon.bytesToInt(intBytes, this.byteOrder);
        if (20071022 != magicNumber) {
            throw new JdaException(400, "\u9519\u8bef\u683c\u5f0f\u3002");
        }
        this.version = buffer[8];
        this.type = buffer[9];
        this.encryptionType = buffer[10];
        this.compressionType = buffer[11];
        this.stringCharset = buffer[12];
        this.messageType = buffer[13];
        this.xorValue = buffer[14];
        System.arraycopy(buffer, 16, intBytes, 0, 4);
        this.contentRawLength = JdaCommon.bytesToInt(intBytes, this.byteOrder);
        System.arraycopy(buffer, 20, intBytes, 0, 4);
        this.contentLength = JdaCommon.bytesToInt(intBytes, this.byteOrder);
        System.arraycopy(buffer, 24, intBytes, 0, 4);
        this.responseCode = JdaCommon.bytesToInt(intBytes, this.byteOrder);
        System.arraycopy(buffer, 28, intBytes, 0, 4);
        this.connectionId = JdaCommon.bytesToInt(intBytes, this.byteOrder);
        System.arraycopy(buffer, 32, intBytes, 0, 4);
        this.serialNumber = JdaCommon.bytesToInt(intBytes, this.byteOrder);
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[48];
        System.arraycopy(JdaCommon.intToBytes(16909060), 0, bytes, 0, 4);
        System.arraycopy(JdaCommon.intToBytes(20071022), 0, bytes, 4, 4);
        bytes[8] = this.version;
        bytes[9] = this.type;
        bytes[10] = this.encryptionType;
        bytes[11] = this.compressionType;
        bytes[12] = this.stringCharset;
        bytes[13] = this.messageType;
        bytes[14] = this.xorValue;
        System.arraycopy(JdaCommon.intToBytes(this.contentRawLength), 0, bytes, 16, 4);
        System.arraycopy(JdaCommon.intToBytes(this.contentLength), 0, bytes, 20, 4);
        System.arraycopy(JdaCommon.intToBytes(this.responseCode), 0, bytes, 24, 4);
        System.arraycopy(JdaCommon.intToBytes(this.connectionId), 0, bytes, 28, 4);
        System.arraycopy(JdaCommon.intToBytes(this.serialNumber), 0, bytes, 32, 4);
        return bytes;
    }

    public int getLength() {
        return 48;
    }

    public byte getVersion() {
        return this.version;
    }

    public byte getType() {
        return this.type;
    }

    public byte getEncryptionType() {
        return this.encryptionType;
    }

    public byte getCompressionType() {
        return this.compressionType;
    }

    public byte getStringCharset() {
        return this.stringCharset;
    }

    public byte getMessageType() {
        return this.messageType;
    }

    public byte getXorValue() {
        return this.xorValue;
    }

    public int getContentRawLength() {
        return this.contentRawLength;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public int getByteOrder() {
        return this.byteOrder;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public void setEncryptionType(byte encryptionType) {
        this.encryptionType = encryptionType;
    }

    public void setCompressionType(byte compressionType) {
        this.compressionType = compressionType;
    }

    public void setStringCharset(byte stringCharset) {
        this.stringCharset = stringCharset;
    }

    public void setMessageType(byte messageType) {
        this.messageType = messageType;
    }

    public void setXorValue(byte xorValue) {
        this.xorValue = xorValue;
    }

    public void setContentRawLength(int contentRawLength) {
        this.contentRawLength = contentRawLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public void setConnectionId(int connectionId) {
        this.connectionId = connectionId;
    }

    public void setSerialNumber(int serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getStringCharsetString() {
        String result = this.stringCharset < charsetString.length ? charsetString[this.stringCharset] : "";
        return result;
    }
}

