/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.dbproxy;

public final class JdaCommon {
    public static final byte TYPE_REQUEST = 1;
    public static final byte TYPE_RESPONSE = 2;
    public static final byte ET_NONE = 0;
    public static final byte ET_XORENCRYPT = 2;
    public static final byte CT_NONE = 0;
    public static final byte SC_GBK = 3;
    public static final int STATUS_OK = 200;
    public static final int BYTEORDERFLAG = 16909060;
    public static final int BO_LITTLE_ENDIAN = 1;
    public static final int BO_BIG_ENDIAN = 2;
    public static final int MT_NCQUERY = 67;
    public static final int MT_NCEXECUTE = 68;
    public static final int MT_NCFUNCCALL = 72;
    public static final byte VT_TINYINT = 1;
    public static final byte VT_UTINYINT = 9;
    public static final byte VT_SMALLINT = 2;
    public static final byte VT_USMALLINT = 10;
    public static final byte VT_INT = 3;
    public static final byte VT_UINT = 11;
    public static final byte VT_BIGINT = 4;
    public static final byte VT_UBIGINT = 12;
    public static final byte VT_BIT = 16;
    public static final byte VT_FLOAT = 17;
    public static final byte VT_DOUBLE = 18;
    public static final byte VT_LONGDOUBLE = 19;
    public static final byte VT_STRING = 20;
    public static final byte VT_TEXT = 21;
    public static final byte VT_BLOB = 22;
    public static final byte VT_NULL = 23;
    public static final byte VT_NUMERIC = 24;

    public static int bytesToInt(byte[] btArr, int byteOrder) {
        int result = -1;
        if (btArr.length >= 4) {
            result = 1 == byteOrder ? (btArr[3] & 0xFF) << 24 | (btArr[2] & 0xFF) << 16 | (btArr[1] & 0xFF) << 8 | btArr[0] & 0xFF : (btArr[0] & 0xFF) << 24 | (btArr[1] & 0xFF) << 16 | (btArr[2] & 0xFF) << 8 | btArr[3] & 0xFF;
        }
        return result;
    }

    public static byte[] doubleToBytes(double data) {
        return JdaCommon.longToBytes(Double.doubleToLongBits(data));
    }

    public static byte[] floatToBytes(float data) {
        return JdaCommon.intToBytes(Float.floatToIntBits(data));
    }

    public static byte[] intToBytes(int data) {
        byte[] buffer = new byte[]{(byte)(0xFF & data >> 24), (byte)(0xFF & data >> 16), (byte)(0xFF & data >> 8), (byte)(0xFF & data)};
        return buffer;
    }

    public static byte[] longToBytes(long data) {
        byte[] buffer = new byte[]{(byte)(0xFFL & data >> 56), (byte)(0xFFL & data >> 48), (byte)(0xFFL & data >> 40), (byte)(0xFFL & data >> 32), (byte)(0xFFL & data >> 24), (byte)(0xFFL & data >> 16), (byte)(0xFFL & data >> 8), (byte)(0xFFL & data)};
        return buffer;
    }

    private JdaCommon() {
    }
}

