/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.dbproxy;

public final class BitArray {
    private final int m_byteCount;
    private final int m_bitCount;
    private final byte[] m_buffer;

    public BitArray(int bitCount) {
        this.m_bitCount = bitCount;
        this.m_byteCount = (bitCount + 7) / 8;
        this.m_buffer = new byte[this.m_byteCount];
        this.reset();
    }

    public byte[] getBytes() {
        return (byte[])this.m_buffer.clone();
    }

    public int length() {
        return this.m_byteCount;
    }

    public void reset() {
        int i = 0;
        while (i < this.m_byteCount) {
            this.m_buffer[i] = 0;
            ++i;
        }
    }

    public void set(int index) {
        if (index < this.m_bitCount) {
            int byteIndex = index / 8;
            int bitIndex = index % 8;
            int n = byteIndex;
            this.m_buffer[n] = (byte)(this.m_buffer[n] | 1 << 7 - bitIndex);
        }
    }
}

